/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class HttpUtil {
    private static final AsciiString CHARSET_EQUALS = AsciiString.of(HttpHeaderValues.CHARSET + "=");
    private static final AsciiString SEMICOLON = AsciiString.cached(";");
    private static final String COMMA_STRING = String.valueOf(',');

    public static boolean isKeepAlive(HttpMessage message2) {
        return !message2.headers().containsValue(HttpHeaderNames.CONNECTION, HttpHeaderValues.CLOSE, true) && (message2.protocolVersion().isKeepAliveDefault() || message2.headers().containsValue(HttpHeaderNames.CONNECTION, HttpHeaderValues.KEEP_ALIVE, true));
    }

    public static void setKeepAlive(HttpMessage message2, boolean keepAlive) {
        HttpUtil.setKeepAlive(message2.headers(), message2.protocolVersion(), keepAlive);
    }

    public static void setKeepAlive(HttpHeaders h, HttpVersion httpVersion, boolean keepAlive) {
        if (httpVersion.isKeepAliveDefault()) {
            if (keepAlive) {
                h.remove(HttpHeaderNames.CONNECTION);
            } else {
                h.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            }
        } else if (keepAlive) {
            h.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        } else {
            h.remove(HttpHeaderNames.CONNECTION);
        }
    }

    public static long getContentLength(HttpMessage message2, long defaultValue) {
        String value2 = message2.headers().get(HttpHeaderNames.CONTENT_LENGTH);
        if (value2 != null) {
            return Long.parseLong(value2);
        }
        long webSocketContentLength = HttpUtil.getWebSocketContentLength(message2);
        if (webSocketContentLength >= 0L) {
            return webSocketContentLength;
        }
        return defaultValue;
    }

    static int getWebSocketContentLength(HttpMessage message2) {
        HttpResponse res2;
        HttpHeaders h = message2.headers();
        if (message2 instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)message2;
            if (HttpMethod.GET.equals(req.method()) && h.contains(HttpHeaderNames.SEC_WEBSOCKET_KEY1) && h.contains(HttpHeaderNames.SEC_WEBSOCKET_KEY2)) {
                return 8;
            }
        } else if (message2 instanceof HttpResponse && (res2 = (HttpResponse)message2).status().code() == 101 && h.contains(HttpHeaderNames.SEC_WEBSOCKET_ORIGIN) && h.contains(HttpHeaderNames.SEC_WEBSOCKET_LOCATION)) {
            return 16;
        }
        return -1;
    }

    public static void setContentLength(HttpMessage message2, long length) {
        message2.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)length);
    }

    public static boolean isContentLengthSet(HttpMessage m) {
        return m.headers().contains(HttpHeaderNames.CONTENT_LENGTH);
    }

    public static boolean is100ContinueExpected(HttpMessage message2) {
        return HttpUtil.isExpectHeaderValid(message2) && message2.headers().contains(HttpHeaderNames.EXPECT, HttpHeaderValues.CONTINUE, true);
    }

    static boolean isUnsupportedExpectation(HttpMessage message2) {
        if (!HttpUtil.isExpectHeaderValid(message2)) {
            return false;
        }
        String expectValue = message2.headers().get(HttpHeaderNames.EXPECT);
        return expectValue != null && !HttpHeaderValues.CONTINUE.toString().equalsIgnoreCase(expectValue);
    }

    private static boolean isExpectHeaderValid(HttpMessage message2) {
        return message2 instanceof HttpRequest && message2.protocolVersion().compareTo(HttpVersion.HTTP_1_1) >= 0;
    }

    public static boolean isTransferEncodingChunked(HttpMessage message2) {
        return message2.headers().containsValue(HttpHeaderNames.TRANSFER_ENCODING, HttpHeaderValues.CHUNKED, true);
    }

    public static void setTransferEncodingChunked(HttpMessage m, boolean chunked) {
        if (chunked) {
            m.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            m.headers().remove(HttpHeaderNames.CONTENT_LENGTH);
        } else {
            List<String> encodings = m.headers().getAll(HttpHeaderNames.TRANSFER_ENCODING);
            if (encodings.isEmpty()) {
                return;
            }
            ArrayList<String> values = new ArrayList<String>(encodings);
            Iterator valuesIt = values.iterator();
            while (valuesIt.hasNext()) {
                CharSequence value2 = (CharSequence)valuesIt.next();
                if (!HttpHeaderValues.CHUNKED.contentEqualsIgnoreCase(value2)) continue;
                valuesIt.remove();
            }
            if (values.isEmpty()) {
                m.headers().remove(HttpHeaderNames.TRANSFER_ENCODING);
            } else {
                m.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, values);
            }
        }
    }

    public static long normalizeAndGetContentLength(List<? extends CharSequence> contentLengthFields, boolean isHttp10OrEarlier, boolean allowDuplicateContentLengths) {
        boolean multipleContentLengths;
        if (contentLengthFields.isEmpty()) {
            return -1L;
        }
        String firstField = contentLengthFields.get(0).toString();
        boolean bl = multipleContentLengths = contentLengthFields.size() > 1 || firstField.indexOf(44) >= 0;
        if (multipleContentLengths && !isHttp10OrEarlier) {
            if (allowDuplicateContentLengths) {
                String firstValue = null;
                for (CharSequence charSequence : contentLengthFields) {
                    String[] tokens;
                    for (String token2 : tokens = charSequence.toString().split(COMMA_STRING, -1)) {
                        String trimmed = token2.trim();
                        if (firstValue == null) {
                            firstValue = trimmed;
                            continue;
                        }
                        if (trimmed.equals(firstValue)) continue;
                        throw new IllegalArgumentException("Multiple Content-Length values found: " + contentLengthFields);
                    }
                }
                firstField = firstValue;
            } else {
                throw new IllegalArgumentException("Multiple Content-Length values found: " + contentLengthFields);
            }
        }
        if (firstField.isEmpty() || !Character.isDigit(firstField.charAt(0))) {
            throw new IllegalArgumentException("Content-Length value is not a number: " + firstField);
        }
        try {
            long value2 = Long.parseLong(firstField);
            return ObjectUtil.checkPositiveOrZero(value2, "Content-Length value");
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Content-Length value is not a number: " + firstField, e);
        }
    }

    static int validateToken(CharSequence token2) {
        if (token2 instanceof AsciiString) {
            return HttpUtil.validateAsciiStringToken((AsciiString)token2);
        }
        return HttpUtil.validateCharSequenceToken(token2);
    }

    private static int validateAsciiStringToken(AsciiString token2) {
        byte[] array = token2.array();
        int len = token2.arrayOffset() + token2.length();
        for (int i2 = token2.arrayOffset(); i2 < len; ++i2) {
            if (HttpUtil.isValidTokenChar(array[i2])) continue;
            return i2 - token2.arrayOffset();
        }
        return -1;
    }

    private static int validateCharSequenceToken(CharSequence token2) {
        int len = token2.length();
        for (int i2 = 0; i2 < len; ++i2) {
            byte value2 = (byte)token2.charAt(i2);
            if (HttpUtil.isValidTokenChar(value2)) continue;
            return i2;
        }
        return -1;
    }

    private static boolean isValidTokenChar(byte bit) {
        if (bit < 0) {
            return false;
        }
        if (bit < 64) {
            return 0L != (0x3FF6CFA00000000L & 1L << bit);
        }
        return 0L != (0x57FFFFFFC7FFFFFEL & 1L << bit - 64);
    }
}

