/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.handler.codec.http.HttpObjectDecoder;
import io.netty.util.internal.ObjectUtil;

public final class HttpDecoderConfig
implements Cloneable {
    private int maxChunkSize = 8192;
    private boolean chunkedSupported = true;
    private boolean allowPartialChunks = true;
    private HttpHeadersFactory headersFactory = DefaultHttpHeadersFactory.headersFactory();
    private HttpHeadersFactory trailersFactory = DefaultHttpHeadersFactory.trailersFactory();
    private boolean allowDuplicateContentLengths = false;
    private int maxInitialLineLength = 4096;
    private int maxHeaderSize = 8192;
    private int initialBufferSize = 128;
    private boolean strictLineParsing = HttpObjectDecoder.DEFAULT_STRICT_LINE_PARSING;

    public int getInitialBufferSize() {
        return this.initialBufferSize;
    }

    public int getMaxInitialLineLength() {
        return this.maxInitialLineLength;
    }

    public HttpDecoderConfig setMaxInitialLineLength(int maxInitialLineLength) {
        ObjectUtil.checkPositive(maxInitialLineLength, "maxInitialLineLength");
        this.maxInitialLineLength = maxInitialLineLength;
        return this;
    }

    public int getMaxHeaderSize() {
        return this.maxHeaderSize;
    }

    public HttpDecoderConfig setMaxHeaderSize(int maxHeaderSize) {
        ObjectUtil.checkPositive(maxHeaderSize, "maxHeaderSize");
        this.maxHeaderSize = maxHeaderSize;
        return this;
    }

    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public HttpDecoderConfig setMaxChunkSize(int maxChunkSize) {
        ObjectUtil.checkPositive(maxChunkSize, "maxChunkSize");
        this.maxChunkSize = maxChunkSize;
        return this;
    }

    public boolean isChunkedSupported() {
        return this.chunkedSupported;
    }

    public boolean isAllowPartialChunks() {
        return this.allowPartialChunks;
    }

    public HttpHeadersFactory getHeadersFactory() {
        return this.headersFactory;
    }

    public boolean isAllowDuplicateContentLengths() {
        return this.allowDuplicateContentLengths;
    }

    public HttpHeadersFactory getTrailersFactory() {
        return this.trailersFactory;
    }

    public boolean isStrictLineParsing() {
        return this.strictLineParsing;
    }

    public HttpDecoderConfig clone() {
        try {
            return (HttpDecoderConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

