/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.AbstractChannelHandlerContext;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPipelineException;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelHandlerContext;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.FailedChannelFuture;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.SucceededChannelFuture;
import io.netty.channel.VoidChannelPromise;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class DefaultChannelPipeline
implements ChannelPipeline {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultChannelPipeline.class);
    private static final String HEAD_NAME = DefaultChannelPipeline.generateName0(HeadContext.class);
    private static final String TAIL_NAME = DefaultChannelPipeline.generateName0(TailContext.class);
    private static final FastThreadLocal<Map<Class<?>, String>> nameCaches = new FastThreadLocal<Map<Class<?>, String>>(){

        @Override
        protected Map<Class<?>, String> initialValue() {
            return new WeakHashMap();
        }
    };
    private static final AtomicReferenceFieldUpdater<DefaultChannelPipeline, MessageSizeEstimator.Handle> ESTIMATOR = AtomicReferenceFieldUpdater.newUpdater(DefaultChannelPipeline.class, MessageSizeEstimator.Handle.class, "estimatorHandle");
    final HeadContext head;
    final TailContext tail;
    private final Channel channel;
    private final ChannelFuture succeededFuture;
    private final VoidChannelPromise voidPromise;
    private final boolean touch = ResourceLeakDetector.isEnabled();
    private Map<EventExecutorGroup, EventExecutor> childExecutors;
    private volatile MessageSizeEstimator.Handle estimatorHandle;
    private boolean firstRegistration = true;
    private PendingHandlerCallback pendingHandlerCallbackHead;
    private boolean registered;

    protected DefaultChannelPipeline(Channel channel) {
        this.channel = ObjectUtil.checkNotNull(channel, "channel");
        this.succeededFuture = new SucceededChannelFuture(channel, null);
        this.voidPromise = new VoidChannelPromise(channel, true);
        this.tail = new TailContext(this);
        this.head = new HeadContext(this);
        this.head.next = this.tail;
        this.tail.prev = this.head;
    }

    final MessageSizeEstimator.Handle estimatorHandle() {
        MessageSizeEstimator.Handle handle2 = this.estimatorHandle;
        if (handle2 == null && !ESTIMATOR.compareAndSet(this, null, handle2 = this.channel.config().getMessageSizeEstimator().newHandle())) {
            handle2 = this.estimatorHandle;
        }
        return handle2;
    }

    final Object touch(Object msg, AbstractChannelHandlerContext next2) {
        return this.touch ? ReferenceCountUtil.touch(msg, next2) : msg;
    }

    private AbstractChannelHandlerContext newContext(EventExecutorGroup group, String name2, ChannelHandler handler2) {
        return new DefaultChannelHandlerContext(this, this.childExecutor(group), name2, handler2);
    }

    private EventExecutor childExecutor(EventExecutorGroup group) {
        EventExecutor childExecutor;
        if (group == null) {
            return null;
        }
        Boolean pinEventExecutor = this.channel.config().getOption(ChannelOption.SINGLE_EVENTEXECUTOR_PER_GROUP);
        if (pinEventExecutor != null && !pinEventExecutor.booleanValue()) {
            return group.next();
        }
        Map<EventExecutorGroup, EventExecutor> childExecutors = this.childExecutors;
        if (childExecutors == null) {
            childExecutors = this.childExecutors = new IdentityHashMap<EventExecutorGroup, EventExecutor>(4);
        }
        if ((childExecutor = childExecutors.get(group)) == null) {
            childExecutor = group.next();
            childExecutors.put(group, childExecutor);
        }
        return childExecutor;
    }

    @Override
    public final Channel channel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelPipeline internalAdd(EventExecutorGroup group, String name2, ChannelHandler handler2, String baseName, AddStrategy addStrategy) {
        AbstractChannelHandlerContext newCtx;
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            DefaultChannelPipeline.checkMultiplicity(handler2);
            name2 = this.filterName(name2, handler2);
            newCtx = this.newContext(group, name2, handler2);
            switch (addStrategy) {
                case ADD_FIRST: {
                    this.addFirst0(newCtx);
                    break;
                }
                case ADD_LAST: {
                    this.addLast0(newCtx);
                    break;
                }
                case ADD_BEFORE: {
                    DefaultChannelPipeline.addBefore0(this.getContextOrDie(baseName), newCtx);
                    break;
                }
                case ADD_AFTER: {
                    DefaultChannelPipeline.addAfter0(this.getContextOrDie(baseName), newCtx);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown add strategy: " + (Object)((Object)addStrategy));
                }
            }
            if (!this.registered) {
                newCtx.setAddPending();
                this.callHandlerCallbackLater(newCtx, true);
                return this;
            }
            EventExecutor executor = newCtx.executor();
            if (!executor.inEventLoop()) {
                this.callHandlerAddedInEventLoop(newCtx, executor);
                return this;
            }
        }
        this.callHandlerAdded0(newCtx);
        return this;
    }

    private void addFirst0(AbstractChannelHandlerContext newCtx) {
        AbstractChannelHandlerContext nextCtx = this.head.next;
        newCtx.prev = this.head;
        newCtx.next = nextCtx;
        this.head.next = newCtx;
        nextCtx.prev = newCtx;
    }

    @Override
    public final ChannelPipeline addLast(String name2, ChannelHandler handler2) {
        return this.addLast(null, name2, handler2);
    }

    public final ChannelPipeline addLast(EventExecutorGroup group, String name2, ChannelHandler handler2) {
        return this.internalAdd(group, name2, handler2, null, AddStrategy.ADD_LAST);
    }

    private void addLast0(AbstractChannelHandlerContext newCtx) {
        AbstractChannelHandlerContext prev;
        newCtx.prev = prev = this.tail.prev;
        newCtx.next = this.tail;
        prev.next = newCtx;
        this.tail.prev = newCtx;
    }

    @Override
    public final ChannelPipeline addBefore(String baseName, String name2, ChannelHandler handler2) {
        return this.addBefore(null, baseName, name2, handler2);
    }

    public final ChannelPipeline addBefore(EventExecutorGroup group, String baseName, String name2, ChannelHandler handler2) {
        return this.internalAdd(group, name2, handler2, baseName, AddStrategy.ADD_BEFORE);
    }

    private static void addBefore0(AbstractChannelHandlerContext ctx, AbstractChannelHandlerContext newCtx) {
        newCtx.prev = ctx.prev;
        newCtx.next = ctx;
        ctx.prev.next = newCtx;
        ctx.prev = newCtx;
    }

    private String filterName(String name2, ChannelHandler handler2) {
        if (name2 == null) {
            return this.generateName(handler2);
        }
        this.checkDuplicateName(name2);
        return name2;
    }

    @Override
    public final ChannelPipeline addAfter(String baseName, String name2, ChannelHandler handler2) {
        return this.addAfter(null, baseName, name2, handler2);
    }

    public final ChannelPipeline addAfter(EventExecutorGroup group, String baseName, String name2, ChannelHandler handler2) {
        return this.internalAdd(group, name2, handler2, baseName, AddStrategy.ADD_AFTER);
    }

    private static void addAfter0(AbstractChannelHandlerContext ctx, AbstractChannelHandlerContext newCtx) {
        newCtx.prev = ctx;
        newCtx.next = ctx.next;
        ctx.next.prev = newCtx;
        ctx.next = newCtx;
    }

    @Override
    public final ChannelPipeline addLast(ChannelHandler ... handlers2) {
        return this.addLast((EventExecutorGroup)null, handlers2);
    }

    public final ChannelPipeline addLast(EventExecutorGroup executor, ChannelHandler ... handlers2) {
        ObjectUtil.checkNotNull(handlers2, "handlers");
        for (ChannelHandler h : handlers2) {
            if (h == null) break;
            this.addLast(executor, (String)null, h);
        }
        return this;
    }

    private String generateName(ChannelHandler handler2) {
        Class<?> handlerType;
        Map<Class<?>, String> cache2 = nameCaches.get();
        String name2 = cache2.get(handlerType = handler2.getClass());
        if (name2 == null) {
            name2 = DefaultChannelPipeline.generateName0(handlerType);
            cache2.put(handlerType, name2);
        }
        if (this.context0(name2) != null) {
            String baseName = name2.substring(0, name2.length() - 1);
            int i2 = 1;
            while (true) {
                String newName;
                if (this.context0(newName = baseName + i2) == null) {
                    name2 = newName;
                    break;
                }
                ++i2;
            }
        }
        return name2;
    }

    private static String generateName0(Class<?> handlerType) {
        return StringUtil.simpleClassName(handlerType) + "#0";
    }

    @Override
    public final ChannelPipeline remove(ChannelHandler handler2) {
        this.remove(this.getContextOrDie(handler2));
        return this;
    }

    @Override
    public final ChannelHandler remove(String name2) {
        return this.remove(this.getContextOrDie(name2)).handler();
    }

    @Override
    public final <T extends ChannelHandler> T remove(Class<T> handlerType) {
        return (T)this.remove(this.getContextOrDie(handlerType)).handler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractChannelHandlerContext remove(final AbstractChannelHandlerContext ctx) {
        assert (ctx != this.head && ctx != this.tail);
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            this.atomicRemoveFromHandlerList(ctx);
            if (!this.registered) {
                this.callHandlerCallbackLater(ctx, false);
                return ctx;
            }
            EventExecutor executor = ctx.executor();
            if (!executor.inEventLoop()) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        DefaultChannelPipeline.this.callHandlerRemoved0(ctx);
                    }
                });
                return ctx;
            }
        }
        this.callHandlerRemoved0(ctx);
        return ctx;
    }

    private synchronized void atomicRemoveFromHandlerList(AbstractChannelHandlerContext ctx) {
        AbstractChannelHandlerContext next2;
        AbstractChannelHandlerContext prev = ctx.prev;
        prev.next = next2 = ctx.next;
        next2.prev = prev;
    }

    @Override
    public final ChannelHandler replace(String oldName, String newName, ChannelHandler newHandler) {
        return this.replace(this.getContextOrDie(oldName), newName, newHandler);
    }

    @Override
    public final <T extends ChannelHandler> T replace(Class<T> oldHandlerType, String newName, ChannelHandler newHandler) {
        return (T)this.replace(this.getContextOrDie(oldHandlerType), newName, newHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelHandler replace(final AbstractChannelHandlerContext ctx, String newName, ChannelHandler newHandler) {
        AbstractChannelHandlerContext newCtx;
        assert (ctx != this.head && ctx != this.tail);
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            DefaultChannelPipeline.checkMultiplicity(newHandler);
            if (newName == null) {
                newName = this.generateName(newHandler);
            } else {
                boolean sameName = ctx.name().equals(newName);
                if (!sameName) {
                    this.checkDuplicateName(newName);
                }
            }
            newCtx = this.newContext(ctx.childExecutor, newName, newHandler);
            DefaultChannelPipeline.replace0(ctx, newCtx);
            if (!this.registered) {
                this.callHandlerCallbackLater(newCtx, true);
                this.callHandlerCallbackLater(ctx, false);
                return ctx.handler();
            }
            EventExecutor executor = ctx.executor();
            if (!executor.inEventLoop()) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        DefaultChannelPipeline.this.callHandlerAdded0(newCtx);
                        DefaultChannelPipeline.this.callHandlerRemoved0(ctx);
                    }
                });
                return ctx.handler();
            }
        }
        this.callHandlerAdded0(newCtx);
        this.callHandlerRemoved0(ctx);
        return ctx.handler();
    }

    private static void replace0(AbstractChannelHandlerContext oldCtx, AbstractChannelHandlerContext newCtx) {
        AbstractChannelHandlerContext prev = oldCtx.prev;
        AbstractChannelHandlerContext next2 = oldCtx.next;
        newCtx.prev = prev;
        newCtx.next = next2;
        prev.next = newCtx;
        next2.prev = newCtx;
        oldCtx.prev = newCtx;
        oldCtx.next = newCtx;
    }

    private static void checkMultiplicity(ChannelHandler handler2) {
        if (handler2 instanceof ChannelHandlerAdapter) {
            ChannelHandlerAdapter h = (ChannelHandlerAdapter)handler2;
            if (!h.isSharable() && h.added) {
                throw new ChannelPipelineException(h.getClass().getName() + " is not a @Sharable handler, so can't be added or removed multiple times.");
            }
            h.added = true;
        }
    }

    private void callHandlerAdded0(AbstractChannelHandlerContext ctx) {
        try {
            ctx.callHandlerAdded();
        }
        catch (Throwable t2) {
            boolean removed;
            block5: {
                removed = false;
                try {
                    this.atomicRemoveFromHandlerList(ctx);
                    ctx.callHandlerRemoved();
                    removed = true;
                }
                catch (Throwable t22) {
                    if (!logger.isWarnEnabled()) break block5;
                    logger.warn("Failed to remove a handler: " + ctx.name(), t22);
                }
            }
            if (removed) {
                this.fireExceptionCaught(new ChannelPipelineException(ctx.handler().getClass().getName() + ".handlerAdded() has thrown an exception; removed.", t2));
            }
            this.fireExceptionCaught(new ChannelPipelineException(ctx.handler().getClass().getName() + ".handlerAdded() has thrown an exception; also failed to remove.", t2));
        }
    }

    private void callHandlerRemoved0(AbstractChannelHandlerContext ctx) {
        try {
            ctx.callHandlerRemoved();
        }
        catch (Throwable t2) {
            this.fireExceptionCaught(new ChannelPipelineException(ctx.handler().getClass().getName() + ".handlerRemoved() has thrown an exception.", t2));
        }
    }

    final void invokeHandlerAddedIfNeeded() {
        assert (this.channel.eventLoop().inEventLoop());
        if (this.firstRegistration) {
            this.firstRegistration = false;
            this.callHandlerAddedForAllHandlers();
        }
    }

    @Override
    public final <T extends ChannelHandler> T get(Class<T> handlerType) {
        ChannelHandlerContext ctx = this.context(handlerType);
        if (ctx == null) {
            return null;
        }
        return (T)ctx.handler();
    }

    public final ChannelHandlerContext context(String name2) {
        return this.context0(ObjectUtil.checkNotNull(name2, "name"));
    }

    @Override
    public final ChannelHandlerContext context(ChannelHandler handler2) {
        ObjectUtil.checkNotNull(handler2, "handler");
        AbstractChannelHandlerContext ctx = this.head.next;
        while (ctx != null) {
            if (ctx.handler() == handler2) {
                return ctx;
            }
            ctx = ctx.next;
        }
        return null;
    }

    @Override
    public final ChannelHandlerContext context(Class<? extends ChannelHandler> handlerType) {
        ObjectUtil.checkNotNull(handlerType, "handlerType");
        AbstractChannelHandlerContext ctx = this.head.next;
        while (ctx != null) {
            if (handlerType.isAssignableFrom(ctx.handler().getClass())) {
                return ctx;
            }
            ctx = ctx.next;
        }
        return null;
    }

    @Override
    public final List<String> names() {
        ArrayList<String> list2 = new ArrayList<String>();
        AbstractChannelHandlerContext ctx = this.head.next;
        while (ctx != null) {
            list2.add(ctx.name());
            ctx = ctx.next;
        }
        return list2;
    }

    public final Map<String, ChannelHandler> toMap() {
        LinkedHashMap<String, ChannelHandler> map2 = new LinkedHashMap<String, ChannelHandler>();
        AbstractChannelHandlerContext ctx = this.head.next;
        while (ctx != this.tail) {
            map2.put(ctx.name(), ctx.handler());
            ctx = ctx.next;
        }
        return map2;
    }

    @Override
    public final Iterator<Map.Entry<String, ChannelHandler>> iterator() {
        return this.toMap().entrySet().iterator();
    }

    public final String toString() {
        StringBuilder buf = new StringBuilder().append(StringUtil.simpleClassName(this)).append('{');
        AbstractChannelHandlerContext ctx = this.head.next;
        while (ctx != this.tail) {
            buf.append('(').append(ctx.name()).append(" = ").append(ctx.handler().getClass().getName()).append(')');
            ctx = ctx.next;
            if (ctx == this.tail) break;
            buf.append(", ");
        }
        buf.append('}');
        return buf.toString();
    }

    @Override
    public final ChannelPipeline fireChannelRegistered() {
        if (this.head.executor().inEventLoop()) {
            if (this.head.invokeHandler()) {
                this.head.channelRegistered(this.head);
            } else {
                this.head.fireChannelRegistered();
            }
        } else {
            this.head.executor().execute(this::fireChannelRegistered);
        }
        return this;
    }

    public final ChannelPipeline fireChannelUnregistered() {
        if (this.head.executor().inEventLoop()) {
            if (this.head.invokeHandler()) {
                this.head.channelUnregistered(this.head);
            } else {
                this.head.fireChannelUnregistered();
            }
        } else {
            this.head.executor().execute(this::fireChannelUnregistered);
        }
        return this;
    }

    private synchronized void destroy() {
        this.destroyUp(this.head.next, false);
    }

    private void destroyUp(AbstractChannelHandlerContext ctx, boolean inEventLoop) {
        Thread currentThread = Thread.currentThread();
        TailContext tail = this.tail;
        while (true) {
            if (ctx == tail) {
                this.destroyDown(currentThread, tail.prev, inEventLoop);
                break;
            }
            EventExecutor executor = ctx.executor();
            if (!inEventLoop && !executor.inEventLoop(currentThread)) {
                final AbstractChannelHandlerContext finalCtx = ctx;
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        DefaultChannelPipeline.this.destroyUp(finalCtx, true);
                    }
                });
                break;
            }
            ctx = ctx.next;
            inEventLoop = false;
        }
    }

    private void destroyDown(Thread currentThread, AbstractChannelHandlerContext ctx, boolean inEventLoop) {
        HeadContext head = this.head;
        while (ctx != head) {
            EventExecutor executor = ctx.executor();
            if (!inEventLoop && !executor.inEventLoop(currentThread)) {
                final AbstractChannelHandlerContext finalCtx = ctx;
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        DefaultChannelPipeline.this.destroyDown(Thread.currentThread(), finalCtx, true);
                    }
                });
                break;
            }
            this.atomicRemoveFromHandlerList(ctx);
            this.callHandlerRemoved0(ctx);
            ctx = ctx.prev;
            inEventLoop = false;
        }
    }

    @Override
    public final ChannelPipeline fireChannelActive() {
        if (this.head.executor().inEventLoop()) {
            if (this.head.invokeHandler()) {
                this.head.channelActive(this.head);
            } else {
                this.head.fireChannelActive();
            }
        } else {
            this.head.executor().execute(this::fireChannelActive);
        }
        return this;
    }

    public final ChannelPipeline fireChannelInactive() {
        if (this.head.executor().inEventLoop()) {
            if (this.head.invokeHandler()) {
                this.head.channelInactive(this.head);
            } else {
                this.head.fireChannelInactive();
            }
        } else {
            this.head.executor().execute(this::fireChannelInactive);
        }
        return this;
    }

    @Override
    public final ChannelPipeline fireExceptionCaught(Throwable cause) {
        if (this.head.executor().inEventLoop()) {
            if (this.head.invokeHandler()) {
                this.head.exceptionCaught(this.head, cause);
            } else {
                this.head.fireExceptionCaught(cause);
            }
        } else {
            this.head.executor().execute(() -> this.fireExceptionCaught(cause));
        }
        return this;
    }

    @Override
    public final ChannelPipeline fireUserEventTriggered(Object event) {
        if (this.head.executor().inEventLoop()) {
            if (this.head.invokeHandler()) {
                this.head.userEventTriggered(this.head, event);
            } else {
                this.head.fireUserEventTriggered(event);
            }
        } else {
            this.head.executor().execute(() -> this.fireUserEventTriggered(event));
        }
        return this;
    }

    @Override
    public final ChannelPipeline fireChannelRead(Object msg) {
        if (this.head.executor().inEventLoop()) {
            if (this.head.invokeHandler()) {
                this.head.channelRead(this.head, msg);
            } else {
                this.head.fireChannelRead(msg);
            }
        } else {
            this.head.executor().execute(() -> this.fireChannelRead(msg));
        }
        return this;
    }

    @Override
    public final ChannelPipeline fireChannelReadComplete() {
        if (this.head.executor().inEventLoop()) {
            if (this.head.invokeHandler()) {
                this.head.channelReadComplete(this.head);
            } else {
                this.head.fireChannelReadComplete();
            }
        } else {
            this.head.executor().execute(this::fireChannelReadComplete);
        }
        return this;
    }

    @Override
    public final ChannelPipeline fireChannelWritabilityChanged() {
        if (this.head.executor().inEventLoop()) {
            if (this.head.invokeHandler()) {
                this.head.channelWritabilityChanged(this.head);
            } else {
                this.head.fireChannelWritabilityChanged();
            }
        } else {
            this.head.executor().execute(this::fireChannelWritabilityChanged);
        }
        return this;
    }

    @Override
    public final ChannelFuture close() {
        return this.tail.close();
    }

    @Override
    public final ChannelPipeline flush() {
        this.tail.flush();
        return this;
    }

    @Override
    public final ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
        return this.tail.bind(localAddress, promise);
    }

    @Override
    public final ChannelFuture connect(SocketAddress remoteAddress2, ChannelPromise promise) {
        return this.tail.connect(remoteAddress2, promise);
    }

    @Override
    public final ChannelFuture connect(SocketAddress remoteAddress2, SocketAddress localAddress, ChannelPromise promise) {
        return this.tail.connect(remoteAddress2, localAddress, promise);
    }

    @Override
    public final ChannelFuture disconnect(ChannelPromise promise) {
        return this.tail.disconnect(promise);
    }

    @Override
    public final ChannelFuture close(ChannelPromise promise) {
        return this.tail.close(promise);
    }

    @Override
    public final ChannelFuture deregister(ChannelPromise promise) {
        return this.tail.deregister(promise);
    }

    @Override
    public final ChannelPipeline read() {
        this.tail.read();
        return this;
    }

    @Override
    public final ChannelFuture write(Object msg) {
        return this.tail.write(msg);
    }

    @Override
    public final ChannelFuture write(Object msg, ChannelPromise promise) {
        return this.tail.write(msg, promise);
    }

    @Override
    public final ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
        return this.tail.writeAndFlush(msg, promise);
    }

    @Override
    public final ChannelFuture writeAndFlush(Object msg) {
        return this.tail.writeAndFlush(msg);
    }

    @Override
    public final ChannelPromise newPromise() {
        return new DefaultChannelPromise(this.channel);
    }

    @Override
    public final ChannelFuture newFailedFuture(Throwable cause) {
        return new FailedChannelFuture(this.channel, null, cause);
    }

    @Override
    public final ChannelPromise voidPromise() {
        return this.voidPromise;
    }

    private void checkDuplicateName(String name2) {
        if (this.context0(name2) != null) {
            throw new IllegalArgumentException("Duplicate handler name: " + name2);
        }
    }

    private AbstractChannelHandlerContext context0(String name2) {
        AbstractChannelHandlerContext context2 = this.head.next;
        while (context2 != this.tail) {
            if (context2.name().equals(name2)) {
                return context2;
            }
            context2 = context2.next;
        }
        return null;
    }

    private AbstractChannelHandlerContext getContextOrDie(String name2) {
        AbstractChannelHandlerContext ctx = (AbstractChannelHandlerContext)this.context(name2);
        if (ctx == null) {
            throw new NoSuchElementException(name2);
        }
        return ctx;
    }

    private AbstractChannelHandlerContext getContextOrDie(ChannelHandler handler2) {
        AbstractChannelHandlerContext ctx = (AbstractChannelHandlerContext)this.context(handler2);
        if (ctx == null) {
            throw new NoSuchElementException(handler2.getClass().getName());
        }
        return ctx;
    }

    private AbstractChannelHandlerContext getContextOrDie(Class<? extends ChannelHandler> handlerType) {
        AbstractChannelHandlerContext ctx = (AbstractChannelHandlerContext)this.context(handlerType);
        if (ctx == null) {
            throw new NoSuchElementException(handlerType.getName());
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callHandlerAddedForAllHandlers() {
        PendingHandlerCallback pendingHandlerCallbackHead;
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            assert (!this.registered);
            this.registered = true;
            pendingHandlerCallbackHead = this.pendingHandlerCallbackHead;
            this.pendingHandlerCallbackHead = null;
        }
        PendingHandlerCallback task = pendingHandlerCallbackHead;
        while (task != null) {
            task.execute();
            task = task.next;
        }
    }

    private void callHandlerCallbackLater(AbstractChannelHandlerContext ctx, boolean added) {
        assert (!this.registered);
        PendingHandlerCallback task = added ? new PendingHandlerAddedTask(ctx) : new PendingHandlerRemovedTask(ctx);
        PendingHandlerCallback pending = this.pendingHandlerCallbackHead;
        if (pending == null) {
            this.pendingHandlerCallbackHead = task;
        } else {
            while (pending.next != null) {
                pending = pending.next;
            }
            pending.next = task;
        }
    }

    private void callHandlerAddedInEventLoop(final AbstractChannelHandlerContext newCtx, EventExecutor executor) {
        newCtx.setAddPending();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                DefaultChannelPipeline.this.callHandlerAdded0(newCtx);
            }
        });
    }

    protected void onUnhandledInboundException(Throwable cause) {
        try {
            logger.warn("An exceptionCaught() event was fired, and it reached at the tail of the pipeline. It usually means the last handler in the pipeline did not handle the exception.", cause);
        }
        finally {
            ReferenceCountUtil.release(cause);
        }
    }

    protected void onUnhandledInboundChannelActive() {
    }

    protected void onUnhandledInboundChannelInactive() {
    }

    protected void onUnhandledInboundMessage(Object msg) {
        try {
            logger.debug("Discarded inbound message {} that reached at the tail of the pipeline. Please check your pipeline configuration.", msg);
        }
        finally {
            ReferenceCountUtil.release(msg);
        }
    }

    protected void onUnhandledInboundMessage(ChannelHandlerContext ctx, Object msg) {
        this.onUnhandledInboundMessage(msg);
        if (logger.isDebugEnabled()) {
            logger.debug("Discarded message pipeline : {}. Channel : {}.", (Object)ctx.pipeline().names(), (Object)ctx.channel());
        }
    }

    protected void onUnhandledInboundChannelReadComplete() {
    }

    protected void onUnhandledInboundUserEventTriggered(Object evt) {
        ReferenceCountUtil.release(evt);
    }

    protected void onUnhandledChannelWritabilityChanged() {
    }

    protected void incrementPendingOutboundBytes(long size) {
        ChannelOutboundBuffer buffer = this.channel.unsafe().outboundBuffer();
        if (buffer != null) {
            buffer.incrementPendingOutboundBytes(size);
        }
    }

    protected void decrementPendingOutboundBytes(long size) {
        ChannelOutboundBuffer buffer = this.channel.unsafe().outboundBuffer();
        if (buffer != null) {
            buffer.decrementPendingOutboundBytes(size);
        }
    }

    private final class PendingHandlerRemovedTask
    extends PendingHandlerCallback {
        PendingHandlerRemovedTask(AbstractChannelHandlerContext ctx) {
            super(ctx);
        }

        @Override
        public void run() {
            DefaultChannelPipeline.this.callHandlerRemoved0(this.ctx);
        }

        @Override
        void execute() {
            EventExecutor executor = this.ctx.executor();
            if (executor.inEventLoop()) {
                DefaultChannelPipeline.this.callHandlerRemoved0(this.ctx);
            } else {
                try {
                    executor.execute(this);
                }
                catch (RejectedExecutionException e) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("Can't invoke handlerRemoved() as the EventExecutor {} rejected it, removing handler {}.", executor, this.ctx.name(), e);
                    }
                    this.ctx.setRemoved();
                }
            }
        }
    }

    private final class PendingHandlerAddedTask
    extends PendingHandlerCallback {
        PendingHandlerAddedTask(AbstractChannelHandlerContext ctx) {
            super(ctx);
        }

        @Override
        public void run() {
            DefaultChannelPipeline.this.callHandlerAdded0(this.ctx);
        }

        @Override
        void execute() {
            EventExecutor executor = this.ctx.executor();
            if (executor.inEventLoop()) {
                DefaultChannelPipeline.this.callHandlerAdded0(this.ctx);
            } else {
                try {
                    executor.execute(this);
                }
                catch (RejectedExecutionException e) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("Can't invoke handlerAdded() as the EventExecutor {} rejected it, removing handler {}.", executor, this.ctx.name(), e);
                    }
                    DefaultChannelPipeline.this.atomicRemoveFromHandlerList(this.ctx);
                    this.ctx.setRemoved();
                }
            }
        }
    }

    private static abstract class PendingHandlerCallback
    implements Runnable {
        final AbstractChannelHandlerContext ctx;
        PendingHandlerCallback next;

        PendingHandlerCallback(AbstractChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        abstract void execute();
    }

    final class HeadContext
    extends AbstractChannelHandlerContext
    implements ChannelInboundHandler,
    ChannelOutboundHandler {
        private final Channel.Unsafe unsafe;

        HeadContext(DefaultChannelPipeline pipeline) {
            super(pipeline, null, HEAD_NAME, HeadContext.class);
            this.unsafe = pipeline.channel().unsafe();
            this.setAddComplete();
        }

        @Override
        public ChannelHandler handler() {
            return this;
        }

        @Override
        public void handlerAdded(ChannelHandlerContext ctx) {
        }

        @Override
        public void handlerRemoved(ChannelHandlerContext ctx) {
        }

        @Override
        public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) {
            this.unsafe.bind(localAddress, promise);
        }

        @Override
        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress2, SocketAddress localAddress, ChannelPromise promise) {
            this.unsafe.connect(remoteAddress2, localAddress, promise);
        }

        @Override
        public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) {
            this.unsafe.disconnect(promise);
        }

        @Override
        public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
            this.unsafe.close(promise);
        }

        @Override
        public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) {
            this.unsafe.deregister(promise);
        }

        @Override
        public void read(ChannelHandlerContext ctx) {
            this.unsafe.beginRead();
        }

        @Override
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
            this.unsafe.write(msg, promise);
        }

        @Override
        public void flush(ChannelHandlerContext ctx) {
            this.unsafe.flush();
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ctx.fireExceptionCaught(cause);
        }

        @Override
        public void channelRegistered(ChannelHandlerContext ctx) {
            DefaultChannelPipeline.this.invokeHandlerAddedIfNeeded();
            ctx.fireChannelRegistered();
        }

        @Override
        public void channelUnregistered(ChannelHandlerContext ctx) {
            ctx.fireChannelUnregistered();
            if (!DefaultChannelPipeline.this.channel.isOpen()) {
                DefaultChannelPipeline.this.destroy();
            }
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) {
            ctx.fireChannelActive();
            this.readIfIsAutoRead();
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) {
            ctx.fireChannelInactive();
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            ctx.fireChannelRead(msg);
        }

        @Override
        public void channelReadComplete(ChannelHandlerContext ctx) {
            ctx.fireChannelReadComplete();
            this.readIfIsAutoRead();
        }

        private void readIfIsAutoRead() {
            if (DefaultChannelPipeline.this.channel.config().isAutoRead()) {
                DefaultChannelPipeline.this.channel.read();
            }
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            ctx.fireUserEventTriggered(evt);
        }

        @Override
        public void channelWritabilityChanged(ChannelHandlerContext ctx) {
            ctx.fireChannelWritabilityChanged();
        }
    }

    final class TailContext
    extends AbstractChannelHandlerContext
    implements ChannelInboundHandler {
        TailContext(DefaultChannelPipeline pipeline) {
            super(pipeline, null, TAIL_NAME, TailContext.class);
            this.setAddComplete();
        }

        @Override
        public ChannelHandler handler() {
            return this;
        }

        @Override
        public void channelRegistered(ChannelHandlerContext ctx) {
        }

        @Override
        public void channelUnregistered(ChannelHandlerContext ctx) {
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) {
            DefaultChannelPipeline.this.onUnhandledInboundChannelActive();
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) {
            DefaultChannelPipeline.this.onUnhandledInboundChannelInactive();
        }

        @Override
        public void channelWritabilityChanged(ChannelHandlerContext ctx) {
            DefaultChannelPipeline.this.onUnhandledChannelWritabilityChanged();
        }

        @Override
        public void handlerAdded(ChannelHandlerContext ctx) {
        }

        @Override
        public void handlerRemoved(ChannelHandlerContext ctx) {
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            DefaultChannelPipeline.this.onUnhandledInboundUserEventTriggered(evt);
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            DefaultChannelPipeline.this.onUnhandledInboundException(cause);
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            DefaultChannelPipeline.this.onUnhandledInboundMessage(ctx, msg);
        }

        @Override
        public void channelReadComplete(ChannelHandlerContext ctx) {
            DefaultChannelPipeline.this.onUnhandledInboundChannelReadComplete();
        }
    }

    private static final class AddStrategy
    extends Enum<AddStrategy> {
        public static final /* enum */ AddStrategy ADD_FIRST = new AddStrategy();
        public static final /* enum */ AddStrategy ADD_LAST = new AddStrategy();
        public static final /* enum */ AddStrategy ADD_BEFORE = new AddStrategy();
        public static final /* enum */ AddStrategy ADD_AFTER = new AddStrategy();
        private static final /* synthetic */ AddStrategy[] $VALUES;

        public static AddStrategy[] values() {
            return (AddStrategy[])$VALUES.clone();
        }

        static {
            $VALUES = new AddStrategy[]{ADD_FIRST, ADD_LAST, ADD_BEFORE, ADD_AFTER};
        }
    }
}

