/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelHandlerMask;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.DefaultChannelProgressivePromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.FailedChannelFuture;
import io.netty.channel.SucceededChannelFuture;
import io.netty.channel.VoidChannelPromise;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ResourceLeakHint;
import io.netty.util.concurrent.AbstractEventExecutor;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.OrderedEventExecutor;
import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PromiseNotificationUtil;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

abstract class AbstractChannelHandlerContext
implements ChannelHandlerContext,
ResourceLeakHint {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractChannelHandlerContext.class);
    volatile AbstractChannelHandlerContext next;
    volatile AbstractChannelHandlerContext prev;
    private static final AtomicIntegerFieldUpdater<AbstractChannelHandlerContext> HANDLER_STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AbstractChannelHandlerContext.class, "handlerState");
    private static final int ADD_PENDING = 1;
    private static final int ADD_COMPLETE = 2;
    private static final int REMOVE_COMPLETE = 3;
    private static final int INIT = 0;
    private final DefaultChannelPipeline pipeline;
    private final String name;
    private final boolean ordered;
    private final int executionMask;
    final EventExecutor childExecutor;
    EventExecutor contextExecutor;
    private ChannelFuture succeededFuture;
    private Tasks invokeTasks;
    private volatile int handlerState = 0;

    AbstractChannelHandlerContext(DefaultChannelPipeline pipeline, EventExecutor executor, String name2, Class<? extends ChannelHandler> handlerClass) {
        this.name = ObjectUtil.checkNotNull(name2, "name");
        this.pipeline = pipeline;
        this.childExecutor = executor;
        this.executionMask = ChannelHandlerMask.mask(handlerClass);
        this.ordered = executor == null || executor instanceof OrderedEventExecutor;
    }

    @Override
    public Channel channel() {
        return this.pipeline.channel();
    }

    @Override
    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.channel().config().getAllocator();
    }

    @Override
    public EventExecutor executor() {
        EventExecutor ex = this.contextExecutor;
        if (ex == null) {
            ex = this.childExecutor != null ? this.childExecutor : this.channel().eventLoop();
            this.contextExecutor = ex;
        }
        return ex;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ChannelHandlerContext fireChannelRegistered() {
        block8: {
            AbstractChannelHandlerContext next2 = this.findContextInbound(2);
            if (next2.executor().inEventLoop()) {
                if (next2.invokeHandler()) {
                    try {
                        ChannelHandler handler2 = next2.handler();
                        DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                        if (handler2 == headContext) {
                            headContext.channelRegistered(next2);
                            break block8;
                        }
                        if (handler2 instanceof ChannelInboundHandlerAdapter) {
                            ((ChannelInboundHandlerAdapter)handler2).channelRegistered(next2);
                            break block8;
                        }
                        ((ChannelInboundHandler)handler2).channelRegistered(next2);
                    }
                    catch (Throwable t2) {
                        next2.invokeExceptionCaught(t2);
                    }
                } else {
                    next2.fireChannelRegistered();
                }
            } else {
                next2.executor().execute(this::fireChannelRegistered);
            }
        }
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelUnregistered() {
        block8: {
            AbstractChannelHandlerContext next2 = this.findContextInbound(4);
            if (next2.executor().inEventLoop()) {
                if (next2.invokeHandler()) {
                    try {
                        ChannelHandler handler2 = next2.handler();
                        DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                        if (handler2 == headContext) {
                            headContext.channelUnregistered(next2);
                            break block8;
                        }
                        if (handler2 instanceof ChannelInboundHandlerAdapter) {
                            ((ChannelInboundHandlerAdapter)handler2).channelUnregistered(next2);
                            break block8;
                        }
                        ((ChannelInboundHandler)handler2).channelUnregistered(next2);
                    }
                    catch (Throwable t2) {
                        next2.invokeExceptionCaught(t2);
                    }
                } else {
                    next2.fireChannelUnregistered();
                }
            } else {
                next2.executor().execute(this::fireChannelUnregistered);
            }
        }
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelActive() {
        block8: {
            AbstractChannelHandlerContext next2 = this.findContextInbound(8);
            if (next2.executor().inEventLoop()) {
                if (next2.invokeHandler()) {
                    try {
                        ChannelHandler handler2 = next2.handler();
                        DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                        if (handler2 == headContext) {
                            headContext.channelActive(next2);
                            break block8;
                        }
                        if (handler2 instanceof ChannelInboundHandlerAdapter) {
                            ((ChannelInboundHandlerAdapter)handler2).channelActive(next2);
                            break block8;
                        }
                        ((ChannelInboundHandler)handler2).channelActive(next2);
                    }
                    catch (Throwable t2) {
                        next2.invokeExceptionCaught(t2);
                    }
                } else {
                    next2.fireChannelActive();
                }
            } else {
                next2.executor().execute(this::fireChannelActive);
            }
        }
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelInactive() {
        block8: {
            AbstractChannelHandlerContext next2 = this.findContextInbound(16);
            if (next2.executor().inEventLoop()) {
                if (next2.invokeHandler()) {
                    try {
                        ChannelHandler handler2 = next2.handler();
                        DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                        if (handler2 == headContext) {
                            headContext.channelInactive(next2);
                            break block8;
                        }
                        if (handler2 instanceof ChannelInboundHandlerAdapter) {
                            ((ChannelInboundHandlerAdapter)handler2).channelInactive(next2);
                            break block8;
                        }
                        ((ChannelInboundHandler)handler2).channelInactive(next2);
                    }
                    catch (Throwable t2) {
                        next2.invokeExceptionCaught(t2);
                    }
                } else {
                    next2.fireChannelInactive();
                }
            } else {
                next2.executor().execute(this::fireChannelInactive);
            }
        }
        return this;
    }

    @Override
    public ChannelHandlerContext fireExceptionCaught(Throwable cause) {
        block4: {
            AbstractChannelHandlerContext next2 = this.findContextInbound(1);
            ObjectUtil.checkNotNull(cause, "cause");
            if (next2.executor().inEventLoop()) {
                next2.invokeExceptionCaught(cause);
            } else {
                try {
                    next2.executor().execute(() -> next2.invokeExceptionCaught(cause));
                }
                catch (Throwable t2) {
                    if (!logger.isWarnEnabled()) break block4;
                    logger.warn("Failed to submit an exceptionCaught() event.", t2);
                    logger.warn("The exceptionCaught() event that was failed to submit was:", cause);
                }
            }
        }
        return this;
    }

    private void invokeExceptionCaught(Throwable cause) {
        if (this.invokeHandler()) {
            try {
                this.handler().exceptionCaught(this, cause);
            }
            catch (Throwable error2) {
                if (logger.isDebugEnabled()) {
                    logger.debug("An exception was thrown by a user handler's exceptionCaught() method while handling the following exception:", cause);
                } else if (logger.isWarnEnabled()) {
                    logger.warn("An exception '{}' [enable DEBUG level for full stacktrace] was thrown by a user handler's exceptionCaught() method while handling the following exception:", (Object)error2, (Object)cause);
                }
            }
        } else {
            this.fireExceptionCaught(cause);
        }
    }

    @Override
    public ChannelHandlerContext fireUserEventTriggered(Object event) {
        block8: {
            ObjectUtil.checkNotNull(event, "event");
            AbstractChannelHandlerContext next2 = this.findContextInbound(128);
            if (next2.executor().inEventLoop()) {
                if (next2.invokeHandler()) {
                    try {
                        ChannelHandler handler2 = next2.handler();
                        DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                        if (handler2 == headContext) {
                            headContext.userEventTriggered(next2, event);
                            break block8;
                        }
                        if (handler2 instanceof ChannelInboundHandlerAdapter) {
                            ((ChannelInboundHandlerAdapter)handler2).userEventTriggered(next2, event);
                            break block8;
                        }
                        ((ChannelInboundHandler)handler2).userEventTriggered(next2, event);
                    }
                    catch (Throwable t2) {
                        next2.invokeExceptionCaught(t2);
                    }
                } else {
                    next2.fireUserEventTriggered(event);
                }
            } else {
                next2.executor().execute(() -> this.fireUserEventTriggered(event));
            }
        }
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelRead(Object msg) {
        block8: {
            AbstractChannelHandlerContext next2 = this.findContextInbound(32);
            if (next2.executor().inEventLoop()) {
                Object m = this.pipeline.touch(msg, next2);
                if (next2.invokeHandler()) {
                    try {
                        ChannelHandler handler2 = next2.handler();
                        DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                        if (handler2 == headContext) {
                            headContext.channelRead(next2, m);
                            break block8;
                        }
                        if (handler2 instanceof ChannelDuplexHandler) {
                            ((ChannelDuplexHandler)handler2).channelRead(next2, m);
                            break block8;
                        }
                        ((ChannelInboundHandler)handler2).channelRead(next2, m);
                    }
                    catch (Throwable t2) {
                        next2.invokeExceptionCaught(t2);
                    }
                } else {
                    next2.fireChannelRead(m);
                }
            } else {
                next2.executor().execute(() -> this.fireChannelRead(msg));
            }
        }
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelReadComplete() {
        block8: {
            AbstractChannelHandlerContext next2 = this.findContextInbound(64);
            if (next2.executor().inEventLoop()) {
                if (next2.invokeHandler()) {
                    try {
                        ChannelHandler handler2 = next2.handler();
                        DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                        if (handler2 == headContext) {
                            headContext.channelReadComplete(next2);
                            break block8;
                        }
                        if (handler2 instanceof ChannelDuplexHandler) {
                            ((ChannelDuplexHandler)handler2).channelReadComplete(next2);
                            break block8;
                        }
                        ((ChannelInboundHandler)handler2).channelReadComplete(next2);
                    }
                    catch (Throwable t2) {
                        next2.invokeExceptionCaught(t2);
                    }
                } else {
                    next2.fireChannelReadComplete();
                }
            } else {
                next2.executor().execute(this.getInvokeTasks().invokeChannelReadCompleteTask);
            }
        }
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelWritabilityChanged() {
        block8: {
            AbstractChannelHandlerContext next2 = this.findContextInbound(256);
            if (next2.executor().inEventLoop()) {
                if (next2.invokeHandler()) {
                    try {
                        ChannelHandler handler2 = next2.handler();
                        DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                        if (handler2 == headContext) {
                            headContext.channelWritabilityChanged(next2);
                            break block8;
                        }
                        if (handler2 instanceof ChannelInboundHandlerAdapter) {
                            ((ChannelInboundHandlerAdapter)handler2).channelWritabilityChanged(next2);
                            break block8;
                        }
                        ((ChannelInboundHandler)handler2).channelWritabilityChanged(next2);
                    }
                    catch (Throwable t2) {
                        next2.invokeExceptionCaught(t2);
                    }
                } else {
                    next2.fireChannelWritabilityChanged();
                }
            } else {
                next2.executor().execute(this.getInvokeTasks().invokeChannelWritableStateChangedTask);
            }
        }
        return this;
    }

    public ChannelFuture bind(SocketAddress localAddress) {
        return this.bind(localAddress, this.newPromise());
    }

    public ChannelFuture connect(SocketAddress remoteAddress2) {
        return this.connect(remoteAddress2, this.newPromise());
    }

    public ChannelFuture connect(SocketAddress remoteAddress2, SocketAddress localAddress) {
        return this.connect(remoteAddress2, localAddress, this.newPromise());
    }

    public ChannelFuture disconnect() {
        return this.disconnect(this.newPromise());
    }

    @Override
    public ChannelFuture close() {
        return this.close(this.newPromise());
    }

    public ChannelFuture deregister() {
        return this.deregister(this.newPromise());
    }

    @Override
    public ChannelFuture bind(final SocketAddress localAddress, final ChannelPromise promise) {
        ObjectUtil.checkNotNull(localAddress, "localAddress");
        if (this.isNotValidPromise(promise, false)) {
            return promise;
        }
        final AbstractChannelHandlerContext next2 = this.findContextOutbound(512);
        EventExecutor executor = next2.executor();
        if (executor.inEventLoop()) {
            next2.invokeBind(localAddress, promise);
        } else {
            AbstractChannelHandlerContext.safeExecute(executor, new Runnable(){

                @Override
                public void run() {
                    next2.invokeBind(localAddress, promise);
                }
            }, promise, null, false);
        }
        return promise;
    }

    private void invokeBind(SocketAddress localAddress, ChannelPromise promise) {
        block7: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler handler2 = this.handler();
                    DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                    if (handler2 == headContext) {
                        headContext.bind(this, localAddress, promise);
                        break block7;
                    }
                    if (handler2 instanceof ChannelDuplexHandler) {
                        ((ChannelDuplexHandler)handler2).bind(this, localAddress, promise);
                        break block7;
                    }
                    if (handler2 instanceof ChannelOutboundHandlerAdapter) {
                        ((ChannelOutboundHandlerAdapter)handler2).bind(this, localAddress, promise);
                        break block7;
                    }
                    ((ChannelOutboundHandler)handler2).bind(this, localAddress, promise);
                }
                catch (Throwable t2) {
                    AbstractChannelHandlerContext.notifyOutboundHandlerException(t2, promise);
                }
            } else {
                this.bind(localAddress, promise);
            }
        }
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress2, ChannelPromise promise) {
        return this.connect(remoteAddress2, null, promise);
    }

    @Override
    public ChannelFuture connect(final SocketAddress remoteAddress2, final SocketAddress localAddress, final ChannelPromise promise) {
        ObjectUtil.checkNotNull(remoteAddress2, "remoteAddress");
        if (this.isNotValidPromise(promise, false)) {
            return promise;
        }
        final AbstractChannelHandlerContext next2 = this.findContextOutbound(1024);
        EventExecutor executor = next2.executor();
        if (executor.inEventLoop()) {
            next2.invokeConnect(remoteAddress2, localAddress, promise);
        } else {
            AbstractChannelHandlerContext.safeExecute(executor, new Runnable(){

                @Override
                public void run() {
                    next2.invokeConnect(remoteAddress2, localAddress, promise);
                }
            }, promise, null, false);
        }
        return promise;
    }

    private void invokeConnect(SocketAddress remoteAddress2, SocketAddress localAddress, ChannelPromise promise) {
        block7: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler handler2 = this.handler();
                    DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                    if (handler2 == headContext) {
                        headContext.connect(this, remoteAddress2, localAddress, promise);
                        break block7;
                    }
                    if (handler2 instanceof ChannelDuplexHandler) {
                        ((ChannelDuplexHandler)handler2).connect(this, remoteAddress2, localAddress, promise);
                        break block7;
                    }
                    if (handler2 instanceof ChannelOutboundHandlerAdapter) {
                        ((ChannelOutboundHandlerAdapter)handler2).connect(this, remoteAddress2, localAddress, promise);
                        break block7;
                    }
                    ((ChannelOutboundHandler)handler2).connect(this, remoteAddress2, localAddress, promise);
                }
                catch (Throwable t2) {
                    AbstractChannelHandlerContext.notifyOutboundHandlerException(t2, promise);
                }
            } else {
                this.connect(remoteAddress2, localAddress, promise);
            }
        }
    }

    @Override
    public ChannelFuture disconnect(final ChannelPromise promise) {
        if (!this.channel().metadata().hasDisconnect()) {
            return this.close(promise);
        }
        if (this.isNotValidPromise(promise, false)) {
            return promise;
        }
        final AbstractChannelHandlerContext next2 = this.findContextOutbound(2048);
        EventExecutor executor = next2.executor();
        if (executor.inEventLoop()) {
            next2.invokeDisconnect(promise);
        } else {
            AbstractChannelHandlerContext.safeExecute(executor, new Runnable(){

                @Override
                public void run() {
                    next2.invokeDisconnect(promise);
                }
            }, promise, null, false);
        }
        return promise;
    }

    private void invokeDisconnect(ChannelPromise promise) {
        block7: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler handler2 = this.handler();
                    DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                    if (handler2 == headContext) {
                        headContext.disconnect(this, promise);
                        break block7;
                    }
                    if (handler2 instanceof ChannelDuplexHandler) {
                        ((ChannelDuplexHandler)handler2).disconnect(this, promise);
                        break block7;
                    }
                    if (handler2 instanceof ChannelOutboundHandlerAdapter) {
                        ((ChannelOutboundHandlerAdapter)handler2).disconnect(this, promise);
                        break block7;
                    }
                    ((ChannelOutboundHandler)handler2).disconnect(this, promise);
                }
                catch (Throwable t2) {
                    AbstractChannelHandlerContext.notifyOutboundHandlerException(t2, promise);
                }
            } else {
                this.disconnect(promise);
            }
        }
    }

    @Override
    public ChannelFuture close(final ChannelPromise promise) {
        if (this.isNotValidPromise(promise, false)) {
            return promise;
        }
        final AbstractChannelHandlerContext next2 = this.findContextOutbound(4096);
        EventExecutor executor = next2.executor();
        if (executor.inEventLoop()) {
            next2.invokeClose(promise);
        } else {
            AbstractChannelHandlerContext.safeExecute(executor, new Runnable(){

                @Override
                public void run() {
                    next2.invokeClose(promise);
                }
            }, promise, null, false);
        }
        return promise;
    }

    private void invokeClose(ChannelPromise promise) {
        block7: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler handler2 = this.handler();
                    DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                    if (handler2 == headContext) {
                        headContext.close(this, promise);
                        break block7;
                    }
                    if (handler2 instanceof ChannelDuplexHandler) {
                        ((ChannelDuplexHandler)handler2).close(this, promise);
                        break block7;
                    }
                    if (handler2 instanceof ChannelOutboundHandlerAdapter) {
                        ((ChannelOutboundHandlerAdapter)handler2).close(this, promise);
                        break block7;
                    }
                    ((ChannelOutboundHandler)handler2).close(this, promise);
                }
                catch (Throwable t2) {
                    AbstractChannelHandlerContext.notifyOutboundHandlerException(t2, promise);
                }
            } else {
                this.close(promise);
            }
        }
    }

    @Override
    public ChannelFuture deregister(final ChannelPromise promise) {
        if (this.isNotValidPromise(promise, false)) {
            return promise;
        }
        final AbstractChannelHandlerContext next2 = this.findContextOutbound(8192);
        EventExecutor executor = next2.executor();
        if (executor.inEventLoop()) {
            next2.invokeDeregister(promise);
        } else {
            AbstractChannelHandlerContext.safeExecute(executor, new Runnable(){

                @Override
                public void run() {
                    next2.invokeDeregister(promise);
                }
            }, promise, null, false);
        }
        return promise;
    }

    private void invokeDeregister(ChannelPromise promise) {
        block7: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler handler2 = this.handler();
                    DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                    if (handler2 == headContext) {
                        headContext.deregister(this, promise);
                        break block7;
                    }
                    if (handler2 instanceof ChannelDuplexHandler) {
                        ((ChannelDuplexHandler)handler2).deregister(this, promise);
                        break block7;
                    }
                    if (handler2 instanceof ChannelOutboundHandlerAdapter) {
                        ((ChannelOutboundHandlerAdapter)handler2).deregister(this, promise);
                        break block7;
                    }
                    ((ChannelOutboundHandler)handler2).deregister(this, promise);
                }
                catch (Throwable t2) {
                    AbstractChannelHandlerContext.notifyOutboundHandlerException(t2, promise);
                }
            } else {
                this.deregister(promise);
            }
        }
    }

    @Override
    public ChannelHandlerContext read() {
        block9: {
            AbstractChannelHandlerContext next2 = this.findContextOutbound(16384);
            if (next2.executor().inEventLoop()) {
                if (next2.invokeHandler()) {
                    try {
                        ChannelHandler handler2 = next2.handler();
                        DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                        if (handler2 == headContext) {
                            headContext.read(next2);
                            break block9;
                        }
                        if (handler2 instanceof ChannelDuplexHandler) {
                            ((ChannelDuplexHandler)handler2).read(next2);
                            break block9;
                        }
                        if (handler2 instanceof ChannelOutboundHandlerAdapter) {
                            ((ChannelOutboundHandlerAdapter)handler2).read(next2);
                            break block9;
                        }
                        ((ChannelOutboundHandler)handler2).read(next2);
                    }
                    catch (Throwable t2) {
                        this.invokeExceptionCaught(t2);
                    }
                } else {
                    next2.read();
                }
            } else {
                next2.executor().execute(this.getInvokeTasks().invokeReadTask);
            }
        }
        return this;
    }

    @Override
    public ChannelFuture write(Object msg) {
        ChannelPromise promise = this.newPromise();
        this.write(msg, false, promise);
        return promise;
    }

    @Override
    public ChannelFuture write(Object msg, ChannelPromise promise) {
        this.write(msg, false, promise);
        return promise;
    }

    @Override
    public ChannelHandlerContext flush() {
        AbstractChannelHandlerContext next2 = this.findContextOutbound(65536);
        EventExecutor executor = next2.executor();
        if (executor.inEventLoop()) {
            next2.invokeFlush();
        } else {
            Tasks tasks2 = next2.invokeTasks;
            if (tasks2 == null) {
                next2.invokeTasks = tasks2 = new Tasks(next2);
            }
            AbstractChannelHandlerContext.safeExecute(executor, tasks2.invokeFlushTask, this.channel().voidPromise(), null, false);
        }
        return this;
    }

    private void invokeFlush() {
        if (this.invokeHandler()) {
            this.invokeFlush0();
        } else {
            this.flush();
        }
    }

    private void invokeFlush0() {
        try {
            ChannelHandler handler2 = this.handler();
            DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
            if (handler2 == headContext) {
                headContext.flush(this);
            } else if (handler2 instanceof ChannelDuplexHandler) {
                ((ChannelDuplexHandler)handler2).flush(this);
            } else if (handler2 instanceof ChannelOutboundHandlerAdapter) {
                ((ChannelOutboundHandlerAdapter)handler2).flush(this);
            } else {
                ((ChannelOutboundHandler)handler2).flush(this);
            }
        }
        catch (Throwable t2) {
            this.invokeExceptionCaught(t2);
        }
    }

    @Override
    public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
        this.write(msg, true, promise);
        return promise;
    }

    void write(Object msg, boolean flush, ChannelPromise promise) {
        if (this.validateWrite(msg, promise)) {
            AbstractChannelHandlerContext next2 = this.findContextOutbound(flush ? 98304 : 32768);
            Object m = this.pipeline.touch(msg, next2);
            EventExecutor executor = next2.executor();
            if (executor.inEventLoop()) {
                if (next2.invokeHandler()) {
                    try {
                        ChannelHandler handler2 = next2.handler();
                        DefaultChannelPipeline.HeadContext headContext = this.pipeline.head;
                        if (handler2 == headContext) {
                            headContext.write(next2, msg, promise);
                        } else if (handler2 instanceof ChannelDuplexHandler) {
                            ((ChannelDuplexHandler)handler2).write(next2, msg, promise);
                        } else if (handler2 instanceof ChannelOutboundHandlerAdapter) {
                            ((ChannelOutboundHandlerAdapter)handler2).write(next2, msg, promise);
                        } else {
                            ((ChannelOutboundHandler)handler2).write(next2, msg, promise);
                        }
                    }
                    catch (Throwable t2) {
                        AbstractChannelHandlerContext.notifyOutboundHandlerException(t2, promise);
                    }
                    if (flush) {
                        next2.invokeFlush0();
                    }
                } else {
                    next2.write(msg, flush, promise);
                }
            } else {
                WriteTask task = WriteTask.newInstance(this, m, promise, flush);
                if (!AbstractChannelHandlerContext.safeExecute(executor, task, promise, m, !flush)) {
                    task.cancel();
                }
            }
        }
    }

    private boolean validateWrite(Object msg, ChannelPromise promise) {
        ObjectUtil.checkNotNull(msg, "msg");
        try {
            if (this.isNotValidPromise(promise, true)) {
                ReferenceCountUtil.release(msg);
                return false;
            }
        }
        catch (RuntimeException e) {
            ReferenceCountUtil.release(msg);
            throw e;
        }
        return true;
    }

    @Override
    public ChannelFuture writeAndFlush(Object msg) {
        return this.writeAndFlush(msg, this.newPromise());
    }

    private static void notifyOutboundHandlerException(Throwable cause, ChannelPromise promise) {
        PromiseNotificationUtil.tryFailure(promise, cause, promise instanceof VoidChannelPromise ? null : logger);
    }

    @Override
    public ChannelPromise newPromise() {
        return new DefaultChannelPromise(this.channel(), this.executor());
    }

    public ChannelProgressivePromise newProgressivePromise() {
        return new DefaultChannelProgressivePromise(this.channel(), this.executor());
    }

    public ChannelFuture newSucceededFuture() {
        ChannelFuture succeededFuture = this.succeededFuture;
        if (succeededFuture == null) {
            this.succeededFuture = succeededFuture = new SucceededChannelFuture(this.channel(), this.executor());
        }
        return succeededFuture;
    }

    public ChannelFuture newFailedFuture(Throwable cause) {
        return new FailedChannelFuture(this.channel(), this.executor(), cause);
    }

    private boolean isNotValidPromise(ChannelPromise promise, boolean allowVoidPromise) {
        ObjectUtil.checkNotNull(promise, "promise");
        if (promise.isDone()) {
            if (promise.isCancelled()) {
                return true;
            }
            throw new IllegalArgumentException("promise already done: " + promise);
        }
        if (promise.channel() != this.channel()) {
            throw new IllegalArgumentException(String.format("promise.channel does not match: %s (expected: %s)", promise.channel(), this.channel()));
        }
        if (promise.getClass() == DefaultChannelPromise.class) {
            return false;
        }
        if (!allowVoidPromise && promise instanceof VoidChannelPromise) {
            throw new IllegalArgumentException(StringUtil.simpleClassName(VoidChannelPromise.class) + " not allowed for this operation");
        }
        if (promise instanceof AbstractChannel.CloseFuture) {
            throw new IllegalArgumentException(StringUtil.simpleClassName(AbstractChannel.CloseFuture.class) + " not allowed in a pipeline");
        }
        return false;
    }

    private AbstractChannelHandlerContext findContextInbound(int mask) {
        AbstractChannelHandlerContext ctx = this;
        EventExecutor currentExecutor = this.executor();
        while (AbstractChannelHandlerContext.skipContext(ctx = ctx.next, currentExecutor, mask, 510)) {
        }
        return ctx;
    }

    private AbstractChannelHandlerContext findContextOutbound(int mask) {
        AbstractChannelHandlerContext ctx = this;
        EventExecutor currentExecutor = this.executor();
        while (AbstractChannelHandlerContext.skipContext(ctx = ctx.prev, currentExecutor, mask, 130560)) {
        }
        return ctx;
    }

    private static boolean skipContext(AbstractChannelHandlerContext ctx, EventExecutor currentExecutor, int mask, int onlyMask) {
        return (ctx.executionMask & (onlyMask | mask)) == 0 || ctx.executor() == currentExecutor && (ctx.executionMask & mask) == 0;
    }

    @Override
    public ChannelPromise voidPromise() {
        return this.channel().voidPromise();
    }

    final void setRemoved() {
        this.handlerState = 3;
    }

    final boolean setAddComplete() {
        int oldState;
        do {
            if ((oldState = this.handlerState) != 3) continue;
            return false;
        } while (!HANDLER_STATE_UPDATER.compareAndSet(this, oldState, 2));
        return true;
    }

    final void setAddPending() {
        boolean updated = HANDLER_STATE_UPDATER.compareAndSet(this, 0, 1);
        assert (updated);
    }

    final void callHandlerAdded() throws Exception {
        if (this.setAddComplete()) {
            this.handler().handlerAdded(this);
        }
    }

    final void callHandlerRemoved() throws Exception {
        try {
            if (this.handlerState == 2) {
                this.handler().handlerRemoved(this);
            }
        }
        finally {
            this.setRemoved();
        }
    }

    boolean invokeHandler() {
        int handlerState = this.handlerState;
        return handlerState == 2 || !this.ordered && handlerState == 1;
    }

    @Override
    public boolean isRemoved() {
        return this.handlerState == 3;
    }

    @Override
    public <T> Attribute<T> attr(AttributeKey<T> key) {
        return this.channel().attr(key);
    }

    @Override
    public <T> boolean hasAttr(AttributeKey<T> key) {
        return this.channel().hasAttr(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean safeExecute(EventExecutor executor, Runnable runnable2, ChannelPromise promise, Object msg, boolean lazy) {
        try {
            if (lazy && executor instanceof AbstractEventExecutor) {
                ((AbstractEventExecutor)executor).lazyExecute(runnable2);
            } else {
                executor.execute(runnable2);
            }
            return true;
        }
        catch (Throwable cause) {
            try {
                if (msg != null) {
                    ReferenceCountUtil.release(msg);
                }
            }
            finally {
                promise.setFailure(cause);
            }
            return false;
        }
    }

    @Override
    public String toHintString() {
        return '\'' + this.name + "' will handle the message from this point.";
    }

    public String toString() {
        return StringUtil.simpleClassName(ChannelHandlerContext.class) + '(' + this.name + ", " + this.channel() + ')';
    }

    Tasks getInvokeTasks() {
        Tasks tasks2 = this.invokeTasks;
        if (tasks2 == null) {
            this.invokeTasks = tasks2 = new Tasks(this);
        }
        return tasks2;
    }

    static final class Tasks {
        final Runnable invokeChannelReadCompleteTask = ctx::fireChannelReadComplete;
        private final Runnable invokeReadTask = ctx::read;
        private final Runnable invokeChannelWritableStateChangedTask = ctx::fireChannelWritabilityChanged;
        private final Runnable invokeFlushTask = () -> AbstractChannelHandlerContext.access$1000(ctx);

        Tasks(AbstractChannelHandlerContext ctx) {
        }
    }

    static final class WriteTask
    implements Runnable {
        private static final Recycler<WriteTask> RECYCLER = new Recycler<WriteTask>(){

            @Override
            protected WriteTask newObject(Recycler.Handle<WriteTask> handle2) {
                return new WriteTask(handle2);
            }
        };
        private static final boolean ESTIMATE_TASK_SIZE_ON_SUBMIT = SystemPropertyUtil.getBoolean("io.netty.transport.estimateSizeOnSubmit", true);
        private static final int WRITE_TASK_OVERHEAD = SystemPropertyUtil.getInt("io.netty.transport.writeTaskSizeOverhead", 32);
        private final ObjectPool.Handle<WriteTask> handle;
        private AbstractChannelHandlerContext ctx;
        private Object msg;
        private ChannelPromise promise;
        private int size;

        static WriteTask newInstance(AbstractChannelHandlerContext ctx, Object msg, ChannelPromise promise, boolean flush) {
            WriteTask task = RECYCLER.get();
            WriteTask.init(task, ctx, msg, promise, flush);
            return task;
        }

        private WriteTask(ObjectPool.Handle<WriteTask> handle2) {
            this.handle = handle2;
        }

        static void init(WriteTask task, AbstractChannelHandlerContext ctx, Object msg, ChannelPromise promise, boolean flush) {
            task.ctx = ctx;
            task.msg = msg;
            task.promise = promise;
            if (ESTIMATE_TASK_SIZE_ON_SUBMIT) {
                task.size = ctx.pipeline.estimatorHandle().size(msg) + WRITE_TASK_OVERHEAD;
                ctx.pipeline.incrementPendingOutboundBytes(task.size);
            } else {
                task.size = 0;
            }
            if (flush) {
                task.size |= Integer.MIN_VALUE;
            }
        }

        @Override
        public void run() {
            try {
                this.decrementPendingOutboundBytes();
                this.ctx.write(this.msg, this.size < 0, this.promise);
            }
            finally {
                this.recycle();
            }
        }

        void cancel() {
            try {
                this.decrementPendingOutboundBytes();
            }
            finally {
                this.recycle();
            }
        }

        private void decrementPendingOutboundBytes() {
            if (ESTIMATE_TASK_SIZE_ON_SUBMIT) {
                this.ctx.pipeline.decrementPendingOutboundBytes(this.size & Integer.MAX_VALUE);
            }
        }

        private void recycle() {
            this.ctx = null;
            this.msg = null;
            this.promise = null;
            this.handle.recycle(this);
        }
    }
}

