/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.kotlin.sdk.server;

import io.modelcontextprotocol.kotlin.sdk.ClientCapabilities;
import io.modelcontextprotocol.kotlin.sdk.Implementation;
import io.modelcontextprotocol.kotlin.sdk.InitializeRequest;
import io.modelcontextprotocol.kotlin.sdk.InitializeResult;
import io.modelcontextprotocol.kotlin.sdk.InitializedNotification;
import io.modelcontextprotocol.kotlin.sdk.Method;
import io.modelcontextprotocol.kotlin.sdk.RequestResult;
import io.modelcontextprotocol.kotlin.sdk.ResourceListChangedNotification;
import io.modelcontextprotocol.kotlin.sdk.ServerCapabilities;
import io.modelcontextprotocol.kotlin.sdk.ToolListChangedNotification;
import io.modelcontextprotocol.kotlin.sdk.TypesKt;
import io.modelcontextprotocol.kotlin.sdk.server.ServerOptions;
import io.modelcontextprotocol.kotlin.sdk.server.ServerSessionKt;
import io.modelcontextprotocol.kotlin.sdk.shared.Protocol;
import io.modelcontextprotocol.kotlin.sdk.shared.RequestHandlerExtra;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nServerSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerSession.kt\nio/modelcontextprotocol/kotlin/sdk/server/ServerSession\n+ 2 Protocol.kt\nio/modelcontextprotocol/kotlin/sdk/shared/Protocol\n*L\n1#1,377:1\n494#2,2:378\n*S KotlinDebug\n*F\n+ 1 ServerSession.kt\nio/modelcontextprotocol/kotlin/sdk/server/ServerSession\n*L\n48#1:378,2\n*E\n"})
public class ServerSession
extends Protocol {
    @NotNull
    private final Implementation serverInfo;
    @Nullable
    private final String instructions;
    @NotNull
    private Function0<Unit> _onInitialized;
    @NotNull
    private Function0<Unit> _onClose;
    @NotNull
    private final ServerCapabilities serverCapabilities;
    @Nullable
    private ClientCapabilities clientCapabilities;
    @Nullable
    private Implementation clientVersion;

    /*
     * WARNING - void declaration
     */
    public ServerSession(@NotNull Implementation serverInfo, @NotNull ServerOptions options, @Nullable String instructions) {
        void method$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)serverInfo, (String)"serverInfo");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        super(options);
        this.serverInfo = serverInfo;
        this.instructions = instructions;
        this._onInitialized = ServerSession::_onInitialized$lambda$0;
        this._onClose = ServerSession::_onClose$lambda$1;
        Protocol protocol = this;
        Method method = Method.Defined.Initialize;
        Function3 block$iv = (Function3)new Function3<InitializeRequest, RequestHandlerExtra, Continuation<? super RequestResult>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ ServerSession this$0;
            {
                this.this$0 = $receiver;
                super(3, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                InitializeRequest initializeRequest = (InitializeRequest)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void request2;
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = request2;
                        this.label = 1;
                        Object object2 = this.this$0.handleInitialize((InitializeRequest)request2, (Continuation<? super InitializeResult>)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(InitializeRequest p1, RequestHandlerExtra p2, Continuation<? super RequestResult> p3) {
                Function3<InitializeRequest, RequestHandlerExtra, Continuation<? super RequestResult>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                function3.L$0 = p1;
                return function3.invokeSuspend((Object)Unit.INSTANCE);
            }
        };
        boolean $i$f$setRequestHandler = false;
        this_$iv.setRequestHandler(Reflection.typeOf(InitializeRequest.class), (Method)method$iv, block$iv);
        this.setNotificationHandler(Method.Defined.NotificationsInitialized, arg_0 -> ServerSession._init_$lambda$2(this, arg_0));
        this.serverCapabilities = options.getCapabilities();
    }

    @Nullable
    public final Implementation getClientVersion() {
        return this.clientVersion;
    }

    @Override
    public void onClose() {
        ServerSessionKt.access$getLogger$p().debug(ServerSession::onClose$lambda$5);
        this._onClose.invoke();
    }

    @Nullable
    public final Object sendResourceListChanged(@NotNull Continuation<? super Unit> $completion) {
        ServerSessionKt.access$getLogger$p().debug(ServerSession::sendResourceListChanged$lambda$11);
        Object object = this.notification(new ResourceListChangedNotification(null, 1, null), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object sendToolListChanged(@NotNull Continuation<? super Unit> $completion) {
        ServerSessionKt.access$getLogger$p().debug(ServerSession::sendToolListChanged$lambda$12);
        Object object = this.notification(new ToolListChangedNotification(null, 1, null), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    protected void assertCapabilityForMethod(@NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        ServerSessionKt.access$getLogger$p().trace(() -> ServerSession.assertCapabilityForMethod$lambda$14(method));
        Method method2 = method;
        if (method2 == Method.Defined.SamplingCreateMessage) {
            ClientCapabilities clientCapabilities = this.clientCapabilities;
            if ((clientCapabilities != null ? clientCapabilities.getSampling() : null) == null) {
                ServerSessionKt.access$getLogger$p().error(ServerSession::assertCapabilityForMethod$lambda$15);
                throw new IllegalStateException("Client does not support sampling (required for " + method.getValue() + ')');
            }
        } else if (method2 == Method.Defined.RootsList) {
            ClientCapabilities clientCapabilities = this.clientCapabilities;
            if ((clientCapabilities != null ? clientCapabilities.getRoots() : null) == null) {
                ServerSessionKt.access$getLogger$p().error(ServerSession::assertCapabilityForMethod$lambda$16);
                throw new IllegalStateException("Client does not support listing roots (required for " + method.getValue() + ')');
            }
        } else if (method2 == Method.Defined.ElicitationCreate) {
            ClientCapabilities clientCapabilities = this.clientCapabilities;
            if ((clientCapabilities != null ? clientCapabilities.getElicitation() : null) == null) {
                ServerSessionKt.access$getLogger$p().error(ServerSession::assertCapabilityForMethod$lambda$17);
                throw new IllegalStateException("Client does not support elicitation (required for " + method.getValue() + ')');
            }
        } else if (method2 == Method.Defined.Ping) {
            // empty if block
        }
    }

    @Override
    protected void assertNotificationCapability(@NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        ServerSessionKt.access$getLogger$p().trace(() -> ServerSession.assertNotificationCapability$lambda$18(method));
        Method method2 = method;
        if (method2 == Method.Defined.NotificationsMessage) {
            if (this.serverCapabilities.getLogging() == null) {
                ServerSessionKt.access$getLogger$p().error(ServerSession::assertNotificationCapability$lambda$19);
                throw new IllegalStateException("Server does not support logging (required for " + method.getValue() + ')');
            }
        } else if (method2 == Method.Defined.NotificationsResourcesUpdated || method2 == Method.Defined.NotificationsResourcesListChanged) {
            if (this.serverCapabilities.getResources() == null) {
                throw new IllegalStateException("Server does not support notifying about resources (required for " + method.getValue() + ')');
            }
        } else if (method2 == Method.Defined.NotificationsToolsListChanged) {
            if (this.serverCapabilities.getTools() == null) {
                throw new IllegalStateException("Server does not support notifying of tool list changes (required for " + method.getValue() + ')');
            }
        } else if (method2 == Method.Defined.NotificationsPromptsListChanged) {
            if (this.serverCapabilities.getPrompts() == null) {
                throw new IllegalStateException("Server does not support notifying of prompt list changes (required for " + method.getValue() + ')');
            }
        } else if (method2 == Method.Defined.NotificationsCancelled || method2 == Method.Defined.NotificationsProgress) {
            // empty if block
        }
    }

    @Override
    public void assertRequestHandlerCapability(@NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        ServerSessionKt.access$getLogger$p().trace(() -> ServerSession.assertRequestHandlerCapability$lambda$20(method));
        Method method2 = method;
        if (method2 == Method.Defined.SamplingCreateMessage) {
            if (this.serverCapabilities.getSampling() == null) {
                ServerSessionKt.access$getLogger$p().error(ServerSession::assertRequestHandlerCapability$lambda$21);
                throw new IllegalStateException("Server does not support sampling (required for " + method + ')');
            }
        } else if (method2 == Method.Defined.LoggingSetLevel) {
            if (this.serverCapabilities.getLogging() == null) {
                throw new IllegalStateException("Server does not support logging (required for " + method + ')');
            }
        } else if (method2 == Method.Defined.PromptsGet || method2 == Method.Defined.PromptsList) {
            if (this.serverCapabilities.getPrompts() == null) {
                throw new IllegalStateException("Server does not support prompts (required for " + method + ')');
            }
        } else if (method2 == Method.Defined.ResourcesList || method2 == Method.Defined.ResourcesTemplatesList || method2 == Method.Defined.ResourcesRead || method2 == Method.Defined.ResourcesSubscribe || method2 == Method.Defined.ResourcesUnsubscribe) {
            if (this.serverCapabilities.getResources() == null) {
                throw new IllegalStateException("Server does not support resources (required for " + method + ')');
            }
        } else if (method2 == Method.Defined.ToolsCall || method2 == Method.Defined.ToolsList) {
            if (this.serverCapabilities.getTools() == null) {
                throw new IllegalStateException("Server does not support tools (required for " + method + ')');
            }
        } else if (method2 == Method.Defined.Ping || method2 == Method.Defined.Initialize) {
            // empty if block
        }
    }

    private final Object handleInitialize(InitializeRequest request2, Continuation<? super InitializeResult> $completion) {
        String string;
        ServerSessionKt.access$getLogger$p().debug(ServerSession::handleInitialize$lambda$22);
        this.clientCapabilities = request2.getCapabilities();
        this.clientVersion = request2.getClientInfo();
        String requestedVersion = request2.getProtocolVersion();
        if (ArraysKt.contains((Object[])TypesKt.getSUPPORTED_PROTOCOL_VERSIONS(), (Object)requestedVersion)) {
            string = requestedVersion;
        } else {
            ServerSessionKt.access$getLogger$p().warn(() -> ServerSession.handleInitialize$lambda$23(requestedVersion));
            string = "2025-03-26";
        }
        String protocolVersion = string;
        return new InitializeResult(protocolVersion, this.serverCapabilities, this.serverInfo, this.instructions, null, 16, null);
    }

    private static final Unit _onInitialized$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit _onClose$lambda$1() {
        return Unit.INSTANCE;
    }

    private static final Deferred _init_$lambda$2(ServerSession this$0, InitializedNotification it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0._onInitialized.invoke();
        return (Deferred)CompletableDeferredKt.CompletableDeferred((Object)Unit.INSTANCE);
    }

    private static final Object onClose$lambda$5() {
        return "Server connection closing";
    }

    private static final Object sendResourceListChanged$lambda$11() {
        return "Sending resource list changed notification";
    }

    private static final Object sendToolListChanged$lambda$12() {
        return "Sending tool list changed notification";
    }

    private static final Object assertCapabilityForMethod$lambda$14(Method $method) {
        return "Asserting capability for method: " + $method.getValue();
    }

    private static final Object assertCapabilityForMethod$lambda$15() {
        return "Client capability assertion failed: sampling not supported";
    }

    private static final Object assertCapabilityForMethod$lambda$16() {
        return "Client capability assertion failed: listing roots not supported";
    }

    private static final Object assertCapabilityForMethod$lambda$17() {
        return "Client capability assertion failed: elicitation not supported";
    }

    private static final Object assertNotificationCapability$lambda$18(Method $method) {
        return "Asserting notification capability for method: " + $method.getValue();
    }

    private static final Object assertNotificationCapability$lambda$19() {
        return "Server capability assertion failed: logging not supported";
    }

    private static final Object assertRequestHandlerCapability$lambda$20(Method $method) {
        return "Asserting request handler capability for method: " + $method.getValue();
    }

    private static final Object assertRequestHandlerCapability$lambda$21() {
        return "Server capability assertion failed: sampling not supported";
    }

    private static final Object handleInitialize$lambda$22() {
        return "Handling initialization request from client";
    }

    private static final Object handleInitialize$lambda$23(String $requestedVersion) {
        return "Client requested unsupported protocol version " + $requestedVersion + ", falling back to 2025-03-26";
    }
}

