/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.websocket;

import io.ktor.http.HeaderValue;
import io.ktor.http.HttpHeaderValueParserKt;
import io.ktor.http.HttpHeaders;
import io.ktor.server.routing.RouteSelector;
import io.ktor.server.routing.RouteSelectorEvaluation;
import io.ktor.server.routing.RoutingResolveContext;
import io.ktor.server.websocket.WebSocketsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nRouting.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Routing.kt\nio/ktor/server/websocket/WebSocketProtocolsSelector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,253:1\n1563#2:254\n1634#2,3:255\n*S KotlinDebug\n*F\n+ 1 Routing.kt\nio/ktor/server/websocket/WebSocketProtocolsSelector\n*L\n242#1:254\n242#1:255,3\n*E\n"})
final class WebSocketProtocolsSelector
extends RouteSelector {
    @NotNull
    private final String requiredProtocol;

    public WebSocketProtocolsSelector(@NotNull String requiredProtocol) {
        Intrinsics.checkNotNullParameter((Object)requiredProtocol, (String)"requiredProtocol");
        this.requiredProtocol = requiredProtocol;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object evaluate(@NotNull RoutingResolveContext context2, int segmentIndex, @NotNull Continuation<? super RouteSelectorEvaluation> $completion) {
        void $this$mapTo$iv$iv;
        String protocols = context2.getCall().getRequest().getHeaders().get(HttpHeaders.INSTANCE.getSecWebSocketProtocol());
        if (protocols == null) {
            WebSocketsKt.getLOGGER().trace("Skipping WebSocket plugin because no Sec-WebSocket-Protocol header provided.");
            return RouteSelectorEvaluation.Companion.getFailedParameter();
        }
        Iterable $this$map$iv = HttpHeaderValueParserKt.parseHeaderValue((String)protocols);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HeaderValue headerValue = (HeaderValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getValue());
        }
        if (((List)destination$iv$iv).contains(this.requiredProtocol)) {
            return RouteSelectorEvaluation.Companion.getConstant();
        }
        WebSocketsKt.getLOGGER().trace("Skipping WebSocket plugin because no Sec-WebSocket-Protocol header " + protocols + " is not matching " + this.requiredProtocol + '.');
        return RouteSelectorEvaluation.Companion.getFailedParameter();
    }
}

