/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.websocket;

import io.ktor.server.application.ApplicationCall;
import io.ktor.server.websocket.WebSocketServerSession;
import io.ktor.websocket.Frame;
import io.ktor.websocket.WebSocketExtension;
import io.ktor.websocket.WebSocketSession;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DelegatedWebSocketServerSession
implements WebSocketServerSession,
WebSocketSession {
    @NotNull
    private final ApplicationCall call;
    @NotNull
    private final WebSocketSession delegate;

    public DelegatedWebSocketServerSession(@NotNull ApplicationCall call2, @NotNull WebSocketSession delegate) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.call = call2;
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public ApplicationCall getCall() {
        return this.call;
    }

    @Nullable
    public Object send(@NotNull Frame frame, @NotNull Continuation<? super Unit> $completion) {
        return this.delegate.send(frame, $completion);
    }

    @Nullable
    public Object flush(@NotNull Continuation<? super Unit> $completion) {
        return this.delegate.flush($completion);
    }

    @Deprecated(message="Use cancel() instead.", replaceWith=@ReplaceWith(expression="cancel()", imports={"kotlinx.coroutines.cancel"}), level=DeprecationLevel.ERROR)
    public void terminate() {
        this.delegate.terminate();
    }

    public boolean getMasking() {
        return this.delegate.getMasking();
    }

    public void setMasking(boolean bl) {
        this.delegate.setMasking(bl);
    }

    public long getMaxFrameSize() {
        return this.delegate.getMaxFrameSize();
    }

    public void setMaxFrameSize(long l) {
        this.delegate.setMaxFrameSize(l);
    }

    @NotNull
    public ReceiveChannel<Frame> getIncoming() {
        return this.delegate.getIncoming();
    }

    @NotNull
    public SendChannel<Frame> getOutgoing() {
        return this.delegate.getOutgoing();
    }

    @NotNull
    public List<WebSocketExtension<?>> getExtensions() {
        return this.delegate.getExtensions();
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.delegate.getCoroutineContext();
    }
}

