/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.http.HttpStatusCode;
import io.ktor.server.response.ApplicationResponse;
import io.ktor.server.response.PipelineResponse;
import io.ktor.server.response.ResponseCookies;
import io.ktor.server.response.ResponseHeaders;
import io.ktor.server.routing.RoutingCall;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RoutingResponse
implements ApplicationResponse {
    @NotNull
    private final RoutingCall call;
    @NotNull
    private final PipelineResponse applicationResponse;
    @NotNull
    private final ResponseHeaders headers;
    @NotNull
    private final ResponseCookies cookies;

    public RoutingResponse(@NotNull RoutingCall call2, @NotNull PipelineResponse applicationResponse) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Intrinsics.checkNotNullParameter((Object)applicationResponse, (String)"applicationResponse");
        this.call = call2;
        this.applicationResponse = applicationResponse;
        this.headers = this.applicationResponse.getHeaders();
        this.cookies = this.applicationResponse.getCookies();
    }

    @Override
    @NotNull
    public RoutingCall getCall() {
        return this.call;
    }

    @Override
    public boolean isCommitted() {
        return this.applicationResponse.isCommitted();
    }

    @Override
    @NotNull
    public ResponseHeaders getHeaders() {
        return this.headers;
    }

    @Override
    @NotNull
    public ResponseCookies getCookies() {
        return this.cookies;
    }

    @Override
    @Nullable
    public HttpStatusCode status() {
        return this.applicationResponse.status();
    }

    @Override
    public void status(@NotNull HttpStatusCode value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.applicationResponse.status(value2);
    }
}

