/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.http.HttpStatusCode;
import io.ktor.http.Parameters;
import io.ktor.server.routing.RoutingNode;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public abstract class RoutingResolveResult {
    @NotNull
    private final RoutingNode route;

    private RoutingResolveResult(RoutingNode route) {
        this.route = route;
    }

    @NotNull
    public final RoutingNode getRoute() {
        return this.route;
    }

    public /* synthetic */ RoutingResolveResult(RoutingNode route, DefaultConstructorMarker $constructor_marker) {
        this(route);
    }

    public static final class Failure
    extends RoutingResolveResult {
        @NotNull
        private final String reason;
        @NotNull
        private final HttpStatusCode errorStatusCode;

        public Failure(@NotNull RoutingNode route, @NotNull String reason, @NotNull HttpStatusCode errorStatusCode) {
            Intrinsics.checkNotNullParameter((Object)route, (String)"route");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)errorStatusCode, (String)"errorStatusCode");
            super(route, null);
            this.reason = reason;
            this.errorStatusCode = errorStatusCode;
        }

        @NotNull
        public final HttpStatusCode getErrorStatusCode() {
            return this.errorStatusCode;
        }

        @NotNull
        public String toString() {
            return "FAILURE \"" + this.reason + "\" @ " + this.getRoute();
        }
    }

    public static final class Success
    extends RoutingResolveResult {
        @NotNull
        private final Parameters parameters;
        private final double quality;

        public Success(@NotNull RoutingNode route, @NotNull Parameters parameters, double quality) {
            Intrinsics.checkNotNullParameter((Object)route, (String)"route");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            super(route, null);
            this.parameters = parameters;
            this.quality = quality;
        }

        @NotNull
        public Parameters getParameters() {
            return this.parameters;
        }

        public final double getQuality$ktor_server_core() {
            return this.quality;
        }

        @NotNull
        public String toString() {
            return "SUCCESS" + (this.getParameters().isEmpty() ? "" : "; " + this.getParameters()) + " @ " + this.getRoute();
        }
    }
}

