/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.http.Parameters;
import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.routing.RoutingNode;
import io.ktor.server.routing.RoutingPipelineCall;
import io.ktor.server.routing.RoutingPipelineResponse;
import io.ktor.server.routing.RoutingRequest;
import io.ktor.server.routing.RoutingResponse;
import io.ktor.util.Attributes;
import io.ktor.util.reflect.TypeInfo;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RoutingCall
implements ApplicationCall {
    @NotNull
    private final RoutingPipelineCall pipelineCall;
    @NotNull
    private final Lazy request$delegate;
    @NotNull
    private final Lazy response$delegate;
    @NotNull
    private final Attributes attributes;
    @NotNull
    private final Application application;
    @NotNull
    private final Parameters parameters;
    @NotNull
    private final Parameters pathParameters;
    @NotNull
    private final Parameters queryParameters;
    @NotNull
    private final RoutingNode route;

    public RoutingCall(@NotNull RoutingPipelineCall pipelineCall) {
        Intrinsics.checkNotNullParameter((Object)pipelineCall, (String)"pipelineCall");
        this.pipelineCall = pipelineCall;
        this.request$delegate = LazyKt.lazy(() -> RoutingCall.request_delegate$lambda$0(this));
        this.response$delegate = LazyKt.lazy(() -> RoutingCall.response_delegate$lambda$1(this));
        this.attributes = this.pipelineCall.getAttributes();
        this.application = this.pipelineCall.getApplication();
        this.parameters = this.pipelineCall.getParameters();
        this.pathParameters = this.pipelineCall.getPathParameters();
        this.queryParameters = this.pipelineCall.getEngineCall().getParameters();
        this.route = this.pipelineCall.getRoute();
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.pipelineCall.getCoroutineContext();
    }

    @Override
    @NotNull
    public RoutingRequest getRequest() {
        Lazy lazy = this.request$delegate;
        return (RoutingRequest)lazy.getValue();
    }

    @Override
    @NotNull
    public RoutingResponse getResponse() {
        Lazy lazy = this.response$delegate;
        return (RoutingResponse)lazy.getValue();
    }

    @Override
    @NotNull
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    @NotNull
    public Application getApplication() {
        return this.application;
    }

    @Override
    @NotNull
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    @Nullable
    public <T> Object receiveNullable(@NotNull TypeInfo typeInfo, @NotNull Continuation<? super T> $completion) {
        return this.pipelineCall.receiveNullable(typeInfo, $completion);
    }

    @Override
    @Nullable
    public Object respond(@Nullable Object message2, @Nullable TypeInfo typeInfo, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.pipelineCall.respond(message2, typeInfo, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final RoutingRequest request_delegate$lambda$0(RoutingCall this$0) {
        return new RoutingRequest(this$0.pipelineCall.getPathParameters(), this$0.pipelineCall.getRequest(), this$0);
    }

    private static final RoutingResponse response_delegate$lambda$1(RoutingCall this$0) {
        RoutingPipelineResponse routingPipelineResponse = this$0.pipelineCall.getResponse();
        return new RoutingResponse(this$0, routingPipelineResponse);
    }
}

