/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.http.Parameters;
import io.ktor.http.ParametersKt;
import io.ktor.server.routing.RouteSelector;
import io.ktor.server.routing.RouteSelectorEvaluation;
import io.ktor.server.routing.RoutingResolveContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nRouteSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RouteSelector.kt\nio/ktor/server/routing/PathSegmentTailcardRouteSelector\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,782:1\n1855#2,2:783\n1#3:785\n1573#4:786\n1604#4,4:787\n*S KotlinDebug\n*F\n+ 1 RouteSelector.kt\nio/ktor/server/routing/PathSegmentTailcardRouteSelector\n*L\n500#1:783,2\n516#1:786\n516#1:787,4\n*E\n"})
public final class PathSegmentTailcardRouteSelector
extends RouteSelector {
    @NotNull
    private final String name;
    @NotNull
    private final String prefix;

    public PathSegmentTailcardRouteSelector(@NotNull String name2, @NotNull String prefix) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            this.name = name2;
            this.prefix = prefix;
            CharSequence $this$none$iv = this.prefix;
            boolean $i$f$none = false;
            for (int j = 0; j < $this$none$iv.length(); ++j) {
                char element$iv;
                char it = element$iv = $this$none$iv.charAt(j);
                boolean bl2 = false;
                if (!(it == '/')) continue;
                bl = false;
                break block2;
            }
            bl = true;
        }
        if (!bl) {
            boolean bl3 = false;
            String string = "Multisegment prefix is not supported";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ PathSegmentTailcardRouteSelector(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        this(string, string2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object evaluate(@NotNull RoutingResolveContext context2, int segmentIndex, @NotNull Continuation<? super RouteSelectorEvaluation> $completion) {
        Parameters parameters;
        String segmentText;
        List<String> segments = context2.getSegments();
        if (((CharSequence)this.prefix).length() > 0 && ((segmentText = (String)CollectionsKt.getOrNull(segments, (int)segmentIndex)) == null || !StringsKt.startsWith$default((String)segmentText, (String)this.prefix, (boolean)false, (int)2, null))) {
            return RouteSelectorEvaluation.Companion.getFailedPath();
        }
        if (((CharSequence)this.name).length() == 0) {
            parameters = ParametersKt.parametersOf();
        } else {
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            Iterable iterable = CollectionsKt.drop((Iterable)segments, (int)segmentIndex);
            String string = this.name;
            boolean $i$f$mapIndexed = false;
            void var8_10 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void segment;
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string2 = (String)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(index == false ? StringsKt.drop((String)segment, (int)this.prefix.length()) : segment);
            }
            parameters = ParametersKt.parametersOf((String)string, (List)((List)destination$iv$iv));
        }
        Parameters values = parameters;
        double quality = segmentIndex < segments.size() ? 0.1 : 0.2;
        return new RouteSelectorEvaluation.Success(quality, values, segments.size() - segmentIndex);
    }

    @NotNull
    public String toString() {
        return "{...}";
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + this.prefix.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PathSegmentTailcardRouteSelector)) {
            return false;
        }
        PathSegmentTailcardRouteSelector pathSegmentTailcardRouteSelector = (PathSegmentTailcardRouteSelector)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)pathSegmentTailcardRouteSelector.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.prefix, (Object)pathSegmentTailcardRouteSelector.prefix);
    }

    public PathSegmentTailcardRouteSelector() {
        this(null, null, 3, null);
    }
}

