/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.http.HttpMethod;
import io.ktor.server.request.ApplicationRequestPropertiesKt;
import io.ktor.server.routing.RouteSelector;
import io.ktor.server.routing.RouteSelectorEvaluation;
import io.ktor.server.routing.RoutingResolveContext;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpMethodRouteSelector
extends RouteSelector {
    @NotNull
    private final HttpMethod method;

    public HttpMethodRouteSelector(@NotNull HttpMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        this.method = method;
    }

    @Override
    @Nullable
    public Object evaluate(@NotNull RoutingResolveContext context2, int segmentIndex, @NotNull Continuation<? super RouteSelectorEvaluation> $completion) {
        if (Intrinsics.areEqual((Object)ApplicationRequestPropertiesKt.getHttpMethod(context2.getCall().getRequest()), (Object)this.method)) {
            return RouteSelectorEvaluation.Companion.getConstant();
        }
        return RouteSelectorEvaluation.Companion.getFailedMethod();
    }

    @NotNull
    public String toString() {
        return "(method:" + this.method.getValue() + ')';
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpMethodRouteSelector)) {
            return false;
        }
        HttpMethodRouteSelector httpMethodRouteSelector = (HttpMethodRouteSelector)other;
        return Intrinsics.areEqual((Object)this.method, (Object)httpMethodRouteSelector.method);
    }
}

