/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.request;

import io.ktor.http.CookieEncoding;
import io.ktor.http.CookieKt;
import io.ktor.server.request.ApplicationRequest;
import io.ktor.util.collections.ConcurrentMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public class RequestCookies {
    @NotNull
    private final ApplicationRequest request;
    @NotNull
    private final ConcurrentMap<Pair<CookieEncoding, String>, String> map;
    @NotNull
    private final Lazy rawCookies$delegate;

    public RequestCookies(@NotNull ApplicationRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        this.request = request2;
        this.map = new ConcurrentMap(0, 1, null);
        this.rawCookies$delegate = LazyKt.lazy(() -> RequestCookies.rawCookies_delegate$lambda$0(this));
    }

    @NotNull
    protected Map<String, String> fetchCookies() {
        List list2 = this.request.getHeaders().getAll("Cookie");
        if (list2 == null) {
            return MapsKt.emptyMap();
        }
        List cookieHeaders = list2;
        HashMap map2 = new HashMap(cookieHeaders.size());
        for (String cookieHeader : cookieHeaders) {
            Map cookies = CookieKt.parseClientCookiesHeader$default((String)cookieHeader, (boolean)false, (int)2, null);
            map2.putAll(cookies);
        }
        return map2;
    }

    private static final Map rawCookies_delegate$lambda$0(RequestCookies this$0) {
        return this$0.fetchCookies();
    }
}

