/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.http.content;

import io.ktor.http.ContentType;
import io.ktor.http.FileContentTypeJvmKt;
import io.ktor.http.content.OutgoingContent;
import io.ktor.http.content.VersionsKt;
import io.ktor.server.http.content.LastModifiedJavaTimeKt;
import io.ktor.util.cio.FileChannelsKt;
import io.ktor.utils.io.ByteReadChannel;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;

public final class LocalFileContent
extends OutgoingContent.ReadChannelContent {
    @NotNull
    private final File file;
    @NotNull
    private final ContentType contentType;

    public LocalFileContent(@NotNull File file, @NotNull ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.file = file;
        this.contentType = contentType;
        if (!this.file.exists()) {
            throw new IOException("No such file " + this.file.getAbsolutePath());
        }
        long lastModifiedVersion = this.file.lastModified();
        VersionsKt.setVersions((OutgoingContent)((OutgoingContent)this), (List)CollectionsKt.plus((Collection)VersionsKt.getVersions((OutgoingContent)((OutgoingContent)this)), (Object)LastModifiedJavaTimeKt.LastModifiedVersion(lastModifiedVersion)));
    }

    public /* synthetic */ LocalFileContent(File file, ContentType contentType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            contentType = FileContentTypeJvmKt.defaultForFile((ContentType.Companion)ContentType.Companion, (File)file);
        }
        this(file, contentType);
    }

    @NotNull
    public ContentType getContentType() {
        return this.contentType;
    }

    @NotNull
    public Long getContentLength() {
        return this.file.length();
    }

    @NotNull
    public ByteReadChannel readFrom() {
        return FileChannelsKt.readChannel$default((File)this.file, (long)0L, (long)0L, null, (int)7, null);
    }

    @NotNull
    public ByteReadChannel readFrom(@NotNull LongRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return FileChannelsKt.readChannel$default((File)this.file, (long)range.getFirst(), (long)range.getLast(), null, (int)4, null);
    }
}

