/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.application;

import kotlin.coroutines.Continuation;
import kotlin.coroutines.ContinuationInterceptor;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ClassLoaderAwareContinuationInterceptor
implements ContinuationInterceptor {
    @NotNull
    public static final ClassLoaderAwareContinuationInterceptor INSTANCE = new ClassLoaderAwareContinuationInterceptor();
    @NotNull
    private static final CoroutineContext.Key<?> key = (CoroutineContext.Key)ContinuationInterceptor.Key;

    private ClassLoaderAwareContinuationInterceptor() {
    }

    @NotNull
    public CoroutineContext.Key<?> getKey() {
        return key;
    }

    @NotNull
    public <T> Continuation<T> interceptContinuation(@NotNull Continuation<? super T> continuation) {
        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return new Continuation<T>(continuation, classLoader){
            private final CoroutineContext context;
            final /* synthetic */ Continuation<T> $continuation;
            final /* synthetic */ ClassLoader $classLoader;
            {
                this.$continuation = $continuation;
                this.$classLoader = $classLoader;
                this.context = $continuation.getContext();
            }

            public CoroutineContext getContext() {
                return this.context;
            }

            public void resumeWith(Object result2) {
                Thread.currentThread().setContextClassLoader(this.$classLoader);
                this.$continuation.resumeWith(result2);
            }
        };
    }

    public void releaseInterceptedContinuation(@NotNull Continuation<?> continuation) {
        ContinuationInterceptor.DefaultImpls.releaseInterceptedContinuation((ContinuationInterceptor)this, continuation);
    }

    @Nullable
    public <E extends CoroutineContext.Element> E get(@NotNull CoroutineContext.Key<E> key) {
        return (E)ContinuationInterceptor.DefaultImpls.get((ContinuationInterceptor)this, key);
    }

    @NotNull
    public CoroutineContext minusKey(@NotNull CoroutineContext.Key<?> key) {
        return ContinuationInterceptor.DefaultImpls.minusKey((ContinuationInterceptor)this, key);
    }

    public <R> R fold(R initial, @NotNull Function2<? super R, ? super CoroutineContext.Element, ? extends R> operation) {
        return (R)ContinuationInterceptor.DefaultImpls.fold((ContinuationInterceptor)this, initial, operation);
    }

    @NotNull
    public CoroutineContext plus(@NotNull CoroutineContext context2) {
        return ContinuationInterceptor.DefaultImpls.plus((ContinuationInterceptor)this, (CoroutineContext)context2);
    }
}

