/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.plugins.contentnegotiation;

import io.ktor.client.plugins.contentnegotiation.ContentNegotiationKt;
import io.ktor.client.plugins.contentnegotiation.DefaultIgnoredTypesJvmKt;
import io.ktor.client.plugins.contentnegotiation.JsonContentTypeMatcher;
import io.ktor.http.ContentType;
import io.ktor.http.ContentTypeMatcher;
import io.ktor.serialization.Configuration;
import io.ktor.serialization.ContentConverter;
import io.ktor.utils.io.KtorDsl;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KtorDsl
public final class ContentNegotiationConfig
implements Configuration {
    @NotNull
    private final Set<KClass<?>> ignoredTypes = CollectionsKt.toMutableSet((Iterable)SetsKt.plus(DefaultIgnoredTypesJvmKt.getDefaultIgnoredTypes(), (Iterable)ContentNegotiationKt.getDefaultCommonIgnoredTypes()));
    @NotNull
    private final List<ConverterRegistration> registrations = new ArrayList();
    @Nullable
    private Double defaultAcceptHeaderQValue;

    @NotNull
    public final Set<KClass<?>> getIgnoredTypes$ktor_client_content_negotiation() {
        return this.ignoredTypes;
    }

    @NotNull
    public final List<ConverterRegistration> getRegistrations$ktor_client_content_negotiation() {
        return this.registrations;
    }

    @Nullable
    public final Double getDefaultAcceptHeaderQValue() {
        return this.defaultAcceptHeaderQValue;
    }

    public <T extends ContentConverter> void register(@NotNull ContentType contentType, @NotNull T converter, @NotNull Function1<? super T, Unit> configuration) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        ContentTypeMatcher matcher = contentType.match(ContentType.Application.INSTANCE.getJson()) ? (ContentTypeMatcher)JsonContentTypeMatcher.INSTANCE : this.defaultMatcher(contentType);
        this.register(contentType, converter, matcher, configuration);
    }

    public final <T extends ContentConverter> void register(@NotNull ContentType contentTypeToSend, @NotNull T converter, @NotNull ContentTypeMatcher contentTypeMatcher, @NotNull Function1<? super T, Unit> configuration) {
        Intrinsics.checkNotNullParameter((Object)contentTypeToSend, (String)"contentTypeToSend");
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        Intrinsics.checkNotNullParameter((Object)contentTypeMatcher, (String)"contentTypeMatcher");
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        T t2 = converter;
        configuration.invoke(t2);
        ConverterRegistration registration = new ConverterRegistration(t2, contentTypeToSend, contentTypeMatcher);
        this.registrations.add(registration);
    }

    private final ContentTypeMatcher defaultMatcher(ContentType pattern) {
        return new ContentTypeMatcher(pattern){
            final /* synthetic */ ContentType $pattern;
            {
                this.$pattern = $pattern;
            }

            public boolean contains(ContentType contentType) {
                Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
                return contentType.match(this.$pattern);
            }
        };
    }

    public static final class ConverterRegistration {
        @NotNull
        private final ContentConverter converter;
        @NotNull
        private final ContentType contentTypeToSend;
        @NotNull
        private final ContentTypeMatcher contentTypeMatcher;

        public ConverterRegistration(@NotNull ContentConverter converter, @NotNull ContentType contentTypeToSend, @NotNull ContentTypeMatcher contentTypeMatcher) {
            Intrinsics.checkNotNullParameter((Object)converter, (String)"converter");
            Intrinsics.checkNotNullParameter((Object)contentTypeToSend, (String)"contentTypeToSend");
            Intrinsics.checkNotNullParameter((Object)contentTypeMatcher, (String)"contentTypeMatcher");
            this.converter = converter;
            this.contentTypeToSend = contentTypeToSend;
            this.contentTypeMatcher = contentTypeMatcher;
        }

        @NotNull
        public final ContentConverter getConverter() {
            return this.converter;
        }

        @NotNull
        public final ContentType getContentTypeToSend() {
            return this.contentTypeToSend;
        }

        @NotNull
        public final ContentTypeMatcher getContentTypeMatcher() {
            return this.contentTypeMatcher;
        }
    }
}

