/*
 * Decompiled with CFR 0.152.
 */
package fleet.kernel.rebase;

import com.jetbrains.rhizomedb.APIKt;
import com.jetbrains.rhizomedb.DBUtilKt;
import com.jetbrains.rhizomedb.DbContext;
import com.jetbrains.rhizomedb.Q;
import com.jetbrains.rhizomedb.Remove;
import fleet.kernel.DurableDbValue;
import fleet.kernel.rebase.CRUDInstructionsCodingKt;
import fleet.kernel.rebase.DbSerializationKt;
import fleet.kernel.rebase.InstructionCoder;
import fleet.kernel.rebase.InstructionCodingKt;
import fleet.kernel.rebase.InstructionDecodingContext;
import fleet.kernel.rebase.InstructionEncodingContext;
import fleet.kernel.rebase.SharedInstruction;
import fleet.kernel.rebase.SharedInstructionData;
import fleet.kernel.rebase.SharedRemove;
import fleet.util.UID;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.serialization.KSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoveCoder
implements InstructionCoder<Remove<?>, SharedRemove> {
    @NotNull
    public static final RemoveCoder INSTANCE = new RemoveCoder();
    @NotNull
    private static final KClass<Remove<?>> instructionClass = Reflection.getOrCreateKotlinClass(Remove.class);
    @NotNull
    private static final KSerializer<SharedRemove> serializer = SharedRemove.Companion.serializer();

    private RemoveCoder() {
    }

    @Override
    @NotNull
    public KClass<Remove<?>> getInstructionClass() {
        return instructionClass;
    }

    @Override
    @NotNull
    public KSerializer<SharedRemove> getSerializer() {
        return serializer;
    }

    @Override
    @NotNull
    public String getInstructionName() {
        return "Remove";
    }

    @Override
    @Nullable
    public SharedInstructionData encode(@NotNull DbContext<? extends Q> $this$encode, @NotNull InstructionEncodingContext serContext, @NotNull Remove<?> instruction) {
        Intrinsics.checkNotNullParameter($this$encode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)serContext, (String)"serContext");
        Intrinsics.checkNotNullParameter(instruction, (String)"instruction");
        return switch (APIKt.partition(instruction.getEid())) {
            case 0, 2 -> {
                SharedInstruction v2;
                UID v0 = DbSerializationKt.sharedId-bBVBO88($this$encode, instruction.getEid(), serContext.getUidAttribute-dkwPBow());
                if (v0 != null) {
                    UID uid = v0;
                    boolean $i$a$-let-RemoveCoder$encode$1 = false;
                    String v1 = DBUtilKt.attributeIdent-4iVtCWM($this$encode, instruction.getAttribute-dkwPBow());
                    Intrinsics.checkNotNull((Object)v1);
                    String attribute = v1;
                    DurableDbValue value = DbSerializationKt.encodeDbValue-jA1riHs($this$encode, serContext.getUidAttribute-dkwPBow(), instruction.getAttribute-dkwPBow(), instruction.getValue());
                    v2 = InstructionCodingKt.sharedInstruction(INSTANCE, new SharedRemove(uid, attribute, value, instruction.getSeed()));
                } else {
                    v2 = null;
                }
                SharedInstruction var8_8 = v2;
                yield new SharedInstructionData(var8_8);
            }
            default -> null;
        };
    }

    @Override
    @NotNull
    public List<Remove<?>> decode(@NotNull DbContext<? extends Q> $this$decode, @NotNull InstructionDecodingContext deserContext, @NotNull SharedRemove sharedInstruction) {
        Intrinsics.checkNotNullParameter($this$decode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)deserContext, (String)"deserContext");
        Intrinsics.checkNotNullParameter((Object)sharedInstruction, (String)"sharedInstruction");
        int eid2 = DBUtilKt.lookupSingle-FAQklpU($this$decode, deserContext.getUidAttribute-dkwPBow(), sharedInstruction.getEntityId());
        int attribute = DBUtilKt.requireAttributeByIdent($this$decode, sharedInstruction.getAttribute());
        return CollectionsKt.listOf(new Remove(eid2, attribute, CRUDInstructionsCodingKt.access$deserializeValue-qeTL424($this$decode, sharedInstruction.getValue(), deserContext, attribute), sharedInstruction.getSeed(), null));
    }
}

