/*
 * Decompiled with CFR 0.152.
 */
package fleet.kernel;

import com.jetbrains.rhizomedb.Attribute;
import com.jetbrains.rhizomedb.CreateEntity;
import fleet.util.UID;
import java.util.List;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocalSnaphost {
    @NotNull
    private final List<SnapshotEntity> entities;
    @NotNull
    private final List<CreateEntity> unknownAttributes;
    @NotNull
    private final List<CreateEntity> unknownEntityTypes;

    public LocalSnaphost(@NotNull List<SnapshotEntity> entities, @NotNull List<CreateEntity> unknownAttributes, @NotNull List<CreateEntity> unknownEntityTypes) {
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        Intrinsics.checkNotNullParameter(unknownAttributes, (String)"unknownAttributes");
        Intrinsics.checkNotNullParameter(unknownEntityTypes, (String)"unknownEntityTypes");
        this.entities = entities;
        this.unknownAttributes = unknownAttributes;
        this.unknownEntityTypes = unknownEntityTypes;
    }

    @NotNull
    public final List<SnapshotEntity> getEntities() {
        return this.entities;
    }

    @NotNull
    public final List<CreateEntity> getUnknownAttributes() {
        return this.unknownAttributes;
    }

    @NotNull
    public final List<CreateEntity> getUnknownEntityTypes() {
        return this.unknownEntityTypes;
    }

    @NotNull
    public String toString() {
        return "LocalSnaphost(entities=" + this.entities + ", unknownAttributes=" + this.unknownAttributes + ", unknownEntityTypes=" + this.unknownEntityTypes + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.entities).hashCode();
        result2 = result2 * 31 + ((Object)this.unknownAttributes).hashCode();
        result2 = result2 * 31 + ((Object)this.unknownEntityTypes).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LocalSnaphost)) {
            return false;
        }
        LocalSnaphost localSnaphost = (LocalSnaphost)other;
        if (!Intrinsics.areEqual(this.entities, localSnaphost.entities)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.unknownAttributes, localSnaphost.unknownAttributes)) {
            return false;
        }
        return Intrinsics.areEqual(this.unknownEntityTypes, localSnaphost.unknownEntityTypes);
    }

    public static final class SnapshotEntity {
        private final int entityTypeEid;
        private final int eid;
        @NotNull
        private final UID uid;
        @NotNull
        private final List<Triple<Attribute<Object>, Object, Long>> attrs;

        public SnapshotEntity(int entityTypeEid, int eid2, @NotNull UID uid2, @NotNull List<? extends Triple<Attribute<Object>, ? extends Object, Long>> attrs) {
            Intrinsics.checkNotNullParameter((Object)uid2, (String)"uid");
            Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
            this.entityTypeEid = entityTypeEid;
            this.eid = eid2;
            this.uid = uid2;
            this.attrs = attrs;
        }

        public final int getEntityTypeEid() {
            return this.entityTypeEid;
        }

        public final int getEid() {
            return this.eid;
        }

        @NotNull
        public final UID getUid() {
            return this.uid;
        }

        @NotNull
        public final List<Triple<Attribute<Object>, Object, Long>> getAttrs() {
            return this.attrs;
        }

        @NotNull
        public String toString() {
            return "SnapshotEntity(entityTypeEid=" + this.entityTypeEid + ", eid=" + this.eid + ", uid=" + this.uid + ", attrs=" + this.attrs + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.entityTypeEid);
            result2 = result2 * 31 + Integer.hashCode(this.eid);
            result2 = result2 * 31 + this.uid.hashCode();
            result2 = result2 * 31 + ((Object)this.attrs).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SnapshotEntity)) {
                return false;
            }
            SnapshotEntity snapshotEntity = (SnapshotEntity)other;
            if (this.entityTypeEid != snapshotEntity.entityTypeEid) {
                return false;
            }
            if (this.eid != snapshotEntity.eid) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.uid, (Object)snapshotEntity.uid)) {
                return false;
            }
            return Intrinsics.areEqual(this.attrs, snapshotEntity.attrs);
        }
    }
}

