/*
 * Decompiled with CFR 0.152.
 */
package fleet.fastutil.longs;

import fleet.fastutil.longs.LongArrays;
import fleet.fastutil.longs.LongList;
import fleet.fastutil.longs.LongListExtensionsKt;
import fleet.fastutil.longs.MutableLongList;
import java.util.Arrays;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LongArrayList
implements MutableLongList,
Comparable<LongList> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long[] a;
    private int size;

    @Override
    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    private LongArrayList(long[] a, boolean wrapped) {
        this.a = a;
    }

    private final void initArrayFromCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Initial capacity (" + capacity + ") is negative");
        }
        this.a = capacity == 0 ? new long[]{} : new long[capacity];
    }

    public LongArrayList() {
        this.a = LongArrays.INSTANCE.getDEFAULT_EMPTY_ARRAY();
    }

    public LongArrayList(int capacity) {
        this.initArrayFromCapacity(capacity);
    }

    private final void grow(int capacity) {
        long[] lArray;
        int capacity2 = capacity;
        long[] lArray2 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray2 = null;
        }
        if (capacity2 <= lArray2.length) {
            return;
        }
        long[] lArray3 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray3 = null;
        }
        if (!Arrays.equals(lArray = lArray3, LongArrays.INSTANCE.getDEFAULT_EMPTY_ARRAY())) {
            long[] lArray4 = this.a;
            if (this.a == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"a");
                lArray4 = null;
            }
            int n = lArray4.length;
            long[] lArray5 = this.a;
            if (this.a == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"a");
                lArray5 = null;
            }
            int n2 = n + (lArray5.length >> 1);
            int n3 = 0x7FFFFFF7;
            capacity2 = Math.max(Math.min(n2, n3), capacity2);
        } else if (capacity2 < 10) {
            capacity2 = 10;
        }
        long[] lArray6 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray6 = null;
        }
        this.a = LongArrays.INSTANCE.forceCapacity(lArray6, capacity2, this.getSize());
        int n = this.getSize();
        long[] lArray7 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray7 = null;
        }
        if (!(n <= lArray7.length)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    public void add(long element) {
        this.grow(this.getSize() + 1);
        long[] lArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray = null;
        }
        int n = this.getSize();
        this.setSize(n + 1);
        lArray[n] = element;
        int n2 = this.getSize();
        long[] lArray2 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray2 = null;
        }
        if (!(n2 <= lArray2.length)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    @Override
    public long get(int index) {
        if (index >= this.getSize() || index < 0) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds for length " + this.getSize());
        }
        long[] lArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray = null;
        }
        return lArray[index];
    }

    public void sort() {
        long[] lArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray = null;
        }
        ArraysKt.sort((long[])lArray, (int)0, (int)this.getSize());
    }

    public boolean equals(@Nullable Object o) {
        return o == this || o instanceof LongList && this.compareTo((LongList)o) == 0;
    }

    @Override
    public int compareTo(@NotNull LongList l) {
        int i2;
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        int s1 = LongListExtensionsKt.length(this);
        int s2 = LongListExtensionsKt.length(l);
        long e1 = 0L;
        long e2 = 0L;
        int r = 0;
        for (i2 = 0; i2 < s1 && i2 < s2; ++i2) {
            e1 = this.get(i2);
            e2 = l.get(i2);
            int n = e1 > e2 ? 1 : (r = e1 < e2 ? -1 : 0);
            if (r == 0) continue;
            return r;
        }
        return i2 < s2 ? -1 : (i2 < s1 ? 1 : 0);
    }

    public int hashCode() {
        int i2 = LongListExtensionsKt.getIndices(this).getFirst();
        int h = 1;
        int s = this.getSize();
        while (s-- != 0) {
            int k = (int)this.get(i2++);
            h = 31 * h + k;
        }
        return h;
    }

    @NotNull
    public String toString() {
        StringBuilder s = new StringBuilder();
        int i2 = LongListExtensionsKt.getIndices(this).getFirst();
        int n = this.getSize();
        int k = 0;
        boolean first = true;
        s.append("[");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            k = (int)this.get(i2);
            ++i2;
            s.append(String.valueOf(k));
        }
        s.append("]");
        String string = s.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public /* synthetic */ LongArrayList(long[] a, boolean wrapped, DefaultConstructorMarker $constructor_marker) {
        this(a, wrapped);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LongArrayList wrap(@NotNull long[] a) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            return this.wrap(a, a.length);
        }

        @NotNull
        public final LongArrayList wrap(@NotNull long[] a, int length) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            if (length > a.length) {
                throw new IllegalArgumentException("The specified length (" + length + ") is greater than the array size (" + a.length + ")");
            }
            LongArrayList l = new LongArrayList(a, true, null);
            l.setSize(length);
            return l;
        }

        @NotNull
        public final LongArrayList of() {
            return new LongArrayList();
        }

        @NotNull
        public final LongArrayList of(long ... init) {
            Intrinsics.checkNotNullParameter((Object)init, (String)"init");
            return this.wrap(init);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

