/*
 * Decompiled with CFR 0.152.
 */
package fleet.fastutil.ints;

import fleet.fastutil.HashCommon;
import fleet.fastutil.ints.IntArrayList;
import fleet.fastutil.ints.IntList;
import fleet.fastutil.ints.IntListExtensionsKt;
import fleet.fastutil.ints.IntSet;
import fleet.fastutil.ints.IntSetExtensionsKt;
import fleet.fastutil.ints.MutableIntIterator;
import fleet.fastutil.ints.MutableIntSet;
import java.util.NoSuchElementException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nIntOpenHashSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntOpenHashSet.kt\nfleet/fastutil/ints/IntOpenHashSet\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,548:1\n1#2:549\n*E\n"})
public final class IntOpenHashSet
implements MutableIntSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private int[] key;
    private int mask;
    private boolean containsNull;
    private int n;
    private int maxFill;
    private final int minN;
    private int size;
    private final float f;

    public IntOpenHashSet(int expected, float f) {
        if (f <= 0.0f || f >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.minN = this.n = HashCommon.INSTANCE.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.INSTANCE.maxFill(this.n, f);
        this.key = new int[this.n + 1];
    }

    public /* synthetic */ IntOpenHashSet(int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 16;
        }
        if ((n2 & 2) != 0) {
            f = 0.75f;
        }
        this(n, f);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    @Override
    @NotNull
    public MutableIntIterator getValues() {
        return new SetIterator();
    }

    public IntOpenHashSet(@NotNull IntList c, float f) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this(c.getSize(), f);
        this.addAll(c);
    }

    public /* synthetic */ IntOpenHashSet(IntList intList, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 0.75f;
        }
        this(intList, f);
    }

    private final int realSize() {
        return this.containsNull ? this.getSize() - 1 : this.getSize();
    }

    private final void ensureCapacity(int capacity) {
        int needed = HashCommon.INSTANCE.arraySize(capacity, this.f);
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private final void tryCapacity(long capacity) {
        int needed = Math.min(0x40000000, Math.max(2, (int)HashCommon.INSTANCE.nextPowerOfTwo((long)Math.ceil((float)capacity / this.f))));
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    public final boolean addAll(@NotNull IntList elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(elements.getSize());
        } else {
            this.tryCapacity(this.getSize() + elements.getSize());
        }
        boolean modified = false;
        IntRange intRange = IntListExtensionsKt.getIndices(elements);
        int index = intRange.getFirst();
        int n = intRange.getLast();
        if (index <= n) {
            while (true) {
                if (this.add(elements.get(index))) {
                    modified = true;
                }
                if (index == n) break;
                ++index;
            }
        }
        return modified;
    }

    public boolean add(int element) {
        int pos = 0;
        if (element == 0) {
            if (this.containsNull) {
                return false;
            }
            this.containsNull = true;
        } else {
            block7: {
                int it;
                int n;
                int curr = 0;
                int[] key = this.key;
                int n2 = n = HashCommon.INSTANCE.mix(element) & this.mask;
                int[] nArray = key;
                boolean bl = false;
                pos = it;
                it = n = nArray[n];
                boolean bl2 = false;
                curr = it;
                if (n != 0) {
                    if (curr == element) {
                        return false;
                    }
                    do {
                        it = n = pos + 1 & this.mask;
                        nArray = key;
                        boolean bl3 = false;
                        pos = it;
                        it = n = nArray[n];
                        boolean bl4 = false;
                        curr = it;
                        if (n == 0) break block7;
                    } while (curr != element);
                    return false;
                }
            }
            key[pos] = element;
        }
        int n = this.getSize();
        this.setSize(n + 1);
        if (n >= this.maxFill) {
            this.rehash(HashCommon.INSTANCE.arraySize(this.getSize() + 1, this.f));
        }
        return true;
    }

    private final void shiftKeys(int pos) {
        int pos2 = pos;
        int last = 0;
        int slot = 0;
        int curr = 0;
        int[] key = this.key;
        while (true) {
            int n;
            int it = n = pos2;
            boolean bl = false;
            last = it;
            pos2 = n + 1 & this.mask;
            while (true) {
                it = n = key[pos2];
                boolean bl2 = false;
                curr = it;
                if (n == 0) {
                    key[last] = 0;
                    return;
                }
                slot = HashCommon.INSTANCE.mix(curr) & this.mask;
                if (last <= pos2 ? last >= slot || slot > pos2 : (pos2 + 1 <= slot ? slot <= last : false)) break;
                pos2 = pos2 + 1 & this.mask;
            }
            key[last] = curr;
        }
    }

    private final boolean removeEntry(int pos) {
        int n = this.getSize();
        this.setSize(n + -1);
        this.shiftKeys(pos);
        if (this.n > this.minN && this.getSize() < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return true;
    }

    private final boolean removeNullEntry() {
        this.containsNull = false;
        this.key[this.n] = 0;
        int n = this.getSize();
        this.setSize(n + -1);
        if (this.n > this.minN && this.getSize() < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return true;
    }

    public boolean remove(int element) {
        int it;
        int n;
        if (element == 0) {
            if (this.containsNull) {
                return this.removeNullEntry();
            }
            return false;
        }
        int curr = 0;
        int[] key = this.key;
        int pos = 0;
        int n2 = n = HashCommon.INSTANCE.mix(element) & this.mask;
        int[] nArray = key;
        boolean bl = false;
        pos = it;
        it = n = nArray[n];
        boolean bl2 = false;
        curr = it;
        if (n == 0) {
            return false;
        }
        if (element == curr) {
            return this.removeEntry(pos);
        }
        do {
            it = n = pos + 1 & this.mask;
            nArray = key;
            boolean bl3 = false;
            pos = it;
            it = n = nArray[n];
            boolean bl4 = false;
            curr = it;
            if (n != 0) continue;
            return false;
        } while (element != curr);
        return this.removeEntry(pos);
    }

    @Override
    public boolean contains(int element) {
        int it;
        int n;
        if (element == 0) {
            return this.containsNull;
        }
        int curr = 0;
        int[] key = this.key;
        int pos = 0;
        int n2 = n = HashCommon.INSTANCE.mix(element) & this.mask;
        int[] nArray = key;
        boolean bl = false;
        pos = it;
        it = n = nArray[n];
        boolean bl2 = false;
        curr = it;
        if (n == 0) {
            return false;
        }
        if (element == curr) {
            return true;
        }
        do {
            it = n = pos + 1 & this.mask;
            nArray = key;
            boolean bl3 = false;
            pos = it;
            it = n = nArray[n];
            boolean bl4 = false;
            curr = it;
            if (n != 0) continue;
            return false;
        } while (element != curr);
        return true;
    }

    private final void rehash(int newN) {
        int[] key = this.key;
        int mask = newN - 1;
        int[] newKey = new int[newN + 1];
        int i2 = this.n;
        int pos = 0;
        int j = this.realSize();
        while (j-- != 0) {
            int it;
            int n;
            while (key[--i2] == 0) {
            }
            int n2 = n = HashCommon.INSTANCE.mix(key[i2]) & mask;
            int[] nArray = newKey;
            boolean bl = false;
            pos = it;
            if (nArray[n] != 0) {
                do {
                    it = n = pos + 1 & mask;
                    nArray = newKey;
                    boolean bl2 = false;
                    pos = it;
                } while (nArray[n] != 0);
            }
            newKey[pos] = key[i2];
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.INSTANCE.maxFill(this.n, this.f);
        this.key = newKey;
    }

    public boolean equals(@Nullable Object other) {
        if (other == null) {
            return false;
        }
        if (super.equals(other)) {
            return true;
        }
        if (other instanceof IntSet) {
            if (((IntSet)other).getSize() != this.getSize()) {
                return false;
            }
            return IntSetExtensionsKt.containsAll(this, (IntSet)other);
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        int[] key = this.key;
        int j = this.realSize();
        int i2 = 0;
        while (j-- != 0) {
            while (key[i2] == 0) {
                ++i2;
            }
            h += key[i2];
            ++i2;
        }
        return h;
    }

    public IntOpenHashSet() {
        this(0, 0.0f, 3, null);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @SourceDebugExtension(value={"SMAP\nIntOpenHashSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntOpenHashSet.kt\nfleet/fastutil/ints/IntOpenHashSet$SetIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,548:1\n1#2:549\n*E\n"})
    private final class SetIterator
    implements MutableIntIterator {
        private int pos;
        private int last;
        private int c;
        private boolean mustReturnNull;
        public IntArrayList wrapped;

        public SetIterator() {
            this.pos = IntOpenHashSet.this.n;
            this.last = -1;
            this.c = IntOpenHashSet.this.getSize();
            this.mustReturnNull = IntOpenHashSet.this.containsNull;
        }

        @NotNull
        public final IntArrayList getWrapped() {
            IntArrayList intArrayList = this.wrapped;
            if (intArrayList != null) {
                return intArrayList;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"wrapped");
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.c != 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int next() {
            void it;
            int n;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n2 = this.c;
            this.c = n2 + -1;
            int[] key = IntOpenHashSet.this.key;
            if (this.mustReturnNull) {
                this.mustReturnNull = false;
                this.last = IntOpenHashSet.this.n;
                return key[IntOpenHashSet.this.n];
            }
            do {
                this.pos += -1;
                if (this.pos >= 0) continue;
                this.last = Integer.MIN_VALUE;
                return this.getWrapped().get(-this.pos - 1);
            } while (key[this.pos] == 0);
            int n3 = n = this.pos;
            int[] nArray = key;
            boolean bl = false;
            this.last = it;
            return nArray[n];
        }
    }
}

