/*
 * Decompiled with CFR 0.152.
 */
package fleet.bifurcan.utils;

import org.jetbrains.annotations.NotNull;

public final class Bits {
    @NotNull
    public static final Bits INSTANCE = new Bits();
    @NotNull
    private static final byte[] deBruijnIndex;

    private Bits() {
    }

    public final int bitOffset(long n) {
        return deBruijnIndex[0xFF & (int)(n * 157587932685088877L >>> 58)];
    }

    public final long highestBit(long n) {
        return Long.highestOneBit(n);
    }

    public final int log2Floor(long n) {
        return this.bitOffset(this.highestBit(n));
    }

    public final int log2Ceil(long n) {
        int log2 = this.log2Floor(n);
        return this.isPowerOfTwo(n) ? log2 : log2 + 1;
    }

    public final long maskBelow(int bits) {
        return (1L << bits) - 1L;
    }

    public final boolean isPowerOfTwo(long n) {
        return (n & n - 1L) == 0L;
    }

    static {
        byte[] byArray = new byte[]{0, 1, 2, 53, 3, 7, 54, 27, 4, 38, 41, 8, 34, 55, 48, 28, 62, 5, 39, 46, 44, 42, 22, 9, 24, 35, 59, 56, 49, 18, 29, 11, 63, 52, 6, 26, 37, 40, 33, 47, 61, 45, 43, 21, 23, 58, 17, 10, 51, 25, 36, 32, 60, 20, 57, 16, 50, 31, 19, 15, 30, 14, 13, 12};
        deBruijnIndex = byArray;
    }
}

