/*
 * Decompiled with CFR 0.152.
 */
package fleet.bifurcan.nodes;

import fleet.bifurcan.utils.Bits;
import java.util.Arrays;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ListNodes {
    @NotNull
    public static final ListNodes INSTANCE = new ListNodes();

    private ListNodes() {
    }

    @NotNull
    public final Object slice(@Nullable Object node2, @NotNull Object editor, long start2, long end) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (node2 instanceof Object[]) {
            return ArraysKt.copyOfRange((Object[])((Object[])node2), (int)((int)start2), (int)((int)end));
        }
        Node node3 = (Node)node2;
        Intrinsics.checkNotNull((Object)node3);
        return node3.slice((int)start2, (int)end, editor);
    }

    @NotNull
    public final Node pushLast(@NotNull Node a, @NotNull Object b, @NotNull Object editor) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return b instanceof Node ? a.pushLast((Node)b, editor) : a.pushLast((Object[])b, editor);
    }

    public static final class Node {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final byte shift;
        private boolean isStrict;
        private int numNodes;
        @Nullable
        private Object editor;
        @NotNull
        private long[] offsets = new long[2];
        @NotNull
        private Object[] nodes = new Object[2];
        @NotNull
        private static final Node EMPTY = new Node(new Object(), 5);

        public Node(@Nullable Object editor, int shift) {
            this.editor = editor;
            this.shift = (byte)shift;
            this.numNodes = 0;
            this.offsets = new long[2];
            this.nodes = new Object[2];
        }

        private Node(int shift) {
            this.shift = (byte)shift;
        }

        public final void assertInvariants() {
            if (this.shift == 5) {
                int n = this.numNodes;
                for (int i2 = 0; i2 < n; ++i2) {
                    if (this.nodes[i2] instanceof Object[]) continue;
                    throw new IllegalStateException("Check failed.");
                }
            } else {
                int n = this.numNodes;
                for (int i3 = 0; i3 < n; ++i3) {
                    Object object = this.nodes[i3];
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type fleet.bifurcan.nodes.ListNodes.Node");
                    if (((Node)object).shift == this.shift - 5) continue;
                    throw new IllegalStateException("Check failed.");
                }
            }
        }

        @Nullable
        public final Object[] first() {
            if (this.numNodes == 0) {
                return null;
            }
            Node n = this;
            while (true) {
                Node node2 = n;
                Intrinsics.checkNotNull((Object)node2);
                if (node2.shift <= 5) break;
                n = (Node)n.nodes[0];
            }
            return (Object[])n.nodes[0];
        }

        @Nullable
        public final Object[] last() {
            if (this.numNodes == 0) {
                return null;
            }
            Node n = this;
            while (n.shift > 5) {
                Object object = n.nodes[n.numNodes - 1];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type fleet.bifurcan.nodes.ListNodes.Node");
                n = (Node)object;
            }
            return (Object[])n.nodes[n.numNodes - 1];
        }

        @NotNull
        public final Object nth(long idx, boolean returnChunk) {
            if (!this.isStrict) {
                return this.relaxedNth(idx, returnChunk);
            }
            Node n = this;
            while (n.shift > 5) {
                int nodeIdx = (int)(idx >>> n.shift & 0x1FL);
                Object object = n.nodes[nodeIdx];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type fleet.bifurcan.nodes.ListNodes.Node");
                n = (Node)object;
                if (n.isStrict) continue;
                return n.relaxedNth(idx, returnChunk);
            }
            Object object = n.nodes[(int)(idx >>> 5 & 0x1FL)];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any>");
            Object[] chunk2 = (Object[])object;
            return returnChunk ? chunk2 : chunk2[(int)(idx & 0x1FL)];
        }

        private final Object relaxedNth(long idx, boolean returnChunk) {
            int nodeIdx;
            long idx2 = idx;
            idx2 &= Bits.INSTANCE.maskBelow(this.shift + 5);
            Node n = this;
            while (n.shift > 5) {
                nodeIdx = n.indexOf(idx2);
                idx2 -= n.offset(nodeIdx);
                Object object = n.nodes[nodeIdx];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type fleet.bifurcan.nodes.ListNodes.Node");
                n = (Node)object;
            }
            nodeIdx = n.indexOf(idx2);
            Object object = n.nodes[nodeIdx];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any>");
            Object[] chunk2 = (Object[])object;
            return returnChunk ? chunk2 : chunk2[(int)(idx2 - n.offset(nodeIdx))];
        }

        private final int indexOf(long idx) {
            int estimate = (int)(this.shift > 60 ? 0L : idx >>> this.shift & 0x1FL);
            if (this.isStrict) {
                return estimate;
            }
            int n = this.nodes.length;
            for (int i2 = estimate; i2 < n; ++i2) {
                if (idx >= this.offsets[i2]) continue;
                return i2;
            }
            return -1;
        }

        private final long offset(int idx) {
            return idx == 0 ? 0L : this.offsets[idx - 1];
        }

        public final long size() {
            return this.numNodes == 0 ? 0L : this.offsets[this.numNodes - 1];
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Node concat(@NotNull Node node2, @NotNull Object editor) {
            Node node3;
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            if (this.size() == 0L) {
                return node2;
            }
            if (node2.size() == 0L) {
                return this;
            }
            if (this.shift == node2.shift) {
                void var3_3;
                Node newNode = editor == this.editor ? this : this.clone(editor);
                int n = node2.numNodes;
                for (int i2 = 0; i2 < n; ++i2) {
                    Object object = node2.nodes[i2];
                    Intrinsics.checkNotNull((Object)object);
                    newNode = INSTANCE.pushLast(newNode, object, editor);
                }
                node3 = var3_3;
            } else {
                node3 = this.shift < node2.shift ? node2.pushFirst(this, editor) : this.pushLast(node2, editor);
            }
            return node3;
        }

        @NotNull
        public final Node slice(int start2, int end, @NotNull Object editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            if (start2 == end) {
                return EMPTY;
            }
            if ((long)start2 == 0L && (long)end == this.size()) {
                return this;
            }
            int startIdx = this.indexOf(start2);
            int endIdx = this.indexOf(end - 1);
            Node rn = EMPTY;
            if (startIdx == endIdx) {
                long offset = this.offset(startIdx);
                Object child2 = INSTANCE.slice(this.nodes[startIdx], editor, (long)start2 - offset, (long)end - offset);
                if (this.shift > 5) {
                    Intrinsics.checkNotNull((Object)child2, (String)"null cannot be cast to non-null type fleet.bifurcan.nodes.ListNodes.Node");
                    return (Node)child2;
                }
                rn = INSTANCE.pushLast(rn, child2, editor);
            } else {
                long sLower = this.offset(startIdx);
                long sUpper = this.offset(startIdx + 1);
                rn = INSTANCE.pushLast(rn, INSTANCE.slice(this.nodes[startIdx], editor, (long)start2 - sLower, sUpper - sLower), editor);
                for (int i2 = startIdx + 1; i2 < endIdx; ++i2) {
                    Object object = this.nodes[i2];
                    Intrinsics.checkNotNull((Object)object);
                    rn = INSTANCE.pushLast(rn, object, editor);
                }
                long eLower = this.offset(endIdx);
                rn = INSTANCE.pushLast(rn, INSTANCE.slice(this.nodes[endIdx], editor, 0L, (long)end - eLower), editor);
            }
            return rn;
        }

        @NotNull
        public final Node pushLast(@Nullable Object[] chunk2, @Nullable Object editor) {
            Node parent;
            int i2;
            if (this.size() == 0L && this.shift > 5) {
                return this.pushLast(Node.Companion.from(editor, chunk2), editor);
            }
            Node[] stack = new Node[this.shift / 5];
            stack[0] = this;
            int n = stack.length;
            for (i2 = 1; i2 < n; ++i2) {
                Node n2;
                Node node2 = n2 = stack[i2 - 1];
                Intrinsics.checkNotNull((Object)node2);
                stack[i2] = node2.nodes[n2.numNodes - 1];
            }
            Node node3 = stack[stack.length - 1];
            Intrinsics.checkNotNull((Object)node3);
            if (node3.numNodes == 32) {
                return this.numNodes == 32 ? new Node(editor, this.shift + 5).pushLast(this, editor).pushLast(chunk2, editor) : this.pushLast(Node.Companion.from(editor, chunk2), editor);
            }
            n = stack.length;
            for (i2 = 0; i2 < n; ++i2) {
                Node node4 = stack[i2];
                Intrinsics.checkNotNull((Object)node4);
                if (node4.editor == editor) continue;
                Node node5 = stack[i2];
                Intrinsics.checkNotNull((Object)node5);
                stack[i2] = node5.clone(editor);
            }
            Node node6 = parent = stack[stack.length - 1];
            Intrinsics.checkNotNull((Object)node6);
            if (node6.nodes.length == parent.numNodes) {
                parent.grow();
            }
            parent.offsets[parent.numNodes] = parent.size();
            Node node7 = parent;
            int n3 = node7.numNodes;
            node7.numNodes = n3 + 1;
            n3 = stack.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                Node n4;
                Node node8 = n4 = stack[i3];
                Intrinsics.checkNotNull((Object)node8);
                int lastIdx = node8.numNodes - 1;
                n4.nodes[lastIdx] = i3 == stack.length - 1 ? chunk2 : stack[i3 + 1];
                long[] lArray = n4.offsets;
                long l = lArray[lastIdx];
                Intrinsics.checkNotNull((Object)chunk2);
                lArray[lastIdx] = l + (long)chunk2.length;
                n4.updateStrict();
            }
            Node node9 = stack[0];
            Intrinsics.checkNotNull((Object)node9);
            return node9;
        }

        @NotNull
        public final Node pushLast(@NotNull Node node2, @Nullable Object editor) {
            Node parent;
            int i2;
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            if (node2.size() == 0L) {
                return this;
            }
            if (this.size() == 0L && this.shift - node2.shift > 5) {
                return this.pushLast(Node.Companion.from(editor, node2.shift + 5, node2), editor);
            }
            if (this.shift < node2.shift) {
                return node2.pushFirst(this, editor);
            }
            if (this.shift == node2.shift) {
                return Node.Companion.from(editor, this.shift + 5, this, node2);
            }
            Node[] stack = new Node[this.numNodes == 0 ? 1 : (this.shift - node2.shift) / 5];
            stack[0] = this;
            int n = stack.length;
            for (i2 = 1; i2 < n; ++i2) {
                Node n2;
                Node node3 = n2 = stack[i2 - 1];
                Intrinsics.checkNotNull((Object)node3);
                stack[i2] = node3.nodes[n2.numNodes - 1];
            }
            Node node4 = stack[stack.length - 1];
            Intrinsics.checkNotNull((Object)node4);
            if (node4.numNodes == 32) {
                return this.pushLast(Node.Companion.from(editor, node2.shift + 5, node2), editor);
            }
            n = stack.length;
            for (i2 = 0; i2 < n; ++i2) {
                Node node5 = stack[i2];
                Intrinsics.checkNotNull((Object)node5);
                if (node5.editor == editor) continue;
                Node node6 = stack[i2];
                Intrinsics.checkNotNull((Object)node6);
                stack[i2] = node6.clone(editor);
            }
            Node node7 = parent = stack[stack.length - 1];
            Intrinsics.checkNotNull((Object)node7);
            if (node7.nodes.length == parent.numNodes) {
                parent.grow();
            }
            parent.offsets[parent.numNodes] = parent.size();
            Node node8 = parent;
            int n3 = node8.numNodes;
            node8.numNodes = n3 + 1;
            long nSize = node2.size();
            int n4 = stack.length;
            for (int i3 = 0; i3 < n4; ++i3) {
                Node n5;
                Node node9 = n5 = stack[i3];
                Intrinsics.checkNotNull((Object)node9);
                int lastIdx = node9.numNodes - 1;
                n5.nodes[lastIdx] = i3 == stack.length - 1 ? node2 : stack[i3 + 1];
                this.assertInvariants();
                long[] lArray = n5.offsets;
                lArray[lastIdx] = lArray[lastIdx] + nSize;
                n5.updateStrict();
            }
            Node node10 = stack[0];
            Intrinsics.checkNotNull((Object)node10);
            return node10;
        }

        @NotNull
        public final Node pushFirst(@Nullable Node node2, @Nullable Object editor) {
            Node parent;
            int i2;
            if (!(this.size() > 0L)) {
                throw new IllegalStateException("Check failed.");
            }
            Node node3 = node2;
            Intrinsics.checkNotNull((Object)node3);
            if (node3.size() == 0L) {
                return this;
            }
            if (this.shift < node2.shift) {
                return node2.pushLast(this, editor);
            }
            if (this.shift == node2.shift) {
                return Node.Companion.from(editor, this.shift + 5, node2, this);
            }
            Node[] stack = new Node[this.numNodes == 0 ? 1 : (this.shift - node2.shift) / 5];
            stack[0] = this;
            int n = stack.length;
            for (i2 = 1; i2 < n; ++i2) {
                Node n2;
                Node node4 = n2 = stack[i2 - 1];
                Intrinsics.checkNotNull((Object)node4);
                stack[i2] = node4.nodes[0];
            }
            Node node5 = stack[stack.length - 1];
            Intrinsics.checkNotNull((Object)node5);
            if (node5.numNodes == 32) {
                return this.pushFirst(Node.Companion.from(editor, node2.shift + 5, node2), editor);
            }
            n = stack.length;
            for (i2 = 0; i2 < n; ++i2) {
                Node node6 = stack[i2];
                Intrinsics.checkNotNull((Object)node6);
                if (node6.editor == editor) continue;
                Node node7 = stack[i2];
                Intrinsics.checkNotNull((Object)node7);
                stack[i2] = node7.clone(editor);
            }
            Node node8 = parent = stack[stack.length - 1];
            Intrinsics.checkNotNull((Object)node8);
            if (node8.nodes.length == parent.numNodes) {
                parent.grow();
            }
            ArraysKt.copyInto((Object[])parent.nodes, (Object[])parent.nodes, (int)1, (int)0, (int)parent.numNodes);
            ArraysKt.copyInto((long[])parent.offsets, (long[])parent.offsets, (int)1, (int)0, (int)parent.numNodes);
            Node node9 = parent;
            int n3 = node9.numNodes;
            node9.numNodes = n3 + 1;
            parent.offsets[0] = 0L;
            long nSize = node2.size();
            int n4 = stack.length;
            for (int i3 = 0; i3 < n4; ++i3) {
                Node n5;
                Node node10 = n5 = stack[i3];
                Intrinsics.checkNotNull((Object)node10);
                node10.nodes[0] = i3 == stack.length - 1 ? node2 : stack[i3 + 1];
                int j = 0;
                int n6 = n5.numNodes;
                while (j < n6) {
                    long[] lArray = n5.offsets;
                    int n7 = j++;
                    lArray[n7] = lArray[n7] + nSize;
                }
                n5.updateStrict();
            }
            Node node11 = stack[0];
            Intrinsics.checkNotNull((Object)node11);
            return node11;
        }

        @NotNull
        public final Node popFirst(@Nullable Object editor) {
            Node parent;
            Node[] stack = new Node[this.shift / 5];
            stack[0] = editor == this.editor ? this : this.clone(editor);
            int n = stack.length;
            for (int i2 = 1; i2 < n; ++i2) {
                Node n2;
                Node node2 = n2 = stack[i2 - 1];
                Intrinsics.checkNotNull((Object)node2);
                stack[i2] = node2.nodes[0];
            }
            Node node3 = parent = stack[stack.length - 1];
            Intrinsics.checkNotNull((Object)node3);
            Object[] chunk2 = (Object[])node3.nodes[0];
            int n3 = stack.length;
            block1: for (int i3 = 0; i3 < n3; ++i3) {
                Node n4 = stack[i3];
                int j = 0;
                Node node4 = n4;
                Intrinsics.checkNotNull((Object)node4);
                int n5 = node4.numNodes;
                while (j < n5) {
                    long[] lArray = n4.offsets;
                    int n6 = j++;
                    long l = lArray[n6];
                    Intrinsics.checkNotNull((Object)chunk2);
                    lArray[n6] = l - (long)chunk2.length;
                }
                n4.updateStrict();
                if (n4.offsets[0] == 0L) {
                    Node node5 = n4;
                    n5 = node5.numNodes;
                    node5.numNodes = n5 + -1;
                    ArraysKt.copyInto((Object[])n4.nodes, (Object[])n4.nodes, (int)0, (int)1, (int)(n4.numNodes + 1));
                    ArraysKt.copyInto((long[])n4.offsets, (long[])n4.offsets, (int)0, (int)1, (int)(n4.numNodes + 1));
                    n4.nodes[n4.numNodes] = null;
                    n4.offsets[n4.numNodes] = 0L;
                    n4.updateStrict();
                    if (i3 != 0) break;
                    while (true) {
                        Node node6 = stack[0];
                        Intrinsics.checkNotNull((Object)node6);
                        if (node6.shift <= 5) break block1;
                        Node node7 = stack[0];
                        Intrinsics.checkNotNull((Object)node7);
                        if (node7.numNodes != 1) break block1;
                        Node node8 = stack[0];
                        Intrinsics.checkNotNull((Object)node8);
                        stack[0] = node8.nodes[0];
                    }
                }
                Node node9 = stack[i3 + 1];
                Intrinsics.checkNotNull((Object)node9);
                if (node9.editor != editor) {
                    Node node10 = stack[i3 + 1];
                    Intrinsics.checkNotNull((Object)node10);
                    stack[i3 + 1] = node10.clone(editor);
                }
                n4.nodes[0] = stack[i3 + 1];
            }
            Node node11 = stack[0];
            Intrinsics.checkNotNull((Object)node11);
            return node11;
        }

        @NotNull
        public final Node popLast(@Nullable Object editor) {
            Node parent;
            Node[] stack = new Node[this.shift / 5];
            stack[0] = editor == this.editor ? this : this.clone(editor);
            int n = stack.length;
            for (int i2 = 1; i2 < n; ++i2) {
                Node n2;
                Node node2 = n2 = stack[i2 - 1];
                Intrinsics.checkNotNull((Object)node2);
                stack[i2] = node2.nodes[n2.numNodes - 1];
            }
            Node node3 = parent = stack[stack.length - 1];
            Intrinsics.checkNotNull((Object)node3);
            Object[] chunk2 = (Object[])node3.nodes[parent.numNodes - 1];
            int n3 = stack.length;
            block1: for (int i3 = 0; i3 < n3; ++i3) {
                Node n4;
                Node node4 = n4 = stack[i3];
                Intrinsics.checkNotNull((Object)node4);
                int lastIdx = node4.numNodes - 1;
                Object object = n4.offsets;
                long l = object[lastIdx];
                Intrinsics.checkNotNull((Object)chunk2);
                object[lastIdx] = l - (long)chunk2.length;
                if (n4.offset(lastIdx + 1) == n4.offset(lastIdx)) {
                    object = n4;
                    int n5 = object.numNodes;
                    object.numNodes = n5 + -1;
                    n4.nodes[n4.numNodes] = null;
                    n4.offsets[n4.numNodes] = 0L;
                    n4.updateStrict();
                    if (i3 != 0) break;
                    while (true) {
                        Node node5 = stack[0];
                        Intrinsics.checkNotNull((Object)node5);
                        if (node5.shift <= 5) break block1;
                        Node node6 = stack[0];
                        Intrinsics.checkNotNull((Object)node6);
                        if (node6.numNodes != 1) break block1;
                        Node node7 = stack[0];
                        Intrinsics.checkNotNull((Object)node7);
                        stack[0] = node7.nodes[0];
                    }
                }
                Node node8 = stack[i3 + 1];
                Intrinsics.checkNotNull((Object)node8);
                if (node8.editor != editor) {
                    Node node9 = stack[i3 + 1];
                    Intrinsics.checkNotNull((Object)node9);
                    stack[i3 + 1] = node9.clone(editor);
                }
                n4.nodes[lastIdx] = stack[i3 + 1];
                n4.updateStrict();
            }
            Node node10 = stack[0];
            Intrinsics.checkNotNull((Object)node10);
            return node10;
        }

        private final void grow() {
            long[] o = new long[this.offsets.length << 1];
            ArraysKt.copyInto((long[])this.offsets, (long[])o, (int)0, (int)0, (int)this.offsets.length);
            this.offsets = o;
            Object[] n = new Object[this.nodes.length << 1];
            ArraysKt.copyInto((Object[])this.nodes, (Object[])n, (int)0, (int)0, (int)this.nodes.length);
            this.nodes = n;
        }

        private final void updateStrict() {
            this.isStrict = this.numNodes <= 1 || this.offset(this.numNodes - 1) == (long)(this.numNodes - 1) * (1L << this.shift);
        }

        private final Node clone(Object editor) {
            Node n = new Node(this.shift);
            n.editor = editor;
            n.numNodes = this.numNodes;
            long[] lArray = Arrays.copyOf(this.offsets, this.offsets.length);
            Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(...)");
            n.offsets = lArray;
            Object[] objectArray = Arrays.copyOf(this.nodes, this.nodes.length);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            n.nodes = objectArray;
            return n;
        }

        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Node getEMPTY() {
                return EMPTY;
            }

            private final Node from(Object editor, int shift, Node child2) {
                return new Node(editor, shift).pushLast(child2, editor);
            }

            private final Node from(Object editor, int shift, Node a, Node b) {
                return new Node(editor, shift).pushLast(a, editor).pushLast(b, editor);
            }

            private final Node from(Object editor, Object[] child2) {
                return new Node(editor, 5).pushLast(child2, editor);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

