/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.webserver;

import com.jetbrains.toolbox.Build;
import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.UIGlobalState;
import com.jetbrains.toolbox.UIModalState;
import com.jetbrains.toolbox.common.RateLimiter;
import com.jetbrains.toolbox.feed.ApplicationType;
import com.jetbrains.toolbox.manager.tool.ToolManager;
import com.jetbrains.toolbox.tools.model.ChannelState;
import com.jetbrains.toolbox.tools.model.ToolBuild;
import com.jetbrains.toolbox.tools.provider.AvailableToolsFacade;
import com.jetbrains.toolbox.webserver.Webserver;
import com.jetbrains.toolbox.webserver.WebserverExtension;
import com.jetbrains.toolbox.webserver.WebserverImpl;
import fi.iki.elonen.NanoHTTPD;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nWebserverImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebserverImpl.kt\ncom/jetbrains/toolbox/webserver/WebserverImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n295#2,2:130\n1#3:132\n*S KotlinDebug\n*F\n+ 1 WebserverImpl.kt\ncom/jetbrains/toolbox/webserver/WebserverImpl\n*L\n67#1:130,2\n*E\n"})
public final class WebserverImpl
extends NanoHTTPD
implements Webserver,
Closeable {
    @NotNull
    private final ToolManager toolManager;
    @NotNull
    private final AvailableToolsFacade availableTools;
    @NotNull
    private final UIGlobalState uiGlobalState;
    @NotNull
    private final RateLimiter rateLimiter;
    @NotNull
    private final List<WebserverExtension> extensions;

    public WebserverImpl(@NotNull ToolManager toolManager, @NotNull AvailableToolsFacade availableTools2, @NotNull UIGlobalState uiGlobalState, @NotNull RateLimiter rateLimiter, int port, @NotNull List<? extends WebserverExtension> extensions) {
        Intrinsics.checkNotNullParameter((Object)toolManager, (String)"toolManager");
        Intrinsics.checkNotNullParameter((Object)availableTools2, (String)"availableTools");
        Intrinsics.checkNotNullParameter((Object)uiGlobalState, (String)"uiGlobalState");
        Intrinsics.checkNotNullParameter((Object)rateLimiter, (String)"rateLimiter");
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        super("localhost", port);
        this.toolManager = toolManager;
        this.availableTools = availableTools2;
        this.uiGlobalState = uiGlobalState;
        this.rateLimiter = rateLimiter;
        this.extensions = extensions;
        try {
            this.start(5000, false);
            Logger.INSTANCE.debug(() -> WebserverImpl._init_$lambda$0(port));
        }
        catch (Throwable t2) {
            Logger.INSTANCE.error(t2, "Failed to create built-in webserver");
        }
    }

    @NotNull
    public NanoHTTPD.Response serve(@NotNull NanoHTTPD.IHTTPSession session2) {
        NanoHTTPD.Response responseFromExtensions;
        String origin;
        block16: {
            NanoHTTPD.Response response2;
            List path2;
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            if (!this.rateLimiter.ensureRateLimit()) {
                NanoHTTPD.Response response3 = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.TOO_MANY_REQUESTS), (String)"text/plain", (String)"Too many requests");
                Intrinsics.checkNotNullExpressionValue((Object)response3, (String)"newFixedLengthResponse(...)");
                return response3;
            }
            origin = (String)session2.getHeaders().get("origin");
            if (!this.isValidOrigin(origin)) {
                NanoHTTPD.Response response4 = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.FORBIDDEN), (String)"text/plain", (String)"Forbidden");
                Intrinsics.checkNotNullExpressionValue((Object)response4, (String)"newFixedLengthResponse(...)");
                return response4;
            }
            Logger.INSTANCE.debug("Serving " + session2.getMethod().name() + " " + session2.getUri());
            if (session2.getMethod() == NanoHTTPD.Method.OPTIONS) {
                NanoHTTPD.Response response5 = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NO_CONTENT), (String)"", (String)"");
                Intrinsics.checkNotNullExpressionValue((Object)response5, (String)"newFixedLengthResponse(...)");
                return this.addCORS(response5, origin);
            }
            if (session2.getMethod() == NanoHTTPD.Method.GET && Intrinsics.areEqual((Object)session2.getUri(), (Object)"/version")) {
                NanoHTTPD.Response response6 = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK), (String)"application/json", (String)("{\"build\":\"" + BuildNumber.toString-impl(Build.INSTANCE.getBuildNumber-Y_E1uuk()) + "\"}"));
                Intrinsics.checkNotNullExpressionValue((Object)response6, (String)"newFixedLengthResponse(...)");
                return this.addCORS(response6, origin);
            }
            String string = session2.getUri();
            if (string != null) {
                char[] cArray = new char[]{'/'};
                v5 = StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            } else {
                v5 = path2 = null;
            }
            if (session2.getMethod() == NanoHTTPD.Method.GET && path2 != null && path2.size() == 4 && Intrinsics.areEqual(path2.get(0), (Object)"") && Intrinsics.areEqual(path2.get(1), (Object)"install")) {
                Object v6;
                String buildNumber;
                String applicationType;
                block15: {
                    applicationType = ApplicationType.constructor-impl((String)path2.get(2));
                    buildNumber = BuildNumber.constructor-impl((String)path2.get(3));
                    Iterable $this$firstOrNull$iv = ((Map)this.toolManager.getModel().getValue()).values();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        ChannelState it = (ChannelState)element$iv;
                        boolean bl = false;
                        if (!(ApplicationType.equals-impl0(it.getTool().getToolId-UtVBrGo(), applicationType) && BuildNumber.equals-impl0(it.getTool().getBuildNumber-Y_E1uuk(), buildNumber))) continue;
                        v6 = element$iv;
                        break block15;
                    }
                    v6 = null;
                }
                ChannelState existing = v6;
                if (existing instanceof ChannelState.Installing) {
                    Logger.INSTANCE.info("Requested application and build is already installing: " + ApplicationType.toString-impl(applicationType) + " " + BuildNumber.toString-impl(buildNumber));
                    NanoHTTPD.Response response7 = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.CONFLICT), (String)"text/plain", (String)"Busy");
                    Intrinsics.checkNotNullExpressionValue((Object)response7, (String)"newFixedLengthResponse(...)");
                    return this.addCORS(response7, origin);
                }
                if (existing != null) {
                    Logger.INSTANCE.info("Requested application and build is already installed: " + ApplicationType.toString-impl(applicationType) + " " + BuildNumber.toString-impl(buildNumber));
                    NanoHTTPD.Response response8 = NanoHTTPD.newFixedLengthResponse((String)"OK");
                    Intrinsics.checkNotNullExpressionValue((Object)response8, (String)"newFixedLengthResponse(...)");
                    return this.addCORS(response8, origin);
                }
                ToolBuild toolBuild2 = (ToolBuild)BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ToolBuild>, Object>(this, applicationType, buildNumber, null){
                    int label;
                    final /* synthetic */ WebserverImpl this$0;
                    final /* synthetic */ String $applicationType;
                    final /* synthetic */ String $buildNumber;
                    {
                        this.this$0 = $receiver;
                        this.$applicationType = $applicationType;
                        this.$buildNumber = $buildNumber;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = WebserverImpl.access$findAvailableTool-WhCQGfU(this.this$0, this.$applicationType, this.$buildNumber, (Continuation)this);
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super ToolBuild> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
                if (toolBuild2 != null) {
                    NanoHTTPD.Response response9;
                    Logger.INSTANCE.info("Prompt user to install " + toolBuild2);
                    this.uiGlobalState.updateState((Function1<? super UIModalState, ? extends UIModalState>)((Function1)arg_0 -> WebserverImpl.serve$lambda$1(toolBuild2, arg_0)));
                    if (this.uiGlobalState.getState().getValue() instanceof UIModalState.FeedjetItem) {
                        NanoHTTPD.Response response10 = NanoHTTPD.newFixedLengthResponse((String)"OK");
                        Intrinsics.checkNotNullExpressionValue((Object)response10, (String)"newFixedLengthResponse(...)");
                        response9 = this.addCORS(response10, origin);
                    } else {
                        Logger.INSTANCE.error("UI is not in the normal state: " + this.uiGlobalState.getState().getValue());
                        NanoHTTPD.Response response11 = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.CONFLICT), (String)"text/plain", (String)"Busy");
                        Intrinsics.checkNotNullExpressionValue((Object)response11, (String)"newFixedLengthResponse(...)");
                        response9 = this.addCORS(response11, origin);
                    }
                    return response9;
                }
                Logger.INSTANCE.warn("Requested application and build not found: " + ApplicationType.toString-impl(applicationType) + " " + BuildNumber.toString-impl(buildNumber));
            }
            for (WebserverExtension it : (Iterable)this.extensions) {
                boolean bl = false;
                NanoHTTPD.Response response12 = it.tryProcessSession(session2);
                if (response12 == null) continue;
                response2 = response12;
                break block16;
            }
            response2 = responseFromExtensions = null;
        }
        if (responseFromExtensions != null) {
            return this.addCORS(responseFromExtensions, origin);
        }
        NanoHTTPD.Response response13 = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND), (String)"text/plain", (String)"Not Found");
        Intrinsics.checkNotNullExpressionValue((Object)response13, (String)"newFixedLengthResponse(...)");
        return this.addCORS(response13, origin);
    }

    /*
     * Unable to fully structure code
     */
    private final Object findAvailableTool-WhCQGfU(String $v$c$com-jetbrains-toolbox-feed-ApplicationType$-applicationType$0, String $v$c$com-jetbrains-toolbox-BuildNumber$-buildNumber$0, Continuation<? super ToolBuild> $completion) {
        if (!($completion instanceof findAvailableTool.1)) ** GOTO lbl-1000
        var5_4 = $completion;
        if ((var5_4.label & -2147483648) != 0) {
            var5_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ WebserverImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return WebserverImpl.access$findAvailableTool-WhCQGfU(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$v$c$com-jetbrains-toolbox-feed-ApplicationType$-applicationType$0);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$v$c$com-jetbrains-toolbox-BuildNumber$-buildNumber$0);
                $continuation.label = 1;
                v0 = AvailableToolsFacade.Builds.loadToolBuilds-myuRksM$default(this.availableTools.getBuilds(), $v$c$com-jetbrains-toolbox-feed-ApplicationType$-applicationType$0, null, $v$c$com-jetbrains-toolbox-BuildNumber$-buildNumber$0, (Continuation)$continuation, 2, null);
                if (v0 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                $v$c$com-jetbrains-toolbox-BuildNumber$-buildNumber$0 = (String)$continuation.L$1;
                $v$c$com-jetbrains-toolbox-feed-ApplicationType$-applicationType$0 = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                return CollectionsKt.singleOrNull((Iterable)((Iterable)v0));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean isValidOrigin(String origin) {
        String string = origin;
        if (!(string != null ? StringsKt.startsWith$default((String)string, (String)"https://", (boolean)false, (int)2, null) : false)) {
            return false;
        }
        return StringsKt.endsWith$default((String)origin, (String)".toolbox.app", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)origin, (String)".jetbrains.com", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)origin, (String)".intellij.net", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)origin, (Object)"https://toolbox.app") || Intrinsics.areEqual((Object)origin, (Object)"https://jetbrains.com") || StringsKt.endsWith$default((String)origin, (String)".academy.labs.jb.gg", (boolean)false, (int)2, null);
    }

    private final NanoHTTPD.Response addCORS(NanoHTTPD.Response $this$addCORS, String origin) {
        if (this.isValidOrigin(origin)) {
            $this$addCORS.addHeader("Access-Control-Allow-Origin", origin);
            $this$addCORS.addHeader("Access-Control-Allow-Methods", "GET, OPTIONS");
            $this$addCORS.addHeader("Access-Control-Allow-Headers", "Content-Type");
        }
        return $this$addCORS;
    }

    @Override
    public void close() {
        this.stop();
    }

    private static final String _init_$lambda$0(int $port) {
        return "Webserver initialized on port " + $port;
    }

    private static final UIModalState serve$lambda$1(ToolBuild $toolBuild, UIModalState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof UIModalState.Normal ? (UIModalState)new UIModalState.FeedjetItem($toolBuild, false, 2, null) : it;
    }

    public static final /* synthetic */ Object access$findAvailableTool-WhCQGfU(WebserverImpl $this, String string, String string2, Continuation $completion) {
        return $this.findAvailableTool-WhCQGfU(string, string2, (Continuation<? super ToolBuild>)$completion);
    }
}

