/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel.settings.remote;

import com.jetbrains.toolbox.api.remoteDev.SettingsSection;
import com.jetbrains.toolbox.common.coroutines.flow.FlowExtensionsKt;
import com.jetbrains.toolbox.fus.FusEnums;
import com.jetbrains.toolbox.gateway.DevEnvironmentId;
import com.jetbrains.toolbox.gateway.log.RemoteDevLogArchiveCollector;
import com.jetbrains.toolbox.i18n.LocalizableStringEx;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.viewmodel.settings.AboutEnvironmentState;
import com.jetbrains.toolbox.viewmodel.settings.SettingsViewModel;
import com.jetbrains.toolbox.viewmodel.settings.SettingsViewState;
import com.jetbrains.toolbox.viewmodel.settings.remote.RemoteSettingsViewModelKt;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nRemoteSettingsViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteSettingsViewModel.kt\ncom/jetbrains/toolbox/viewmodel/settings/remote/RemoteSettingsViewModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
public final class RemoteSettingsViewModel
implements SettingsViewModel {
    @NotNull
    private final DevEnvironmentId environmentId;
    @NotNull
    private final SettingsViewModel.AboutEnvironment aboutEnvironment;
    @NotNull
    private final SettingsViewModel.Tools tools;
    @NotNull
    private final SettingsViewModel.Advanced advanced;
    @NotNull
    private final SettingsViewModel.Proxy proxy;
    @NotNull
    private final RemoteDevLogArchiveCollector remoteDevLogArchiveCollector;
    @NotNull
    private final CoroutineScope envCoroutineScope;
    @NotNull
    private final StateFlow<SettingsViewState> state;
    @Nullable
    private final SettingsViewModel.About about;
    @Nullable
    private final SettingsViewModel.Accounts accounts;
    @Nullable
    private final SettingsViewModel.Appearance appearance;
    @Nullable
    private final SettingsViewModel.Internal internal;

    public RemoteSettingsViewModel(@NotNull DevEnvironmentId environmentId, @NotNull StateFlow<String> environmentName, @Nullable Set<? extends SettingsSection> availableSettings, @NotNull SettingsViewModel.AboutEnvironment aboutEnvironment, @NotNull SettingsViewModel.Tools tools2, @NotNull SettingsViewModel.Advanced advanced, @NotNull SettingsViewModel.Proxy proxy, @NotNull RemoteDevLogArchiveCollector remoteDevLogArchiveCollector, @NotNull CoroutineScope envCoroutineScope) {
        Intrinsics.checkNotNullParameter((Object)environmentId, (String)"environmentId");
        Intrinsics.checkNotNullParameter(environmentName, (String)"environmentName");
        Intrinsics.checkNotNullParameter((Object)aboutEnvironment, (String)"aboutEnvironment");
        Intrinsics.checkNotNullParameter((Object)tools2, (String)"tools");
        Intrinsics.checkNotNullParameter((Object)advanced, (String)"advanced");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)remoteDevLogArchiveCollector, (String)"remoteDevLogArchiveCollector");
        Intrinsics.checkNotNullParameter((Object)envCoroutineScope, (String)"envCoroutineScope");
        this.environmentId = environmentId;
        this.aboutEnvironment = aboutEnvironment;
        this.tools = tools2;
        this.advanced = advanced;
        this.proxy = proxy;
        this.remoteDevLogArchiveCollector = remoteDevLogArchiveCollector;
        this.envCoroutineScope = envCoroutineScope;
        this.state = FlowExtensionsKt.combineStates(environmentName, this.getTools().getState(), this.getAdvanced().getState(), this.getProxy().getState(), this.getAboutEnvironment().getState(), (arg_0, arg_1, arg_2, arg_3, arg_4) -> RemoteSettingsViewModel.state$lambda$0(availableSettings, arg_0, arg_1, arg_2, arg_3, arg_4));
    }

    @NotNull
    public SettingsViewModel.AboutEnvironment getAboutEnvironment() {
        return this.aboutEnvironment;
    }

    @Override
    @NotNull
    public SettingsViewModel.Tools getTools() {
        return this.tools;
    }

    @Override
    @NotNull
    public SettingsViewModel.Advanced getAdvanced() {
        return this.advanced;
    }

    @Override
    @NotNull
    public SettingsViewModel.Proxy getProxy() {
        return this.proxy;
    }

    @Override
    @NotNull
    public StateFlow<SettingsViewState> getState() {
        return this.state;
    }

    @Override
    @Nullable
    public SettingsViewModel.About getAbout() {
        return this.about;
    }

    @Override
    @Nullable
    public SettingsViewModel.Accounts getAccounts() {
        return this.accounts;
    }

    @Override
    @Nullable
    public SettingsViewModel.Appearance getAppearance() {
        return this.appearance;
    }

    @Override
    @Nullable
    public SettingsViewModel.Internal getInternal() {
        return this.internal;
    }

    @NotNull
    public Void onTabSwitch(@NotNull FusEnums.UITab uiTab, @NotNull FusEnums.UIGenerator eventGenerator) {
        Intrinsics.checkNotNullParameter((Object)((Object)uiTab), (String)"uiTab");
        Intrinsics.checkNotNullParameter((Object)((Object)eventGenerator), (String)"eventGenerator");
        this.methodIsNotSupported();
        throw new KotlinNothingValueException();
    }

    @Override
    public void onShowLogFilesClick() {
        BuildersKt.launch$default((CoroutineScope)this.envCoroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ RemoteSettingsViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = RemoteDevLogArchiveCollector.collectAllLogs-OoiPzSQ$default(RemoteSettingsViewModel.access$getRemoteDevLogArchiveCollector$p(this.this$0), RemoteSettingsViewModel.access$getEnvironmentId$p(this.this$0), null, false, (Continuation)this, 4, null);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Void methodIsNotSupported() {
        throw new IllegalStateException("method is not supported".toString());
    }

    private static final SettingsViewState state$lambda$0(Set $availableSettings, String environmentName, SettingsViewState.Tools tools2, SettingsViewState.Advanced advanced, SettingsViewState.Proxy proxy, AboutEnvironmentState aboutEnvironment) {
        AboutEnvironmentState aboutEnvironmentState;
        Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
        LocalizableStringEx localizableStringEx = LocalizableStringExKt.notr(environmentName);
        Object object = tools2;
        SettingsViewState.Tools it = object;
        boolean bl = false;
        SettingsViewState.Tools tools3 = RemoteSettingsViewModelKt.access$contains($availableSettings, SettingsSection.TOOLS) ? object : null;
        Object object2 = advanced;
        SettingsViewState.Advanced it2 = object2;
        boolean bl2 = false;
        object = RemoteSettingsViewModelKt.access$contains($availableSettings, SettingsSection.ADVANCED) ? object2 : null;
        Object object3 = proxy;
        SettingsViewState.Proxy it3 = object3;
        boolean bl3 = false;
        object2 = RemoteSettingsViewModelKt.access$contains($availableSettings, SettingsSection.PROXY) ? object3 : null;
        AboutEnvironmentState it4 = aboutEnvironmentState = aboutEnvironment;
        boolean bl4 = false;
        object3 = RemoteSettingsViewModelKt.access$contains($availableSettings, SettingsSection.ABOUT_ENVIRONMENT) ? aboutEnvironmentState : null;
        return new SettingsViewState(localizableStringEx, null, null, tools3, (SettingsViewState.Proxy)object2, (SettingsViewState.Advanced)object, null, (AboutEnvironmentState)object3);
    }

    public static final /* synthetic */ RemoteDevLogArchiveCollector access$getRemoteDevLogArchiveCollector$p(RemoteSettingsViewModel $this) {
        return $this.remoteDevLogArchiveCollector;
    }

    public static final /* synthetic */ DevEnvironmentId access$getEnvironmentId$p(RemoteSettingsViewModel $this) {
        return $this.environmentId;
    }
}

