/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel.settings;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.common.PortRange;
import com.jetbrains.toolbox.common.io.FileSize;
import com.jetbrains.toolbox.desktop.hotkeys.Hotkey;
import com.jetbrains.toolbox.feed.ApplicationQuality;
import com.jetbrains.toolbox.gateway.MarketplaceInstance;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.i18n.UILanguage;
import com.jetbrains.toolbox.i18n.UIRegion;
import com.jetbrains.toolbox.i18n.gettext.I18n;
import com.jetbrains.toolbox.openssh.SshExecutable;
import com.jetbrains.toolbox.settings.BackgroundEffects;
import com.jetbrains.toolbox.settings.GraphicsApi;
import com.jetbrains.toolbox.settings.HttpLoggingVerbosity;
import com.jetbrains.toolbox.settings.Theme;
import com.jetbrains.toolbox.settings.ToolFeedSource;
import com.jetbrains.toolbox.viewmodel.settings.AboutEnvironmentState;
import com.jetbrains.toolbox.viewmodel.settings.LockableValue;
import java.util.List;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.Level;

public final class SettingsViewState {
    @NotNull
    private final LocalizableString title;
    @Nullable
    private final Accounts accounts;
    @Nullable
    private final Appearance appearance;
    @Nullable
    private final Tools tools;
    @Nullable
    private final Proxy proxy;
    @Nullable
    private final Advanced advanced;
    @Nullable
    private final Internal internal;
    @Nullable
    private final AboutEnvironmentState aboutEnvironment;

    public SettingsViewState(@NotNull LocalizableString title2, @Nullable Accounts accounts2, @Nullable Appearance appearance, @Nullable Tools tools2, @Nullable Proxy proxy, @Nullable Advanced advanced, @Nullable Internal internal, @Nullable AboutEnvironmentState aboutEnvironment) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        this.title = title2;
        this.accounts = accounts2;
        this.appearance = appearance;
        this.tools = tools2;
        this.proxy = proxy;
        this.advanced = advanced;
        this.internal = internal;
        this.aboutEnvironment = aboutEnvironment;
    }

    @NotNull
    public final LocalizableString getTitle() {
        return this.title;
    }

    @Nullable
    public final Accounts getAccounts() {
        return this.accounts;
    }

    @Nullable
    public final Appearance getAppearance() {
        return this.appearance;
    }

    @Nullable
    public final Tools getTools() {
        return this.tools;
    }

    @Nullable
    public final Proxy getProxy() {
        return this.proxy;
    }

    @Nullable
    public final Advanced getAdvanced() {
        return this.advanced;
    }

    @Nullable
    public final Internal getInternal() {
        return this.internal;
    }

    @Nullable
    public final AboutEnvironmentState getAboutEnvironment() {
        return this.aboutEnvironment;
    }

    @NotNull
    public String toString() {
        return "SettingsViewState(title=" + this.title + ", accounts=" + this.accounts + ", appearance=" + this.appearance + ", tools=" + this.tools + ", proxy=" + this.proxy + ", advanced=" + this.advanced + ", internal=" + this.internal + ", aboutEnvironment=" + this.aboutEnvironment + ")";
    }

    public int hashCode() {
        int result2 = this.title.hashCode();
        result2 = result2 * 31 + (this.accounts == null ? 0 : this.accounts.hashCode());
        result2 = result2 * 31 + (this.appearance == null ? 0 : this.appearance.hashCode());
        result2 = result2 * 31 + (this.tools == null ? 0 : this.tools.hashCode());
        result2 = result2 * 31 + (this.proxy == null ? 0 : this.proxy.hashCode());
        result2 = result2 * 31 + (this.advanced == null ? 0 : this.advanced.hashCode());
        result2 = result2 * 31 + (this.internal == null ? 0 : this.internal.hashCode());
        result2 = result2 * 31 + (this.aboutEnvironment == null ? 0 : this.aboutEnvironment.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SettingsViewState)) {
            return false;
        }
        SettingsViewState settingsViewState = (SettingsViewState)other;
        if (!Intrinsics.areEqual((Object)this.title, (Object)settingsViewState.title)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.accounts, (Object)settingsViewState.accounts)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.appearance, (Object)settingsViewState.appearance)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tools, (Object)settingsViewState.tools)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.proxy, (Object)settingsViewState.proxy)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.advanced, (Object)settingsViewState.advanced)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.internal, (Object)settingsViewState.internal)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.aboutEnvironment, (Object)settingsViewState.aboutEnvironment);
    }

    public static final class Accounts {
        @Nullable
        private final JetBrainsAccount jetBrainsAccount;
        @Nullable
        private final Enterprise enterprise;
        @NotNull
        private final GoogleAccount googleAccount;

        public Accounts(@Nullable JetBrainsAccount jetBrainsAccount2, @Nullable Enterprise enterprise, @NotNull GoogleAccount googleAccount) {
            Intrinsics.checkNotNullParameter((Object)googleAccount, (String)"googleAccount");
            this.jetBrainsAccount = jetBrainsAccount2;
            this.enterprise = enterprise;
            this.googleAccount = googleAccount;
        }

        @Nullable
        public final JetBrainsAccount getJetBrainsAccount() {
            return this.jetBrainsAccount;
        }

        @Nullable
        public final Enterprise getEnterprise() {
            return this.enterprise;
        }

        @NotNull
        public final GoogleAccount getGoogleAccount() {
            return this.googleAccount;
        }

        @NotNull
        public String toString() {
            return "Accounts(jetBrainsAccount=" + this.jetBrainsAccount + ", enterprise=" + this.enterprise + ", googleAccount=" + this.googleAccount + ")";
        }

        public int hashCode() {
            int result2 = this.jetBrainsAccount == null ? 0 : this.jetBrainsAccount.hashCode();
            result2 = result2 * 31 + (this.enterprise == null ? 0 : this.enterprise.hashCode());
            result2 = result2 * 31 + this.googleAccount.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Accounts)) {
                return false;
            }
            Accounts accounts2 = (Accounts)other;
            if (!Intrinsics.areEqual((Object)this.jetBrainsAccount, (Object)accounts2.jetBrainsAccount)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.enterprise, (Object)accounts2.enterprise)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.googleAccount, (Object)accounts2.googleAccount);
        }
    }

    public static final class Advanced {
        @Nullable
        private final Boolean showInstalledBuild;
        @Nullable
        private final Boolean allowPatches;
        @Nullable
        private final Boolean submitExceptionsAutomatically;
        @Nullable
        private final String additionalHeaderName;
        @Nullable
        private final String additionalHeaderValue;
        @NotNull
        private final Level loggingLevel;
        @NotNull
        private final List<Level> availableLoggingLevels;
        @Nullable
        private final GraphicsApi graphicsApi;
        @NotNull
        private final HttpLoggingVerbosity httpLoggingVerbosity;
        @NotNull
        private final List<HttpLoggingVerbosity> availableHttpLoggingVerbosity;
        @Nullable
        private final SshExecutable userSelectedSshExecutable;
        @Nullable
        private final List<SshExecutable> sshExecutableLocations;
        @Nullable
        private final PortRange sshDynamicForwardingPortRange;

        public Advanced(@Nullable Boolean showInstalledBuild, @Nullable Boolean allowPatches, @Nullable Boolean submitExceptionsAutomatically, @Nullable String additionalHeaderName, @Nullable String additionalHeaderValue, @NotNull Level loggingLevel, @NotNull List<? extends Level> availableLoggingLevels, @Nullable GraphicsApi graphicsApi, @NotNull HttpLoggingVerbosity httpLoggingVerbosity, @NotNull List<? extends HttpLoggingVerbosity> availableHttpLoggingVerbosity, @Nullable SshExecutable userSelectedSshExecutable, @Nullable List<SshExecutable> sshExecutableLocations, @Nullable PortRange sshDynamicForwardingPortRange) {
            Intrinsics.checkNotNullParameter((Object)loggingLevel, (String)"loggingLevel");
            Intrinsics.checkNotNullParameter(availableLoggingLevels, (String)"availableLoggingLevels");
            Intrinsics.checkNotNullParameter((Object)((Object)httpLoggingVerbosity), (String)"httpLoggingVerbosity");
            Intrinsics.checkNotNullParameter(availableHttpLoggingVerbosity, (String)"availableHttpLoggingVerbosity");
            this.showInstalledBuild = showInstalledBuild;
            this.allowPatches = allowPatches;
            this.submitExceptionsAutomatically = submitExceptionsAutomatically;
            this.additionalHeaderName = additionalHeaderName;
            this.additionalHeaderValue = additionalHeaderValue;
            this.loggingLevel = loggingLevel;
            this.availableLoggingLevels = availableLoggingLevels;
            this.graphicsApi = graphicsApi;
            this.httpLoggingVerbosity = httpLoggingVerbosity;
            this.availableHttpLoggingVerbosity = availableHttpLoggingVerbosity;
            this.userSelectedSshExecutable = userSelectedSshExecutable;
            this.sshExecutableLocations = sshExecutableLocations;
            this.sshDynamicForwardingPortRange = sshDynamicForwardingPortRange;
        }

        @Nullable
        public final Boolean getShowInstalledBuild() {
            return this.showInstalledBuild;
        }

        @Nullable
        public final Boolean getAllowPatches() {
            return this.allowPatches;
        }

        @Nullable
        public final Boolean getSubmitExceptionsAutomatically() {
            return this.submitExceptionsAutomatically;
        }

        @Nullable
        public final String getAdditionalHeaderName() {
            return this.additionalHeaderName;
        }

        @Nullable
        public final String getAdditionalHeaderValue() {
            return this.additionalHeaderValue;
        }

        @NotNull
        public final Level getLoggingLevel() {
            return this.loggingLevel;
        }

        @NotNull
        public final List<Level> getAvailableLoggingLevels() {
            return this.availableLoggingLevels;
        }

        @Nullable
        public final GraphicsApi getGraphicsApi() {
            return this.graphicsApi;
        }

        @NotNull
        public final HttpLoggingVerbosity getHttpLoggingVerbosity() {
            return this.httpLoggingVerbosity;
        }

        @NotNull
        public final List<HttpLoggingVerbosity> getAvailableHttpLoggingVerbosity() {
            return this.availableHttpLoggingVerbosity;
        }

        @Nullable
        public final SshExecutable getUserSelectedSshExecutable() {
            return this.userSelectedSshExecutable;
        }

        @Nullable
        public final List<SshExecutable> getSshExecutableLocations() {
            return this.sshExecutableLocations;
        }

        @Nullable
        public final PortRange getSshDynamicForwardingPortRange() {
            return this.sshDynamicForwardingPortRange;
        }

        @NotNull
        public String toString() {
            return "Advanced(showInstalledBuild=" + this.showInstalledBuild + ", allowPatches=" + this.allowPatches + ", submitExceptionsAutomatically=" + this.submitExceptionsAutomatically + ", additionalHeaderName=" + this.additionalHeaderName + ", additionalHeaderValue=" + this.additionalHeaderValue + ", loggingLevel=" + this.loggingLevel + ", availableLoggingLevels=" + this.availableLoggingLevels + ", graphicsApi=" + this.graphicsApi + ", httpLoggingVerbosity=" + this.httpLoggingVerbosity + ", availableHttpLoggingVerbosity=" + this.availableHttpLoggingVerbosity + ", userSelectedSshExecutable=" + this.userSelectedSshExecutable + ", sshExecutableLocations=" + this.sshExecutableLocations + ", sshDynamicForwardingPortRange=" + this.sshDynamicForwardingPortRange + ")";
        }

        public int hashCode() {
            int result2 = this.showInstalledBuild == null ? 0 : ((Object)this.showInstalledBuild).hashCode();
            result2 = result2 * 31 + (this.allowPatches == null ? 0 : ((Object)this.allowPatches).hashCode());
            result2 = result2 * 31 + (this.submitExceptionsAutomatically == null ? 0 : ((Object)this.submitExceptionsAutomatically).hashCode());
            result2 = result2 * 31 + (this.additionalHeaderName == null ? 0 : this.additionalHeaderName.hashCode());
            result2 = result2 * 31 + (this.additionalHeaderValue == null ? 0 : this.additionalHeaderValue.hashCode());
            result2 = result2 * 31 + this.loggingLevel.hashCode();
            result2 = result2 * 31 + ((Object)this.availableLoggingLevels).hashCode();
            result2 = result2 * 31 + (this.graphicsApi == null ? 0 : this.graphicsApi.hashCode());
            result2 = result2 * 31 + this.httpLoggingVerbosity.hashCode();
            result2 = result2 * 31 + ((Object)this.availableHttpLoggingVerbosity).hashCode();
            result2 = result2 * 31 + (this.userSelectedSshExecutable == null ? 0 : this.userSelectedSshExecutable.hashCode());
            result2 = result2 * 31 + (this.sshExecutableLocations == null ? 0 : ((Object)this.sshExecutableLocations).hashCode());
            result2 = result2 * 31 + (this.sshDynamicForwardingPortRange == null ? 0 : this.sshDynamicForwardingPortRange.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Advanced)) {
                return false;
            }
            Advanced advanced = (Advanced)other;
            if (!Intrinsics.areEqual((Object)this.showInstalledBuild, (Object)advanced.showInstalledBuild)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.allowPatches, (Object)advanced.allowPatches)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.submitExceptionsAutomatically, (Object)advanced.submitExceptionsAutomatically)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.additionalHeaderName, (Object)advanced.additionalHeaderName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.additionalHeaderValue, (Object)advanced.additionalHeaderValue)) {
                return false;
            }
            if (this.loggingLevel != advanced.loggingLevel) {
                return false;
            }
            if (!Intrinsics.areEqual(this.availableLoggingLevels, advanced.availableLoggingLevels)) {
                return false;
            }
            if (this.graphicsApi != advanced.graphicsApi) {
                return false;
            }
            if (this.httpLoggingVerbosity != advanced.httpLoggingVerbosity) {
                return false;
            }
            if (!Intrinsics.areEqual(this.availableHttpLoggingVerbosity, advanced.availableHttpLoggingVerbosity)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.userSelectedSshExecutable, (Object)advanced.userSelectedSshExecutable)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.sshExecutableLocations, advanced.sshExecutableLocations)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.sshDynamicForwardingPortRange, (Object)advanced.sshDynamicForwardingPortRange);
        }
    }

    public static final class Appearance {
        @NotNull
        private final ApplicationQuality updateQuality;
        @NotNull
        private final List<UILanguage> supportedLanguages;
        @NotNull
        private final UILanguage language;
        @NotNull
        private final UIRegion region;
        @NotNull
        private final List<Theme> availableThemes;
        @NotNull
        private final Theme theme;
        private final boolean autostart;
        @Nullable
        private final Boolean startMenuShortcut;
        @NotNull
        private final LockableValue<Boolean> updateAppAutomatically;
        @NotNull
        private final LockableValue<Boolean> anonymousStatistics;
        @Nullable
        private final Hotkey hotkey;
        @NotNull
        private final BackgroundEffects backgroundEffects;
        @NotNull
        private final List<Float> availableScales;
        private final float scale;

        public Appearance(@NotNull ApplicationQuality updateQuality, @NotNull List<? extends UILanguage> supportedLanguages, @NotNull UILanguage language, @NotNull UIRegion region, @NotNull List<? extends Theme> availableThemes, @NotNull Theme theme, boolean autostart, @Nullable Boolean startMenuShortcut, @NotNull LockableValue<Boolean> updateAppAutomatically, @NotNull LockableValue<Boolean> anonymousStatistics, @Nullable Hotkey hotkey, @NotNull BackgroundEffects backgroundEffects, @NotNull List<Float> availableScales, float scale2) {
            Intrinsics.checkNotNullParameter((Object)updateQuality, (String)"updateQuality");
            Intrinsics.checkNotNullParameter(supportedLanguages, (String)"supportedLanguages");
            Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
            Intrinsics.checkNotNullParameter((Object)((Object)region), (String)"region");
            Intrinsics.checkNotNullParameter(availableThemes, (String)"availableThemes");
            Intrinsics.checkNotNullParameter((Object)((Object)theme), (String)"theme");
            Intrinsics.checkNotNullParameter(updateAppAutomatically, (String)"updateAppAutomatically");
            Intrinsics.checkNotNullParameter(anonymousStatistics, (String)"anonymousStatistics");
            Intrinsics.checkNotNullParameter((Object)((Object)backgroundEffects), (String)"backgroundEffects");
            Intrinsics.checkNotNullParameter(availableScales, (String)"availableScales");
            this.updateQuality = updateQuality;
            this.supportedLanguages = supportedLanguages;
            this.language = language;
            this.region = region;
            this.availableThemes = availableThemes;
            this.theme = theme;
            this.autostart = autostart;
            this.startMenuShortcut = startMenuShortcut;
            this.updateAppAutomatically = updateAppAutomatically;
            this.anonymousStatistics = anonymousStatistics;
            this.hotkey = hotkey;
            this.backgroundEffects = backgroundEffects;
            this.availableScales = availableScales;
            this.scale = scale2;
        }

        @NotNull
        public final List<UILanguage> getSupportedLanguages() {
            return this.supportedLanguages;
        }

        @NotNull
        public final UILanguage getLanguage() {
            return this.language;
        }

        @NotNull
        public final UIRegion getRegion() {
            return this.region;
        }

        @NotNull
        public final List<Theme> getAvailableThemes() {
            return this.availableThemes;
        }

        @NotNull
        public final Theme getTheme() {
            return this.theme;
        }

        public final boolean getAutostart() {
            return this.autostart;
        }

        @Nullable
        public final Boolean getStartMenuShortcut() {
            return this.startMenuShortcut;
        }

        @NotNull
        public final LockableValue<Boolean> getUpdateAppAutomatically() {
            return this.updateAppAutomatically;
        }

        @NotNull
        public final LockableValue<Boolean> getAnonymousStatistics() {
            return this.anonymousStatistics;
        }

        @Nullable
        public final Hotkey getHotkey() {
            return this.hotkey;
        }

        @NotNull
        public final BackgroundEffects getBackgroundEffects() {
            return this.backgroundEffects;
        }

        @NotNull
        public final List<Float> getAvailableScales() {
            return this.availableScales;
        }

        public final float getScale() {
            return this.scale;
        }

        @NotNull
        public String toString() {
            return "Appearance(updateQuality=" + this.updateQuality + ", supportedLanguages=" + this.supportedLanguages + ", language=" + this.language + ", region=" + this.region + ", availableThemes=" + this.availableThemes + ", theme=" + this.theme + ", autostart=" + this.autostart + ", startMenuShortcut=" + this.startMenuShortcut + ", updateAppAutomatically=" + this.updateAppAutomatically + ", anonymousStatistics=" + this.anonymousStatistics + ", hotkey=" + this.hotkey + ", backgroundEffects=" + this.backgroundEffects + ", availableScales=" + this.availableScales + ", scale=" + this.scale + ")";
        }

        public int hashCode() {
            int result2 = this.updateQuality.hashCode();
            result2 = result2 * 31 + ((Object)this.supportedLanguages).hashCode();
            result2 = result2 * 31 + this.language.hashCode();
            result2 = result2 * 31 + this.region.hashCode();
            result2 = result2 * 31 + ((Object)this.availableThemes).hashCode();
            result2 = result2 * 31 + this.theme.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.autostart);
            result2 = result2 * 31 + (this.startMenuShortcut == null ? 0 : ((Object)this.startMenuShortcut).hashCode());
            result2 = result2 * 31 + this.updateAppAutomatically.hashCode();
            result2 = result2 * 31 + this.anonymousStatistics.hashCode();
            result2 = result2 * 31 + (this.hotkey == null ? 0 : this.hotkey.hashCode());
            result2 = result2 * 31 + this.backgroundEffects.hashCode();
            result2 = result2 * 31 + ((Object)this.availableScales).hashCode();
            result2 = result2 * 31 + Float.hashCode(this.scale);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Appearance)) {
                return false;
            }
            Appearance appearance = (Appearance)other;
            if (!Intrinsics.areEqual((Object)this.updateQuality, (Object)appearance.updateQuality)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.supportedLanguages, appearance.supportedLanguages)) {
                return false;
            }
            if (this.language != appearance.language) {
                return false;
            }
            if (this.region != appearance.region) {
                return false;
            }
            if (!Intrinsics.areEqual(this.availableThemes, appearance.availableThemes)) {
                return false;
            }
            if (this.theme != appearance.theme) {
                return false;
            }
            if (this.autostart != appearance.autostart) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.startMenuShortcut, (Object)appearance.startMenuShortcut)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.updateAppAutomatically, appearance.updateAppAutomatically)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.anonymousStatistics, appearance.anonymousStatistics)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.hotkey, (Object)appearance.hotkey)) {
                return false;
            }
            if (this.backgroundEffects != appearance.backgroundEffects) {
                return false;
            }
            if (!Intrinsics.areEqual(this.availableScales, appearance.availableScales)) {
                return false;
            }
            return Float.compare(this.scale, appearance.scale) == 0;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class DiskUsage {
        private final boolean cleaningDownloadCache;
        private final boolean removingPreviousVersions;
        private final boolean hasLeftovers;
        private final long leftoversSize;
        private final long downloadCacheSize;
        private final boolean isDownloadCacheEmpty;
        private final long backupsSize;

        private DiskUsage(boolean cleaningDownloadCache, boolean removingPreviousVersions, boolean hasLeftovers, long leftoversSize, long downloadCacheSize, boolean isDownloadCacheEmpty, long backupsSize) {
            this.cleaningDownloadCache = cleaningDownloadCache;
            this.removingPreviousVersions = removingPreviousVersions;
            this.hasLeftovers = hasLeftovers;
            this.leftoversSize = leftoversSize;
            this.downloadCacheSize = downloadCacheSize;
            this.isDownloadCacheEmpty = isDownloadCacheEmpty;
            this.backupsSize = backupsSize;
        }

        public final boolean getCleaningDownloadCache() {
            return this.cleaningDownloadCache;
        }

        public final boolean getRemovingPreviousVersions() {
            return this.removingPreviousVersions;
        }

        public final boolean getHasLeftovers() {
            return this.hasLeftovers;
        }

        public final long getLeftoversSize-WN0b6rc() {
            return this.leftoversSize;
        }

        public final long getDownloadCacheSize-WN0b6rc() {
            return this.downloadCacheSize;
        }

        public final boolean isDownloadCacheEmpty() {
            return this.isDownloadCacheEmpty;
        }

        public final long getBackupsSize-WN0b6rc() {
            return this.backupsSize;
        }

        @NotNull
        public String toString() {
            return "DiskUsage(cleaningDownloadCache=" + this.cleaningDownloadCache + ", removingPreviousVersions=" + this.removingPreviousVersions + ", hasLeftovers=" + this.hasLeftovers + ", leftoversSize=" + FileSize.toString-impl(this.leftoversSize) + ", downloadCacheSize=" + FileSize.toString-impl(this.downloadCacheSize) + ", isDownloadCacheEmpty=" + this.isDownloadCacheEmpty + ", backupsSize=" + FileSize.toString-impl(this.backupsSize) + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.cleaningDownloadCache);
            result2 = result2 * 31 + Boolean.hashCode(this.removingPreviousVersions);
            result2 = result2 * 31 + Boolean.hashCode(this.hasLeftovers);
            result2 = result2 * 31 + FileSize.hashCode-impl(this.leftoversSize);
            result2 = result2 * 31 + FileSize.hashCode-impl(this.downloadCacheSize);
            result2 = result2 * 31 + Boolean.hashCode(this.isDownloadCacheEmpty);
            result2 = result2 * 31 + FileSize.hashCode-impl(this.backupsSize);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DiskUsage)) {
                return false;
            }
            DiskUsage diskUsage = (DiskUsage)other;
            if (this.cleaningDownloadCache != diskUsage.cleaningDownloadCache) {
                return false;
            }
            if (this.removingPreviousVersions != diskUsage.removingPreviousVersions) {
                return false;
            }
            if (this.hasLeftovers != diskUsage.hasLeftovers) {
                return false;
            }
            if (!FileSize.equals-impl0(this.leftoversSize, diskUsage.leftoversSize)) {
                return false;
            }
            if (!FileSize.equals-impl0(this.downloadCacheSize, diskUsage.downloadCacheSize)) {
                return false;
            }
            if (this.isDownloadCacheEmpty != diskUsage.isDownloadCacheEmpty) {
                return false;
            }
            return FileSize.equals-impl0(this.backupsSize, diskUsage.backupsSize);
        }

        public /* synthetic */ DiskUsage(boolean cleaningDownloadCache, boolean removingPreviousVersions, boolean hasLeftovers, long leftoversSize, long downloadCacheSize, boolean isDownloadCacheEmpty, long backupsSize, DefaultConstructorMarker $constructor_marker) {
            this(cleaningDownloadCache, removingPreviousVersions, hasLeftovers, leftoversSize, downloadCacheSize, isDownloadCacheEmpty, backupsSize);
        }
    }

    public static final class Enterprise {
        @Nullable
        private final Account account;
        @Nullable
        private final String companyLogoUrl;
        @NotNull
        private final String companyName;
        @NotNull
        private final String tbeServerUrl;
        private final boolean showLeaveButton;

        public Enterprise(@Nullable Account account2, @Nullable String companyLogoUrl, @NotNull String companyName, @NotNull String tbeServerUrl, boolean showLeaveButton) {
            Intrinsics.checkNotNullParameter((Object)companyName, (String)"companyName");
            Intrinsics.checkNotNullParameter((Object)tbeServerUrl, (String)"tbeServerUrl");
            this.account = account2;
            this.companyLogoUrl = companyLogoUrl;
            this.companyName = companyName;
            this.tbeServerUrl = tbeServerUrl;
            this.showLeaveButton = showLeaveButton;
        }

        @Nullable
        public final Account getAccount() {
            return this.account;
        }

        @Nullable
        public final String getCompanyLogoUrl() {
            return this.companyLogoUrl;
        }

        @NotNull
        public final String getCompanyName() {
            return this.companyName;
        }

        @NotNull
        public final String getTbeServerUrl() {
            return this.tbeServerUrl;
        }

        public final boolean getShowLeaveButton() {
            return this.showLeaveButton;
        }

        @NotNull
        public String toString() {
            return "Enterprise(account=" + this.account + ", companyLogoUrl=" + this.companyLogoUrl + ", companyName=" + this.companyName + ", tbeServerUrl=" + this.tbeServerUrl + ", showLeaveButton=" + this.showLeaveButton + ")";
        }

        public int hashCode() {
            int result2 = this.account == null ? 0 : this.account.hashCode();
            result2 = result2 * 31 + (this.companyLogoUrl == null ? 0 : this.companyLogoUrl.hashCode());
            result2 = result2 * 31 + this.companyName.hashCode();
            result2 = result2 * 31 + this.tbeServerUrl.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.showLeaveButton);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Enterprise)) {
                return false;
            }
            Enterprise enterprise = (Enterprise)other;
            if (!Intrinsics.areEqual((Object)this.account, (Object)enterprise.account)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.companyLogoUrl, (Object)enterprise.companyLogoUrl)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.companyName, (Object)enterprise.companyName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.tbeServerUrl, (Object)enterprise.tbeServerUrl)) {
                return false;
            }
            return this.showLeaveButton == enterprise.showLeaveButton;
        }

        public static final class Account {
            @NotNull
            private final String id;
            @NotNull
            private final String fullName;
            @Nullable
            private final String email;

            public Account(@NotNull String id, @NotNull String fullName, @Nullable String email) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)fullName, (String)"fullName");
                this.id = id;
                this.fullName = fullName;
                this.email = email;
            }

            @NotNull
            public final String getId() {
                return this.id;
            }

            @NotNull
            public final String getFullName() {
                return this.fullName;
            }

            @Nullable
            public final String getEmail() {
                return this.email;
            }

            @NotNull
            public String toString() {
                return "Account(id=" + this.id + ", fullName=" + this.fullName + ", email=" + this.email + ")";
            }

            public int hashCode() {
                int result2 = this.id.hashCode();
                result2 = result2 * 31 + this.fullName.hashCode();
                result2 = result2 * 31 + (this.email == null ? 0 : this.email.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Account)) {
                    return false;
                }
                Account account2 = (Account)other;
                if (!Intrinsics.areEqual((Object)this.id, (Object)account2.id)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.fullName, (Object)account2.fullName)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.email, (Object)account2.email);
            }
        }
    }

    public static sealed interface GoogleAccount {

        public static final class LoggedIn
        implements GoogleAccount {
            @NotNull
            private final String id;
            @NotNull
            private final String fullName;
            @NotNull
            private final String email;

            public LoggedIn(@NotNull String id, @NotNull String fullName, @NotNull String email) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)fullName, (String)"fullName");
                Intrinsics.checkNotNullParameter((Object)email, (String)"email");
                this.id = id;
                this.fullName = fullName;
                this.email = email;
            }

            @NotNull
            public final String getFullName() {
                return this.fullName;
            }

            @NotNull
            public final String getEmail() {
                return this.email;
            }

            @NotNull
            public String toString() {
                return "LoggedIn(id=" + this.id + ", fullName=" + this.fullName + ", email=" + this.email + ")";
            }

            public int hashCode() {
                int result2 = this.id.hashCode();
                result2 = result2 * 31 + this.fullName.hashCode();
                result2 = result2 * 31 + this.email.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LoggedIn)) {
                    return false;
                }
                LoggedIn loggedIn = (LoggedIn)other;
                if (!Intrinsics.areEqual((Object)this.id, (Object)loggedIn.id)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.fullName, (Object)loggedIn.fullName)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.email, (Object)loggedIn.email);
            }
        }

        public static final class LoggedOut
        implements GoogleAccount {
            @NotNull
            public static final LoggedOut INSTANCE = new LoggedOut();

            private LoggedOut() {
            }

            @NotNull
            public String toString() {
                return "LoggedOut";
            }

            public int hashCode() {
                return 2147088300;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LoggedOut)) {
                    return false;
                }
                LoggedOut cfr_ignored_0 = (LoggedOut)other;
                return true;
            }
        }

        public static final class LoggingIn
        implements GoogleAccount {
            @NotNull
            public static final LoggingIn INSTANCE = new LoggingIn();

            private LoggingIn() {
            }

            @NotNull
            public String toString() {
                return "LoggingIn";
            }

            public int hashCode() {
                return -2143865308;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LoggingIn)) {
                    return false;
                }
                LoggingIn cfr_ignored_0 = (LoggingIn)other;
                return true;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class Internal {
        @Nullable
        private final Boolean welcome;
        @Nullable
        private final Boolean showHiddenTools;
        @Nullable
        private final Boolean gateway;
        @Nullable
        private final Boolean enableDevcontainersIntegration;
        @Nullable
        private final Boolean showAiChat;
        private final boolean mcpHub;
        private final int mcpStationConnect;
        private final boolean mcpKitchenSink;
        @Nullable
        private final String authServiceUrl;
        @Nullable
        private final Boolean browserIntegration;
        @Nullable
        private final Boolean isStatisticsEnabled;
        @Nullable
        private final Boolean frameFreezeDetectEnabled;
        @Nullable
        private final Duration additionalLatency;
        @Nullable
        private final Boolean showBandwidthUsage;
        @Nullable
        private final Boolean logTransportMetrics;
        @Nullable
        private final Boolean multiWindowMode;
        @Nullable
        private final Hotkey aiChatHotkey;
        @Nullable
        private final Duration newEnvironmentFormBusyExtensionTime;
        @Nullable
        private final Boolean stagingAsFeedSourceAllowed;
        @Nullable
        private final ToolFeedSource toolFeedSource;
        @Nullable
        private final String toolFeedPath;
        @Nullable
        private final String toolFeedUrl;
        @Nullable
        private final Boolean advancedIDEDirectoryManagementEnabled;
        @Nullable
        private final Boolean enableLicenseUI;
        @Nullable
        private final Boolean useModernClientConnectionFlow;
        @Nullable
        private final Boolean useSymmetricalAnimatedBorderStyle;
        @Nullable
        private final MarketplaceInstance pluginsSource;
        @Nullable
        private final Boolean enableJbidesRdIntegration;
        @Nullable
        private final Boolean detectToolsFreezes;
        @Nullable
        private final Boolean enableInstantUpdate;

        private Internal(Boolean welcome, Boolean showHiddenTools, Boolean gateway, Boolean enableDevcontainersIntegration, Boolean showAiChat, boolean mcpHub, int mcpStationConnect, boolean mcpKitchenSink, String authServiceUrl, Boolean browserIntegration, Boolean isStatisticsEnabled, Boolean frameFreezeDetectEnabled, Duration additionalLatency, Boolean showBandwidthUsage, Boolean logTransportMetrics, Boolean multiWindowMode, Hotkey aiChatHotkey, Duration newEnvironmentFormBusyExtensionTime, Boolean stagingAsFeedSourceAllowed, ToolFeedSource toolFeedSource, String toolFeedPath, String toolFeedUrl, Boolean advancedIDEDirectoryManagementEnabled, Boolean enableLicenseUI, Boolean useModernClientConnectionFlow, Boolean useSymmetricalAnimatedBorderStyle, MarketplaceInstance pluginsSource, Boolean enableJbidesRdIntegration, Boolean detectToolsFreezes, Boolean enableInstantUpdate) {
            this.welcome = welcome;
            this.showHiddenTools = showHiddenTools;
            this.gateway = gateway;
            this.enableDevcontainersIntegration = enableDevcontainersIntegration;
            this.showAiChat = showAiChat;
            this.mcpHub = mcpHub;
            this.mcpStationConnect = mcpStationConnect;
            this.mcpKitchenSink = mcpKitchenSink;
            this.authServiceUrl = authServiceUrl;
            this.browserIntegration = browserIntegration;
            this.isStatisticsEnabled = isStatisticsEnabled;
            this.frameFreezeDetectEnabled = frameFreezeDetectEnabled;
            this.additionalLatency = additionalLatency;
            this.showBandwidthUsage = showBandwidthUsage;
            this.logTransportMetrics = logTransportMetrics;
            this.multiWindowMode = multiWindowMode;
            this.aiChatHotkey = aiChatHotkey;
            this.newEnvironmentFormBusyExtensionTime = newEnvironmentFormBusyExtensionTime;
            this.stagingAsFeedSourceAllowed = stagingAsFeedSourceAllowed;
            this.toolFeedSource = toolFeedSource;
            this.toolFeedPath = toolFeedPath;
            this.toolFeedUrl = toolFeedUrl;
            this.advancedIDEDirectoryManagementEnabled = advancedIDEDirectoryManagementEnabled;
            this.enableLicenseUI = enableLicenseUI;
            this.useModernClientConnectionFlow = useModernClientConnectionFlow;
            this.useSymmetricalAnimatedBorderStyle = useSymmetricalAnimatedBorderStyle;
            this.pluginsSource = pluginsSource;
            this.enableJbidesRdIntegration = enableJbidesRdIntegration;
            this.detectToolsFreezes = detectToolsFreezes;
            this.enableInstantUpdate = enableInstantUpdate;
        }

        @Nullable
        public final Boolean getWelcome() {
            return this.welcome;
        }

        @Nullable
        public final Boolean getShowHiddenTools() {
            return this.showHiddenTools;
        }

        @Nullable
        public final Boolean getGateway() {
            return this.gateway;
        }

        @Nullable
        public final Boolean getEnableDevcontainersIntegration() {
            return this.enableDevcontainersIntegration;
        }

        @Nullable
        public final Boolean getShowAiChat() {
            return this.showAiChat;
        }

        public final boolean getMcpHub() {
            return this.mcpHub;
        }

        public final int getMcpStationConnect() {
            return this.mcpStationConnect;
        }

        public final boolean getMcpKitchenSink() {
            return this.mcpKitchenSink;
        }

        @Nullable
        public final String getAuthServiceUrl() {
            return this.authServiceUrl;
        }

        @Nullable
        public final Boolean getBrowserIntegration() {
            return this.browserIntegration;
        }

        @Nullable
        public final Boolean isStatisticsEnabled() {
            return this.isStatisticsEnabled;
        }

        @Nullable
        public final Boolean getFrameFreezeDetectEnabled() {
            return this.frameFreezeDetectEnabled;
        }

        @Nullable
        public final Duration getAdditionalLatency-FghU774() {
            return this.additionalLatency;
        }

        @Nullable
        public final Boolean getShowBandwidthUsage() {
            return this.showBandwidthUsage;
        }

        @Nullable
        public final Boolean getLogTransportMetrics() {
            return this.logTransportMetrics;
        }

        @Nullable
        public final Boolean getMultiWindowMode() {
            return this.multiWindowMode;
        }

        @Nullable
        public final Hotkey getAiChatHotkey() {
            return this.aiChatHotkey;
        }

        @Nullable
        public final Duration getNewEnvironmentFormBusyExtensionTime-FghU774() {
            return this.newEnvironmentFormBusyExtensionTime;
        }

        @Nullable
        public final Boolean getStagingAsFeedSourceAllowed() {
            return this.stagingAsFeedSourceAllowed;
        }

        @Nullable
        public final ToolFeedSource getToolFeedSource() {
            return this.toolFeedSource;
        }

        @Nullable
        public final String getToolFeedPath() {
            return this.toolFeedPath;
        }

        @Nullable
        public final String getToolFeedUrl() {
            return this.toolFeedUrl;
        }

        @Nullable
        public final Boolean getAdvancedIDEDirectoryManagementEnabled() {
            return this.advancedIDEDirectoryManagementEnabled;
        }

        @Nullable
        public final Boolean getEnableLicenseUI() {
            return this.enableLicenseUI;
        }

        @Nullable
        public final Boolean getUseModernClientConnectionFlow() {
            return this.useModernClientConnectionFlow;
        }

        @Nullable
        public final Boolean getUseSymmetricalAnimatedBorderStyle() {
            return this.useSymmetricalAnimatedBorderStyle;
        }

        @Nullable
        public final MarketplaceInstance getPluginsSource() {
            return this.pluginsSource;
        }

        @Nullable
        public final Boolean getEnableJbidesRdIntegration() {
            return this.enableJbidesRdIntegration;
        }

        @Nullable
        public final Boolean getDetectToolsFreezes() {
            return this.detectToolsFreezes;
        }

        @Nullable
        public final Boolean getEnableInstantUpdate() {
            return this.enableInstantUpdate;
        }

        @NotNull
        public String toString() {
            return "Internal(welcome=" + this.welcome + ", showHiddenTools=" + this.showHiddenTools + ", gateway=" + this.gateway + ", enableDevcontainersIntegration=" + this.enableDevcontainersIntegration + ", showAiChat=" + this.showAiChat + ", mcpHub=" + this.mcpHub + ", mcpStationConnect=" + this.mcpStationConnect + ", mcpKitchenSink=" + this.mcpKitchenSink + ", authServiceUrl=" + this.authServiceUrl + ", browserIntegration=" + this.browserIntegration + ", isStatisticsEnabled=" + this.isStatisticsEnabled + ", frameFreezeDetectEnabled=" + this.frameFreezeDetectEnabled + ", additionalLatency=" + this.additionalLatency + ", showBandwidthUsage=" + this.showBandwidthUsage + ", logTransportMetrics=" + this.logTransportMetrics + ", multiWindowMode=" + this.multiWindowMode + ", aiChatHotkey=" + this.aiChatHotkey + ", newEnvironmentFormBusyExtensionTime=" + this.newEnvironmentFormBusyExtensionTime + ", stagingAsFeedSourceAllowed=" + this.stagingAsFeedSourceAllowed + ", toolFeedSource=" + this.toolFeedSource + ", toolFeedPath=" + this.toolFeedPath + ", toolFeedUrl=" + this.toolFeedUrl + ", advancedIDEDirectoryManagementEnabled=" + this.advancedIDEDirectoryManagementEnabled + ", enableLicenseUI=" + this.enableLicenseUI + ", useModernClientConnectionFlow=" + this.useModernClientConnectionFlow + ", useSymmetricalAnimatedBorderStyle=" + this.useSymmetricalAnimatedBorderStyle + ", pluginsSource=" + this.pluginsSource + ", enableJbidesRdIntegration=" + this.enableJbidesRdIntegration + ", detectToolsFreezes=" + this.detectToolsFreezes + ", enableInstantUpdate=" + this.enableInstantUpdate + ")";
        }

        public int hashCode() {
            int result2 = this.welcome == null ? 0 : ((Object)this.welcome).hashCode();
            result2 = result2 * 31 + (this.showHiddenTools == null ? 0 : ((Object)this.showHiddenTools).hashCode());
            result2 = result2 * 31 + (this.gateway == null ? 0 : ((Object)this.gateway).hashCode());
            result2 = result2 * 31 + (this.enableDevcontainersIntegration == null ? 0 : ((Object)this.enableDevcontainersIntegration).hashCode());
            result2 = result2 * 31 + (this.showAiChat == null ? 0 : ((Object)this.showAiChat).hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.mcpHub);
            result2 = result2 * 31 + Integer.hashCode(this.mcpStationConnect);
            result2 = result2 * 31 + Boolean.hashCode(this.mcpKitchenSink);
            result2 = result2 * 31 + (this.authServiceUrl == null ? 0 : this.authServiceUrl.hashCode());
            result2 = result2 * 31 + (this.browserIntegration == null ? 0 : ((Object)this.browserIntegration).hashCode());
            result2 = result2 * 31 + (this.isStatisticsEnabled == null ? 0 : ((Object)this.isStatisticsEnabled).hashCode());
            result2 = result2 * 31 + (this.frameFreezeDetectEnabled == null ? 0 : ((Object)this.frameFreezeDetectEnabled).hashCode());
            result2 = result2 * 31 + (this.additionalLatency == null ? 0 : Duration.hashCode-impl((long)this.additionalLatency.unbox-impl()));
            result2 = result2 * 31 + (this.showBandwidthUsage == null ? 0 : ((Object)this.showBandwidthUsage).hashCode());
            result2 = result2 * 31 + (this.logTransportMetrics == null ? 0 : ((Object)this.logTransportMetrics).hashCode());
            result2 = result2 * 31 + (this.multiWindowMode == null ? 0 : ((Object)this.multiWindowMode).hashCode());
            result2 = result2 * 31 + (this.aiChatHotkey == null ? 0 : this.aiChatHotkey.hashCode());
            result2 = result2 * 31 + (this.newEnvironmentFormBusyExtensionTime == null ? 0 : Duration.hashCode-impl((long)this.newEnvironmentFormBusyExtensionTime.unbox-impl()));
            result2 = result2 * 31 + (this.stagingAsFeedSourceAllowed == null ? 0 : ((Object)this.stagingAsFeedSourceAllowed).hashCode());
            result2 = result2 * 31 + (this.toolFeedSource == null ? 0 : this.toolFeedSource.hashCode());
            result2 = result2 * 31 + (this.toolFeedPath == null ? 0 : this.toolFeedPath.hashCode());
            result2 = result2 * 31 + (this.toolFeedUrl == null ? 0 : this.toolFeedUrl.hashCode());
            result2 = result2 * 31 + (this.advancedIDEDirectoryManagementEnabled == null ? 0 : ((Object)this.advancedIDEDirectoryManagementEnabled).hashCode());
            result2 = result2 * 31 + (this.enableLicenseUI == null ? 0 : ((Object)this.enableLicenseUI).hashCode());
            result2 = result2 * 31 + (this.useModernClientConnectionFlow == null ? 0 : ((Object)this.useModernClientConnectionFlow).hashCode());
            result2 = result2 * 31 + (this.useSymmetricalAnimatedBorderStyle == null ? 0 : ((Object)this.useSymmetricalAnimatedBorderStyle).hashCode());
            result2 = result2 * 31 + (this.pluginsSource == null ? 0 : this.pluginsSource.hashCode());
            result2 = result2 * 31 + (this.enableJbidesRdIntegration == null ? 0 : ((Object)this.enableJbidesRdIntegration).hashCode());
            result2 = result2 * 31 + (this.detectToolsFreezes == null ? 0 : ((Object)this.detectToolsFreezes).hashCode());
            result2 = result2 * 31 + (this.enableInstantUpdate == null ? 0 : ((Object)this.enableInstantUpdate).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Internal)) {
                return false;
            }
            Internal internal = (Internal)other;
            if (!Intrinsics.areEqual((Object)this.welcome, (Object)internal.welcome)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.showHiddenTools, (Object)internal.showHiddenTools)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.gateway, (Object)internal.gateway)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.enableDevcontainersIntegration, (Object)internal.enableDevcontainersIntegration)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.showAiChat, (Object)internal.showAiChat)) {
                return false;
            }
            if (this.mcpHub != internal.mcpHub) {
                return false;
            }
            if (this.mcpStationConnect != internal.mcpStationConnect) {
                return false;
            }
            if (this.mcpKitchenSink != internal.mcpKitchenSink) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.authServiceUrl, (Object)internal.authServiceUrl)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.browserIntegration, (Object)internal.browserIntegration)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.isStatisticsEnabled, (Object)internal.isStatisticsEnabled)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.frameFreezeDetectEnabled, (Object)internal.frameFreezeDetectEnabled)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.additionalLatency, (Object)internal.additionalLatency)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.showBandwidthUsage, (Object)internal.showBandwidthUsage)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.logTransportMetrics, (Object)internal.logTransportMetrics)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.multiWindowMode, (Object)internal.multiWindowMode)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.aiChatHotkey, (Object)internal.aiChatHotkey)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.newEnvironmentFormBusyExtensionTime, (Object)internal.newEnvironmentFormBusyExtensionTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.stagingAsFeedSourceAllowed, (Object)internal.stagingAsFeedSourceAllowed)) {
                return false;
            }
            if (this.toolFeedSource != internal.toolFeedSource) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.toolFeedPath, (Object)internal.toolFeedPath)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.toolFeedUrl, (Object)internal.toolFeedUrl)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.advancedIDEDirectoryManagementEnabled, (Object)internal.advancedIDEDirectoryManagementEnabled)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.enableLicenseUI, (Object)internal.enableLicenseUI)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.useModernClientConnectionFlow, (Object)internal.useModernClientConnectionFlow)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.useSymmetricalAnimatedBorderStyle, (Object)internal.useSymmetricalAnimatedBorderStyle)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pluginsSource, (Object)internal.pluginsSource)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.enableJbidesRdIntegration, (Object)internal.enableJbidesRdIntegration)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.detectToolsFreezes, (Object)internal.detectToolsFreezes)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.enableInstantUpdate, (Object)internal.enableInstantUpdate);
        }

        public /* synthetic */ Internal(Boolean welcome, Boolean showHiddenTools, Boolean gateway, Boolean enableDevcontainersIntegration, Boolean showAiChat, boolean mcpHub, int mcpStationConnect, boolean mcpKitchenSink, String authServiceUrl, Boolean browserIntegration, Boolean isStatisticsEnabled, Boolean frameFreezeDetectEnabled, Duration additionalLatency, Boolean showBandwidthUsage, Boolean logTransportMetrics, Boolean multiWindowMode, Hotkey aiChatHotkey, Duration newEnvironmentFormBusyExtensionTime, Boolean stagingAsFeedSourceAllowed, ToolFeedSource toolFeedSource, String toolFeedPath, String toolFeedUrl, Boolean advancedIDEDirectoryManagementEnabled, Boolean enableLicenseUI, Boolean useModernClientConnectionFlow, Boolean useSymmetricalAnimatedBorderStyle, MarketplaceInstance pluginsSource, Boolean enableJbidesRdIntegration, Boolean detectToolsFreezes, Boolean enableInstantUpdate, DefaultConstructorMarker $constructor_marker) {
            this(welcome, showHiddenTools, gateway, enableDevcontainersIntegration, showAiChat, mcpHub, mcpStationConnect, mcpKitchenSink, authServiceUrl, browserIntegration, isStatisticsEnabled, frameFreezeDetectEnabled, additionalLatency, showBandwidthUsage, logTransportMetrics, multiWindowMode, aiChatHotkey, newEnvironmentFormBusyExtensionTime, stagingAsFeedSourceAllowed, toolFeedSource, toolFeedPath, toolFeedUrl, advancedIDEDirectoryManagementEnabled, enableLicenseUI, useModernClientConnectionFlow, useSymmetricalAnimatedBorderStyle, pluginsSource, enableJbidesRdIntegration, detectToolsFreezes, enableInstantUpdate);
        }
    }

    public static sealed interface JetBrainsAccount {

        public static final class LoggedIn
        implements JetBrainsAccount {
            @NotNull
            private final String id;
            @NotNull
            private final String fullName;
            @NotNull
            private final String email;
            @NotNull
            private final String allEmails;
            private final boolean isInternal;

            public LoggedIn(@NotNull String id, @NotNull String fullName, @NotNull String email, @NotNull String allEmails, boolean isInternal) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)fullName, (String)"fullName");
                Intrinsics.checkNotNullParameter((Object)email, (String)"email");
                Intrinsics.checkNotNullParameter((Object)allEmails, (String)"allEmails");
                this.id = id;
                this.fullName = fullName;
                this.email = email;
                this.allEmails = allEmails;
                this.isInternal = isInternal;
            }

            @NotNull
            public final String getId() {
                return this.id;
            }

            @NotNull
            public final String getFullName() {
                return this.fullName;
            }

            @NotNull
            public final String getEmail() {
                return this.email;
            }

            @NotNull
            public final String getAllEmails() {
                return this.allEmails;
            }

            public final boolean isInternal() {
                return this.isInternal;
            }

            @NotNull
            public String toString() {
                return "LoggedIn(id=" + this.id + ", fullName=" + this.fullName + ", email=" + this.email + ", allEmails=" + this.allEmails + ", isInternal=" + this.isInternal + ")";
            }

            public int hashCode() {
                int result2 = this.id.hashCode();
                result2 = result2 * 31 + this.fullName.hashCode();
                result2 = result2 * 31 + this.email.hashCode();
                result2 = result2 * 31 + this.allEmails.hashCode();
                result2 = result2 * 31 + Boolean.hashCode(this.isInternal);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LoggedIn)) {
                    return false;
                }
                LoggedIn loggedIn = (LoggedIn)other;
                if (!Intrinsics.areEqual((Object)this.id, (Object)loggedIn.id)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.fullName, (Object)loggedIn.fullName)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.email, (Object)loggedIn.email)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.allEmails, (Object)loggedIn.allEmails)) {
                    return false;
                }
                return this.isInternal == loggedIn.isInternal;
            }
        }

        public static final class LoggedOut
        implements JetBrainsAccount {
            @NotNull
            public static final LoggedOut INSTANCE = new LoggedOut();

            private LoggedOut() {
            }

            @NotNull
            public String toString() {
                return "LoggedOut";
            }

            public int hashCode() {
                return 1473276635;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LoggedOut)) {
                    return false;
                }
                LoggedOut cfr_ignored_0 = (LoggedOut)other;
                return true;
            }
        }

        public static final class LoggingIn
        implements JetBrainsAccount {
            @NotNull
            public static final LoggingIn INSTANCE = new LoggingIn();

            private LoggingIn() {
            }

            @NotNull
            public String toString() {
                return "LoggingIn";
            }

            public int hashCode() {
                return 1477290323;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LoggingIn)) {
                    return false;
                }
                LoggingIn cfr_ignored_0 = (LoggingIn)other;
                return true;
            }
        }

        public static final class Troubleshooting
        implements JetBrainsAccount {
            @NotNull
            public static final Troubleshooting INSTANCE = new Troubleshooting();

            private Troubleshooting() {
            }

            @NotNull
            public String toString() {
                return "Troubleshooting";
            }

            public int hashCode() {
                return 1077924745;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Troubleshooting)) {
                    return false;
                }
                Troubleshooting cfr_ignored_0 = (Troubleshooting)other;
                return true;
            }
        }
    }

    public static final class Location {
        @NotNull
        private final String value;
        @NotNull
        private final String defaultValue;

        public Location(@NotNull String value2, @NotNull String defaultValue) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
            this.value = value2;
            this.defaultValue = defaultValue;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final String getDefaultValue() {
            return this.defaultValue;
        }

        @NotNull
        public String toString() {
            return "Location(value=" + this.value + ", defaultValue=" + this.defaultValue + ")";
        }

        public int hashCode() {
            int result2 = this.value.hashCode();
            result2 = result2 * 31 + this.defaultValue.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Location)) {
                return false;
            }
            Location location2 = (Location)other;
            if (!Intrinsics.areEqual((Object)this.value, (Object)location2.value)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.defaultValue, (Object)location2.defaultValue);
        }
    }

    public static final class Proxy {
        @NotNull
        private final List<Type> availableTypes;
        @NotNull
        private final Type type;
        @NotNull
        private final String configurationUrl;
        @NotNull
        private final String host;
        @NotNull
        private final String port;
        @Nullable
        private final String username;
        @Nullable
        private final String password;
        private final boolean enabled;
        private final boolean systemProxySettingsAvailable;
        @NotNull
        private final ConnectionStatus status;

        public Proxy(@NotNull List<? extends Type> availableTypes, @NotNull Type type2, @NotNull String configurationUrl, @NotNull String host, @NotNull String port, @Nullable String username, @Nullable String password, boolean enabled, boolean systemProxySettingsAvailable, @NotNull ConnectionStatus status2) {
            Intrinsics.checkNotNullParameter(availableTypes, (String)"availableTypes");
            Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
            Intrinsics.checkNotNullParameter((Object)configurationUrl, (String)"configurationUrl");
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)port, (String)"port");
            Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
            this.availableTypes = availableTypes;
            this.type = type2;
            this.configurationUrl = configurationUrl;
            this.host = host;
            this.port = port;
            this.username = username;
            this.password = password;
            this.enabled = enabled;
            this.systemProxySettingsAvailable = systemProxySettingsAvailable;
            this.status = status2;
        }

        @NotNull
        public final List<Type> getAvailableTypes() {
            return this.availableTypes;
        }

        @NotNull
        public final Type getType() {
            return this.type;
        }

        @NotNull
        public final String getConfigurationUrl() {
            return this.configurationUrl;
        }

        @NotNull
        public final String getHost() {
            return this.host;
        }

        @NotNull
        public final String getPort() {
            return this.port;
        }

        @Nullable
        public final String getUsername() {
            return this.username;
        }

        @Nullable
        public final String getPassword() {
            return this.password;
        }

        public final boolean getEnabled() {
            return this.enabled;
        }

        public final boolean getSystemProxySettingsAvailable() {
            return this.systemProxySettingsAvailable;
        }

        @NotNull
        public final ConnectionStatus getStatus() {
            return this.status;
        }

        @NotNull
        public final Proxy copy(@NotNull List<? extends Type> availableTypes, @NotNull Type type2, @NotNull String configurationUrl, @NotNull String host, @NotNull String port, @Nullable String username, @Nullable String password, boolean enabled, boolean systemProxySettingsAvailable, @NotNull ConnectionStatus status2) {
            Intrinsics.checkNotNullParameter(availableTypes, (String)"availableTypes");
            Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
            Intrinsics.checkNotNullParameter((Object)configurationUrl, (String)"configurationUrl");
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)port, (String)"port");
            Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
            return new Proxy(availableTypes, type2, configurationUrl, host, port, username, password, enabled, systemProxySettingsAvailable, status2);
        }

        public static /* synthetic */ Proxy copy$default(Proxy proxy, List list2, Type type2, String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2, ConnectionStatus connectionStatus, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = proxy.availableTypes;
            }
            if ((n & 2) != 0) {
                type2 = proxy.type;
            }
            if ((n & 4) != 0) {
                string = proxy.configurationUrl;
            }
            if ((n & 8) != 0) {
                string2 = proxy.host;
            }
            if ((n & 0x10) != 0) {
                string3 = proxy.port;
            }
            if ((n & 0x20) != 0) {
                string4 = proxy.username;
            }
            if ((n & 0x40) != 0) {
                string5 = proxy.password;
            }
            if ((n & 0x80) != 0) {
                bl = proxy.enabled;
            }
            if ((n & 0x100) != 0) {
                bl2 = proxy.systemProxySettingsAvailable;
            }
            if ((n & 0x200) != 0) {
                connectionStatus = proxy.status;
            }
            return proxy.copy(list2, type2, string, string2, string3, string4, string5, bl, bl2, connectionStatus);
        }

        @NotNull
        public String toString() {
            return "Proxy(availableTypes=" + this.availableTypes + ", type=" + this.type + ", configurationUrl=" + this.configurationUrl + ", host=" + this.host + ", port=" + this.port + ", username=" + this.username + ", password=" + this.password + ", enabled=" + this.enabled + ", systemProxySettingsAvailable=" + this.systemProxySettingsAvailable + ", status=" + this.status + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.availableTypes).hashCode();
            result2 = result2 * 31 + this.type.hashCode();
            result2 = result2 * 31 + this.configurationUrl.hashCode();
            result2 = result2 * 31 + this.host.hashCode();
            result2 = result2 * 31 + this.port.hashCode();
            result2 = result2 * 31 + (this.username == null ? 0 : this.username.hashCode());
            result2 = result2 * 31 + (this.password == null ? 0 : this.password.hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.enabled);
            result2 = result2 * 31 + Boolean.hashCode(this.systemProxySettingsAvailable);
            result2 = result2 * 31 + this.status.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Proxy)) {
                return false;
            }
            Proxy proxy = (Proxy)other;
            if (!Intrinsics.areEqual(this.availableTypes, proxy.availableTypes)) {
                return false;
            }
            if (this.type != proxy.type) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.configurationUrl, (Object)proxy.configurationUrl)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.host, (Object)proxy.host)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.port, (Object)proxy.port)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.username, (Object)proxy.username)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.password, (Object)proxy.password)) {
                return false;
            }
            if (this.enabled != proxy.enabled) {
                return false;
            }
            if (this.systemProxySettingsAvailable != proxy.systemProxySettingsAvailable) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.status, (Object)proxy.status);
        }

        public static abstract sealed class ConnectionStatus {
            private ConnectionStatus() {
            }

            public /* synthetic */ ConnectionStatus(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            public static final class Connecting
            extends ConnectionStatus {
                @NotNull
                public static final Connecting INSTANCE = new Connecting();

                private Connecting() {
                    super(null);
                }

                @NotNull
                public String toString() {
                    return "Connecting";
                }

                public int hashCode() {
                    return 257764368;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Connecting)) {
                        return false;
                    }
                    Connecting cfr_ignored_0 = (Connecting)other;
                    return true;
                }
            }

            public static final class Failure
            extends ConnectionStatus {
                @NotNull
                private final LocalizableString message;

                public Failure(@NotNull LocalizableString message2) {
                    Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                    super(null);
                    this.message = message2;
                }

                @NotNull
                public final LocalizableString getMessage() {
                    return this.message;
                }

                @NotNull
                public String toString() {
                    return "Failure(message=" + this.message + ")";
                }

                public int hashCode() {
                    return this.message.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Failure)) {
                        return false;
                    }
                    Failure failure = (Failure)other;
                    return Intrinsics.areEqual((Object)this.message, (Object)failure.message);
                }
            }

            public static final class NotChecked
            extends ConnectionStatus {
                @NotNull
                public static final NotChecked INSTANCE = new NotChecked();

                private NotChecked() {
                    super(null);
                }

                @NotNull
                public String toString() {
                    return "NotChecked";
                }

                public int hashCode() {
                    return 542320300;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof NotChecked)) {
                        return false;
                    }
                    NotChecked cfr_ignored_0 = (NotChecked)other;
                    return true;
                }
            }

            public static final class Valid
            extends ConnectionStatus {
                @NotNull
                public static final Valid INSTANCE = new Valid();

                private Valid() {
                    super(null);
                }

                @NotNull
                public String toString() {
                    return "Valid";
                }

                public int hashCode() {
                    return -1501369436;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Valid)) {
                        return false;
                    }
                    Valid cfr_ignored_0 = (Valid)other;
                    return true;
                }
            }
        }

        public static final class Type
        extends Enum<Type> {
            @NotNull
            private final LocalizableString string;
            public static final /* enum */ Type System = new Type(LocalizableStringExKt.trl("System settings"));
            public static final /* enum */ Type Automatic = new Type(LocalizableStringExKt.trl("Automatic"));
            public static final /* enum */ Type HTTP = new Type(LocalizableStringExKt.trl("HTTP"));
            public static final /* enum */ Type SOCKS = new Type(LocalizableStringExKt.trl("SOCKS"));
            public static final /* enum */ Type Disabled = new Type(LocalizableStringExKt.trl("Disable"));
            private static final /* synthetic */ Type[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private Type(LocalizableString string) {
                this.string = string;
            }

            @NotNull
            public final String localize(@NotNull I18n i18n) {
                Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
                return LocalizableStringExKt.localize(this.string, i18n);
            }

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            @NotNull
            public static EnumEntries<Type> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = typeArray = new Type[]{Type.System, Type.Automatic, Type.HTTP, Type.SOCKS, Type.Disabled};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    public static final class Tools {
        @Nullable
        private final LockableValue<Boolean> updateAllAutomatically;
        @Nullable
        private final Boolean createStartMenuShortcuts;
        @Nullable
        private final Boolean createFileAssociations;
        @Nullable
        private final Boolean generateShellScripts;
        @Nullable
        private final Boolean instantRollback;
        @NotNull
        private final DiskUsage diskUsage;
        @Nullable
        private final Location installLocation;
        private final boolean filePickerAvailable;
        @Nullable
        private final Location shellLaunchersLocation;
        private final boolean hasFrontendTools;

        public Tools(@Nullable LockableValue<Boolean> updateAllAutomatically, @Nullable Boolean createStartMenuShortcuts, @Nullable Boolean createFileAssociations, @Nullable Boolean generateShellScripts, @Nullable Boolean instantRollback, @NotNull DiskUsage diskUsage, @Nullable Location installLocation, boolean filePickerAvailable, @Nullable Location shellLaunchersLocation, boolean hasFrontendTools) {
            Intrinsics.checkNotNullParameter((Object)diskUsage, (String)"diskUsage");
            this.updateAllAutomatically = updateAllAutomatically;
            this.createStartMenuShortcuts = createStartMenuShortcuts;
            this.createFileAssociations = createFileAssociations;
            this.generateShellScripts = generateShellScripts;
            this.instantRollback = instantRollback;
            this.diskUsage = diskUsage;
            this.installLocation = installLocation;
            this.filePickerAvailable = filePickerAvailable;
            this.shellLaunchersLocation = shellLaunchersLocation;
            this.hasFrontendTools = hasFrontendTools;
        }

        @Nullable
        public final LockableValue<Boolean> getUpdateAllAutomatically() {
            return this.updateAllAutomatically;
        }

        @Nullable
        public final Boolean getCreateStartMenuShortcuts() {
            return this.createStartMenuShortcuts;
        }

        @Nullable
        public final Boolean getCreateFileAssociations() {
            return this.createFileAssociations;
        }

        @Nullable
        public final Boolean getGenerateShellScripts() {
            return this.generateShellScripts;
        }

        @Nullable
        public final Boolean getInstantRollback() {
            return this.instantRollback;
        }

        @NotNull
        public final DiskUsage getDiskUsage() {
            return this.diskUsage;
        }

        @Nullable
        public final Location getInstallLocation() {
            return this.installLocation;
        }

        public final boolean getFilePickerAvailable() {
            return this.filePickerAvailable;
        }

        @Nullable
        public final Location getShellLaunchersLocation() {
            return this.shellLaunchersLocation;
        }

        public final boolean getHasFrontendTools() {
            return this.hasFrontendTools;
        }

        @NotNull
        public String toString() {
            return "Tools(updateAllAutomatically=" + this.updateAllAutomatically + ", createStartMenuShortcuts=" + this.createStartMenuShortcuts + ", createFileAssociations=" + this.createFileAssociations + ", generateShellScripts=" + this.generateShellScripts + ", instantRollback=" + this.instantRollback + ", diskUsage=" + this.diskUsage + ", installLocation=" + this.installLocation + ", filePickerAvailable=" + this.filePickerAvailable + ", shellLaunchersLocation=" + this.shellLaunchersLocation + ", hasFrontendTools=" + this.hasFrontendTools + ")";
        }

        public int hashCode() {
            int result2 = this.updateAllAutomatically == null ? 0 : this.updateAllAutomatically.hashCode();
            result2 = result2 * 31 + (this.createStartMenuShortcuts == null ? 0 : ((Object)this.createStartMenuShortcuts).hashCode());
            result2 = result2 * 31 + (this.createFileAssociations == null ? 0 : ((Object)this.createFileAssociations).hashCode());
            result2 = result2 * 31 + (this.generateShellScripts == null ? 0 : ((Object)this.generateShellScripts).hashCode());
            result2 = result2 * 31 + (this.instantRollback == null ? 0 : ((Object)this.instantRollback).hashCode());
            result2 = result2 * 31 + this.diskUsage.hashCode();
            result2 = result2 * 31 + (this.installLocation == null ? 0 : this.installLocation.hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.filePickerAvailable);
            result2 = result2 * 31 + (this.shellLaunchersLocation == null ? 0 : this.shellLaunchersLocation.hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.hasFrontendTools);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Tools)) {
                return false;
            }
            Tools tools2 = (Tools)other;
            if (!Intrinsics.areEqual(this.updateAllAutomatically, tools2.updateAllAutomatically)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.createStartMenuShortcuts, (Object)tools2.createStartMenuShortcuts)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.createFileAssociations, (Object)tools2.createFileAssociations)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.generateShellScripts, (Object)tools2.generateShellScripts)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.instantRollback, (Object)tools2.instantRollback)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.diskUsage, (Object)tools2.diskUsage)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.installLocation, (Object)tools2.installLocation)) {
                return false;
            }
            if (this.filePickerAvailable != tools2.filePickerAvailable) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.shellLaunchersLocation, (Object)tools2.shellLaunchersLocation)) {
                return false;
            }
            return this.hasFrontendTools == tools2.hasFrontendTools;
        }
    }
}

