/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel.recents;

import com.jetbrains.toolbox.gateway.DevEnvironmentId;
import com.jetbrains.toolbox.platform.image.internal.Image;
import com.jetbrains.toolbox.tools.ProjectStatus;
import com.jetbrains.toolbox.tools.model.ProjectId;
import com.jetbrains.toolbox.viewmodel.projects.LaunchMethodViewState;
import com.jetbrains.toolbox.viewmodel.projects.ProjectIconData;
import com.jetbrains.toolbox.viewmodel.projects.ProjectViewState;
import com.jetbrains.toolbox.viewmodel.tools.InstalledToolViewState;
import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RecentProjectsState {
    @NotNull
    private final List<Project> active;
    @NotNull
    private final List<Project> closed;
    private final boolean hasProjects;

    public RecentProjectsState(@NotNull List<Project> active2, @NotNull List<Project> closed) {
        Intrinsics.checkNotNullParameter(active2, (String)"active");
        Intrinsics.checkNotNullParameter(closed, (String)"closed");
        this.active = active2;
        this.closed = closed;
        this.hasProjects = !((Collection)this.active).isEmpty() || !((Collection)this.closed).isEmpty();
    }

    @NotNull
    public final List<Project> getActive() {
        return this.active;
    }

    @NotNull
    public final List<Project> getClosed() {
        return this.closed;
    }

    public final boolean getHasProjects() {
        return this.hasProjects;
    }

    @NotNull
    public String toString() {
        return "RecentProjectsState(active=" + this.active + ", closed=" + this.closed + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.active).hashCode();
        result2 = result2 * 31 + ((Object)this.closed).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RecentProjectsState)) {
            return false;
        }
        RecentProjectsState recentProjectsState = (RecentProjectsState)other;
        if (!Intrinsics.areEqual(this.active, recentProjectsState.active)) {
            return false;
        }
        return Intrinsics.areEqual(this.closed, recentProjectsState.closed);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class Project
    implements ProjectViewState {
        @NotNull
        private final String projectId;
        @NotNull
        private final String name;
        @NotNull
        private final String location;
        private final boolean deleted;
        @Nullable
        private final String environmentName;
        @Nullable
        private final Image environmentIcon;
        @NotNull
        private final ProjectIconData iconData;
        @NotNull
        private final ProjectStatus status;
        private final boolean active;
        @NotNull
        private final List<Action> actions;
        @NotNull
        private final List<LaunchMethodViewState> launchMethods;
        @Nullable
        private final InstalledToolViewState.ToolDescriptionViewState toolDescription;

        private Project(String projectId, String name2, String location2, boolean deleted, String environmentName, Image environmentIcon, ProjectIconData iconData, ProjectStatus status2, boolean active2, List<? extends Action> actions2, List<? extends LaunchMethodViewState> launchMethods, InstalledToolViewState.ToolDescriptionViewState toolDescription) {
            Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
            Intrinsics.checkNotNullParameter((Object)iconData, (String)"iconData");
            Intrinsics.checkNotNullParameter((Object)((Object)status2), (String)"status");
            Intrinsics.checkNotNullParameter(actions2, (String)"actions");
            Intrinsics.checkNotNullParameter(launchMethods, (String)"launchMethods");
            this.projectId = projectId;
            this.name = name2;
            this.location = location2;
            this.deleted = deleted;
            this.environmentName = environmentName;
            this.environmentIcon = environmentIcon;
            this.iconData = iconData;
            this.status = status2;
            this.active = active2;
            this.actions = actions2;
            this.launchMethods = launchMethods;
            this.toolDescription = toolDescription;
        }

        @NotNull
        public String getProjectId-kZr3Ip4() {
            return this.projectId;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public String getLocation() {
            return this.location;
        }

        @Override
        public boolean getDeleted() {
            return this.deleted;
        }

        @Nullable
        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Nullable
        public final Image getEnvironmentIcon() {
            return this.environmentIcon;
        }

        @Override
        @NotNull
        public ProjectIconData getIconData() {
            return this.iconData;
        }

        @Override
        @NotNull
        public ProjectStatus getStatus() {
            return this.status;
        }

        public final boolean getActive() {
            return this.active;
        }

        @NotNull
        public final List<Action> getActions() {
            return this.actions;
        }

        @Override
        @NotNull
        public List<LaunchMethodViewState> getLaunchMethods() {
            return this.launchMethods;
        }

        @Override
        @Nullable
        public InstalledToolViewState.ToolDescriptionViewState getToolDescription() {
            return this.toolDescription;
        }

        @NotNull
        public String toString() {
            return "Project(projectId=" + ProjectId.toString-impl(this.projectId) + ", name=" + this.name + ", location=" + this.location + ", deleted=" + this.deleted + ", environmentName=" + this.environmentName + ", environmentIcon=" + this.environmentIcon + ", iconData=" + this.iconData + ", status=" + this.status + ", active=" + this.active + ", actions=" + this.actions + ", launchMethods=" + this.launchMethods + ", toolDescription=" + this.toolDescription + ")";
        }

        public int hashCode() {
            int result2 = ProjectId.hashCode-impl(this.projectId);
            result2 = result2 * 31 + this.name.hashCode();
            result2 = result2 * 31 + this.location.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.deleted);
            result2 = result2 * 31 + (this.environmentName == null ? 0 : this.environmentName.hashCode());
            result2 = result2 * 31 + (this.environmentIcon == null ? 0 : this.environmentIcon.hashCode());
            result2 = result2 * 31 + this.iconData.hashCode();
            result2 = result2 * 31 + this.status.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.active);
            result2 = result2 * 31 + ((Object)this.actions).hashCode();
            result2 = result2 * 31 + ((Object)this.launchMethods).hashCode();
            result2 = result2 * 31 + (this.toolDescription == null ? 0 : this.toolDescription.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Project)) {
                return false;
            }
            Project project2 = (Project)other;
            if (!ProjectId.equals-impl0(this.projectId, project2.projectId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)project2.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.location, (Object)project2.location)) {
                return false;
            }
            if (this.deleted != project2.deleted) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.environmentName, (Object)project2.environmentName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.environmentIcon, (Object)project2.environmentIcon)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.iconData, (Object)project2.iconData)) {
                return false;
            }
            if (this.status != project2.status) {
                return false;
            }
            if (this.active != project2.active) {
                return false;
            }
            if (!Intrinsics.areEqual(this.actions, project2.actions)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.launchMethods, project2.launchMethods)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.toolDescription, (Object)project2.toolDescription);
        }

        public /* synthetic */ Project(String projectId, String name2, String location2, boolean deleted, String environmentName, Image environmentIcon, ProjectIconData iconData, ProjectStatus status2, boolean active2, List actions2, List launchMethods, InstalledToolViewState.ToolDescriptionViewState toolDescription, DefaultConstructorMarker $constructor_marker) {
            this(projectId, name2, location2, deleted, environmentName, environmentIcon, iconData, status2, active2, actions2, launchMethods, toolDescription);
        }

        public static sealed interface Action {

            public static final class GoToEnvironment
            implements Action {
                @NotNull
                private final DevEnvironmentId id;
                @NotNull
                private final String name;

                public GoToEnvironment(@NotNull DevEnvironmentId id, @NotNull String name2) {
                    Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                    Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                    this.id = id;
                    this.name = name2;
                }

                @NotNull
                public final DevEnvironmentId getId() {
                    return this.id;
                }

                @NotNull
                public final String getName() {
                    return this.name;
                }

                @NotNull
                public String toString() {
                    return "GoToEnvironment(id=" + this.id + ", name=" + this.name + ")";
                }

                public int hashCode() {
                    int result2 = this.id.hashCode();
                    result2 = result2 * 31 + this.name.hashCode();
                    return result2;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof GoToEnvironment)) {
                        return false;
                    }
                    GoToEnvironment goToEnvironment = (GoToEnvironment)other;
                    if (!Intrinsics.areEqual((Object)this.id, (Object)goToEnvironment.id)) {
                        return false;
                    }
                    return Intrinsics.areEqual((Object)this.name, (Object)goToEnvironment.name);
                }
            }

            public static final class Hide
            implements Action {
                @NotNull
                public static final Hide INSTANCE = new Hide();

                private Hide() {
                }

                @NotNull
                public String toString() {
                    return "Hide";
                }

                public int hashCode() {
                    return 1654734995;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Hide)) {
                        return false;
                    }
                    Hide cfr_ignored_0 = (Hide)other;
                    return true;
                }
            }

            public static final class OpenInFileManager
            implements Action {
                @NotNull
                private final Path path;

                public OpenInFileManager(@NotNull Path path2) {
                    Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                    this.path = path2;
                }

                @NotNull
                public final Path getPath() {
                    return this.path;
                }

                @NotNull
                public String toString() {
                    return "OpenInFileManager(path=" + this.path + ")";
                }

                public int hashCode() {
                    return this.path.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof OpenInFileManager)) {
                        return false;
                    }
                    OpenInFileManager openInFileManager = (OpenInFileManager)other;
                    return Intrinsics.areEqual((Object)this.path, (Object)openInFileManager.path);
                }
            }
        }
    }
}

