/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel.dialogs;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.api.ui.DescriptionTree;
import com.jetbrains.toolbox.viewmodel.dialogs.DialogViewModel;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfirmationDialogViewModel
implements DialogViewModel {
    @Nullable
    private final String providerName;
    @NotNull
    private final LocalizableString title;
    @NotNull
    private final List<DescriptionTree> content;
    @NotNull
    private final LocalizableString okButtonText;
    @NotNull
    private final LocalizableString cancelButtonText;
    @NotNull
    private final Function1<Boolean, Unit> answer;

    public ConfirmationDialogViewModel(@Nullable String providerName, @NotNull LocalizableString title2, @NotNull List<? extends DescriptionTree> content2, @NotNull LocalizableString okButtonText, @NotNull LocalizableString cancelButtonText, @NotNull Function1<? super Boolean, Unit> answer) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter(content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)okButtonText, (String)"okButtonText");
        Intrinsics.checkNotNullParameter((Object)cancelButtonText, (String)"cancelButtonText");
        Intrinsics.checkNotNullParameter(answer, (String)"answer");
        this.providerName = providerName;
        this.title = title2;
        this.content = content2;
        this.okButtonText = okButtonText;
        this.cancelButtonText = cancelButtonText;
        this.answer = answer;
    }

    @NotNull
    public final LocalizableString getTitle() {
        return this.title;
    }

    @NotNull
    public final List<DescriptionTree> getContent() {
        return this.content;
    }

    @NotNull
    public final LocalizableString getOkButtonText() {
        return this.okButtonText;
    }

    @NotNull
    public final LocalizableString getCancelButtonText() {
        return this.cancelButtonText;
    }

    @NotNull
    public final Function1<Boolean, Unit> getAnswer() {
        return this.answer;
    }

    @NotNull
    public String toString() {
        return "ConfirmationDialogViewModel(providerName=" + this.providerName + ", title=" + this.title + ", content=" + this.content + ", okButtonText=" + this.okButtonText + ", cancelButtonText=" + this.cancelButtonText + ", answer=" + this.answer + ")";
    }

    public int hashCode() {
        int result2 = this.providerName == null ? 0 : this.providerName.hashCode();
        result2 = result2 * 31 + this.title.hashCode();
        result2 = result2 * 31 + ((Object)this.content).hashCode();
        result2 = result2 * 31 + this.okButtonText.hashCode();
        result2 = result2 * 31 + this.cancelButtonText.hashCode();
        result2 = result2 * 31 + this.answer.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConfirmationDialogViewModel)) {
            return false;
        }
        ConfirmationDialogViewModel confirmationDialogViewModel = (ConfirmationDialogViewModel)other;
        if (!Intrinsics.areEqual((Object)this.providerName, (Object)confirmationDialogViewModel.providerName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.title, (Object)confirmationDialogViewModel.title)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.content, confirmationDialogViewModel.content)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.okButtonText, (Object)confirmationDialogViewModel.okButtonText)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.cancelButtonText, (Object)confirmationDialogViewModel.cancelButtonText)) {
            return false;
        }
        return Intrinsics.areEqual(this.answer, confirmationDialogViewModel.answer);
    }
}

