/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel.dialogs;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.api.ui.DescriptionTree;
import com.jetbrains.toolbox.manager.AlertLevel;
import com.jetbrains.toolbox.viewmodel.dialogs.DialogViewModel;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AlertDialogViewModel
implements DialogViewModel {
    @Nullable
    private final String providerName;
    @NotNull
    private final AlertLevel alertLevel;
    @NotNull
    private final LocalizableString title;
    @NotNull
    private final List<DescriptionTree> content;
    @NotNull
    private final LocalizableString okButtonText;
    @NotNull
    private final Function0<Unit> answer;

    public AlertDialogViewModel(@Nullable String providerName, @NotNull AlertLevel alertLevel, @NotNull LocalizableString title2, @NotNull List<? extends DescriptionTree> content2, @NotNull LocalizableString okButtonText, @NotNull Function0<Unit> answer) {
        Intrinsics.checkNotNullParameter((Object)((Object)alertLevel), (String)"alertLevel");
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter(content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)okButtonText, (String)"okButtonText");
        Intrinsics.checkNotNullParameter(answer, (String)"answer");
        this.providerName = providerName;
        this.alertLevel = alertLevel;
        this.title = title2;
        this.content = content2;
        this.okButtonText = okButtonText;
        this.answer = answer;
    }

    @Nullable
    public final String getProviderName() {
        return this.providerName;
    }

    @NotNull
    public final AlertLevel getAlertLevel() {
        return this.alertLevel;
    }

    @NotNull
    public final LocalizableString getTitle() {
        return this.title;
    }

    @NotNull
    public final List<DescriptionTree> getContent() {
        return this.content;
    }

    @NotNull
    public final LocalizableString getOkButtonText() {
        return this.okButtonText;
    }

    @NotNull
    public final Function0<Unit> getAnswer() {
        return this.answer;
    }

    @NotNull
    public String toString() {
        return "AlertDialogViewModel(providerName=" + this.providerName + ", alertLevel=" + this.alertLevel + ", title=" + this.title + ", content=" + this.content + ", okButtonText=" + this.okButtonText + ", answer=" + this.answer + ")";
    }

    public int hashCode() {
        int result2 = this.providerName == null ? 0 : this.providerName.hashCode();
        result2 = result2 * 31 + this.alertLevel.hashCode();
        result2 = result2 * 31 + this.title.hashCode();
        result2 = result2 * 31 + ((Object)this.content).hashCode();
        result2 = result2 * 31 + this.okButtonText.hashCode();
        result2 = result2 * 31 + this.answer.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AlertDialogViewModel)) {
            return false;
        }
        AlertDialogViewModel alertDialogViewModel = (AlertDialogViewModel)other;
        if (!Intrinsics.areEqual((Object)this.providerName, (Object)alertDialogViewModel.providerName)) {
            return false;
        }
        if (this.alertLevel != alertDialogViewModel.alertLevel) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.title, (Object)alertDialogViewModel.title)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.content, alertDialogViewModel.content)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.okButtonText, (Object)alertDialogViewModel.okButtonText)) {
            return false;
        }
        return Intrinsics.areEqual(this.answer, alertDialogViewModel.answer);
    }
}

