/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.viewmodel;

import com.jetbrains.toolbox.viewmodel.AvailablePluginViewState;
import com.jetbrains.toolbox.viewmodel.InstalledPluginViewState;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginsListViewState {
    private final boolean isLoading;
    @NotNull
    private final List<InstalledPluginViewState> installed;
    @NotNull
    private final List<AvailablePluginViewState> available;
    private final boolean updatesReadyToApply;

    public PluginsListViewState(boolean isLoading2, @NotNull List<InstalledPluginViewState> installed2, @NotNull List<AvailablePluginViewState> available2, boolean updatesReadyToApply) {
        Intrinsics.checkNotNullParameter(installed2, (String)"installed");
        Intrinsics.checkNotNullParameter(available2, (String)"available");
        this.isLoading = isLoading2;
        this.installed = installed2;
        this.available = available2;
        this.updatesReadyToApply = updatesReadyToApply;
    }

    public final boolean isLoading() {
        return this.isLoading;
    }

    @NotNull
    public final List<InstalledPluginViewState> getInstalled() {
        return this.installed;
    }

    @NotNull
    public final List<AvailablePluginViewState> getAvailable() {
        return this.available;
    }

    public final boolean getUpdatesReadyToApply() {
        return this.updatesReadyToApply;
    }

    @NotNull
    public String toString() {
        return "PluginsListViewState(isLoading=" + this.isLoading + ", installed=" + this.installed + ", available=" + this.available + ", updatesReadyToApply=" + this.updatesReadyToApply + ")";
    }

    public int hashCode() {
        int result2 = Boolean.hashCode(this.isLoading);
        result2 = result2 * 31 + ((Object)this.installed).hashCode();
        result2 = result2 * 31 + ((Object)this.available).hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.updatesReadyToApply);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PluginsListViewState)) {
            return false;
        }
        PluginsListViewState pluginsListViewState = (PluginsListViewState)other;
        if (this.isLoading != pluginsListViewState.isLoading) {
            return false;
        }
        if (!Intrinsics.areEqual(this.installed, pluginsListViewState.installed)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.available, pluginsListViewState.available)) {
            return false;
        }
        return this.updatesReadyToApply == pluginsListViewState.updatesReadyToApply;
    }
}

