/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ui.views;

import androidx.compose.foundation.layout.BoxKt;
import androidx.compose.foundation.layout.BoxScope;
import androidx.compose.foundation.layout.BoxScopeInstance;
import androidx.compose.foundation.layout.SizeKt;
import androidx.compose.material.TextKt;
import androidx.compose.runtime.Applier;
import androidx.compose.runtime.ComposablesKt;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.CompositionLocal;
import androidx.compose.runtime.CompositionLocalMap;
import androidx.compose.runtime.RecomposeScopeImplKt;
import androidx.compose.runtime.ScopeUpdateScope;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.runtime.Updater;
import androidx.compose.runtime.internal.ComposableLambdaKt;
import androidx.compose.ui.Alignment;
import androidx.compose.ui.ComposedModifierKt;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.layout.MeasurePolicy;
import androidx.compose.ui.node.ComposeUiNode;
import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.api.remoteDev.states.CustomRemoteEnvironmentState;
import com.jetbrains.toolbox.api.remoteDev.states.CustomRemoteEnvironmentStateV2;
import com.jetbrains.toolbox.api.remoteDev.states.EnvironmentStateIcons;
import com.jetbrains.toolbox.api.remoteDev.states.RemoteEnvironmentState;
import com.jetbrains.toolbox.api.remoteDev.states.StandardRemoteEnvironmentState;
import com.jetbrains.toolbox.api.ui.BuiltinActions;
import com.jetbrains.toolbox.gateway.states.AgentState;
import com.jetbrains.toolbox.gateway.states.StandardAgentState;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.i18n.gettext.I18n;
import com.jetbrains.toolbox.platform.image.ImageKey;
import com.jetbrains.toolbox.platform.images.GenericImageKeys;
import com.jetbrains.toolbox.ui.CommonLocalsKt;
import com.jetbrains.toolbox.ui.EnvironmentStateColorPaletteImplKt;
import com.jetbrains.toolbox.ui.components.ConnectionStatus;
import com.jetbrains.toolbox.ui.navigation.Navigator;
import com.jetbrains.toolbox.ui.navigation.NavigatorImplKt;
import com.jetbrains.toolbox.ui.navigation.Screen;
import com.jetbrains.toolbox.ui.views.GatewayUtilKt;
import com.jetbrains.toolbox.viewmodel.ActionModel;
import java.util.Set;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.crystal.IconKt;
import org.jetbrains.crystal.LinkKt;
import org.jetbrains.crystal.MenuItem;
import org.jetbrains.crystal.MenuSeparator;
import org.jetbrains.crystal.geometry.UnitKt;
import org.jetbrains.crystal.theme.LinkStyle;
import org.jetbrains.crystal.theme.ThemeColor;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\ngatewayUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 gatewayUtil.kt\ncom/jetbrains/toolbox/ui/views/GatewayUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CompositionLocal.kt\nandroidx/compose/runtime/CompositionLocal\n+ 4 Composer.kt\nandroidx/compose/runtime/ComposerKt\n*L\n1#1,144:1\n295#2,2:145\n295#2,2:147\n75#3:149\n75#3:150\n1247#4,6:151\n*S KotlinDebug\n*F\n+ 1 gatewayUtil.kt\ncom/jetbrains/toolbox/ui/views/GatewayUtilKt\n*L\n62#1:145,2\n74#1:147,2\n135#1:149\n136#1:150\n140#1:151,6\n*E\n"})
public final class GatewayUtilKt {
    @NotNull
    private static final Set<StandardAgentState> priorityAllowedAgentStates;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ConnectionStatus getConnectionStatus(@NotNull RemoteEnvironmentState envState, @NotNull AgentState agentState) {
        ConnectionStatus connectionStatus;
        block33: {
            block36: {
                RemoteEnvironmentState remoteEnvironmentState;
                block35: {
                    EnvironmentStateIcons environmentStateIcons;
                    ThemeColor themeColor;
                    ThemeColor themeColor2;
                    LocalizableString localizableString;
                    block30: {
                        void $this$firstOrNull$iv;
                        block34: {
                            EnvironmentStateIcons environmentStateIcons2;
                            ThemeColor themeColor3;
                            ThemeColor themeColor4;
                            LocalizableString localizableString2;
                            block29: {
                                void $this$firstOrNull$iv2;
                                block31: {
                                    block32: {
                                        boolean showAgentState;
                                        Intrinsics.checkNotNullParameter((Object)envState, (String)"envState");
                                        Intrinsics.checkNotNullParameter((Object)agentState, (String)"agentState");
                                        boolean bl = showAgentState = envState.isReachable() && (!envState.isPriorityShow() || CollectionsKt.contains((Iterable)priorityAllowedAgentStates, (Object)agentState));
                                        if (!showAgentState) break block31;
                                        if (!(agentState instanceof StandardAgentState)) break block32;
                                        switch (WhenMappings.$EnumSwitchMapping$0[((StandardAgentState)agentState).ordinal()]) {
                                            case 1: {
                                                connectionStatus = ConnectionStatus.NoAgent.INSTANCE;
                                                break block33;
                                            }
                                            case 2: {
                                                connectionStatus = ConnectionStatus.Disconnected.INSTANCE;
                                                break block33;
                                            }
                                            case 3: {
                                                connectionStatus = ConnectionStatus.Connecting.INSTANCE;
                                                break block33;
                                            }
                                            case 4: {
                                                connectionStatus = ConnectionStatus.Connected.INSTANCE;
                                                break block33;
                                            }
                                            case 5: {
                                                connectionStatus = ConnectionStatus.Error.INSTANCE;
                                                break block33;
                                            }
                                            default: {
                                                throw new NoWhenBranchMatchedException();
                                            }
                                        }
                                    }
                                    throw new NoWhenBranchMatchedException();
                                }
                                remoteEnvironmentState = envState;
                                if (!(remoteEnvironmentState instanceof CustomRemoteEnvironmentState)) break block34;
                                Iterable iterable = (Iterable)EnvironmentStateIcons.getEntries();
                                localizableString2 = LocalizableStringExKt.notr(((CustomRemoteEnvironmentState)envState).getLabel());
                                themeColor4 = EnvironmentStateColorPaletteImplKt.toThemeColor(((CustomRemoteEnvironmentState)envState).getColor().getBackgroundColor());
                                themeColor3 = EnvironmentStateColorPaletteImplKt.toThemeColor(((CustomRemoteEnvironmentState)envState).getColor().getForegroundColor());
                                boolean $i$f$firstOrNull = false;
                                for (Object element$iv : $this$firstOrNull$iv2) {
                                    EnvironmentStateIcons it = (EnvironmentStateIcons)element$iv;
                                    boolean bl = false;
                                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)((CustomRemoteEnvironmentState)envState).getIconId())) continue;
                                    environmentStateIcons2 = (EnvironmentStateIcons)element$iv;
                                    break block29;
                                }
                                environmentStateIcons2 = null;
                            }
                            EnvironmentStateIcons environmentStateIcons3 = environmentStateIcons2;
                            ThemeColor themeColor5 = themeColor3;
                            ThemeColor themeColor6 = themeColor4;
                            LocalizableString localizableString3 = localizableString2;
                            EnvironmentStateIcons environmentStateIcons4 = environmentStateIcons3;
                            if (environmentStateIcons4 == null) {
                                localizableString2 = localizableString3;
                                themeColor4 = themeColor6;
                                themeColor3 = themeColor5;
                                boolean bl = false;
                                Logger.INSTANCE.warn("Icon with id: " + ((CustomRemoteEnvironmentState)envState).getIconId() + " not found");
                                environmentStateIcons3 = EnvironmentStateIcons.NoIcon;
                                themeColor5 = themeColor3;
                                themeColor6 = themeColor4;
                                localizableString3 = localizableString2;
                                environmentStateIcons4 = environmentStateIcons3;
                            }
                            boolean bl = ((CustomRemoteEnvironmentState)envState).isReachable() && agentState == StandardAgentState.Connected;
                            EnvironmentStateIcons environmentStateIcons5 = environmentStateIcons4;
                            LocalizableString localizableString4 = localizableString3;
                            ThemeColor themeColor7 = themeColor6;
                            ThemeColor themeColor8 = themeColor5;
                            connectionStatus = new ConnectionStatus(themeColor8, themeColor7, localizableString4, environmentStateIcons5, bl);
                            break block33;
                        }
                        if (!(remoteEnvironmentState instanceof CustomRemoteEnvironmentStateV2)) break block35;
                        Iterable bl = (Iterable)EnvironmentStateIcons.getEntries();
                        localizableString = ((CustomRemoteEnvironmentStateV2)envState).getLabel();
                        themeColor2 = EnvironmentStateColorPaletteImplKt.toThemeColor(((CustomRemoteEnvironmentStateV2)envState).getColor().getBackgroundColor());
                        themeColor = EnvironmentStateColorPaletteImplKt.toThemeColor(((CustomRemoteEnvironmentStateV2)envState).getColor().getForegroundColor());
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            EnvironmentStateIcons it = (EnvironmentStateIcons)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getId(), (Object)((CustomRemoteEnvironmentStateV2)envState).getIconId())) continue;
                            environmentStateIcons = (EnvironmentStateIcons)element$iv;
                            break block30;
                        }
                        environmentStateIcons = null;
                    }
                    EnvironmentStateIcons environmentStateIcons6 = environmentStateIcons;
                    ThemeColor themeColor9 = themeColor;
                    ThemeColor themeColor10 = themeColor2;
                    LocalizableString localizableString5 = localizableString;
                    EnvironmentStateIcons environmentStateIcons7 = environmentStateIcons6;
                    if (environmentStateIcons7 == null) {
                        localizableString = localizableString5;
                        themeColor2 = themeColor10;
                        themeColor = themeColor9;
                        boolean bl = false;
                        Logger.INSTANCE.warn("Icon with id: " + ((CustomRemoteEnvironmentStateV2)envState).getIconId() + " not found");
                        environmentStateIcons6 = EnvironmentStateIcons.NoIcon;
                        themeColor9 = themeColor;
                        themeColor10 = themeColor2;
                        localizableString5 = localizableString;
                        environmentStateIcons7 = environmentStateIcons6;
                    }
                    boolean bl = ((CustomRemoteEnvironmentStateV2)envState).isReachable() && agentState == StandardAgentState.Connected;
                    EnvironmentStateIcons environmentStateIcons8 = environmentStateIcons7;
                    LocalizableString localizableString6 = localizableString5;
                    ThemeColor themeColor11 = themeColor10;
                    ThemeColor themeColor12 = themeColor9;
                    connectionStatus = new ConnectionStatus(themeColor12, themeColor11, localizableString6, environmentStateIcons8, bl);
                    break block33;
                }
                if (!(remoteEnvironmentState instanceof StandardRemoteEnvironmentState)) break block36;
                switch (WhenMappings.$EnumSwitchMapping$1[((StandardRemoteEnvironmentState)envState).ordinal()]) {
                    case 1: {
                        connectionStatus = ConnectionStatus.Active.INSTANCE;
                        break block33;
                    }
                    case 2: {
                        connectionStatus = ConnectionStatus.Error.INSTANCE;
                        break block33;
                    }
                    case 3: {
                        connectionStatus = ConnectionStatus.Unreachable.INSTANCE;
                        break block33;
                    }
                    case 4: {
                        connectionStatus = ConnectionStatus.Hibernated.INSTANCE;
                        break block33;
                    }
                    case 5: {
                        connectionStatus = ConnectionStatus.Restarting.INSTANCE;
                        break block33;
                    }
                    case 6: {
                        connectionStatus = ConnectionStatus.Initializing.INSTANCE;
                        break block33;
                    }
                    case 7: {
                        connectionStatus = ConnectionStatus.Activating.INSTANCE;
                        break block33;
                    }
                    case 8: {
                        connectionStatus = ConnectionStatus.Unhealthy.INSTANCE;
                        break block33;
                    }
                    case 9: {
                        connectionStatus = ConnectionStatus.Hibernating.INSTANCE;
                        break block33;
                    }
                    case 10: {
                        connectionStatus = ConnectionStatus.Deleting.INSTANCE;
                        break block33;
                    }
                    case 11: {
                        connectionStatus = ConnectionStatus.Deleted.INSTANCE;
                        break block33;
                    }
                    case 12: {
                        connectionStatus = ConnectionStatus.Failed.INSTANCE;
                        break block33;
                    }
                    case 13: {
                        connectionStatus = ConnectionStatus.FailedToStart.INSTANCE;
                        break block33;
                    }
                    case 14: {
                        connectionStatus = ConnectionStatus.Created.INSTANCE;
                        break block33;
                    }
                    case 15: {
                        connectionStatus = ConnectionStatus.Inactive.INSTANCE;
                        break block33;
                    }
                    case 16: {
                        connectionStatus = ConnectionStatus.PreparingTool.INSTANCE;
                        break block33;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return connectionStatus;
    }

    @NotNull
    public static final MenuItem asMenuItem(@NotNull ActionModel $this$asMenuItem, @NotNull I18n i18n, @NotNull Function0<Unit> onClick2) {
        MenuItem menuItem;
        Intrinsics.checkNotNullParameter((Object)$this$asMenuItem, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        Intrinsics.checkNotNullParameter(onClick2, (String)"onClick");
        if ($this$asMenuItem.getDelimiter()) {
            menuItem = new MenuSeparator();
        } else if ($this$asMenuItem.getToggle() != null) {
            MutableStateFlow mutableStateFlow = $this$asMenuItem.getToggle();
            if (mutableStateFlow == null) {
                ActionModel $this$asMenuItem_u24lambda_u241 = $this$asMenuItem;
                boolean bl = false;
                Logger.INSTANCE.error("Toggle action doesn't have a toggle state");
                mutableStateFlow = StateFlowKt.MutableStateFlow((Object)false);
            }
            MutableStateFlow toggleState = mutableStateFlow;
            String string = $this$asMenuItem.getText() + "-toggle";
            menuItem = new MenuItem(false, false, false, () -> GatewayUtilKt.asMenuItem$lambda$2(toggleState), null, string, null, ComposableLambdaKt.composableLambdaInstance(2113583252, true, new Function3<Boolean, Composer, Integer, Unit>((MutableStateFlow<Boolean>)toggleState, i18n, $this$asMenuItem){
                final /* synthetic */ MutableStateFlow<Boolean> $toggleState;
                final /* synthetic */ I18n $i18n;
                final /* synthetic */ ActionModel $this_asMenuItem;
                {
                    this.$toggleState = $toggleState;
                    this.$i18n = $i18n;
                    this.$this_asMenuItem = $receiver;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(boolean it, Composer $composer, int $changed) {
                    ComposerKt.sourceInformation($composer, "C113@5411L16,114@5434L19:gatewayUtil.kt#ikvrdg");
                    if ($composer.shouldExecute(($changed & 0x11) != 16, $changed & 1)) {
                        if (ComposerKt.isTraceInProgress()) {
                            ComposerKt.traceEventStart(2113583252, $changed, -1, "com.jetbrains.toolbox.ui.views.asMenuItem.<anonymous> (gatewayUtil.kt:113)");
                        }
                        State<Boolean> currentToggleState$delegate = SnapshotStateKt.collectAsState((StateFlow)this.$toggleState, null, $composer, 0, 1);
                        TextKt.Text--4IGK_g(this.$i18n.tr(this.$this_asMenuItem.getText()), null, 0L, 0L, null, null, null, 0L, null, null, 0L, 0, false, 0, 0, null, null, $composer, 0, 0, 131070);
                        if (asMenuItem.3.invoke$lambda$0(currentToggleState$delegate)) {
                            void $composer2;
                            void $changed$iv$iv$iv;
                            void $changed$iv$iv;
                            void modifier$iv$iv;
                            void modifier$iv;
                            void contentAlignment$iv;
                            void $composer$iv;
                            $composer.startReplaceGroup(1538224974);
                            ComposerKt.sourceInformation($composer, "116@5494L174");
                            Modifier modifier2 = SizeKt.fillMaxWidth$default(Modifier.Companion, 0.0f, 1, null);
                            Alignment alignment = Alignment.Companion.getCenterEnd();
                            Composer composer = $composer;
                            int $changed$iv = 54;
                            boolean $i$f$Box = false;
                            ComposerKt.sourceInformationMarkerStart((Composer)$composer$iv, 1042775818, "CC(Box)P(2,1,3)71@3423L130:Box.kt#2w3rfo");
                            boolean propagateMinConstraints$iv = false;
                            MeasurePolicy measurePolicy$iv = BoxKt.maybeCachedBoxMeasurePolicy((Alignment)contentAlignment$iv, propagateMinConstraints$iv);
                            void var12_12 = modifier$iv;
                            int n = 0x70 & $changed$iv << 3;
                            boolean $i$f$Layout = false;
                            ComposerKt.sourceInformationMarkerStart((Composer)$composer$iv, -1159599143, "CC(Layout)P(!1,2)79@3206L23,82@3357L359:Layout.kt#80mrfh");
                            int compositeKeyHash$iv$iv = ComposablesKt.getCurrentCompositeKeyHash((Composer)$composer$iv, 0);
                            CompositionLocalMap localMap$iv$iv = $composer$iv.getCurrentCompositionLocalMap();
                            Modifier materialized$iv$iv = ComposedModifierKt.materializeModifier((Composer)$composer$iv, (Modifier)modifier$iv$iv);
                            Function0<ComposeUiNode> function0 = ComposeUiNode.Companion.getConstructor();
                            int n2 = 6 | 0x380 & $changed$iv$iv << 6;
                            boolean $i$f$ReusableComposeNode = false;
                            ComposerKt.sourceInformationMarkerStart((Composer)$composer$iv, -553112988, "CC(ReusableComposeNode)P(1,2)355@14017L9:Composables.kt#9igjgp");
                            if (!($composer$iv.getApplier() instanceof Applier)) {
                                ComposablesKt.invalidApplier();
                            }
                            $composer$iv.startReusableNode();
                            if ($composer$iv.getInserting()) {
                                void factory$iv$iv$iv;
                                $composer$iv.createNode(factory$iv$iv$iv);
                            } else {
                                $composer$iv.useNode();
                            }
                            Composer $this$Layout_u24lambda_u240$iv$iv = Updater.constructor-impl((Composer)$composer$iv);
                            boolean bl = false;
                            Updater.set-impl($this$Layout_u24lambda_u240$iv$iv, measurePolicy$iv, ComposeUiNode.Companion.getSetMeasurePolicy());
                            Updater.set-impl($this$Layout_u24lambda_u240$iv$iv, localMap$iv$iv, ComposeUiNode.Companion.getSetResolvedCompositionLocals());
                            Function2<ComposeUiNode, Integer, Unit> block$iv$iv$iv = ComposeUiNode.Companion.getSetCompositeKeyHash();
                            boolean bl2 = false;
                            Composer $this$set_impl_u24lambda_u240$iv$iv$iv = $this$Layout_u24lambda_u240$iv$iv;
                            boolean bl3 = false;
                            if ($this$set_impl_u24lambda_u240$iv$iv$iv.getInserting() || !Intrinsics.areEqual((Object)$this$set_impl_u24lambda_u240$iv$iv$iv.rememberedValue(), (Object)compositeKeyHash$iv$iv)) {
                                $this$set_impl_u24lambda_u240$iv$iv$iv.updateRememberedValue(compositeKeyHash$iv$iv);
                                $this$Layout_u24lambda_u240$iv$iv.apply(compositeKeyHash$iv$iv, block$iv$iv$iv);
                            }
                            Updater.set-impl($this$Layout_u24lambda_u240$iv$iv, materialized$iv$iv, ComposeUiNode.Companion.getSetModifier());
                            int n3 = 0xE & $changed$iv$iv$iv >> 6;
                            void $composer$iv2 = $composer$iv;
                            boolean bl4 = false;
                            ComposerKt.sourceInformationMarkerStart((Composer)$composer$iv2, -2146730711, "C72@3468L9:Box.kt#2w3rfo");
                            int n4 = 6 | 0x70 & $changed$iv >> 6;
                            void var31_31 = $composer$iv2;
                            BoxScope $this$invoke_u24lambda_u241 = BoxScopeInstance.INSTANCE;
                            boolean bl5 = false;
                            ComposerKt.sourceInformationMarkerStart((Composer)$composer2, -2045054840, "C117@5586L72:gatewayUtil.kt#ikvrdg");
                            IconKt.Icon-JCyEnZY(GenericImageKeys.INSTANCE.getCheckmark(), null, 0.0f, SizeKt.size-3ABfNKs(Modifier.Companion, UnitKt.getUnit(2)), 0L, 0.0f, null, (Composer)$composer2, 0, 118);
                            ComposerKt.sourceInformationMarkerEnd((Composer)$composer2);
                            ComposerKt.sourceInformationMarkerEnd((Composer)$composer$iv2);
                            $composer$iv.endNode();
                            ComposerKt.sourceInformationMarkerEnd((Composer)$composer$iv);
                            ComposerKt.sourceInformationMarkerEnd((Composer)$composer$iv);
                            ComposerKt.sourceInformationMarkerEnd((Composer)$composer$iv);
                            $composer.endReplaceGroup();
                        } else {
                            $composer.startReplaceGroup(1532777902);
                            $composer.endReplaceGroup();
                        }
                        if (ComposerKt.isTraceInProgress()) {
                            ComposerKt.traceEventEnd();
                        }
                    } else {
                        $composer.skipToGroupEnd();
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                private static final boolean invoke$lambda$0(State<Boolean> $currentToggleState$delegate) {
                    void $this$getValue$iv;
                    State<Boolean> state2 = $currentToggleState$delegate;
                    Object var2_2 = null;
                    Object property$iv = null;
                    boolean $i$f$getValue = false;
                    return (Boolean)$this$getValue$iv.getValue();
                }
            }), 87, null);
        } else {
            String string = i18n.tr($this$asMenuItem.getText());
            boolean bl = $this$asMenuItem.getEnabled();
            boolean bl2 = $this$asMenuItem.getReadOnly();
            boolean bl3 = $this$asMenuItem.getDangerous();
            String string2 = i18n.tr($this$asMenuItem.getText());
            menuItem = new MenuItem(string, bl, bl2, bl3, string2, null, onClick2, 32, null);
        }
        return menuItem;
    }

    public static /* synthetic */ MenuItem asMenuItem$default(ActionModel actionModel, I18n i18n, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = () -> GatewayUtilKt.asMenuItem$lambda$0(actionModel);
        }
        return GatewayUtilKt.asMenuItem(actionModel, i18n, (Function0<Unit>)function0);
    }

    /*
     * WARNING - void declaration
     */
    public static final void BuiltinAction(@NotNull BuiltinActions action2, @Nullable Composer $composer, int $changed) {
        block9: {
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            $composer = $composer.startRestartGroup(122648641);
            ComposerKt.sourceInformation($composer, "C(BuiltinAction)134@5953L7,135@5994L7:gatewayUtil.kt#ikvrdg");
            int $dirty = $changed;
            if (($changed & 6) == 0) {
                $dirty |= $composer.changedInstance(action2) ? 4 : 2;
            }
            if ($composer.shouldExecute(($dirty & 3) != 2, $dirty & 1)) {
                Object object;
                LinkStyle linkStyle;
                boolean bl;
                Modifier modifier2;
                float f;
                float f2;
                ImageKey imageKey;
                boolean bl2;
                String string;
                Modifier modifier3;
                String string2;
                void this_$iv;
                void $composer$iv;
                void this_$iv2;
                CompositionLocal $composer$iv2;
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventStart(122648641, $dirty, -1, "com.jetbrains.toolbox.ui.views.BuiltinAction (gatewayUtil.kt:133)");
                }
                CompositionLocal compositionLocal = CommonLocalsKt.getLocalI18n();
                Composer composer = $composer;
                boolean $changed$iv22 = false;
                boolean $i$f$getCurrent = false;
                ComposerKt.sourceInformationMarkerStart((Composer)((Object)$composer$iv2), 2023513938, "CC(<get-current>):CompositionLocal.kt#9igjgp");
                Object t2 = $composer$iv2.consume(this_$iv2);
                ComposerKt.sourceInformationMarkerEnd((Composer)((Object)$composer$iv2));
                I18n i18n = (I18n)t2;
                $composer$iv2 = NavigatorImplKt.getLocalNavigator();
                Composer $changed$iv22 = $composer;
                int $changed$iv3 = 6;
                boolean $i$f$getCurrent2 = false;
                ComposerKt.sourceInformationMarkerStart((Composer)$composer$iv, 2023513938, "CC(<get-current>):CompositionLocal.kt#9igjgp");
                Object t3 = $composer$iv.consume(this_$iv);
                ComposerKt.sourceInformationMarkerEnd((Composer)$composer$iv);
                Navigator navigator = (Navigator)t3;
                if (Intrinsics.areEqual((Object)action2, (Object)BuiltinActions.OpenSettings.INSTANCE)) {
                    void $this$cache$iv;
                    $composer.startReplaceGroup(1901232526);
                    ComposerKt.sourceInformation($composer, "139@6116L41,137@6055L109");
                    string2 = i18n.tr("Open settings");
                    modifier3 = null;
                    string = null;
                    bl2 = false;
                    imageKey = null;
                    f2 = 0.0f;
                    f = 0.0f;
                    modifier2 = null;
                    bl = false;
                    linkStyle = null;
                    ComposerKt.sourceInformationMarkerStart($composer, 1901234410, "CC(remember):gatewayUtil.kt#9igjgp");
                    Composer $changed$iv3 = $composer;
                    boolean invalid$iv = $composer.changedInstance(navigator);
                    boolean $i$f$cache = false;
                    Object it$iv = $this$cache$iv.rememberedValue();
                    boolean bl3 = false;
                    if (invalid$iv || it$iv == Composer.Companion.getEmpty()) {
                        LinkStyle linkStyle2 = linkStyle;
                        boolean bl4 = bl;
                        Modifier modifier4 = modifier2;
                        float f3 = f;
                        float f4 = f2;
                        ImageKey imageKey2 = imageKey;
                        boolean bl5 = bl2;
                        String string3 = string;
                        Modifier modifier5 = modifier3;
                        String string4 = string2;
                        boolean bl6 = false;
                        Function0 function0 = () -> GatewayUtilKt.BuiltinAction$lambda$0$0(navigator);
                        string2 = string4;
                        modifier3 = modifier5;
                        string = string3;
                        bl2 = bl5;
                        imageKey = imageKey2;
                        f2 = f4;
                        f = f3;
                        modifier2 = modifier4;
                        bl = bl4;
                        linkStyle = linkStyle2;
                        Function0 value$iv = function0;
                        $this$cache$iv.updateRememberedValue(value$iv);
                        object = value$iv;
                    } else {
                        object = it$iv;
                    }
                } else {
                    $composer.startReplaceGroup(1901230949);
                    $composer.endReplaceGroup();
                    throw new NoWhenBranchMatchedException();
                }
                Function0 function0 = (Function0)object;
                ComposerKt.sourceInformationMarkerEnd($composer);
                LinkKt.Link-vCe147k(string2, modifier3, string, bl2, imageKey, f2, f, modifier2, bl, linkStyle, (Function0<Unit>)function0, $composer, 0, 0, 1022);
                $composer.endReplaceGroup();
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventEnd();
                }
            } else {
                $composer.skipToGroupEnd();
            }
            ScopeUpdateScope scopeUpdateScope = $composer.endRestartGroup();
            if (scopeUpdateScope == null) break block9;
            scopeUpdateScope.updateScope((Function2<? super Composer, ? super Integer, Unit>)((Function2)(arg_0, arg_1) -> GatewayUtilKt.BuiltinAction$lambda$1(action2, $changed, arg_0, arg_1)));
        }
    }

    private static final Unit asMenuItem$lambda$0(ActionModel $this_asMenuItem) {
        $this_asMenuItem.run();
        return Unit.INSTANCE;
    }

    private static final Unit asMenuItem$lambda$2(MutableStateFlow $toggleState) {
        $toggleState.setValue((Object)((Boolean)$toggleState.getValue() == false ? 1 : 0));
        return Unit.INSTANCE;
    }

    private static final Unit BuiltinAction$lambda$0$0(Navigator $navigator) {
        Navigator.navigate$default($navigator, new Screen.Settings(null, null, false, 7, null), false, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit BuiltinAction$lambda$1(BuiltinActions $action, int $$changed, Composer $composer, int $force) {
        GatewayUtilKt.BuiltinAction($action, $composer, RecomposeScopeImplKt.updateChangedFlags($$changed | 1));
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new StandardAgentState[]{StandardAgentState.Connecting, StandardAgentState.Connected, StandardAgentState.Error};
        priorityAllowedAgentStates = SetsKt.setOf((Object[])objectArray);
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[StandardAgentState.values().length];
            try {
                nArray[StandardAgentState.NoAgent.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StandardAgentState.Disconnected.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StandardAgentState.Connecting.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StandardAgentState.Connected.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StandardAgentState.Error.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[StandardRemoteEnvironmentState.values().length];
            try {
                nArray[StandardRemoteEnvironmentState.Active.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StandardRemoteEnvironmentState.Error.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StandardRemoteEnvironmentState.Unreachable.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StandardRemoteEnvironmentState.Hibernated.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StandardRemoteEnvironmentState.Restarting.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StandardRemoteEnvironmentState.Initializing.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StandardRemoteEnvironmentState.Activating.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StandardRemoteEnvironmentState.Unhealthy.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StandardRemoteEnvironmentState.Hibernating.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StandardRemoteEnvironmentState.Deleting.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StandardRemoteEnvironmentState.Deleted.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StandardRemoteEnvironmentState.Failed.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StandardRemoteEnvironmentState.FailedToStart.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StandardRemoteEnvironmentState.Created.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StandardRemoteEnvironmentState.Inactive.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StandardRemoteEnvironmentState.PreparingTool.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

