/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ui.navigation;

import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.feed.ApplicationType;
import com.jetbrains.toolbox.feed.WhatsNew;
import com.jetbrains.toolbox.gateway.DevEnvironmentId;
import com.jetbrains.toolbox.gateway.DevEnvironmentProviderId;
import com.jetbrains.toolbox.gateway.PluginId;
import com.jetbrains.toolbox.theme.BackgroundColors;
import com.jetbrains.toolbox.tools.model.ChannelId;
import com.jetbrains.toolbox.tools.model.ToolBuild;
import com.jetbrains.toolbox.tools.model.subscription.SubscriptionId;
import com.jetbrains.toolbox.ui.views.GatewayEnvironmentTab;
import com.jetbrains.toolbox.ui.views.settings.SettingsTabs;
import com.jetbrains.toolbox.ui.views.tools.available.ToolOverviewTabs;
import com.jetbrains.toolbox.viewmodel.DistributionId;
import com.jetbrains.toolbox.viewmodel.GatewayUiPageViewModel;
import com.jetbrains.toolbox.viewmodel.tools.InstalledToolData;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.crystal.animations.HighlightTarget;

public abstract sealed class Screen {
    private final boolean allowNavigation;

    private Screen(boolean allowNavigation) {
        this.allowNavigation = allowNavigation;
    }

    public /* synthetic */ Screen(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl, null);
    }

    public final boolean getAllowNavigation() {
        return this.allowNavigation;
    }

    @NotNull
    public abstract String getId();

    public /* synthetic */ Screen(boolean allowNavigation, DefaultConstructorMarker $constructor_marker) {
        this(allowNavigation);
    }

    public static final class EndUserAgreement
    extends Screen {
        @NotNull
        public static final EndUserAgreement INSTANCE = new EndUserAgreement();

        private EndUserAgreement() {
            super(false, null);
        }

        @Override
        @NotNull
        public String getId() {
            return "JetBrains User Agreement";
        }

        @NotNull
        public String toString() {
            return "EndUserAgreement";
        }

        public int hashCode() {
            return 473354406;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EndUserAgreement)) {
                return false;
            }
            EndUserAgreement cfr_ignored_0 = (EndUserAgreement)other;
            return true;
        }
    }

    public static final class FrontendToolsCleanup
    extends Screen {
        @NotNull
        public static final FrontendToolsCleanup INSTANCE = new FrontendToolsCleanup();

        private FrontendToolsCleanup() {
            super(false, 1, null);
        }

        @Override
        @NotNull
        public String getId() {
            return "Frontend Tools cleanup";
        }

        @NotNull
        public String toString() {
            return "FrontendToolsCleanup";
        }

        public int hashCode() {
            return -1591647811;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FrontendToolsCleanup)) {
                return false;
            }
            FrontendToolsCleanup cfr_ignored_0 = (FrontendToolsCleanup)other;
            return true;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class GatewayAboutPlugin
    extends Screen {
        @NotNull
        private final String pluginId;

        private GatewayAboutPlugin(String pluginId) {
            Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
            super(false, 1, null);
            this.pluginId = pluginId;
        }

        @NotNull
        public final String getPluginId-NE1ku3Q() {
            return this.pluginId;
        }

        @Override
        @NotNull
        public String getId() {
            return "GatewayAvailablePlugin: " + PluginId.toString-impl(this.pluginId);
        }

        @NotNull
        public String toString() {
            return "GatewayAboutPlugin(pluginId=" + PluginId.toString-impl(this.pluginId) + ")";
        }

        public int hashCode() {
            return PluginId.hashCode-impl(this.pluginId);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GatewayAboutPlugin)) {
                return false;
            }
            GatewayAboutPlugin gatewayAboutPlugin = (GatewayAboutPlugin)other;
            return PluginId.equals-impl0(this.pluginId, gatewayAboutPlugin.pluginId);
        }

        public /* synthetic */ GatewayAboutPlugin(String pluginId, DefaultConstructorMarker $constructor_marker) {
            this(pluginId);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class GatewayEnvironment
    extends Screen
    implements RemoteEnvironmentScreen,
    RemoteScreen {
        @NotNull
        private final DevEnvironmentId devEnvironmentId;
        @NotNull
        private final GatewayEnvironmentTab initialSelectedTab;
        @Nullable
        private final HighlightTarget initialHighlightedElement;
        @NotNull
        private final MutableState<GatewayEnvironmentTab> observableSelectedTab;
        @NotNull
        private final MutableState<HighlightTarget> observableHighlightedElement;
        public static final int $stable = 8;

        public GatewayEnvironment(@NotNull DevEnvironmentId devEnvironmentId, @NotNull GatewayEnvironmentTab initialSelectedTab, @Nullable HighlightTarget initialHighlightedElement) {
            Intrinsics.checkNotNullParameter((Object)devEnvironmentId, (String)"devEnvironmentId");
            Intrinsics.checkNotNullParameter((Object)((Object)initialSelectedTab), (String)"initialSelectedTab");
            super(false, 1, null);
            this.devEnvironmentId = devEnvironmentId;
            this.initialSelectedTab = initialSelectedTab;
            this.initialHighlightedElement = initialHighlightedElement;
            this.observableSelectedTab = SnapshotStateKt.mutableStateOf$default((Object)this.initialSelectedTab, null, 2, null);
            this.observableHighlightedElement = SnapshotStateKt.mutableStateOf$default(this.initialHighlightedElement, null, 2, null);
        }

        public /* synthetic */ GatewayEnvironment(DevEnvironmentId devEnvironmentId, GatewayEnvironmentTab gatewayEnvironmentTab, HighlightTarget highlightTarget, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                gatewayEnvironmentTab = GatewayEnvironmentTab.Tools;
            }
            if ((n & 4) != 0) {
                highlightTarget = null;
            }
            this(devEnvironmentId, gatewayEnvironmentTab, highlightTarget);
        }

        @Override
        @NotNull
        public DevEnvironmentId getDevEnvironmentId() {
            return this.devEnvironmentId;
        }

        @NotNull
        public final GatewayEnvironmentTab getInitialSelectedTab$ui() {
            return this.initialSelectedTab;
        }

        @Override
        @NotNull
        public String getId() {
            return "GatewayEnvironment-" + this.getDevEnvironmentId();
        }

        @Override
        @NotNull
        public String getProviderId-rwbms5E() {
            return this.getDevEnvironmentId().getProviderId-rwbms5E();
        }

        @NotNull
        public final MutableState<GatewayEnvironmentTab> getObservableSelectedTab$ui() {
            return this.observableSelectedTab;
        }

        @NotNull
        public final MutableState<HighlightTarget> getObservableHighlightedElement$ui() {
            return this.observableHighlightedElement;
        }

        @NotNull
        public String toString() {
            return "GatewayEnvironment(devEnvironmentId=" + this.devEnvironmentId + ", initialSelectedTab=" + this.initialSelectedTab + ", initialHighlightedElement=" + this.initialHighlightedElement + ")";
        }

        public int hashCode() {
            int result2 = this.devEnvironmentId.hashCode();
            result2 = result2 * 31 + this.initialSelectedTab.hashCode();
            result2 = result2 * 31 + (this.initialHighlightedElement == null ? 0 : this.initialHighlightedElement.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GatewayEnvironment)) {
                return false;
            }
            GatewayEnvironment gatewayEnvironment = (GatewayEnvironment)other;
            if (!Intrinsics.areEqual((Object)this.devEnvironmentId, (Object)gatewayEnvironment.devEnvironmentId)) {
                return false;
            }
            if (this.initialSelectedTab != gatewayEnvironment.initialSelectedTab) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.initialHighlightedElement, (Object)gatewayEnvironment.initialHighlightedElement);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class GatewayErrorMoreInfo
    extends Screen {
        @NotNull
        private final String providerId;
        @NotNull
        private final BackgroundColors backgroundColors;
        @NotNull
        private final Throwable error;
        @NotNull
        private final Function0<Unit> restartAction;
        public static final int $stable = 8;

        private GatewayErrorMoreInfo(String providerId, BackgroundColors backgroundColors, Throwable error2, Function0<Unit> restartAction) {
            Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
            Intrinsics.checkNotNullParameter((Object)backgroundColors, (String)"backgroundColors");
            Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
            Intrinsics.checkNotNullParameter(restartAction, (String)"restartAction");
            super(false, 1, null);
            this.providerId = providerId;
            this.backgroundColors = backgroundColors;
            this.error = error2;
            this.restartAction = restartAction;
        }

        @NotNull
        public final String getProviderId-rwbms5E() {
            return this.providerId;
        }

        @NotNull
        public final BackgroundColors getBackgroundColors() {
            return this.backgroundColors;
        }

        @NotNull
        public final Throwable getError() {
            return this.error;
        }

        @NotNull
        public final Function0<Unit> getRestartAction() {
            return this.restartAction;
        }

        @Override
        @NotNull
        public String getId() {
            return "GatewayErrorMoreInfo-" + this.providerId + "-" + this.error.hashCode();
        }

        @NotNull
        public String toString() {
            return "GatewayErrorMoreInfo(providerId=" + DevEnvironmentProviderId.toString-impl(this.providerId) + ", backgroundColors=" + this.backgroundColors + ", error=" + this.error + ", restartAction=" + this.restartAction + ")";
        }

        public int hashCode() {
            int result2 = DevEnvironmentProviderId.hashCode-impl(this.providerId);
            result2 = result2 * 31 + this.backgroundColors.hashCode();
            result2 = result2 * 31 + this.error.hashCode();
            result2 = result2 * 31 + this.restartAction.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GatewayErrorMoreInfo)) {
                return false;
            }
            GatewayErrorMoreInfo gatewayErrorMoreInfo = (GatewayErrorMoreInfo)other;
            if (!DevEnvironmentProviderId.equals-impl0(this.providerId, gatewayErrorMoreInfo.providerId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.backgroundColors, (Object)gatewayErrorMoreInfo.backgroundColors)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.error, (Object)gatewayErrorMoreInfo.error)) {
                return false;
            }
            return Intrinsics.areEqual(this.restartAction, gatewayErrorMoreInfo.restartAction);
        }

        public /* synthetic */ GatewayErrorMoreInfo(String providerId, BackgroundColors backgroundColors, Throwable error2, Function0 restartAction, DefaultConstructorMarker $constructor_marker) {
            this(providerId, backgroundColors, error2, (Function0<Unit>)restartAction);
        }
    }

    public static final class GatewayPlugins
    extends Screen {
        @NotNull
        public static final GatewayPlugins INSTANCE = new GatewayPlugins();

        private GatewayPlugins() {
            super(false, 1, null);
        }

        @Override
        @NotNull
        public String getId() {
            return "GatewayPlugins";
        }

        @NotNull
        public String toString() {
            return "GatewayPlugins";
        }

        public int hashCode() {
            return -1867452290;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GatewayPlugins)) {
                return false;
            }
            GatewayPlugins cfr_ignored_0 = (GatewayPlugins)other;
            return true;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class GatewayProvider
    extends Screen
    implements RemoteScreen,
    TopLevelScreen {
        @NotNull
        private final String providerId;
        private final boolean initialExpanded;
        @NotNull
        private final MutableSharedFlow<Boolean> refresh;
        @NotNull
        private final MutableStateFlow<BuildNumber> pluginVersion;
        public static final int $stable = 8;

        private GatewayProvider(String providerId, boolean initialExpanded) {
            Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
            super(false, 1, null);
            this.providerId = providerId;
            this.initialExpanded = initialExpanded;
            this.refresh = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)1, null);
            this.pluginVersion = StateFlowKt.MutableStateFlow((Object)BuildNumber.box-impl(BuildNumber.Companion.getZERO-Y_E1uuk()));
        }

        public /* synthetic */ GatewayProvider(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            this(string, bl, null);
        }

        @Override
        @NotNull
        public String getProviderId-rwbms5E() {
            return this.providerId;
        }

        public final boolean getInitialExpanded() {
            return this.initialExpanded;
        }

        @Override
        @NotNull
        public String getId() {
            return "GatewayProvider-" + DevEnvironmentProviderId.toString-impl(this.getProviderId-rwbms5E());
        }

        @NotNull
        public final MutableSharedFlow<Boolean> getRefresh() {
            return this.refresh;
        }

        @NotNull
        public final MutableStateFlow<BuildNumber> getPluginVersion() {
            return this.pluginVersion;
        }

        @NotNull
        public String toString() {
            return "GatewayProvider(providerId=" + DevEnvironmentProviderId.toString-impl(this.providerId) + ", initialExpanded=" + this.initialExpanded + ")";
        }

        public int hashCode() {
            int result2 = DevEnvironmentProviderId.hashCode-impl(this.providerId);
            result2 = result2 * 31 + Boolean.hashCode(this.initialExpanded);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GatewayProvider)) {
                return false;
            }
            GatewayProvider gatewayProvider = (GatewayProvider)other;
            if (!DevEnvironmentProviderId.equals-impl0(this.providerId, gatewayProvider.providerId)) {
                return false;
            }
            return this.initialExpanded == gatewayProvider.initialExpanded;
        }

        public /* synthetic */ GatewayProvider(String providerId, boolean initialExpanded, DefaultConstructorMarker $constructor_marker) {
            this(providerId, initialExpanded);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class GatewayUiPage
    extends Screen
    implements RemoteScreen {
        @NotNull
        private final String providerId;
        @NotNull
        private final GatewayUiPageViewModel pageModel;

        private GatewayUiPage(String providerId, GatewayUiPageViewModel pageModel) {
            Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
            Intrinsics.checkNotNullParameter((Object)pageModel, (String)"pageModel");
            super(false, 1, null);
            this.providerId = providerId;
            this.pageModel = pageModel;
        }

        @Override
        @NotNull
        public String getProviderId-rwbms5E() {
            return this.providerId;
        }

        @NotNull
        public final GatewayUiPageViewModel getPageModel() {
            return this.pageModel;
        }

        @Override
        @NotNull
        public String getId() {
            return "GatewayUiPage-" + DevEnvironmentProviderId.toString-impl(this.getProviderId-rwbms5E()) + "-" + this.pageModel.getPageWrapper().getTitle().getValue();
        }

        @NotNull
        public String toString() {
            return "GatewayUiPage(providerId=" + DevEnvironmentProviderId.toString-impl(this.providerId) + ", pageModel=" + this.pageModel + ")";
        }

        public int hashCode() {
            int result2 = DevEnvironmentProviderId.hashCode-impl(this.providerId);
            result2 = result2 * 31 + this.pageModel.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GatewayUiPage)) {
                return false;
            }
            GatewayUiPage gatewayUiPage = (GatewayUiPage)other;
            if (!DevEnvironmentProviderId.equals-impl0(this.providerId, gatewayUiPage.providerId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.pageModel, (Object)gatewayUiPage.pageModel);
        }

        public /* synthetic */ GatewayUiPage(String providerId, GatewayUiPageViewModel pageModel, DefaultConstructorMarker $constructor_marker) {
            this(providerId, pageModel);
        }
    }

    public static final class InstalledToolMeta
    extends Screen
    implements RemoteEnvironmentScreen {
        @Nullable
        private final DevEnvironmentId devEnvironmentId;
        @NotNull
        private final InstalledToolData data;
        public static final int $stable = 8;

        public InstalledToolMeta(@Nullable DevEnvironmentId devEnvironmentId, @NotNull InstalledToolData data2) {
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            super(false, 1, null);
            this.devEnvironmentId = devEnvironmentId;
            this.data = data2;
        }

        @Override
        @Nullable
        public DevEnvironmentId getDevEnvironmentId() {
            return this.devEnvironmentId;
        }

        @NotNull
        public final InstalledToolData getData() {
            return this.data;
        }

        @Override
        @NotNull
        public String getId() {
            return ChannelId.toString-impl(this.data.getChannelId-5CZByfs());
        }

        @NotNull
        public String toString() {
            return "InstalledToolMeta(devEnvironmentId=" + this.devEnvironmentId + ", data=" + this.data + ")";
        }

        public int hashCode() {
            int result2 = this.devEnvironmentId == null ? 0 : this.devEnvironmentId.hashCode();
            result2 = result2 * 31 + this.data.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InstalledToolMeta)) {
                return false;
            }
            InstalledToolMeta installedToolMeta2 = (InstalledToolMeta)other;
            if (!Intrinsics.areEqual((Object)this.devEnvironmentId, (Object)installedToolMeta2.devEnvironmentId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.data, (Object)installedToolMeta2.data);
        }
    }

    public static final class KitchenSink
    extends Screen {
        @NotNull
        public static final KitchenSink INSTANCE = new KitchenSink();

        private KitchenSink() {
            super(false, 1, null);
        }

        @Override
        @NotNull
        public String getId() {
            return "Kitchen Sink";
        }

        @NotNull
        public String toString() {
            return "KitchenSink";
        }

        public int hashCode() {
            return 1850352597;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof KitchenSink)) {
                return false;
            }
            KitchenSink cfr_ignored_0 = (KitchenSink)other;
            return true;
        }
    }

    public static final class LeftoverIDEDirectories
    extends Screen
    implements RemoteEnvironmentScreen {
        @Nullable
        private final DevEnvironmentId devEnvironmentId;
        public static final int $stable = 8;

        public LeftoverIDEDirectories(@Nullable DevEnvironmentId devEnvironmentId) {
            super(false, 1, null);
            this.devEnvironmentId = devEnvironmentId;
        }

        @Override
        @Nullable
        public DevEnvironmentId getDevEnvironmentId() {
            return this.devEnvironmentId;
        }

        @Override
        @NotNull
        public String getId() {
            return "Leftover Directories";
        }

        @NotNull
        public String toString() {
            return "LeftoverIDEDirectories(devEnvironmentId=" + this.devEnvironmentId + ")";
        }

        public int hashCode() {
            return this.devEnvironmentId == null ? 0 : this.devEnvironmentId.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LeftoverIDEDirectories)) {
                return false;
            }
            LeftoverIDEDirectories leftoverIDEDirectories = (LeftoverIDEDirectories)other;
            return Intrinsics.areEqual((Object)this.devEnvironmentId, (Object)leftoverIDEDirectories.devEnvironmentId);
        }
    }

    public static final class LicenseAgreement
    extends Screen {
        @NotNull
        private final com.jetbrains.toolbox.feed.LicenseAgreement licenseAgreement;
        @NotNull
        private final String toolName;
        public static final int $stable = 8;

        public LicenseAgreement(@NotNull com.jetbrains.toolbox.feed.LicenseAgreement licenseAgreement, @NotNull String toolName) {
            Intrinsics.checkNotNullParameter((Object)licenseAgreement, (String)"licenseAgreement");
            Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
            super(false, 1, null);
            this.licenseAgreement = licenseAgreement;
            this.toolName = toolName;
        }

        @NotNull
        public final com.jetbrains.toolbox.feed.LicenseAgreement getLicenseAgreement() {
            return this.licenseAgreement;
        }

        @NotNull
        public final String getToolName() {
            return this.toolName;
        }

        @Override
        @NotNull
        public String getId() {
            return "License Agreement for " + this.toolName;
        }

        @NotNull
        public String toString() {
            return "LicenseAgreement(licenseAgreement=" + this.licenseAgreement + ", toolName=" + this.toolName + ")";
        }

        public int hashCode() {
            int result2 = this.licenseAgreement.hashCode();
            result2 = result2 * 31 + this.toolName.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LicenseAgreement)) {
                return false;
            }
            LicenseAgreement licenseAgreement = (LicenseAgreement)other;
            if (!Intrinsics.areEqual((Object)this.licenseAgreement, (Object)licenseAgreement.licenseAgreement)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.toolName, (Object)licenseAgreement.toolName);
        }
    }

    public static final class Main
    extends Screen
    implements TopLevelScreen {
        @NotNull
        public static final Main INSTANCE = new Main();

        private Main() {
            super(false, 1, null);
        }

        @Override
        @NotNull
        public String getId() {
            return "Main";
        }

        @NotNull
        public String toString() {
            return "Main";
        }

        public int hashCode() {
            return -1044681733;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Main)) {
                return false;
            }
            Main cfr_ignored_0 = (Main)other;
            return true;
        }
    }

    public static final class McpServerDetails
    extends Screen {
        @Nullable
        private final Integer eid;
        @NotNull
        private final String id;

        public McpServerDetails(@Nullable Integer eid2) {
            super(false, 1, null);
            this.eid = eid2;
            this.id = "McpServerDetails-" + this.eid;
        }

        @Nullable
        public final Integer getEid() {
            return this.eid;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @NotNull
        public String toString() {
            return "McpServerDetails(eid=" + this.eid + ")";
        }

        public int hashCode() {
            return this.eid == null ? 0 : ((Object)this.eid).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof McpServerDetails)) {
                return false;
            }
            McpServerDetails mcpServerDetails = (McpServerDetails)other;
            return Intrinsics.areEqual((Object)this.eid, (Object)mcpServerDetails.eid);
        }
    }

    public static final class ModalAction
    extends Screen {
        @NotNull
        private final String message;

        public ModalAction(@NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            super(false, null);
            this.message = message2;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public String getId() {
            return this.message;
        }

        @NotNull
        public String toString() {
            return "ModalAction(message=" + this.message + ")";
        }

        public int hashCode() {
            return this.message.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModalAction)) {
                return false;
            }
            ModalAction modalAction = (ModalAction)other;
            return Intrinsics.areEqual((Object)this.message, (Object)modalAction.message);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class NewAvailableTool
    extends Screen
    implements RemoteEnvironmentScreen {
        @Nullable
        private final DevEnvironmentId devEnvironmentId;
        @NotNull
        private final String toolId;
        @NotNull
        private final String toolName;
        @NotNull
        private final ToolOverviewTabs initialSelectedTab;
        @NotNull
        private final MutableState<ToolOverviewTabs> observableSelectedTab;
        public static final int $stable = 8;

        private NewAvailableTool(DevEnvironmentId devEnvironmentId, String toolId, String toolName, ToolOverviewTabs initialSelectedTab) {
            Intrinsics.checkNotNullParameter((Object)toolId, (String)"toolId");
            Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
            Intrinsics.checkNotNullParameter((Object)((Object)initialSelectedTab), (String)"initialSelectedTab");
            super(false, 1, null);
            this.devEnvironmentId = devEnvironmentId;
            this.toolId = toolId;
            this.toolName = toolName;
            this.initialSelectedTab = initialSelectedTab;
            this.observableSelectedTab = SnapshotStateKt.mutableStateOf$default((Object)this.initialSelectedTab, null, 2, null);
        }

        public /* synthetic */ NewAvailableTool(DevEnvironmentId devEnvironmentId, String string, String string2, ToolOverviewTabs toolOverviewTabs, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                toolOverviewTabs = ToolOverviewTabs.Overview;
            }
            this(devEnvironmentId, string, string2, toolOverviewTabs, null);
        }

        @Override
        @Nullable
        public DevEnvironmentId getDevEnvironmentId() {
            return this.devEnvironmentId;
        }

        @NotNull
        public final String getToolId-UtVBrGo() {
            return this.toolId;
        }

        @NotNull
        public final String getToolName() {
            return this.toolName;
        }

        @NotNull
        public final ToolOverviewTabs getInitialSelectedTab$ui() {
            return this.initialSelectedTab;
        }

        @Override
        @NotNull
        public String getId() {
            return "Available " + ApplicationType.toString-impl(this.toolId);
        }

        @NotNull
        public final MutableState<ToolOverviewTabs> getObservableSelectedTab$ui() {
            return this.observableSelectedTab;
        }

        @NotNull
        public String toString() {
            return "NewAvailableTool(devEnvironmentId=" + this.devEnvironmentId + ", toolId=" + ApplicationType.toString-impl(this.toolId) + ", toolName=" + this.toolName + ", initialSelectedTab=" + this.initialSelectedTab + ")";
        }

        public int hashCode() {
            int result2 = this.devEnvironmentId == null ? 0 : this.devEnvironmentId.hashCode();
            result2 = result2 * 31 + ApplicationType.hashCode-impl(this.toolId);
            result2 = result2 * 31 + this.toolName.hashCode();
            result2 = result2 * 31 + this.initialSelectedTab.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NewAvailableTool)) {
                return false;
            }
            NewAvailableTool newAvailableTool = (NewAvailableTool)other;
            if (!Intrinsics.areEqual((Object)this.devEnvironmentId, (Object)newAvailableTool.devEnvironmentId)) {
                return false;
            }
            if (!ApplicationType.equals-impl0(this.toolId, newAvailableTool.toolId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.toolName, (Object)newAvailableTool.toolName)) {
                return false;
            }
            return this.initialSelectedTab == newAvailableTool.initialSelectedTab;
        }

        public /* synthetic */ NewAvailableTool(DevEnvironmentId devEnvironmentId, String toolId, String toolName, ToolOverviewTabs initialSelectedTab, DefaultConstructorMarker $constructor_marker) {
            this(devEnvironmentId, toolId, toolName, initialSelectedTab);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class NewToolVersions
    extends Screen
    implements RemoteEnvironmentScreen {
        @Nullable
        private final DevEnvironmentId devEnvironmentId;
        @NotNull
        private final String toolId;
        @NotNull
        private final String toolName;
        public static final int $stable = 8;

        private NewToolVersions(DevEnvironmentId devEnvironmentId, String toolId, String toolName) {
            Intrinsics.checkNotNullParameter((Object)toolId, (String)"toolId");
            Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
            super(false, 1, null);
            this.devEnvironmentId = devEnvironmentId;
            this.toolId = toolId;
            this.toolName = toolName;
        }

        @Override
        @Nullable
        public DevEnvironmentId getDevEnvironmentId() {
            return this.devEnvironmentId;
        }

        @NotNull
        public final String getToolId-UtVBrGo() {
            return this.toolId;
        }

        @NotNull
        public final String getToolName() {
            return this.toolName;
        }

        @Override
        @NotNull
        public String getId() {
            return "Versions of " + ApplicationType.toString-impl(this.toolId);
        }

        @NotNull
        public String toString() {
            return "NewToolVersions(devEnvironmentId=" + this.devEnvironmentId + ", toolId=" + ApplicationType.toString-impl(this.toolId) + ", toolName=" + this.toolName + ")";
        }

        public int hashCode() {
            int result2 = this.devEnvironmentId == null ? 0 : this.devEnvironmentId.hashCode();
            result2 = result2 * 31 + ApplicationType.hashCode-impl(this.toolId);
            result2 = result2 * 31 + this.toolName.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NewToolVersions)) {
                return false;
            }
            NewToolVersions newToolVersions = (NewToolVersions)other;
            if (!Intrinsics.areEqual((Object)this.devEnvironmentId, (Object)newToolVersions.devEnvironmentId)) {
                return false;
            }
            if (!ApplicationType.equals-impl0(this.toolId, newToolVersions.toolId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.toolName, (Object)newToolVersions.toolName);
        }

        public /* synthetic */ NewToolVersions(DevEnvironmentId devEnvironmentId, String toolId, String toolName, DefaultConstructorMarker $constructor_marker) {
            this(devEnvironmentId, toolId, toolName);
        }
    }

    public static final class Onboarding
    extends Screen {
        private final boolean isEnterpriseBlockedScreen;

        public Onboarding(boolean isEnterpriseBlockedScreen) {
            super(false, null);
            this.isEnterpriseBlockedScreen = isEnterpriseBlockedScreen;
        }

        public /* synthetic */ Onboarding(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public final boolean isEnterpriseBlockedScreen() {
            return this.isEnterpriseBlockedScreen;
        }

        @Override
        @NotNull
        public String getId() {
            return "onboarding";
        }

        @NotNull
        public String toString() {
            return "Onboarding(isEnterpriseBlockedScreen=" + this.isEnterpriseBlockedScreen + ")";
        }

        public int hashCode() {
            return Boolean.hashCode(this.isEnterpriseBlockedScreen);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Onboarding)) {
                return false;
            }
            Onboarding onboarding = (Onboarding)other;
            return this.isEnterpriseBlockedScreen == onboarding.isEnterpriseBlockedScreen;
        }

        public Onboarding() {
            this(false, 1, null);
        }
    }

    public static final class PatronusBuild
    extends Screen {
        @NotNull
        private final String buildId;
        @NotNull
        private final String id;

        public PatronusBuild(@NotNull String buildId) {
            Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
            super(false, 1, null);
            this.buildId = buildId;
            this.id = "PatronusBuild-" + this.buildId;
        }

        @NotNull
        public final String getBuildId() {
            return this.buildId;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @NotNull
        public String toString() {
            return "PatronusBuild(buildId=" + this.buildId + ")";
        }

        public int hashCode() {
            return this.buildId.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PatronusBuild)) {
                return false;
            }
            PatronusBuild patronusBuild = (PatronusBuild)other;
            return Intrinsics.areEqual((Object)this.buildId, (Object)patronusBuild.buildId);
        }
    }

    public static final class ProposeEnterpriseConfig
    extends Screen {
        @NotNull
        private final String configUrl;
        private final boolean cwmConnectionAfterJoin;

        public ProposeEnterpriseConfig(@NotNull String configUrl, boolean cwmConnectionAfterJoin) {
            Intrinsics.checkNotNullParameter((Object)configUrl, (String)"configUrl");
            super(false, null);
            this.configUrl = configUrl;
            this.cwmConnectionAfterJoin = cwmConnectionAfterJoin;
        }

        @NotNull
        public final String getConfigUrl() {
            return this.configUrl;
        }

        public final boolean getCwmConnectionAfterJoin() {
            return this.cwmConnectionAfterJoin;
        }

        @Override
        @NotNull
        public String getId() {
            return "Accept configuration from " + this.configUrl;
        }

        @NotNull
        public String toString() {
            return "ProposeEnterpriseConfig(configUrl=" + this.configUrl + ", cwmConnectionAfterJoin=" + this.cwmConnectionAfterJoin + ")";
        }

        public int hashCode() {
            int result2 = this.configUrl.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.cwmConnectionAfterJoin);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProposeEnterpriseConfig)) {
                return false;
            }
            ProposeEnterpriseConfig proposeEnterpriseConfig = (ProposeEnterpriseConfig)other;
            if (!Intrinsics.areEqual((Object)this.configUrl, (Object)proposeEnterpriseConfig.configUrl)) {
                return false;
            }
            return this.cwmConnectionAfterJoin == proposeEnterpriseConfig.cwmConnectionAfterJoin;
        }
    }

    public static final class ProposeInstall
    extends Screen {
        @NotNull
        private final ToolBuild toolBuild;
        public static final int $stable = 8;

        public ProposeInstall(@NotNull ToolBuild toolBuild2) {
            Intrinsics.checkNotNullParameter((Object)toolBuild2, (String)"toolBuild");
            super(false, null);
            this.toolBuild = toolBuild2;
        }

        @NotNull
        public final ToolBuild getToolBuild() {
            return this.toolBuild;
        }

        @Override
        @NotNull
        public String getId() {
            return "Install " + ApplicationType.toString-impl(this.toolBuild.getTool().getApplicationType-UtVBrGo()) + " " + BuildNumber.toString-impl(this.toolBuild.getBuild().getId-Y_E1uuk());
        }

        @NotNull
        public String toString() {
            return "ProposeInstall(toolBuild=" + this.toolBuild + ")";
        }

        public int hashCode() {
            return this.toolBuild.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProposeInstall)) {
                return false;
            }
            ProposeInstall proposeInstall = (ProposeInstall)other;
            return Intrinsics.areEqual((Object)this.toolBuild, (Object)proposeInstall.toolBuild);
        }
    }

    public static final class Recents
    extends Screen
    implements TopLevelScreen {
        @NotNull
        public static final Recents INSTANCE = new Recents();

        private Recents() {
            super(false, 1, null);
        }

        @Override
        @NotNull
        public String getId() {
            return "Recents";
        }

        @NotNull
        public String toString() {
            return "Recents";
        }

        public int hashCode() {
            return -529113098;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Recents)) {
                return false;
            }
            Recents cfr_ignored_0 = (Recents)other;
            return true;
        }
    }

    public static sealed interface RemoteEnvironmentScreen
    permits GatewayEnvironment, InstalledToolMeta, LeftoverIDEDirectories, NewAvailableTool, NewToolVersions, WhatsNewInAvailableTool, WhatsNewInInstalledTool {
        @Nullable
        public DevEnvironmentId getDevEnvironmentId();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static sealed interface RemoteScreen
    permits GatewayEnvironment, GatewayProvider, GatewayUiPage {
        @NotNull
        public String getProviderId-rwbms5E();
    }

    public static final class RhizomeBacked
    extends Screen
    implements TopLevelScreen {
        @NotNull
        private final String id;
        public static final int $stable;

        public RhizomeBacked(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            super(false, 1, null);
            this.id = id;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @NotNull
        public String toString() {
            return "RhizomeBacked(id=" + this.id + ")";
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RhizomeBacked)) {
                return false;
            }
            RhizomeBacked rhizomeBacked = (RhizomeBacked)other;
            return Intrinsics.areEqual((Object)this.id, (Object)rhizomeBacked.id);
        }
    }

    public static final class ServiceOverview
    extends Screen {
        @NotNull
        private final String serviceId;

        public ServiceOverview(@NotNull String serviceId) {
            Intrinsics.checkNotNullParameter((Object)serviceId, (String)"serviceId");
            super(false, 1, null);
            this.serviceId = serviceId;
        }

        @NotNull
        public final String getServiceId() {
            return this.serviceId;
        }

        @Override
        @NotNull
        public String getId() {
            return this.serviceId;
        }

        @NotNull
        public String toString() {
            return "ServiceOverview(serviceId=" + this.serviceId + ")";
        }

        public int hashCode() {
            return this.serviceId.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ServiceOverview)) {
                return false;
            }
            ServiceOverview serviceOverview = (ServiceOverview)other;
            return Intrinsics.areEqual((Object)this.serviceId, (Object)serviceOverview.serviceId);
        }
    }

    public static final class Settings
    extends Screen {
        @NotNull
        private final SettingsTabs initialSelectedTab;
        @Nullable
        private final HighlightTarget initialHighlightedField;
        private final boolean navigateBackOnLogin;
        @NotNull
        private final MutableState<SettingsTabs> observableSelectedTab;
        @NotNull
        private final MutableState<HighlightTarget> observableHighlightedField;
        public static final int $stable = 8;

        public Settings(@NotNull SettingsTabs initialSelectedTab, @Nullable HighlightTarget initialHighlightedField, boolean navigateBackOnLogin) {
            Intrinsics.checkNotNullParameter((Object)((Object)initialSelectedTab), (String)"initialSelectedTab");
            super(false, 1, null);
            this.initialSelectedTab = initialSelectedTab;
            this.initialHighlightedField = initialHighlightedField;
            this.navigateBackOnLogin = navigateBackOnLogin;
            this.observableSelectedTab = SnapshotStateKt.mutableStateOf$default((Object)this.initialSelectedTab, null, 2, null);
            this.observableHighlightedField = SnapshotStateKt.mutableStateOf$default(this.initialHighlightedField, null, 2, null);
        }

        public /* synthetic */ Settings(SettingsTabs settingsTabs, HighlightTarget highlightTarget, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                settingsTabs = SettingsTabs.Settings;
            }
            if ((n & 2) != 0) {
                highlightTarget = null;
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            this(settingsTabs, highlightTarget, bl);
        }

        @NotNull
        public final SettingsTabs getInitialSelectedTab() {
            return this.initialSelectedTab;
        }

        public final boolean getNavigateBackOnLogin() {
            return this.navigateBackOnLogin;
        }

        @Override
        @NotNull
        public String getId() {
            return "Toolbox App Settings (" + this.observableSelectedTab.getValue().name() + ")";
        }

        @NotNull
        public final MutableState<SettingsTabs> getObservableSelectedTab$ui() {
            return this.observableSelectedTab;
        }

        @NotNull
        public final MutableState<HighlightTarget> getObservableHighlightedField$ui() {
            return this.observableHighlightedField;
        }

        @NotNull
        public String toString() {
            return "Settings(initialSelectedTab=" + this.initialSelectedTab + ", initialHighlightedField=" + this.initialHighlightedField + ", navigateBackOnLogin=" + this.navigateBackOnLogin + ")";
        }

        public int hashCode() {
            int result2 = this.initialSelectedTab.hashCode();
            result2 = result2 * 31 + (this.initialHighlightedField == null ? 0 : this.initialHighlightedField.hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.navigateBackOnLogin);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Settings)) {
                return false;
            }
            Settings settings2 = (Settings)other;
            if (this.initialSelectedTab != settings2.initialSelectedTab) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.initialHighlightedField, (Object)settings2.initialHighlightedField)) {
                return false;
            }
            return this.navigateBackOnLogin == settings2.navigateBackOnLogin;
        }

        public Settings() {
            this(null, null, false, 7, null);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class Subscription
    extends Screen {
        @NotNull
        private final String subscriptionId;
        @NotNull
        private final String id;

        private Subscription(String subscriptionId) {
            Intrinsics.checkNotNullParameter((Object)subscriptionId, (String)"subscriptionId");
            super(false, 1, null);
            this.subscriptionId = subscriptionId;
            this.id = "Subscription-" + SubscriptionId.toString-impl(this.subscriptionId);
        }

        @NotNull
        public final String getSubscriptionId-NYHu9Lo() {
            return this.subscriptionId;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @NotNull
        public String toString() {
            return "Subscription(subscriptionId=" + SubscriptionId.toString-impl(this.subscriptionId) + ")";
        }

        public int hashCode() {
            return SubscriptionId.hashCode-impl(this.subscriptionId);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Subscription)) {
                return false;
            }
            Subscription subscription2 = (Subscription)other;
            return SubscriptionId.equals-impl0(this.subscriptionId, subscription2.subscriptionId);
        }

        public /* synthetic */ Subscription(String subscriptionId, DefaultConstructorMarker $constructor_marker) {
            this(subscriptionId);
        }
    }

    public static final class TestWhatsNew
    extends Screen {
        @NotNull
        public static final TestWhatsNew INSTANCE = new TestWhatsNew();

        private TestWhatsNew() {
            super(false, 1, null);
        }

        @Override
        @NotNull
        public String getId() {
            return "Test whats_new.html";
        }

        @NotNull
        public String toString() {
            return "TestWhatsNew";
        }

        public int hashCode() {
            return -716366875;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TestWhatsNew)) {
                return false;
            }
            TestWhatsNew cfr_ignored_0 = (TestWhatsNew)other;
            return true;
        }
    }

    public static final class ThirdParty
    extends Screen {
        @NotNull
        public static final ThirdParty INSTANCE = new ThirdParty();

        private ThirdParty() {
            super(false, 1, null);
        }

        @Override
        @NotNull
        public String getId() {
            return "Third-Party Software List";
        }

        @NotNull
        public String toString() {
            return "ThirdParty";
        }

        public int hashCode() {
            return -1599137151;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ThirdParty)) {
                return false;
            }
            ThirdParty cfr_ignored_0 = (ThirdParty)other;
            return true;
        }
    }

    public static sealed interface TopLevelScreen
    permits GatewayProvider, Main, Recents, RhizomeBacked {
    }

    public static final class UnhandledError
    extends Screen {
        @NotNull
        private final Throwable error;
        public static final int $stable = 8;

        public UnhandledError(@NotNull Throwable error2) {
            Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
            super(false, null);
            this.error = error2;
        }

        @NotNull
        public final Throwable getError() {
            return this.error;
        }

        @Override
        @NotNull
        public String getId() {
            return "Unhandled error";
        }

        @NotNull
        public String toString() {
            return "UnhandledError(error=" + this.error + ")";
        }

        public int hashCode() {
            return this.error.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UnhandledError)) {
                return false;
            }
            UnhandledError unhandledError = (UnhandledError)other;
            return Intrinsics.areEqual((Object)this.error, (Object)unhandledError.error);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class Welcome
    extends Screen {
        @NotNull
        private final String channelId;

        private Welcome(String channelId) {
            Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
            super(false, 1, null);
            this.channelId = channelId;
        }

        @NotNull
        public final String getChannelId-5CZByfs() {
            return this.channelId;
        }

        @Override
        @NotNull
        public String getId() {
            return "Welcome to " + ChannelId.toString-impl(this.channelId);
        }

        @NotNull
        public String toString() {
            return "Welcome(channelId=" + ChannelId.toString-impl(this.channelId) + ")";
        }

        public int hashCode() {
            return ChannelId.hashCode-impl(this.channelId);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Welcome)) {
                return false;
            }
            Welcome welcome = (Welcome)other;
            return ChannelId.equals-impl0(this.channelId, welcome.channelId);
        }

        public /* synthetic */ Welcome(String channelId, DefaultConstructorMarker $constructor_marker) {
            this(channelId);
        }
    }

    public static final class WhatsNewInApp
    extends Screen {
        @NotNull
        public static final WhatsNewInApp INSTANCE = new WhatsNewInApp();

        private WhatsNewInApp() {
            super(false, 1, null);
        }

        @Override
        @NotNull
        public String getId() {
            return "What's New in Toolbox App";
        }

        @NotNull
        public String toString() {
            return "WhatsNewInApp";
        }

        public int hashCode() {
            return -1074591671;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WhatsNewInApp)) {
                return false;
            }
            WhatsNewInApp cfr_ignored_0 = (WhatsNewInApp)other;
            return true;
        }
    }

    public static final class WhatsNewInAvailableTool
    extends Screen
    implements RemoteEnvironmentScreen {
        @NotNull
        private final DistributionId distributionId;
        @NotNull
        private final String toolName;
        @Nullable
        private final DevEnvironmentId devEnvironmentId;
        public static final int $stable = 8;

        public WhatsNewInAvailableTool(@NotNull DistributionId distributionId, @NotNull String toolName, @Nullable DevEnvironmentId devEnvironmentId) {
            Intrinsics.checkNotNullParameter((Object)distributionId, (String)"distributionId");
            Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
            super(false, 1, null);
            this.distributionId = distributionId;
            this.toolName = toolName;
            this.devEnvironmentId = devEnvironmentId;
        }

        @NotNull
        public final DistributionId getDistributionId() {
            return this.distributionId;
        }

        @NotNull
        public final String getToolName() {
            return this.toolName;
        }

        @Override
        @Nullable
        public DevEnvironmentId getDevEnvironmentId() {
            return this.devEnvironmentId;
        }

        @Override
        @NotNull
        public String getId() {
            return "What's New in available " + ApplicationType.toString-impl(this.distributionId.getToolId-UtVBrGo()) + " " + BuildNumber.toString-impl(this.distributionId.getBuildNumber-Y_E1uuk());
        }

        @NotNull
        public String toString() {
            return "WhatsNewInAvailableTool(distributionId=" + this.distributionId + ", toolName=" + this.toolName + ", devEnvironmentId=" + this.devEnvironmentId + ")";
        }

        public int hashCode() {
            int result2 = this.distributionId.hashCode();
            result2 = result2 * 31 + this.toolName.hashCode();
            result2 = result2 * 31 + (this.devEnvironmentId == null ? 0 : this.devEnvironmentId.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WhatsNewInAvailableTool)) {
                return false;
            }
            WhatsNewInAvailableTool whatsNewInAvailableTool = (WhatsNewInAvailableTool)other;
            if (!Intrinsics.areEqual((Object)this.distributionId, (Object)whatsNewInAvailableTool.distributionId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.toolName, (Object)whatsNewInAvailableTool.toolName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.devEnvironmentId, (Object)whatsNewInAvailableTool.devEnvironmentId);
        }
    }

    public static final class WhatsNewInCurrentApp
    extends Screen {
        @NotNull
        private final String nameAndVersion;
        @Nullable
        private final WhatsNew whatsNew;
        public static final int $stable = 8;

        public WhatsNewInCurrentApp(@NotNull String nameAndVersion, @Nullable WhatsNew whatsNew2) {
            Intrinsics.checkNotNullParameter((Object)nameAndVersion, (String)"nameAndVersion");
            super(false, 1, null);
            this.nameAndVersion = nameAndVersion;
            this.whatsNew = whatsNew2;
        }

        @NotNull
        public final String getNameAndVersion() {
            return this.nameAndVersion;
        }

        @Nullable
        public final WhatsNew getWhatsNew() {
            return this.whatsNew;
        }

        @Override
        @NotNull
        public String getId() {
            return "What's New in " + this.nameAndVersion;
        }

        @NotNull
        public String toString() {
            return "WhatsNewInCurrentApp(nameAndVersion=" + this.nameAndVersion + ", whatsNew=" + this.whatsNew + ")";
        }

        public int hashCode() {
            int result2 = this.nameAndVersion.hashCode();
            result2 = result2 * 31 + (this.whatsNew == null ? 0 : this.whatsNew.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WhatsNewInCurrentApp)) {
                return false;
            }
            WhatsNewInCurrentApp whatsNewInCurrentApp = (WhatsNewInCurrentApp)other;
            if (!Intrinsics.areEqual((Object)this.nameAndVersion, (Object)whatsNewInCurrentApp.nameAndVersion)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.whatsNew, (Object)whatsNewInCurrentApp.whatsNew);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class WhatsNewInInstalledTool
    extends Screen
    implements RemoteEnvironmentScreen {
        @NotNull
        private final String toolName;
        @NotNull
        private final String toolVersion;
        @NotNull
        private final String toolBuildNumber;
        @NotNull
        private final String channelId;
        private final boolean displayForUpdate;
        @Nullable
        private final DevEnvironmentId devEnvironmentId;
        public static final int $stable = 8;

        private WhatsNewInInstalledTool(String toolName, String toolVersion, String toolBuildNumber, String channelId, boolean displayForUpdate, DevEnvironmentId devEnvironmentId) {
            Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
            Intrinsics.checkNotNullParameter((Object)toolVersion, (String)"toolVersion");
            Intrinsics.checkNotNullParameter((Object)toolBuildNumber, (String)"toolBuildNumber");
            Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
            super(false, 1, null);
            this.toolName = toolName;
            this.toolVersion = toolVersion;
            this.toolBuildNumber = toolBuildNumber;
            this.channelId = channelId;
            this.displayForUpdate = displayForUpdate;
            this.devEnvironmentId = devEnvironmentId;
        }

        @NotNull
        public final String getToolName() {
            return this.toolName;
        }

        @NotNull
        public final String getToolVersion() {
            return this.toolVersion;
        }

        @NotNull
        public final String getToolBuildNumber-Y_E1uuk() {
            return this.toolBuildNumber;
        }

        @NotNull
        public final String getChannelId-5CZByfs() {
            return this.channelId;
        }

        public final boolean getDisplayForUpdate() {
            return this.displayForUpdate;
        }

        @Override
        @Nullable
        public DevEnvironmentId getDevEnvironmentId() {
            return this.devEnvironmentId;
        }

        @Override
        @NotNull
        public String getId() {
            return "What's New in installed " + this.toolName + " " + this.toolVersion + " build " + BuildNumber.toString-impl(this.toolBuildNumber);
        }

        @NotNull
        public String toString() {
            return "WhatsNewInInstalledTool(toolName=" + this.toolName + ", toolVersion=" + this.toolVersion + ", toolBuildNumber=" + BuildNumber.toString-impl(this.toolBuildNumber) + ", channelId=" + ChannelId.toString-impl(this.channelId) + ", displayForUpdate=" + this.displayForUpdate + ", devEnvironmentId=" + this.devEnvironmentId + ")";
        }

        public int hashCode() {
            int result2 = this.toolName.hashCode();
            result2 = result2 * 31 + this.toolVersion.hashCode();
            result2 = result2 * 31 + BuildNumber.hashCode-impl(this.toolBuildNumber);
            result2 = result2 * 31 + ChannelId.hashCode-impl(this.channelId);
            result2 = result2 * 31 + Boolean.hashCode(this.displayForUpdate);
            result2 = result2 * 31 + (this.devEnvironmentId == null ? 0 : this.devEnvironmentId.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WhatsNewInInstalledTool)) {
                return false;
            }
            WhatsNewInInstalledTool whatsNewInInstalledTool = (WhatsNewInInstalledTool)other;
            if (!Intrinsics.areEqual((Object)this.toolName, (Object)whatsNewInInstalledTool.toolName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.toolVersion, (Object)whatsNewInInstalledTool.toolVersion)) {
                return false;
            }
            if (!BuildNumber.equals-impl0(this.toolBuildNumber, whatsNewInInstalledTool.toolBuildNumber)) {
                return false;
            }
            if (!ChannelId.equals-impl0(this.channelId, whatsNewInInstalledTool.channelId)) {
                return false;
            }
            if (this.displayForUpdate != whatsNewInInstalledTool.displayForUpdate) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.devEnvironmentId, (Object)whatsNewInInstalledTool.devEnvironmentId);
        }

        public /* synthetic */ WhatsNewInInstalledTool(String toolName, String toolVersion, String toolBuildNumber, String channelId, boolean displayForUpdate, DevEnvironmentId devEnvironmentId, DefaultConstructorMarker $constructor_marker) {
            this(toolName, toolVersion, toolBuildNumber, channelId, displayForUpdate, devEnvironmentId);
        }
    }
}

