/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ui.components.layout.views;

import androidx.compose.runtime.Composer;
import androidx.compose.ui.Modifier;
import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.viewmodel.ActionModel;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ViewTitle {
    @NotNull
    private final LocalizableString title;
    private final boolean breakable;
    @NotNull
    private final LocalizableString navigationTitle;
    @Nullable
    private final Function1<String, Unit> onTitleChange;
    @Nullable
    private final Function3<Modifier, Composer, Integer, Unit> icon;
    @NotNull
    private final List<ActionModel> additionalActions;

    public ViewTitle(@NotNull LocalizableString title2, boolean breakable, @NotNull LocalizableString navigationTitle, @Nullable Function1<? super String, Unit> onTitleChange, @Nullable Function3<? super Modifier, ? super Composer, ? super Integer, Unit> icon2, @NotNull List<ActionModel> additionalActions) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)navigationTitle, (String)"navigationTitle");
        Intrinsics.checkNotNullParameter(additionalActions, (String)"additionalActions");
        this.title = title2;
        this.breakable = breakable;
        this.navigationTitle = navigationTitle;
        this.onTitleChange = onTitleChange;
        this.icon = icon2;
        this.additionalActions = additionalActions;
    }

    public /* synthetic */ ViewTitle(LocalizableString localizableString, boolean bl, LocalizableString localizableString2, Function1 function1, Function3 function3, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            localizableString2 = localizableString;
        }
        if ((n & 8) != 0) {
            function1 = null;
        }
        if ((n & 0x10) != 0) {
            function3 = null;
        }
        if ((n & 0x20) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(localizableString, bl, localizableString2, (Function1<? super String, Unit>)function1, (Function3<? super Modifier, ? super Composer, ? super Integer, Unit>)function3, list2);
    }

    @NotNull
    public final LocalizableString getTitle() {
        return this.title;
    }

    public final boolean getBreakable() {
        return this.breakable;
    }

    @NotNull
    public final LocalizableString getNavigationTitle() {
        return this.navigationTitle;
    }

    @Nullable
    public final Function1<String, Unit> getOnTitleChange() {
        return this.onTitleChange;
    }

    @Nullable
    public final Function3<Modifier, Composer, Integer, Unit> getIcon() {
        return this.icon;
    }

    @NotNull
    public final List<ActionModel> getAdditionalActions() {
        return this.additionalActions;
    }

    @NotNull
    public String toString() {
        return "ViewTitle(title=" + this.title + ", breakable=" + this.breakable + ", navigationTitle=" + this.navigationTitle + ", onTitleChange=" + this.onTitleChange + ", icon=" + this.icon + ", additionalActions=" + this.additionalActions + ")";
    }

    public int hashCode() {
        int result2 = this.title.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.breakable);
        result2 = result2 * 31 + this.navigationTitle.hashCode();
        result2 = result2 * 31 + (this.onTitleChange == null ? 0 : this.onTitleChange.hashCode());
        result2 = result2 * 31 + (this.icon == null ? 0 : this.icon.hashCode());
        result2 = result2 * 31 + ((Object)this.additionalActions).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ViewTitle)) {
            return false;
        }
        ViewTitle viewTitle = (ViewTitle)other;
        if (!Intrinsics.areEqual((Object)this.title, (Object)viewTitle.title)) {
            return false;
        }
        if (this.breakable != viewTitle.breakable) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.navigationTitle, (Object)viewTitle.navigationTitle)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.onTitleChange, viewTitle.onTitleChange)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.icon, viewTitle.icon)) {
            return false;
        }
        return Intrinsics.areEqual(this.additionalActions, viewTitle.additionalActions);
    }
}

