/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.uninstaller;

import com.jetbrains.toolbox.FileUtils;
import com.jetbrains.toolbox.interop.Pid;
import com.jetbrains.toolbox.tools.ToolUninstaller;
import com.jetbrains.toolbox.tools.UninstallResult;
import com.jetbrains.toolbox.tools.model.ChannelUtilsKt;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import com.jetbrains.toolbox.tools.runningStatusChecker.WindowsToolRunningStatusChecker;
import com.jetbrains.toolbox.tools.uninstaller.RemoveInstallDirKt;
import com.jetbrains.toolbox.tools.uninstaller.WindowsToolUninstaller;
import java.util.Collection;
import java.util.List;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.tinylog.kotlin.Logger;

@VisibleForTesting
public final class WindowsToolUninstaller
implements ToolUninstaller {
    @NotNull
    private final WindowsToolRunningStatusChecker toolRunningStatusChecker;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final FileUtils fileUtils;

    public WindowsToolUninstaller(@NotNull WindowsToolRunningStatusChecker toolRunningStatusChecker, @NotNull FileSystem fileSystem, @NotNull FileUtils fileUtils) {
        Intrinsics.checkNotNullParameter((Object)toolRunningStatusChecker, (String)"toolRunningStatusChecker");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)fileUtils, (String)"fileUtils");
        this.toolRunningStatusChecker = toolRunningStatusChecker;
        this.fileSystem = fileSystem;
        this.fileUtils = fileUtils;
    }

    @Override
    @Nullable
    public Object canUninstall(@NotNull ToolInstance toolInstance, @NotNull Continuation<? super UninstallResult> $completion) {
        UninstallResult uninstallResult;
        Path installDir = toolInstance.getChannel().getInstallationDirectory();
        List<Pair<Pid, Path>> processesFromDir = this.toolRunningStatusChecker.getRunningProcesses(toolInstance);
        if (!((Collection)processesFromDir).isEmpty()) {
            Logger.INSTANCE.info("Detected running process(es) " + CollectionsKt.joinToString$default((Iterable)processesFromDir, null, null, null, (int)0, null, WindowsToolUninstaller::canUninstall$lambda$0, (int)31, null) + " with directory '" + installDir + "'");
            return new UninstallResult.Running(((Pid)((Pair)CollectionsKt.first(processesFromDir)).getFirst()).unbox-impl(), null);
        }
        try {
            this.fileSystem.atomicMove(installDir, installDir);
            Logger.INSTANCE.info("Succeeded to move '" + installDir + "' to itself: for Windows, it means that the directory isn't in use by any process");
            uninstallResult = UninstallResult.Success.INSTANCE;
        }
        catch (Exception e) {
            UninstallResult uninstallResult2;
            if (!this.fileSystem.exists(installDir)) {
                Logger.INSTANCE.info("'" + installDir + "' has already been removed");
                uninstallResult2 = UninstallResult.Success.INSTANCE;
            } else if (!ChannelUtilsKt.canOverwriteInstallationDirectory(toolInstance.getChannel(), this.fileSystem)) {
                Logger.INSTANCE.info("Couldn't uninstall '" + installDir + "' because the parent directory '" + installDir.parent() + "' is not writable.");
                uninstallResult2 = UninstallResult.DirectoryIsNotWritable.INSTANCE;
            } else {
                Logger.INSTANCE.info((Throwable)e, "Failed to move '" + installDir + "' to itself: for Windows, it means that the directory is in use by some process");
                uninstallResult2 = new UninstallResult.Blocked("another process uses the tool directory '" + installDir + "'");
            }
            uninstallResult = uninstallResult2;
        }
        return uninstallResult;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object uninstall(@NotNull ToolInstance toolInstance, @Nullable Path backupTo, @NotNull Continuation<? super UninstallResult> $completion) {
        if (!($completion instanceof uninstall.1)) ** GOTO lbl-1000
        var6_4 = $completion;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ WindowsToolUninstaller this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.uninstall(null, null, (Continuation<? super UninstallResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = toolInstance;
                $continuation.L$1 = backupTo;
                $continuation.label = 1;
                v0 = this.canUninstall(toolInstance, (Continuation<? super UninstallResult>)$continuation);
                if (v0 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                backupTo = (Path)$continuation.L$1;
                toolInstance = (ToolInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                if (!Intrinsics.areEqual((Object)(canUninstall = (UninstallResult)v0), (Object)UninstallResult.Success.INSTANCE)) {
                    return canUninstall;
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)toolInstance);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)backupTo);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)canUninstall);
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super UninstallResult>, Object>(this, toolInstance, backupTo, null){
                    int label;
                    final /* synthetic */ WindowsToolUninstaller this$0;
                    final /* synthetic */ ToolInstance $toolInstance;
                    final /* synthetic */ Path $backupTo;
                    {
                        this.this$0 = $receiver;
                        this.$toolInstance = $toolInstance;
                        this.$backupTo = $backupTo;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                return RemoveInstallDirKt.removeInstallDir(WindowsToolUninstaller.access$getFileSystem$p(this.this$0), this.$toolInstance.getChannel().getInstallationDirectory(), this.$backupTo, WindowsToolUninstaller.access$getFileUtils$p(this.this$0));
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super UninstallResult> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl40
            }
            case 2: {
                canUninstall = (UninstallResult)$continuation.L$2;
                backupTo = (Path)$continuation.L$1;
                toolInstance = (ToolInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl40:
                // 2 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final CharSequence canUninstall$lambda$0(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        long pid = ((Pid)pair.component1()).unbox-impl();
        Path path2 = (Path)pair.component2();
        return Pid.toString-impl(pid) + " '" + path2 + "'";
    }

    public static final /* synthetic */ FileSystem access$getFileSystem$p(WindowsToolUninstaller $this) {
        return $this.fileSystem;
    }

    public static final /* synthetic */ FileUtils access$getFileUtils$p(WindowsToolUninstaller $this) {
        return $this.fileUtils;
    }
}

