/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.runningStatusChecker;

import com.jetbrains.toolbox.common.io.PathExtensionsKt;
import com.jetbrains.toolbox.tools.ToolRunningStatusChecker;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import java.io.FileNotFoundException;
import java.nio.file.AccessDeniedException;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class LinuxToolRunningStatusChecker
implements ToolRunningStatusChecker {
    @NotNull
    private final FileSystem fileSystem;

    public LinuxToolRunningStatusChecker(@NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
    }

    @Override
    public boolean isRunning(@NotNull ToolInstance toolInstance) {
        Intrinsics.checkNotNullParameter((Object)toolInstance, (String)"toolInstance");
        return this.getRunningProcessPid(toolInstance) != null;
    }

    @Nullable
    public final Long getRunningProcessPid(@NotNull ToolInstance toolInstance) {
        Long l;
        block9: {
            Intrinsics.checkNotNullParameter((Object)toolInstance, (String)"toolInstance");
            Path directory = toolInstance.getChannel().getInstallationDirectory();
            List list2 = this.fileSystem.listOrNull(Path.Companion.get$default((Path.Companion)Path.Companion, (String)"/proc", (boolean)false, (int)1, null));
            if (list2 != null) {
                for (Path pidPath : (Iterable)list2) {
                    Long l2;
                    Long l3;
                    boolean bl = false;
                    Long l4 = StringsKt.toLongOrNull((String)pidPath.name());
                    if (l4 == null) {
                        l3 = null;
                    } else {
                        Long l5;
                        long pid = l4;
                        try {
                            Path executablePath = this.fileSystem.canonicalize(pidPath.resolve("exe"));
                            l5 = PathExtensionsKt.contains(directory, executablePath) ? Long.valueOf(pid) : null;
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            l5 = null;
                        }
                        catch (AccessDeniedException accessDeniedException) {
                            l5 = null;
                        }
                        catch (Exception e) {
                            Logger.INSTANCE.warn((Throwable)e);
                            l5 = null;
                        }
                        l3 = l5;
                    }
                    if ((l2 = l3) == null) continue;
                    l = l2;
                    break block9;
                }
                l = null;
            } else {
                l = null;
            }
        }
        return l;
    }
}

