/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.launcher;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.tools.ExtensionsKt;
import com.jetbrains.toolbox.tools.model.Channel;
import com.jetbrains.toolbox.tools.model.ClientToolExtension;
import com.jetbrains.toolbox.tools.model.ClientToolExtensionKt;
import com.jetbrains.toolbox.tools.model.InstalledTool;
import com.jetbrains.toolbox.tools.model.ToolExtension;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToolParameters {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Path command;
    @NotNull
    private final Path installationDirectory;
    @NotNull
    private final List<String> arguments;
    private final boolean allowsSetsid;

    public ToolParameters(@Nullable Path command2, @NotNull Path installationDirectory, @NotNull List<String> arguments2, boolean allowsSetsid) {
        Intrinsics.checkNotNullParameter((Object)installationDirectory, (String)"installationDirectory");
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        this.command = command2;
        this.installationDirectory = installationDirectory;
        this.arguments = arguments2;
        this.allowsSetsid = allowsSetsid;
    }

    public /* synthetic */ ToolParameters(Path path2, Path path3, List list2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            path2 = null;
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        this(path2, path3, list2, bl);
    }

    @Nullable
    public final Path getCommand() {
        return this.command;
    }

    @NotNull
    public final Path getInstallationDirectory() {
        return this.installationDirectory;
    }

    @NotNull
    public final List<String> getArguments() {
        return this.arguments;
    }

    public final boolean getAllowsSetsid() {
        return this.allowsSetsid;
    }

    @NotNull
    public String toString() {
        return "ToolParameters(command=" + this.command + ", installationDirectory=" + this.installationDirectory + ", arguments=" + this.arguments + ", allowsSetsid=" + this.allowsSetsid + ")";
    }

    public int hashCode() {
        int result2 = this.command == null ? 0 : this.command.hashCode();
        result2 = result2 * 31 + this.installationDirectory.hashCode();
        result2 = result2 * 31 + ((Object)this.arguments).hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.allowsSetsid);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ToolParameters)) {
            return false;
        }
        ToolParameters toolParameters = (ToolParameters)other;
        if (!Intrinsics.areEqual((Object)this.command, (Object)toolParameters.command)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.installationDirectory, (Object)toolParameters.installationDirectory)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.arguments, toolParameters.arguments)) {
            return false;
        }
        return this.allowsSetsid == toolParameters.allowsSetsid;
    }

    @SourceDebugExtension(value={"SMAP\nToolParameters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolParameters.kt\ncom/jetbrains/toolbox/tools/launcher/ToolParameters$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1#2:68\n1761#3,3:69\n*S KotlinDebug\n*F\n+ 1 ToolParameters.kt\ncom/jetbrains/toolbox/tools/launcher/ToolParameters$Companion\n*L\n61#1:69,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ToolParameters asClient(@NotNull InstalledTool tool, @NotNull Channel channel) {
            ToolParameters toolParameters;
            Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            ClientToolExtension clientToolExtension = ClientToolExtensionKt.getClientExtension(tool);
            if ((clientToolExtension != null ? clientToolExtension.getClientLaunchCommand() : null) != null) {
                ToolInstance pair = new ToolInstance(channel, tool);
                boolean bl = false;
                Path path2 = ExtensionsKt.getClientLaunchCommand(pair);
                if (path2 == null) {
                    path2 = ExtensionsKt.getLaunchCommand(pair);
                }
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n = 4;
                boolean bl2 = !this.crashesWithSetsid(tool);
                List list2 = null;
                Path path3 = channel.getInstallationDirectory();
                Path path4 = path2;
                toolParameters = new ToolParameters(path4, path3, list2, bl2, n, defaultConstructorMarker);
            } else {
                toolParameters = this.of(tool, channel);
            }
            return toolParameters;
        }

        @NotNull
        public final ToolParameters of(@NotNull InstalledTool tool, @NotNull Channel channel) {
            Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            return new ToolParameters(ExtensionsKt.getLaunchCommand(new ToolInstance(channel, tool)), channel.getInstallationDirectory(), null, !this.crashesWithSetsid(tool), 4, null);
        }

        @NotNull
        public final ToolParameters of(@NotNull ToolInstance toolInstance) {
            Intrinsics.checkNotNullParameter((Object)toolInstance, (String)"toolInstance");
            return this.of(toolInstance.getTool(), toolInstance.getChannel());
        }

        @NotNull
        public final ToolParameters of(@NotNull Path absolutePath, @NotNull List<String> arguments2, boolean allowsSetsid) {
            Intrinsics.checkNotNullParameter((Object)absolutePath, (String)"absolutePath");
            Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
            if (!absolutePath.isAbsolute()) {
                boolean bl = false;
                String string = "Only absolute path is accepted";
                throw new IllegalArgumentException(string.toString());
            }
            Path path2 = absolutePath.parent();
            if (path2 == null) {
                boolean bl = false;
                String string = "Root path is not accepted";
                throw new IllegalArgumentException(string.toString());
            }
            Path directory = path2;
            return new ToolParameters(absolutePath, directory, arguments2, allowsSetsid);
        }

        public static /* synthetic */ ToolParameters of$default(Companion companion, Path path2, List list2, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.of(path2, list2, bl);
        }

        private final boolean crashesWithSetsid(InstalledTool tool) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = tool.getExtensions();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ToolExtension it = (ToolExtension)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getClass().getSimpleName(), (Object)"IntelliJToolExtension")) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl && BuildNumber.compareTo-Szkhn3Q(tool.getBuildNumber-Y_E1uuk(), BuildNumber.constructor-impl("242")) < 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

