/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools;

import com.jetbrains.toolbox.tools.ToolSearchRule;
import com.jetbrains.toolbox.tools.UniversalIntellijToolBuildDescriptor;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProductCodeRule
implements ToolSearchRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String pattern;

    public ProductCodeRule(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        this.pattern = pattern;
    }

    @NotNull
    public final String getPattern() {
        return this.pattern;
    }

    @Override
    public boolean match(@NotNull UniversalIntellijToolBuildDescriptor toolBuildDescriptor) {
        Intrinsics.checkNotNullParameter((Object)toolBuildDescriptor, (String)"toolBuildDescriptor");
        return Intrinsics.areEqual((Object)toolBuildDescriptor.getProductCode(), (Object)this.pattern) || Intrinsics.areEqual((Object)StringsKt.replace$default((String)toolBuildDescriptor.getType-UtVBrGo(), (String)"-", (String)"", (boolean)false, (int)4, null), (Object)this.pattern);
    }

    @Override
    @NotNull
    public String toPrettyString() {
        return Companion.generatePrettyString(this.pattern);
    }

    @NotNull
    public String toString() {
        return "ProductCodeRule(pattern=" + this.pattern + ")";
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProductCodeRule)) {
            return false;
        }
        ProductCodeRule productCodeRule = (ProductCodeRule)other;
        return Intrinsics.areEqual((Object)this.pattern, (Object)productCodeRule.pattern);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String generatePrettyString(@NotNull String productCode) {
            Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
            return "Product code should match '" + productCode + "'";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

