/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.tools.ToolSearchRule;
import com.jetbrains.toolbox.tools.UniversalIntellijToolBuildDescriptor;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuildNumberRule
implements ToolSearchRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String pattern;
    private final int componentIndex;

    public BuildNumberRule(@NotNull String pattern, int componentIndex) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        this.pattern = pattern;
        this.componentIndex = componentIndex;
    }

    @NotNull
    public final String getPattern() {
        return this.pattern;
    }

    public final int getComponentIndex() {
        return this.componentIndex;
    }

    @Override
    public boolean match(@NotNull UniversalIntellijToolBuildDescriptor toolBuildDescriptor) {
        Intrinsics.checkNotNullParameter((Object)toolBuildDescriptor, (String)"toolBuildDescriptor");
        return Intrinsics.areEqual((Object)CollectionsKt.getOrNull(BuildNumber.getComponents-impl(toolBuildDescriptor.getBuildNumber-Y_E1uuk()), (int)this.componentIndex), (Object)this.pattern);
    }

    @Override
    @NotNull
    public String toPrettyString() {
        return Companion.generatePrettyString(this.pattern, this.componentIndex);
    }

    @NotNull
    public String toString() {
        return "BuildNumberRule(pattern=" + this.pattern + ", componentIndex=" + this.componentIndex + ")";
    }

    public int hashCode() {
        int result2 = this.pattern.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.componentIndex);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BuildNumberRule)) {
            return false;
        }
        BuildNumberRule buildNumberRule = (BuildNumberRule)other;
        if (!Intrinsics.areEqual((Object)this.pattern, (Object)buildNumberRule.pattern)) {
            return false;
        }
        return this.componentIndex == buildNumberRule.componentIndex;
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String generatePrettyString(@NotNull String pattern, int componentIndex) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            return "Build number component with index: " + componentIndex + " should match '" + pattern + "'";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

