/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.state.model;

import com.jetbrains.toolbox.state.model.Tool;
import com.jetbrains.toolbox.state.model.Tool$;
import com.jetbrains.toolbox.state.model.ToolboxState$;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
public final class ToolboxState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int version;
    @NotNull
    private final String appVersion;
    @NotNull
    private final List<Tool> tools;
    @JvmField
    @NotNull
    private static final Lazy<KSerializer<Object>>[] $childSerializers;

    public ToolboxState(int version, @NotNull String appVersion, @NotNull List<Tool> tools2) {
        Intrinsics.checkNotNullParameter((Object)appVersion, (String)"appVersion");
        Intrinsics.checkNotNullParameter(tools2, (String)"tools");
        this.version = version;
        this.appVersion = appVersion;
        this.tools = tools2;
    }

    @NotNull
    public String toString() {
        return "ToolboxState(version=" + this.version + ", appVersion=" + this.appVersion + ", tools=" + this.tools + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.version);
        result2 = result2 * 31 + this.appVersion.hashCode();
        result2 = result2 * 31 + ((Object)this.tools).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ToolboxState)) {
            return false;
        }
        ToolboxState toolboxState = (ToolboxState)other;
        if (this.version != toolboxState.version) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.appVersion, (Object)toolboxState.appVersion)) {
            return false;
        }
        return Intrinsics.areEqual(this.tools, toolboxState.tools);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$shared_state_model(ToolboxState self, CompositeEncoder output2, SerialDescriptor serialDesc) {
        Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
        output2.encodeIntElement(serialDesc, 0, self.version);
        output2.encodeStringElement(serialDesc, 1, self.appVersion);
        output2.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)lazyArray[2].getValue(), self.tools);
    }

    public /* synthetic */ ToolboxState(int seen0, int version, String appVersion, List tools2, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)7, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.version = version;
        this.appVersion = appVersion;
        this.tools = tools2;
    }

    public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        Lazy[] lazyArray = new Lazy[]{null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)Tool$.serializer.INSTANCE))};
        $childSerializers = lazyArray;
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<ToolboxState> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

