/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.shortcutsWindows;

import com.jetbrains.toolbox.shortcutsWindows.Win32Shortcuts;
import com.jetbrains.toolbox.shortcutsWindows.WindowsShortcutChannelExtension;
import com.jetbrains.toolbox.tools.model.Channel;
import com.jetbrains.toolbox.tools.model.InstalledToolKt;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Util.kt\ncom/jetbrains/toolbox/shortcutsWindows/UtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,27:1\n808#2,11:28\n*S KotlinDebug\n*F\n+ 1 Util.kt\ncom/jetbrains/toolbox/shortcutsWindows/UtilKt\n*L\n10#1:28,11\n*E\n"})
public final class UtilKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final WindowsShortcutChannelExtension getWindowsShortcutExtension(@NotNull Channel $this$windowsShortcutExtension) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$windowsShortcutExtension, (String)"<this>");
        Iterable $this$filterIsInstance$iv = $this$windowsShortcutExtension.getExtensions();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof WindowsShortcutChannelExtension)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (WindowsShortcutChannelExtension)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    public static final void removeApplicationShortcut(@NotNull Win32Shortcuts $this$removeApplicationShortcut, @NotNull Path shortcutPath) {
        Intrinsics.checkNotNullParameter((Object)$this$removeApplicationShortcut, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)shortcutPath, (String)"shortcutPath");
        $this$removeApplicationShortcut.removeShortcut(UtilKt.addLinkExtensionIfNeeded(shortcutPath));
    }

    public static final void ensureApplicationShortcut(@NotNull Win32Shortcuts $this$ensureApplicationShortcut, @NotNull ToolInstance toolInstance, @NotNull Path shortcutPath, @NotNull Path command2) {
        Intrinsics.checkNotNullParameter((Object)$this$ensureApplicationShortcut, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)toolInstance, (String)"toolInstance");
        Intrinsics.checkNotNullParameter((Object)shortcutPath, (String)"shortcutPath");
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        try {
            $this$ensureApplicationShortcut.ensureShortcut(UtilKt.addLinkExtensionIfNeeded(shortcutPath), InstalledToolKt.displayNameWithVersion(toolInstance.getChannel(), toolInstance.getTool()), command2);
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, "Can't ensure shortcut for " + toolInstance.getChannel().getInstallationDirectory() + ", skipping ensuring the shortcut");
        }
    }

    private static final Path addLinkExtensionIfNeeded(Path path2) {
        return StringsKt.endsWith$default((String)path2.name(), (String)".lnk", (boolean)false, (int)2, null) ? path2 : Path.Companion.get$default((Path.Companion)Path.Companion, (String)(path2 + ".lnk"), (boolean)false, (int)1, null);
    }
}

