/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.shell.model;

import com.jetbrains.toolbox.feed.ApplicationType;
import com.jetbrains.toolbox.shell.model.ShellLauncherToolExtensionKt;
import com.jetbrains.toolbox.tools.ExtensionsKt;
import com.jetbrains.toolbox.tools.WellKnownApplications;
import com.jetbrains.toolbox.tools.model.EphemeralToolKt;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nToolInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolInfo.kt\ncom/jetbrains/toolbox/shell/model/ToolInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,49:1\n1#2:50\n*E\n"})
public final class ToolInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path installDir;
    @Nullable
    private final Path command;
    @NotNull
    private final AppType appType;
    @NotNull
    private final String launcherName;
    private final boolean hidden;

    public ToolInfo(@NotNull Path installDir, @Nullable Path command2, @NotNull AppType appType, @NotNull String launcherName, boolean hidden) {
        Intrinsics.checkNotNullParameter((Object)installDir, (String)"installDir");
        Intrinsics.checkNotNullParameter((Object)((Object)appType), (String)"appType");
        Intrinsics.checkNotNullParameter((Object)launcherName, (String)"launcherName");
        this.installDir = installDir;
        this.command = command2;
        this.appType = appType;
        this.launcherName = launcherName;
        this.hidden = hidden;
        if (!this.installDir.isAbsolute()) {
            boolean $i$a$-require-ToolInfo$32 = false;
            String $i$a$-require-ToolInfo$32 = "installDir should contain absolute path, but '" + this.installDir + "' is received";
            throw new IllegalArgumentException($i$a$-require-ToolInfo$32.toString());
        }
        if (!(this.command == null || this.command.isAbsolute())) {
            boolean bl = false;
            String string = "command should contain absolute path, but '" + this.command + "' is received";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final Path getInstallDir() {
        return this.installDir;
    }

    @Nullable
    public final Path getCommand() {
        return this.command;
    }

    @NotNull
    public final AppType getAppType() {
        return this.appType;
    }

    @NotNull
    public final String getLauncherName() {
        return this.launcherName;
    }

    public final boolean getHidden() {
        return this.hidden;
    }

    @NotNull
    public String toString() {
        return "ToolInfo(installDir=" + this.installDir + ", command=" + this.command + ", appType=" + this.appType + ", launcherName=" + this.launcherName + ", hidden=" + this.hidden + ")";
    }

    public int hashCode() {
        int result2 = this.installDir.hashCode();
        result2 = result2 * 31 + (this.command == null ? 0 : this.command.hashCode());
        result2 = result2 * 31 + this.appType.hashCode();
        result2 = result2 * 31 + this.launcherName.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.hidden);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ToolInfo)) {
            return false;
        }
        ToolInfo toolInfo = (ToolInfo)other;
        if (!Intrinsics.areEqual((Object)this.installDir, (Object)toolInfo.installDir)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.command, (Object)toolInfo.command)) {
            return false;
        }
        if (this.appType != toolInfo.appType) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.launcherName, (Object)toolInfo.launcherName)) {
            return false;
        }
        return this.hidden == toolInfo.hidden;
    }

    public static final class AppType
    extends Enum<AppType> {
        public static final /* enum */ AppType IntellijBased = new AppType();
        public static final /* enum */ AppType Fleet = new AppType();
        private static final /* synthetic */ AppType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AppType[] values() {
            return (AppType[])$VALUES.clone();
        }

        static {
            $VALUES = appTypeArray = new AppType[]{AppType.IntellijBased, AppType.Fleet};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ToolInfo of(@NotNull ToolInstance toolInstance, @NotNull String launcherName) {
            AppType appType;
            Intrinsics.checkNotNullParameter((Object)toolInstance, (String)"toolInstance");
            Intrinsics.checkNotNullParameter((Object)launcherName, (String)"launcherName");
            ToolInstance $this$of_u24lambda_u240 = toolInstance;
            boolean bl = false;
            if (ApplicationType.equals-impl0($this$of_u24lambda_u240.getTool().getToolId-UtVBrGo(), WellKnownApplications.INSTANCE.getFleet-UtVBrGo())) {
                appType = AppType.Fleet;
            } else if (ShellLauncherToolExtensionKt.getShellLauncher($this$of_u24lambda_u240.getTool()) != null) {
                appType = AppType.IntellijBased;
            } else {
                return null;
            }
            AppType appType2 = appType;
            Path installDir = $this$of_u24lambda_u240.getChannel().getInstallationDirectory();
            return new ToolInfo(installDir, ExtensionsKt.getLaunchCommand(toolInstance), appType2, launcherName, EphemeralToolKt.getHidden($this$of_u24lambda_u240.getTool()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

