/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.shell.generator;

import com.jetbrains.toolbox.common.Win32ArgumentHelper;
import com.jetbrains.toolbox.shell.generator.AbstractShellLauncherGenerator;
import com.jetbrains.toolbox.shell.model.ToolInfo;
import com.jetbrains.toolbox.shell.resolver.ExecutableResolver;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
public final class WindowsIntellijLauncherGenerator
extends AbstractShellLauncherGenerator {
    @NotNull
    private final String applicationFullNameVersion;
    @NotNull
    private final ExecutableResolver resolver;

    public WindowsIntellijLauncherGenerator(@NotNull String applicationFullNameVersion, @NotNull ExecutableResolver resolver) {
        Intrinsics.checkNotNullParameter((Object)applicationFullNameVersion, (String)"applicationFullNameVersion");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        this.applicationFullNameVersion = applicationFullNameVersion;
        this.resolver = resolver;
    }

    @Override
    @NotNull
    protected String getApplicationFullNameVersion() {
        return this.applicationFullNameVersion;
    }

    @Override
    @NotNull
    public String generateShellScript(@NotNull ToolInfo tool) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        return StringsKt.trimMargin$default((String)("\n    |@echo off\n    |rem " + this.createHeaderComment() + "\n    |\n    |set waitarg=\n    |set intellij_args=\n    |\n    |:next\n    |set \"passwait=\"\n    |if \"%~1\"==\"--wait\" set passwait=1\n    |if \"%~1\"==\"-w\" set passwait=1\n    |if defined passwait (set waitarg=/wait)\n    |if not \"%~1\"==\"\" (\n    |  if defined passwait (set \"intellij_args=%intellij_args%--wait \") else (set \"intellij_args=%intellij_args%%1 \")\n    |  shift\n    |  goto next\n    |)\n    |\n    |start \"\" %waitarg% " + Win32ArgumentHelper.INSTANCE.quoteArgument(this.resolver.resolveExecutablePath(tool).toString()) + " %intellij_args%\n  "), null, (int)1, null);
    }
}

