/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.shell.generator;

import com.jetbrains.toolbox.shell.generator.AbstractShellLauncherGenerator;
import com.jetbrains.toolbox.shell.model.ToolInfo;
import com.jetbrains.toolbox.shell.resolver.ExecutableResolver;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
public final class LinuxCommonLauncherGenerator
extends AbstractShellLauncherGenerator {
    @NotNull
    private final String applicationFullNameVersion;
    @NotNull
    private final ExecutableResolver resolver;

    public LinuxCommonLauncherGenerator(@NotNull String applicationFullNameVersion, @NotNull ExecutableResolver resolver) {
        Intrinsics.checkNotNullParameter((Object)applicationFullNameVersion, (String)"applicationFullNameVersion");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        this.applicationFullNameVersion = applicationFullNameVersion;
        this.resolver = resolver;
    }

    @Override
    @NotNull
    protected String getApplicationFullNameVersion() {
        return this.applicationFullNameVersion;
    }

    @Override
    @NotNull
    public String generateShellScript(@NotNull ToolInfo tool) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        return StringsKt.trimMargin$default((String)("\n    |#!/bin/bash\n    |#" + this.createHeaderComment() + "\n    |\n    |\"" + this.resolver.resolveExecutablePath(tool) + "\" \"$@\"\n  "), null, (int)1, null);
    }
}

