/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.shell;

import com.jetbrains.toolbox.shell.ShellLaunchersStateListener;
import com.jetbrains.toolbox.shell.generator.WindowsBashLauncherGenerator;
import com.jetbrains.toolbox.shell.model.ToolInfo;
import java.io.Closeable;
import kotlin.ExceptionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.BufferedSink;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nWindowsBashLaunchersManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsBashLaunchersManager.kt\ncom/jetbrains/toolbox/shell/WindowsBashLaunchersManager\n+ 2 FileSystem.kt\nokio/FileSystem\n+ 3 Okio.kt\nokio/Okio__OkioKt\n*L\n1#1,45:1\n80#2:46\n165#2:47\n81#2:48\n82#2:53\n52#3,4:49\n60#3,10:54\n56#3,18:64\n*S KotlinDebug\n*F\n+ 1 WindowsBashLaunchersManager.kt\ncom/jetbrains/toolbox/shell/WindowsBashLaunchersManager\n*L\n18#1:46\n18#1:47\n18#1:48\n18#1:53\n18#1:49,4\n18#1:54,10\n18#1:64,18\n*E\n"})
public final class WindowsBashLaunchersManager
implements ShellLaunchersStateListener {
    @NotNull
    private final WindowsBashLauncherGenerator launcherGenerator;
    @NotNull
    private final FileSystem fileSystem;

    public WindowsBashLaunchersManager(@NotNull WindowsBashLauncherGenerator launcherGenerator, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)launcherGenerator, (String)"launcherGenerator");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.launcherGenerator = launcherGenerator;
        this.fileSystem = fileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onShellLauncherCreated(@NotNull ToolInfo tool, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            BufferedSink bufferedSink;
            Throwable thrown$iv$iv;
            Path path2;
            block18: {
                void $this$iv;
                Path path3 = this.getAdditionalLauncherPath(file, "created");
                if (path3 == null) {
                    return;
                }
                path2 = path3;
                String content2 = this.launcherGenerator.generateShellScript(tool);
                FileSystem fileSystem = this.fileSystem;
                Path file$iv = path2;
                boolean mustCreate$iv = false;
                boolean bl = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, mustCreate$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                    boolean bl2 = false;
                    BufferedSink $this$onShellLauncherCreated_u24lambda_u240 = it$iv;
                    boolean bl3 = false;
                    bufferedSink = $this$onShellLauncherCreated_u24lambda_u240.writeUtf8(content2);
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        bufferedSink = null;
                        break block18;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block19: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block19;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            BufferedSink result$iv$iv = bufferedSink;
            Throwable throwable = thrown$iv$iv;
            if (throwable != null) {
                throw throwable;
            }
            Logger.INSTANCE.debug("Created additional shell launcher '" + path2.name() + "'");
            return;
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, "Unable to create additional launcher for '" + file.name() + "'");
        }
    }

    @Override
    public void onShellLauncherRemoved(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            Path path2 = this.getAdditionalLauncherPath(file, "removed");
            if (path2 == null) {
                return;
            }
            Path path3 = path2;
            this.fileSystem.delete(path3);
            Logger.INSTANCE.debug("Removed additional shell launcher '" + path3.name() + "'");
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, "Unable to remove additional launcher for '" + file.name() + "'");
        }
    }

    private final Path getAdditionalLauncherPath(Path file, String logAction) {
        String name2 = file.name();
        String additionalLauncherName = StringsKt.removeSuffix((String)name2, (CharSequence)".cmd");
        if (Intrinsics.areEqual((Object)additionalLauncherName, (Object)name2)) {
            Logger.INSTANCE.warn("Expecting launcher name '" + name2 + "' to have '.cmd' extension. Additional launcher will not be " + logAction + ".");
            return null;
        }
        Path path2 = file.parent();
        return path2 != null ? Path.resolve$default((Path)path2, (String)additionalLauncherName, (boolean)false, (int)2, null) : null;
    }
}

