/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.shell;

import com.jetbrains.toolbox.OS;
import com.jetbrains.toolbox.StandardPaths;
import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.shell.ShellEnvironment;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.TimeoutKt;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nShellEnvironmentImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellEnvironmentImpl.kt\ncom/jetbrains/toolbox/shell/ShellEnvironmentImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n1563#2:178\n1634#2,3:179\n1563#2:182\n1634#2,3:183\n1878#2,3:186\n774#2:189\n865#2,2:190\n1374#2:192\n1460#2,5:193\n774#2:198\n865#2,2:199\n*S KotlinDebug\n*F\n+ 1 ShellEnvironmentImpl.kt\ncom/jetbrains/toolbox/shell/ShellEnvironmentImpl\n*L\n44#1:178\n44#1:179,3\n67#1:182\n67#1:183,3\n89#1:186,3\n93#1:189\n93#1:190,2\n94#1:192\n94#1:193,5\n95#1:198\n95#1:199,2\n*E\n"})
public final class ShellEnvironmentImpl
implements ShellEnvironment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String shellType;
    @NotNull
    private final ProcessBuilder processBuilder;
    private final long initialDelay;
    private final long executionTimeout;
    @NotNull
    private final OS.Type os;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final String pathSeparator;
    @NotNull
    private List<Path> path;
    @NotNull
    private final List<String> pathExtensions;
    @NotNull
    private final Job initJob;

    /*
     * WARNING - void declaration
     */
    private ShellEnvironmentImpl(String systemPath, String pathExtensions, String shellType, ProcessBuilder processBuilder, long initialDelay, long executionTimeout, OS.Type os, FileSystem fileSystem, CoroutineScope coroutineScope) {
        List list2;
        String[] stringArray;
        List list3;
        Intrinsics.checkNotNullParameter((Object)systemPath, (String)"systemPath");
        Intrinsics.checkNotNullParameter((Object)shellType, (String)"shellType");
        Intrinsics.checkNotNullParameter((Object)processBuilder, (String)"processBuilder");
        Intrinsics.checkNotNullParameter((Object)((Object)os), (String)"os");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.shellType = shellType;
        this.processBuilder = processBuilder;
        this.initialDelay = initialDelay;
        this.executionTimeout = executionTimeout;
        this.os = os;
        this.fileSystem = fileSystem;
        this.coroutineScope = coroutineScope;
        this.pathSeparator = this.os == OS.Type.Windows ? ";" : ":";
        this.path = this.split(systemPath);
        ShellEnvironmentImpl shellEnvironmentImpl = this;
        if (pathExtensions != null && (list3 = StringsKt.split$default((CharSequence)pathExtensions, (String[])(stringArray = new String[]{this.pathSeparator}), (boolean)false, (int)0, (int)6, null)) != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list3;
            ShellEnvironmentImpl shellEnvironmentImpl2 = shellEnvironmentImpl;
            boolean $i$f$map = false;
            void var16_16 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
            }
            list2 = (List)destination$iv$iv;
            shellEnvironmentImpl = shellEnvironmentImpl2;
        } else {
            Object[] objectArray = new String[]{".com", ".exe", ".bat", ".cmd"};
            list2 = CollectionsKt.listOf((Object[])objectArray);
        }
        shellEnvironmentImpl.pathExtensions = list2;
        this.initJob = this.os == OS.Type.Mac ? BuildersKt.launch((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (CoroutineStart)CoroutineStart.LAZY, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ShellEnvironmentImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        ShellEnvironmentImpl.access$setPath$p(this.this$0, CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)ShellEnvironmentImpl.access$getPathVarViaShell(this.this$0), (Iterable)this.this$0.getPath())));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })) : (Job)CompletableDeferredKt.CompletableDeferred((Object)Unit.INSTANCE);
    }

    public /* synthetic */ ShellEnvironmentImpl(String string, String string2, String string3, ProcessBuilder processBuilder, long l, long l2, OS.Type type2, FileSystem fileSystem, CoroutineScope coroutineScope, int n, DefaultConstructorMarker defaultConstructorMarker) {
        String string4;
        String string5;
        if ((n & 1) != 0 && (string5 = System.getenv("PATH")) == null) {
            string5 = string = "";
        }
        if ((n & 2) != 0) {
            string2 = System.getenv("PATHEXT");
        }
        if ((n & 4) != 0 && (string4 = System.getenv("SHELL")) == null) {
            string4 = string3 = "bash";
        }
        if ((n & 8) != 0) {
            processBuilder = new ProcessBuilder(new String[0]);
        }
        if ((n & 0x10) != 0) {
            l = DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS);
        }
        if ((n & 0x20) != 0) {
            l2 = DurationKt.toDuration((int)60, (DurationUnit)DurationUnit.SECONDS);
        }
        this(string, string2, string3, processBuilder, l, l2, type2, fileSystem, coroutineScope, null);
    }

    @Override
    @NotNull
    public String getPathString() {
        return CollectionsKt.joinToString$default((Iterable)this.getPath(), (CharSequence)this.pathSeparator, null, null, (int)0, null, ShellEnvironmentImpl::_get_pathString_$lambda$0, (int)30, null);
    }

    @Override
    @NotNull
    public List<Path> getPath() {
        return this.path;
    }

    @Override
    @Nullable
    public Object awaitInitialization(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.initJob.join($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final void scheduleInit() {
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ShellEnvironmentImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = DelayKt.delay-VtjQ1oo((long)ShellEnvironmentImpl.access$getInitialDelay$p(this.this$0), (Continuation)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.label = 2;
                        v1 = this.this$0.awaitInitialization((Continuation<? super Unit>)((Continuation)this));
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl21
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl21:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Path> split(String path2) {
        void $this$mapTo$iv$iv;
        String[] stringArray = new String[]{this.pathSeparator};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)path2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Path.Companion.get$default((Path.Companion)Path.Companion, (String)((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString(), (boolean)false, (int)1, null));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Path> getPathVarViaShell() {
        List list2;
        Logger.INSTANCE.debug("PATH from shell. Toolbox PID=" + OS.INSTANCE.getPID());
        String[] stringArray = new String[]{this.shellType, "-l", "-i", "-c", "printenv PATH"};
        this.processBuilder.command(stringArray);
        this.processBuilder.directory(StandardPaths.INSTANCE.getHome().toFile());
        Map<String, String> environment = this.processBuilder.environment();
        Intrinsics.checkNotNull(environment);
        environment.put("DISABLE_AUTO_UPDATE", "true");
        environment.put("INTELLIJ_ENVIRONMENT_READER", "true");
        this.processBuilder.redirectError(ProcessBuilder.Redirect.DISCARD);
        this.processBuilder.redirectInput(ProcessBuilder.Redirect.PIPE);
        File file = this.processBuilder.directory();
        List<String> list3 = this.processBuilder.command();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"command(...)");
        Logger.INSTANCE.debug("PATH from shell. Running: " + file + ">" + CollectionsKt.joinToString$default((Iterable)list3, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        try {
            List list4;
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Process process2 = this.processBuilder.start();
            process2.getOutputStream().close();
            Intrinsics.checkNotNull((Object)process2);
            List<String> lines = this.readOutputLines(process2);
            Logger.INSTANCE.debug("PATH from shell. [printed " + lines.size() + " lines]");
            Iterable $this$forEachIndexed$iv = lines;
            boolean $i$f$forEachIndexed = false;
            int index$iv22 = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void line;
                int n;
                if ((n = index$iv22++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                int index = n;
                boolean bl = false;
                Logger.INSTANCE.debug("PATH from shell. Line " + (index + 1) + ". [" + (String)line + "]");
            }
            $this$forEachIndexed$iv = lines;
            boolean $i$f$filter = false;
            void index$iv22 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String line = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)line);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                String line = (String)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = this.split(line);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Path path2 = (Path)element$iv$iv;
                boolean bl = false;
                if (!this.fileSystem.exists(path2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List paths = list4 = (List)destination$iv$iv;
            boolean bl = false;
            Logger.INSTANCE.info("PATH from shell. Paths:\n  " + CollectionsKt.joinToString$default((Iterable)paths, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
            list2 = list4;
        }
        catch (Exception e) {
            Logger.INSTANCE.warn((Throwable)e, "PATH from shell. Failed to get PATH from shell Toolbox PID=" + OS.INSTANCE.getPID());
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private final List<String> readOutputLines(Process process2) {
        return (List)BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends String>>, Object>(process2, this, null){
            Object L$1;
            Object L$2;
            Object L$3;
            long J$0;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Process $process;
            final /* synthetic */ ShellEnvironmentImpl this$0;
            {
                this.$process = $process;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var13_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        processPid = this.$process.pid();
                        Logger.INSTANCE.debug("PATH from shell. Shell process PID=" + processPid);
                        var5_5 = this.$process.getInputStream();
                        var6_6 = this.this$0;
                        var7_8 = null;
                        try {
                            processOutput = (InputStream)var5_5;
                            $i$a$-use-ShellEnvironmentImpl$readOutputLines$1$1 = 0;
                            outputLinesDeferred = BuildersKt.async$default((CoroutineScope)$this$runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends String>>, Object>(processOutput, null){
                                int label;
                                final /* synthetic */ InputStream $processOutput;
                                {
                                    this.$processOutput = $processOutput;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            InputStream inputStream = this.$processOutput;
                                            Intrinsics.checkNotNull((Object)inputStream);
                                            Charset charset = Charsets.UTF_8;
                                            return TextStreamsKt.readLines((Reader)new InputStreamReader(inputStream, charset));
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super List<String>> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null);
                            Logger.INSTANCE.debug("PATH from shell. Waiting for process PID=" + processPid + " output...");
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$runBlocking);
                            this.L$1 = var5_5;
                            this.L$2 = SpillingKt.nullOutSpilledVariable((Object)processOutput);
                            this.L$3 = outputLinesDeferred;
                            this.J$0 = processPid;
                            this.I$0 = $i$a$-use-ShellEnvironmentImpl$readOutputLines$1$1;
                            this.label = 1;
                            v0 = TimeoutKt.withTimeout-KLykuaI((long)ShellEnvironmentImpl.access$getExecutionTimeout$p(var6_6), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends String>>, Object>((Deferred<? extends List<String>>)outputLinesDeferred, null){
                                int label;
                                final /* synthetic */ Deferred<List<String>> $outputLinesDeferred;
                                {
                                    this.$outputLinesDeferred = $outputLinesDeferred;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            Object object2 = this.$outputLinesDeferred.await((Continuation)this);
                                            if (object2 != object) return object2;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return object2;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super List<String>> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)this);
                        }
                        catch (Throwable var9_12) {
                            var7_8 = var9_12;
                            throw var9_12;
                        }
                        catch (Throwable var9_13) {
                            throw var9_13;
                        }
                        v1 = v0;
                        if (v0 == var13_3) {
                            return var13_3;
                        }
                        ** GOTO lbl61
                    }
                    case 1: {
                        $i$a$-use-ShellEnvironmentImpl$readOutputLines$1$1 = this.I$0;
                        processPid = this.J$0;
                        outputLinesDeferred = (Deferred)this.L$3;
                        processOutput = (InputStream)this.L$2;
                        var7_8 = null;
                        var5_5 = (Closeable)this.L$1;
                        ** try [egrp 5[TRYBLOCK] [1 : 250->279)] { 
lbl51:
                        // 1 sources

                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
                        ** GOTO lbl61
lbl55:
                        // 1 sources

                        finally {
                            if (!outputLinesDeferred.isCompleted()) {
                                Logger.INSTANCE.debug("PATH from shell. Cancelling waiting for process PID=" + processPid + " output...");
                                Job.DefaultImpls.cancel$default((Job)((Job)outputLinesDeferred), null, (int)1, null);
                                Logger.INSTANCE.debug("PATH from shell. Cancelled waiting for process PID=" + processPid + " output.");
                            }
                        }
lbl61:
                        // 2 sources

                        outputLines = (List)v1;
                        Logger.INSTANCE.debug("PATH from shell. Read process PID=" + processPid + " output: [" + outputLines + "]");
                        var11_15 = outputLines;
                        var8_9 = var11_15;
                        return var8_9;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<String>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Override
    @Nullable
    public Path findExecutable(@NotNull String executable) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Path absolutePath = Path.Companion.get$default((Path.Companion)Path.Companion, (String)executable, (boolean)false, (int)1, null);
        if (this.fileSystem.exists(absolutePath)) {
            return absolutePath;
        }
        for (Path path2 : this.getPath()) {
            Path candidate;
            if (this.os == OS.Type.Windows) {
                List<String> extensions = this.pathExtensions;
                for (String extension2 : extensions) {
                    Path candidate2 = path2.resolve(executable + extension2);
                    if (!this.fileSystem.exists(candidate2)) continue;
                    return candidate2;
                }
            }
            if (!this.fileSystem.exists(candidate = path2.resolve(executable))) continue;
            return candidate;
        }
        return null;
    }

    @Override
    @Nullable
    public String get(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return System.getenv(name2);
    }

    private static final CharSequence _get_pathString_$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toString();
    }

    public /* synthetic */ ShellEnvironmentImpl(String systemPath, String pathExtensions, String shellType, ProcessBuilder processBuilder, long initialDelay, long executionTimeout, OS.Type os, FileSystem fileSystem, CoroutineScope coroutineScope, DefaultConstructorMarker $constructor_marker) {
        this(systemPath, pathExtensions, shellType, processBuilder, initialDelay, executionTimeout, os, fileSystem, coroutineScope);
    }

    public static final /* synthetic */ long access$getInitialDelay$p(ShellEnvironmentImpl $this) {
        return $this.initialDelay;
    }

    public static final /* synthetic */ long access$getExecutionTimeout$p(ShellEnvironmentImpl $this) {
        return $this.executionTimeout;
    }

    public static final /* synthetic */ void access$setPath$p(ShellEnvironmentImpl $this, List list2) {
        $this.path = list2;
    }

    public static final /* synthetic */ List access$getPathVarViaShell(ShellEnvironmentImpl $this) {
        return $this.getPathVarViaShell();
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

