/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.settings;

import com.jetbrains.toolbox.common.datetime.InstantExtensionsKt;
import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.interop.Win32Integration;
import com.jetbrains.toolbox.settings.Onboarding;
import com.jetbrains.toolbox.settings.Storage;
import com.jetbrains.toolbox.settings.StorageManager;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import kotlin.ExceptionsKt;
import kotlin.KotlinNothingValueException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileMetadata;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nStorageManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StorageManagerImpl.kt\ncom/jetbrains/toolbox/settings/StorageManagerImpl\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Okio.kt\nokio/Okio__OkioKt\n+ 5 FileSystem.kt\nokio/FileSystem\n*L\n1#1,89:1\n230#2,5:90\n230#2,5:119\n1#3:95\n66#4:96\n52#4,4:98\n60#4,10:103\n56#4,3:113\n71#4,3:116\n52#4,4:127\n60#4,10:132\n56#4,18:142\n67#5:97\n68#5:102\n80#5:124\n165#5:125\n81#5:126\n82#5:131\n*S KotlinDebug\n*F\n+ 1 StorageManagerImpl.kt\ncom/jetbrains/toolbox/settings/StorageManagerImpl\n*L\n60#1:90,5\n71#1:119,5\n39#1:96\n39#1:98,4\n39#1:103,10\n39#1:113,3\n39#1:116,3\n86#1:127,4\n86#1:132,10\n86#1:142,18\n39#1:97\n39#1:102\n86#1:124\n86#1:125\n86#1:126\n86#1:131\n*E\n"})
public final class StorageManagerImpl
implements StorageManager {
    @NotNull
    private final Path storageFile;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Json json;
    @NotNull
    private final MutableStateFlow<Storage> storage;

    public StorageManagerImpl(@NotNull Path storageFile, boolean isInstall, boolean suppressOnboarding, @NotNull FileSystem fileSystem, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.storageFile = storageFile;
        this.fileSystem = fileSystem;
        this.json = JsonKt.Json$default(null, StorageManagerImpl::json$lambda$0, (int)1, null);
        this.storage = StateFlowKt.MutableStateFlow((Object)this.loadStorage(isInstall, suppressOnboarding));
        if (!isInstall) {
            BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ StorageManagerImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.this$0.getStorage().collect(new FlowCollector(){

                                public final Object emit(Storage it, Continuation<? super Unit> $completion) {
                                    this$0.saveStorage();
                                    return Unit.INSTANCE;
                                }
                            }, (Continuation)this);
                            if (object2 != object) throw new KotlinNothingValueException();
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            throw new KotlinNothingValueException();
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            if (((Storage)this.getStorage().getValue()).getFirstRunDate() == null) {
                Storage it;
                Storage nextValue$iv;
                Object prevValue$iv;
                MutableStateFlow<Storage> $this$update$iv = this.getStorage();
                boolean $i$f$update = false;
                do {
                    prevValue$iv = $this$update$iv.getValue();
                    it = (Storage)prevValue$iv;
                    boolean bl = false;
                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = Storage.copy-sSrm3y0$default(it, false, false, InstantExtensionsKt.toISOString(this.firstRunDate()), null, null, null, null, null, false, 0L, false, null, null, false, null, 32763, null))));
            }
        }
    }

    @Override
    @NotNull
    public MutableStateFlow<Storage> getStorage() {
        return this.storage;
    }

    private final Instant firstRunDate() {
        Object object;
        block3: {
            block2: {
                object = this.storageFile.parent();
                if (object == null) break block2;
                Path it = object;
                boolean bl = false;
                FileMetadata fileMetadata2 = this.fileSystem.metadataOrNull(it);
                object = fileMetadata2;
                if (fileMetadata2 == null || (object = object.getLastModifiedAtMillis()) == null) break block2;
                long it2 = ((Number)object).longValue();
                boolean bl2 = false;
                Instant instant = Instant.Companion.fromEpochMilliseconds(it2);
                object = instant;
                if (instant != null) break block3;
            }
            object = Instant.Companion.getDISTANT_PAST();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Storage loadStorage(boolean isInstall, boolean suppressOnboarding) {
        try {
            String string;
            Throwable thrown$iv$iv;
            block17: {
                void this_$iv;
                FileSystem fileSystem = this.fileSystem;
                Path file$iv = this.storageFile;
                boolean bl = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                    boolean bl2 = false;
                    BufferedSource $this$loadStorage_u24lambda_u240 = it$iv;
                    boolean bl3 = false;
                    string = $this$loadStorage_u24lambda_u240.readUtf8();
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        string = null;
                        break block17;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block18: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block18;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            String result$iv$iv = string;
            Throwable throwable = thrown$iv$iv;
            if (throwable != null) {
                throw throwable;
            }
            String text2 = result$iv$iv;
            if (!(((CharSequence)text2).length() == 0)) return (Storage)com.jetbrains.toolbox.common.JsonKt.getJsonx().decodeFromString((DeserializationStrategy)Storage.Companion.serializer(), text2);
            throw new IOException();
        }
        catch (Throwable t2) {
            Onboarding defaultOnboarding;
            Onboarding onboarding = defaultOnboarding = suppressOnboarding ? Onboarding.Companion.getFinished() : Onboarding.Companion.getEmpty();
            return isInstall ? new Storage(false, false, null, null, null, null, null, null, false, 0L, false, defaultOnboarding, null, false, null, 30715, null) : (t2 instanceof FileNotFoundException || t2 instanceof IOException ? new Storage(false, false, InstantExtensionsKt.toISOString(Clock.System.INSTANCE.now()), null, null, null, null, null, false, 0L, false, defaultOnboarding, null, false, null, 30715, null) : new Storage(false, false, InstantExtensionsKt.toISOString(this.firstRunDate()), null, null, null, null, null, false, 0L, false, defaultOnboarding, null, false, null, 30715, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void saveStorage() {
        BufferedSink bufferedSink;
        Throwable thrown$iv$iv;
        block17: {
            void $this$iv;
            boolean bl;
            boolean storageFileExists = this.fileSystem.exists(this.storageFile);
            if (OS.INSTANCE.isWindows() && storageFileExists) {
                Win32Integration.INSTANCE.setFileAttributesNormal(this.storageFile.toFile());
            }
            if (!storageFileExists) {
                Path path2 = this.storageFile.parent();
                if (path2 != null) {
                    Path it = path2;
                    bl = false;
                    this.fileSystem.createDirectories(it);
                }
            }
            FileSystem fileSystem = this.fileSystem;
            Path file$iv = this.storageFile;
            boolean mustCreate$iv = false;
            bl = false;
            Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, mustCreate$iv));
            boolean $i$f$use = false;
            thrown$iv$iv = null;
            try {
                BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                boolean bl2 = false;
                BufferedSink $this$saveStorage_u24lambda_u241 = it$iv;
                boolean bl3 = false;
                bufferedSink = $this$saveStorage_u24lambda_u241.writeUtf8(this.json.encodeToString((SerializationStrategy)Storage.Companion.serializer(), this.getStorage().getValue()));
            }
            catch (Throwable t$iv$iv) {
                try {
                    thrown$iv$iv = t$iv$iv;
                    bufferedSink = null;
                    break block17;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    block18: {
                        try {
                            Closeable closeable = $this$use$iv$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv$iv2) {
                            if (thrown$iv$iv == null) {
                                thrown$iv$iv = t$iv$iv2;
                                break block18;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                        }
                    }
                }
            }
            try {
                Closeable closeable = $this$use$iv$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv$iv) {
                thrown$iv$iv = t$iv$iv;
            }
        }
        BufferedSink result$iv$iv = bufferedSink;
        Throwable throwable = thrown$iv$iv;
        if (throwable == null) return;
        throw throwable;
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setEncodeDefaults(true);
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setLenient(true);
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }
}

