/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.rpc.metrics;

import com.jetbrains.toolbox.common.JsonKt;
import com.jetbrains.toolbox.common.formatting.HumanMemorySizeKt;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.BiFunction;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.selects.OnTimeoutKt;
import kotlinx.coroutines.selects.SelectBuilder;
import kotlinx.coroutines.selects.SelectImplementation;
import kotlinx.rpc.krpc.KrpcTransportMessage;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nTransportMetrics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportMetrics.kt\ncom/jetbrains/toolbox/rpc/metrics/TransportMetrics\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 catching.kt\ncom/jetbrains/toolbox/common/concurrent/CatchingKt\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1068#2:111\n1869#2,2:112\n7#3,2:114\n9#3,5:117\n222#4:116\n1#5:122\n*S KotlinDebug\n*F\n+ 1 TransportMetrics.kt\ncom/jetbrains/toolbox/rpc/metrics/TransportMetrics\n*L\n63#1:111\n63#1:112,2\n70#1:114,2\n70#1:117,5\n71#1:116\n*E\n"})
public final class TransportMetrics {
    @NotNull
    private final String name;
    private final long debounceTimeout;
    @NotNull
    private final Channel<Pair<String, Integer>> logChannel;
    @NotNull
    private final Set<String> keepAliveIds;

    private TransportMetrics(String name2, CoroutineScope scope2, long debounceTimeout) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.name = name2;
        this.debounceTimeout = debounceTimeout;
        this.logChannel = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        this.keepAliveIds = SetsKt.setOf((Object)"ControlService.keepalive");
        BuildersKt.launch$default((CoroutineScope)scope2, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int I$0;
            int I$1;
            int label;
            final /* synthetic */ TransportMetrics this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var27_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        map = new LinkedHashMap<K, V>();
lbl7:
                        // 3 sources

                        while (true) {
                            var4_5 = this.this$0;
                            $i$f$select = 0;
                            $this$select_u24lambda_u240$iv = new SelectImplementation(this.getContext());
                            $i$a$-run-SelectKt$select$2$iv = 0;
                            $this$invokeSuspend_u24lambda_u240 = (SelectBuilder)$this$select_u24lambda_u240$iv;
                            $i$a$-select-TransportMetrics$1$message$1 = false;
                            $this$invokeSuspend_u24lambda_u240.invoke(TransportMetrics.access$getLogChannel$p(var4_5).getOnReceive(), (Function2)new Function2<Pair<? extends String, ? extends Integer>, Continuation<? super Pair<? extends String, ? extends Integer>>, Object>(null){
                                int label;
                                /* synthetic */ Object L$0;

                                /*
                                 * WARNING - void declaration
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Pair pair = (Pair)this.L$0;
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            void it;
                                            ResultKt.throwOnFailure((Object)$result);
                                            return it;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value2;
                                    return (Continuation)var3_3;
                                }

                                public final Object invoke(Pair<String, Integer> p1, Continuation<? super Pair<String, Integer>> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            });
                            if (((Collection)SetsKt.minus(map.keySet(), (Iterable)TransportMetrics.access$getKeepAliveIds$p(var4_5))).isEmpty() == false) {
                                OnTimeoutKt.onTimeout-8Mi8wO0((SelectBuilder)$this$invokeSuspend_u24lambda_u240, (long)TransportMetrics.access$getDebounceTimeout$p(var4_5), (Function1)((Function1)new Function1<Continuation<? super Pair<? extends String, ? extends Integer>>, Object>(null){
                                    int label;

                                    public final Object invokeSuspend(Object $result) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                return null;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(Continuation<? super Pair<String, Integer>> p1) {
                                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }));
                            }
                            this.L$0 = map;
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$select_u24lambda_u240$iv);
                            this.I$0 = $i$f$select;
                            this.I$1 = $i$a$-run-SelectKt$select$2$iv;
                            this.label = 1;
                            v0 = $this$select_u24lambda_u240$iv.doSelect((Continuation)this);
                            if (v0 == var27_2) {
                                return var27_2;
                            }
                            ** GOTO lbl37
                            break;
                        }
                    }
                    case 1: {
                        $i$a$-run-SelectKt$select$2$iv = this.I$1;
                        $i$f$select = this.I$0;
                        $this$select_u24lambda_u240$iv = (SelectImplementation)this.L$1;
                        map = (Map)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl37:
                        // 2 sources

                        message = (Pair)v0;
                        if (message == null) ** GOTO lbl45
                        var4_5 = message;
                        callId = (String)var4_5.component1();
                        size = ((Number)var4_5.component2()).intValue();
                        map.compute(callId, (BiFunction<Object, Object, Metric>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$2(kotlin.jvm.functions.Function2 java.lang.Object java.lang.Object ), (Ljava/lang/Object;Ljava/lang/Object;)Lcom/jetbrains/toolbox/rpc/metrics/TransportMetrics$Metric;)((Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$1(int java.lang.String com.jetbrains.toolbox.rpc.metrics.TransportMetrics$Metric ), (Ljava/lang/String;Lcom/jetbrains/toolbox/rpc/metrics/TransportMetrics$Metric;)Lcom/jetbrains/toolbox/rpc/metrics/TransportMetrics$Metric;)((int)size)));
                        ** GOTO lbl7
lbl45:
                        // 1 sources

                        var5_6 = this.this$0;
                        $this$invokeSuspend_u24lambda_u243 = var6_9 = new StringBuilder();
                        $i$a$-buildString-TransportMetrics$1$message$2 = false;
                        $this$invokeSuspend_u24lambda_u243.append(TransportMetrics.access$getName$p(var5_6)).append('\n');
                        $this$partition$iv = map.entrySet();
                        $i$f$partition = false;
                        first$iv = new ArrayList<T>();
                        second$iv = new ArrayList<T>();
                        for (T element$iv : $this$partition$iv) {
                            it = (Map.Entry)element$iv;
                            $i$a$-partition-TransportMetrics$1$message$2$1 = false;
                            v1 = TransportMetrics.access$getKeepAliveIds$p(var5_6).contains(it.getKey()) != false ? first$iv.add(element$iv) : second$iv.add(element$iv);
                        }
                        var17_23 = new Pair(first$iv, second$iv);
                        keepAlive = (List)var17_23.component1();
                        other = (List)var17_23.component2();
                        TransportMetrics.access$appendMetrics(var5_6, $this$invokeSuspend_u24lambda_u243, other);
                        var11_15 = $this$invokeSuspend_u24lambda_u243;
                        var12_16 = other;
                        var18_24 = var5_6;
                        var19_25 = 0L;
                        for (T var16_21 : var12_16) {
                            var21_26 = (Map.Entry)var16_21;
                            var22_27 = var19_25;
                            $i$a$-sumOfLong-TransportMetrics$1$message$2$2 = false;
                            var25_29 = ((Metric)it.getValue()).getTotalSize();
                            var19_25 = var22_27 + var25_29;
                        }
                        var22_27 = var19_25;
                        var11_15.append("Total: " + TransportMetrics.access$getBytes(var18_24, var22_27)).append('\n');
                        $this$invokeSuspend_u24lambda_u243.append('\n');
                        TransportMetrics.access$appendMetrics(var5_6, $this$invokeSuspend_u24lambda_u243, keepAlive);
                        var11_15 = $this$invokeSuspend_u24lambda_u243;
                        var12_16 = map.values();
                        var18_24 = var5_6;
                        var19_25 = 0L;
                        for (T var16_22 : var12_16) {
                            it = (Metric)var16_22;
                            var22_27 = var19_25;
                            $i$a$-sumOfLong-TransportMetrics$1$message$2$3 = false;
                            var25_29 = it.getTotalSize();
                            var19_25 = var22_27 + var25_29;
                        }
                        var22_27 = var19_25;
                        var11_15.append("Including keep-alive: " + TransportMetrics.access$getBytes(var18_24, var22_27)).append('\n');
                        message = var6_9.toString();
                        Logger.INSTANCE.debug(message);
                        map.clear();
                        ** continue;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Metric invokeSuspend$lambda$1(int $size, String string, Metric m) {
                Metric metric = m;
                if (metric == null) {
                    metric = new Metric(0, 0L);
                }
                Metric metric2 = metric;
                return metric2.copy(metric2.getCount() + 1, metric2.getTotalSize() + (long)$size);
            }

            private static final Metric invokeSuspend$lambda$2(Function2 $tmp0, Object p0, Object p1) {
                return (Metric)$tmp0.invoke(p0, p1);
            }
        }), (int)3, null);
    }

    public /* synthetic */ TransportMetrics(String string, CoroutineScope coroutineScope, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS);
        }
        this(string, coroutineScope, l, null);
    }

    private final void appendMetrics(StringBuilder $this$appendMetrics, List<? extends Map.Entry<String, Metric>> entries2) {
        Iterable $this$sortedByDescending$iv = entries2;
        boolean $i$f$sortedByDescending = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(((Metric)it.getValue()).getTotalSize());
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(((Metric)it.getValue()).getTotalSize()));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            String key = (String)entry.getKey();
            Metric metric = (Metric)entry.getValue();
            $this$appendMetrics.append(StringsKt.padEnd$default((String)key, (int)60, (char)'\u0000', (int)2, null) + ": " + StringsKt.padEnd$default((String)this.getBytes(metric.getTotalSize()), (int)11, (char)'\u0000', (int)2, null) + "= " + StringsKt.padEnd$default((String)this.getBytes(metric.getAvgSize()), (int)11, (char)'\u0000', (int)2, null) + "*" + metric.getCount()).append('\n');
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object log(@NotNull KrpcTransportMessage message2, @NotNull Continuation<? super Unit> $completion) {
        Object object;
        KrpcTransportMessage.StringMessage stringMessage = message2 instanceof KrpcTransportMessage.StringMessage ? (KrpcTransportMessage.StringMessage)message2 : null;
        if (stringMessage == null) {
            return Unit.INSTANCE;
        }
        KrpcTransportMessage.StringMessage msg = stringMessage;
        boolean $i$f$catching = false;
        try {
            Object object2;
            String clazz;
            void this_$iv;
            boolean bl = false;
            Json json2 = JsonKt.getJsonx();
            String string$iv = msg.getValue();
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            JsonObject json3 = (JsonObject)this_$iv.decodeFromString((DeserializationStrategy)JsonObject.Companion.serializer(), string$iv);
            JsonElement jsonElement = (JsonElement)json3.get((Object)"serviceType");
            String string = clazz = jsonElement != null ? this.getShortClassName(jsonElement) : null;
            if (clazz != null) {
                Object object3 = (JsonElement)json3.get((Object)"method");
                if (object3 == null || (object3 = this.getAsString((JsonElement)object3)) == null) {
                    JsonElement jsonElement2 = (JsonElement)json3.get((Object)"callId");
                    object3 = jsonElement2 != null ? this.getCallId(jsonElement2) : null;
                }
                Object callId = object3;
                object2 = clazz + "." + (String)callId;
            } else {
                JsonObject pluginParams;
                JsonElement jsonElement3 = (JsonElement)json3.get((Object)"pluginParams");
                Object object4 = pluginParams = jsonElement3 != null ? JsonElementKt.getJsonObject((JsonElement)jsonElement3) : null;
                if (pluginParams != null) {
                    JsonElement jsonElement4 = (JsonElement)pluginParams.get((Object)"-32764");
                    String clazz2 = jsonElement4 != null ? this.getShortClassName(jsonElement4) : null;
                    JsonElement jsonElement5 = (JsonElement)pluginParams.get((Object)"-32765");
                    String callId = jsonElement5 != null ? this.getCallId(jsonElement5) : null;
                    object2 = "@RPC @ " + clazz2 + "." + callId;
                } else {
                    JsonElement jsonElement6 = (JsonElement)json3.get((Object)"type");
                    object2 = jsonElement6 != null ? this.getAsString(jsonElement6) : null;
                    if (object2 == null) {
                        object2 = "";
                    }
                }
            }
            object = Result.constructor-impl((Object)object2);
        }
        catch (CancellationException c$iv) {
            throw c$iv;
        }
        catch (Throwable t$iv) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t$iv));
        }
        Object object5 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object5);
        if (throwable != null) {
            Throwable throwable2;
            Throwable it = throwable2 = throwable;
            boolean bl = false;
            Logger.INSTANCE.error("Failed to parse '" + msg.getValue() + "': " + it.getMessage());
        }
        String string = (String)(Result.isFailure-impl((Object)object5) ? null : object5);
        if (string == null) {
            return Unit.INSTANCE;
        }
        String callId = string;
        Object object6 = this.logChannel.send((Object)TuplesKt.to((Object)callId, (Object)Boxing.boxInt((int)msg.getValue().length())), $completion);
        if (object6 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object6;
        }
        return Unit.INSTANCE;
    }

    private final String getAsString(JsonElement $this$asString) {
        return JsonElementKt.getJsonPrimitive((JsonElement)$this$asString).getContent();
    }

    private final String getShortClassName(JsonElement $this$shortClassName) {
        return StringsKt.substringAfterLast$default((String)this.getAsString($this$shortClassName), (char)'.', null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String getCallId(JsonElement $this$callId) {
        String it = this.getAsString($this$callId);
        boolean bl = false;
        char[] cArray = new char[]{':'};
        String string = (String)CollectionsKt.getOrNull((List)StringsKt.split$default((CharSequence)it, (char[])cArray, (boolean)false, (int)0, (int)6, null), (int)1);
        if (string == null) {
            void var2_2;
            string = var2_2;
        }
        return string;
    }

    private final String getBytes(long $this$bytes) {
        return HumanMemorySizeKt.humanFileSize($this$bytes, $this$bytes < 1024L ? 0 : 1);
    }

    public /* synthetic */ TransportMetrics(String name2, CoroutineScope scope2, long debounceTimeout, DefaultConstructorMarker $constructor_marker) {
        this(name2, scope2, debounceTimeout);
    }

    public static final /* synthetic */ Channel access$getLogChannel$p(TransportMetrics $this) {
        return $this.logChannel;
    }

    public static final /* synthetic */ Set access$getKeepAliveIds$p(TransportMetrics $this) {
        return $this.keepAliveIds;
    }

    public static final /* synthetic */ long access$getDebounceTimeout$p(TransportMetrics $this) {
        return $this.debounceTimeout;
    }

    public static final /* synthetic */ String access$getName$p(TransportMetrics $this) {
        return $this.name;
    }

    public static final /* synthetic */ void access$appendMetrics(TransportMetrics $this, StringBuilder $receiver, List entries2) {
        $this.appendMetrics($receiver, entries2);
    }

    public static final /* synthetic */ String access$getBytes(TransportMetrics $this, long $receiver) {
        return $this.getBytes($receiver);
    }

    public static final class Metric {
        private final int count;
        private final long totalSize;
        private final long avgSize;

        public Metric(int count, long totalSize) {
            this.count = count;
            this.totalSize = totalSize;
            this.avgSize = this.count == 0 ? 0L : this.totalSize / (long)this.count;
        }

        public final int getCount() {
            return this.count;
        }

        public final long getTotalSize() {
            return this.totalSize;
        }

        public final long getAvgSize() {
            return this.avgSize;
        }

        public final int component1() {
            return this.count;
        }

        public final long component2() {
            return this.totalSize;
        }

        @NotNull
        public final Metric copy(int count, long totalSize) {
            return new Metric(count, totalSize);
        }

        public static /* synthetic */ Metric copy$default(Metric metric, int n, long l, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = metric.count;
            }
            if ((n2 & 2) != 0) {
                l = metric.totalSize;
            }
            return metric.copy(n, l);
        }

        @NotNull
        public String toString() {
            return "Metric(count=" + this.count + ", totalSize=" + this.totalSize + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.count);
            result2 = result2 * 31 + Long.hashCode(this.totalSize);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Metric)) {
                return false;
            }
            Metric metric = (Metric)other;
            if (this.count != metric.count) {
                return false;
            }
            return this.totalSize == metric.totalSize;
        }
    }
}

