/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.rhizome;

import com.jetbrains.toolbox.rhizome.JVMLogger;
import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggerFactory;
import java.util.Map;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class Slf4jKLoggerFactory
implements KLoggerFactory {
    @Override
    @NotNull
    public KLogger logger(@NotNull KClass<?> owner2) {
        Intrinsics.checkNotNullParameter(owner2, (String)"owner");
        return this.defaultLogger(owner2);
    }

    @NotNull
    public KLogger logger(@NotNull Object owner2) {
        Intrinsics.checkNotNullParameter((Object)owner2, (String)"owner");
        return this.defaultLogger(JvmClassMappingKt.getKotlinClass(owner2.getClass()));
    }

    @NotNull
    public KLogger logger(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.defaultLogger(name2);
    }

    private final KLogger defaultLogger(String name2) {
        Logger slf4jLogger = LoggerFactory.getLogger((String)name2);
        Intrinsics.checkNotNull((Object)slf4jLogger);
        return new KLogger(new JVMLogger(slf4jLogger));
    }

    private final KLogger defaultLogger(KClass<?> clazz) {
        return this.defaultLogger(JvmClassMappingKt.getJavaClass(clazz));
    }

    private final KLogger defaultLogger(Class<?> clazz) {
        Logger slf4jLogger = LoggerFactory.getLogger(clazz);
        Intrinsics.checkNotNull((Object)slf4jLogger);
        return new KLogger(new JVMLogger(slf4jLogger));
    }

    @Nullable
    public Map<String, String> getLoggingContext() {
        return MDC.getCopyOfContextMap();
    }

    public void setLoggingContext(@Nullable Map<String, String> map2) {
        if (map2 == null) {
            MDC.clear();
        } else {
            MDC.setContextMap(map2);
        }
    }
}

