/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.resharper.vs;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.StandardPaths;
import com.jetbrains.toolbox.resharper.model.VisualStudio2017PlusInstance;
import com.jetbrains.toolbox.resharper.model.VisualStudioInstance;
import com.jetbrains.toolbox.resharper.vs.VisualStudio2017PlusDetector;
import com.jetbrains.toolbox.resharper.vs.VisualStudio2017PlusEnumerator;
import com.jetbrains.toolbox.resharper.vs.VisualStudioDetector;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.tinylog.kotlin.Logger;

@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nVisualStudio2017PlusDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VisualStudio2017PlusDetector.kt\ncom/jetbrains/toolbox/resharper/vs/VisualStudio2017PlusDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1475#2,5:73\n*S KotlinDebug\n*F\n+ 1 VisualStudio2017PlusDetector.kt\ncom/jetbrains/toolbox/resharper/vs/VisualStudio2017PlusDetector\n*L\n22#1:73,5\n*E\n"})
public final class VisualStudio2017PlusDetector
implements VisualStudioDetector {
    @NotNull
    private final VisualStudio2017PlusEnumerator visualStudio2017PlusEnumerator;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Path appLocalDataVsPath;

    public VisualStudio2017PlusDetector(@NotNull VisualStudio2017PlusEnumerator visualStudio2017PlusEnumerator, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)visualStudio2017PlusEnumerator, (String)"visualStudio2017PlusEnumerator");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.visualStudio2017PlusEnumerator = visualStudio2017PlusEnumerator;
        this.fileSystem = fileSystem;
        this.appLocalDataVsPath = StandardPaths.INSTANCE.getLocalAppData().resolve("Microsoft").resolve("VisualStudio");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<VisualStudioInstance> detectVisualStudioInstances() {
        void var2_2;
        void $this$flatMapTo$iv;
        Iterable iterable = this.visualStudio2017PlusEnumerator.enumerateInstances();
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$flatMapSequenceTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            VisualStudio2017PlusInstance p0 = (VisualStudio2017PlusInstance)element$iv;
            boolean bl = false;
            Sequence<VisualStudioInstance> list$iv = this.detectAllInstances(p0);
            CollectionsKt.addAll((Collection)destination$iv, list$iv);
        }
        return (Set)var2_2;
    }

    private final Sequence<VisualStudioInstance> detectAllInstances(VisualStudio2017PlusInstance instance2) {
        Logger.INSTANCE.info("Working Visual Studio 2017+ install: " + instance2);
        if (!this.fileSystem.exists(instance2.getInstallPath())) {
            Logger.INSTANCE.warn("Skipping VS install since install path " + instance2.getInstallPath() + " does not exists");
            return SequencesKt.emptySequence();
        }
        Path devenvExe = instance2.getInstallPath().resolve("Common7/IDE/devenv.exe");
        if (!this.fileSystem.exists(devenvExe)) {
            Logger.INSTANCE.warn("Skipping VS install since devenv path " + devenvExe + " does not exists (but instance path " + instance2.getInstallPath() + " exists)");
            return SequencesKt.emptySequence();
        }
        String string = instance2.getBuildNumber-Y_E1uuk();
        String string2 = instance2.getInstanceId();
        String string3 = instance2.getDisplayName();
        Sequence systemInstance = SequencesKt.sequenceOf((Object)new VisualStudioInstance(string2, string3, string, "", devenvExe, null));
        String majorVersionString = BuildNumber.majorVersion-impl(instance2.getBuildNumber-Y_E1uuk());
        Integer n = StringsKt.toIntOrNull((String)majorVersionString);
        if (n == null) {
            VisualStudio2017PlusDetector $this$detectAllInstances_u24lambda_u240 = this;
            boolean bl = false;
            Logger.INSTANCE.warn("Unable to parse major version from VS instance " + instance2 + ". '" + majorVersionString + "' should be an integer.");
            return systemInstance;
        }
        int majorVersion = n;
        Regex directoryNameRegex = new Regex(majorVersion + "\\.\\d+_" + Regex.Companion.escape(instance2.getInstanceId()) + "(?<hive>.+)");
        List list2 = this.fileSystem.listOrNull(this.appLocalDataVsPath);
        Object object = list2 != null ? CollectionsKt.asSequence((Iterable)list2) : null;
        if (object == null) {
            object = SequencesKt.emptySequence();
        }
        Sequence userInstances2 = SequencesKt.map((Sequence)SequencesKt.onEach((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)object, arg_0 -> VisualStudio2017PlusDetector.detectAllInstances$lambda$1(this, arg_0)), (Function1)((Function1)detectAllInstances.userInstances.2.INSTANCE)), (Function1)((Function1)new Function1<CharSequence, MatchResult>((Object)directoryNameRegex){

            public final MatchResult invoke(CharSequence p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Regex)this.receiver).matchEntire(p0);
            }
        })), VisualStudio2017PlusDetector::detectAllInstances$lambda$2), arg_0 -> VisualStudio2017PlusDetector.detectAllInstances$lambda$3(instance2, devenvExe, arg_0));
        return SequencesKt.plus((Sequence)systemInstance, (Sequence)userInstances2);
    }

    private static final boolean detectAllInstances$lambda$1(VisualStudio2017PlusDetector this$0, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.fileSystem.metadata(it).isDirectory();
    }

    private static final Unit detectAllInstances$lambda$2(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Logger.INSTANCE.info("Found VS hive at " + it.getValue());
        return Unit.INSTANCE;
    }

    private static final VisualStudioInstance detectAllInstances$lambda$3(VisualStudio2017PlusInstance $instance, Path $devenvExe, MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = $instance.getBuildNumber-Y_E1uuk();
        MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)it.getGroups(), (String)"hive");
        String string2 = matchGroup != null ? matchGroup.getValue() : null;
        if (string2 == null) {
            string2 = "";
        }
        String string3 = string2;
        String string4 = $instance.getInstanceId();
        String string5 = $instance.getDisplayName();
        return new VisualStudioInstance(string4, string5, string, string3, $devenvExe, null);
    }
}

