/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.project;

import com.jetbrains.toolbox.project.CheckedOutProject;
import com.jetbrains.toolbox.project.FileSystemProject;
import com.jetbrains.toolbox.project.FleetWorkspace;
import com.jetbrains.toolbox.project.Project;
import com.jetbrains.toolbox.project.ProjectManager;
import com.jetbrains.toolbox.project.ProjectModelUpdater;
import com.jetbrains.toolbox.tools.model.ProjectId;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nProjectExistenceCheckUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectExistenceCheckUpdater.kt\ncom/jetbrains/toolbox/project/ProjectExistenceCheckUpdater\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n230#2,5:73\n1761#3,3:78\n*S KotlinDebug\n*F\n+ 1 ProjectExistenceCheckUpdater.kt\ncom/jetbrains/toolbox/project/ProjectExistenceCheckUpdater\n*L\n28#1:73,5\n47#1:78,3\n*E\n"})
public final class ProjectExistenceCheckUpdater
implements ProjectModelUpdater {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final MutableStateFlow<Set<ProjectId>> _deletedProjects;
    private final int order;

    public ProjectExistenceCheckUpdater(@NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
        this._deletedProjects = StateFlowKt.MutableStateFlow((Object)SetsKt.emptySet());
        this.order = 8;
    }

    @Override
    @NotNull
    public Flow<ProjectManager.Model> updateProjectModel(@NotNull Flow<ProjectManager.Model> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        return FlowKt.combine(input, (Flow)((Flow)this._deletedProjects), (Function3)((Function3)new Function3<ProjectManager.Model, Set<? extends ProjectId>, Continuation<? super ProjectManager.Model>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            final /* synthetic */ ProjectExistenceCheckUpdater this$0;
            {
                this.this$0 = $receiver;
                super(3, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                ProjectManager.Model model2 = (ProjectManager.Model)this.L$0;
                Set set = (Set)this.L$1;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        void model3;
                        ResultKt.throwOnFailure((Object)$result);
                        Iterable iterable = model3.getProjects();
                        ProjectExistenceCheckUpdater projectExistenceCheckUpdater = this.this$0;
                        void var14_6 = model3;
                        boolean $i$f$map = false;
                        void var7_8 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void deletedProjects;
                            void it;
                            Project project2 = (Project)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(ProjectExistenceCheckUpdater.access$updateSafe(projectExistenceCheckUpdater, (Project)it, (Set)deletedProjects));
                        }
                        return ProjectManager.Model.copy$default((ProjectManager.Model)var14_6, CollectionsKt.toSet((Iterable)((List)destination$iv$iv)), null, null, null, null, 30, null);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(ProjectManager.Model p1, Set<ProjectId> p2, Continuation<? super ProjectManager.Model> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                var4_4.L$1 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public final void markDeleted-CD0_5dk(@NotNull String string) {
        Set it;
        Set nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter((Object)string, (String)"$v$c$com-jetbrains-toolbox-tools-model-ProjectId$-projectId$0");
        MutableStateFlow<Set<ProjectId>> $this$update$iv = this._deletedProjects;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (Set)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = SetsKt.plus((Set)it, (Object)ProjectId.box-impl(string)))));
    }

    private final Project updateSafe(Project project2, Set<ProjectId> deletedProjects) {
        Project project3;
        try {
            project3 = this.update(project2, deletedProjects);
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, "Couldn't update project " + ProjectId.toString-impl(project2.getId-kZr3Ip4()));
            project3 = project2;
        }
        return project3;
    }

    private final Project update(Project project2, Set<ProjectId> deletedProjects) {
        boolean bl;
        block11: {
            if (!(project2 instanceof CheckedOutProject)) {
                return project2;
            }
            if (deletedProjects.contains(ProjectId.box-impl(project2.getId-kZr3Ip4()))) {
                Logger.INSTANCE.debug("Marking previously existing project '" + ProjectId.toString-impl(project2.getId-kZr3Ip4()) + "' as non-existing, because it was marked as deleted explicitly");
                ((CheckedOutProject)project2).setDeleted(true);
                return project2;
            }
            CheckedOutProject checkedOutProject = (CheckedOutProject)project2;
            if (checkedOutProject instanceof FileSystemProject) {
                bl = this.safeCheckExists(((FileSystemProject)project2).getDirectory());
            } else if (checkedOutProject instanceof FleetWorkspace) {
                Iterable $this$any$iv = ((FleetWorkspace)project2).getPaths();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Path it = (Path)element$iv;
                        boolean bl2 = false;
                        if (!this.safeCheckExists(it)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            } else {
                return project2;
            }
        }
        boolean exists = bl;
        if (exists && ((CheckedOutProject)project2).getDeleted()) {
            Logger.INSTANCE.debug("Marking previously non-existing project '" + ProjectId.toString-impl(project2.getId-kZr3Ip4()) + "' as existing");
            return ((CheckedOutProject)project2).setDeleted(false);
        }
        if (!exists && !((CheckedOutProject)project2).getDeleted()) {
            Logger.INSTANCE.debug("Marking project '" + ProjectId.toString-impl(project2.getId-kZr3Ip4()) + "' as non-existing");
            return ((CheckedOutProject)project2).setDeleted(true);
        }
        return project2;
    }

    private final boolean safeCheckExists(Path path2) {
        boolean bl;
        try {
            bl = this.fileSystem.exists(path2);
        }
        catch (IOException e) {
            Logger.INSTANCE.warn("Couldn't check existence of path " + path2 + " due to error " + e.getMessage());
            bl = true;
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, "Couldn't check existence of path " + path2);
            bl = true;
        }
        return bl;
    }

    public static final /* synthetic */ Project access$updateSafe(ProjectExistenceCheckUpdater $this, Project project2, Set deletedProjects) {
        return $this.updateSafe(project2, deletedProjects);
    }
}

