/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.platform.oauth;

import com.jetbrains.toolbox.common.security.ShaKt;
import com.jetbrains.toolbox.ex.stdlib.security.RandomKt;
import kotlin.io.encoding.Base64;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

public final class PkceKt {
    @NotNull
    private static final Base64 base64 = Base64.Default.getUrlSafe().withPadding(Base64.PaddingOption.ABSENT);

    @NotNull
    public static final String oauthCodeVerifier() {
        byte[] bytes2 = RandomKt.randomBytes(64);
        return Base64.encode$default((Base64)base64, (byte[])bytes2, (int)0, (int)0, (int)6, null);
    }

    @NotNull
    public static final String oauthCodeChallenge(@NotNull String codeVerifier) {
        Intrinsics.checkNotNullParameter((Object)codeVerifier, (String)"codeVerifier");
        String string = codeVerifier;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return Base64.encode$default((Base64)base64, (byte[])ShaKt.sha256(byArray), (int)0, (int)0, (int)6, null);
    }
}

